local function split(str, sep)
  local sub_table = {}
  local i, j = 0, 0
  while true do
    j = string.find(str, sep, i + 1)
    if j == nil then
      table.insert(sub_table, string.sub(str, i + 1))
      break
    end
    table.insert(sub_table, string.sub(str, i + 1, j - 1))
    i = j
  end
  return sub_table
end

local function adddatetime(timebox, num, types)
  if types == 'days' then
    timebox:adddays(num)
  elseif types == 'hours' then
    timebox:addhours(num)
  elseif types == "minutes" then
    timebox:addminutes(num)
  elseif types == 'seconds' then
    timebox:addseconds(num)
  elseif types == 'months' then
    timebox:addmonths(num)
  elseif types == 'years' then
    timebox:addyears(num)
  elseif types == 'weeks' then
    timebox:adddays(num * 7)
  end
end

local function setdatetime(timebox, num, types)
  if types == 'days' then
    timebox:setday(num)
  elseif types == 'hours' then
    timebox:sethours(num)
  elseif types == "minutes" then
    timebox:setminutes(num)
  elseif types == 'seconds' then
    timebox:setseconds(num)
  elseif types == 'months' then
    timebox:setmonth(num)
  elseif types == 'years' then
    timebox:setyear(num)
  elseif types == 'weeks' then
    timebox:setisoweeknumber(num)
  end
end

local function setstartof(timebox, types)
  if types == 'day' then
    timebox:sethours(0, 0, 0, 0)
  elseif types == 'hour' then
    timebox:setminutes(0, 0, 0)
  elseif types == "minute" then
    timebox:setseconds(0, 0)
  elseif types == 'month' then
    timebox:setday(1)
    timebox:sethours(0, 0, 0, 0)
  elseif types == 'year' then
    timebox:setmonth(1, 1)
    timebox:sethours(0, 0, 0, 0)
  elseif types == 'week' then
    timebox:setisoweekday(1)
    timebox:sethours(0, 0, 0, 0)
  end
end

function STRFTIME(format, timestr, modifier)
  local w,_,rc
  local mark,num,types
  local timebox
  local modify
  local isnumber,isstring = extend.isnumber,extend.isstring

  if not timestr then
    timebox = LuaDate()
  elseif isnumber(timestr) then
    timebox = LuaDate(timestr/1000):tolocal()
  elseif isstring(timestr) and (timestr == 'now' or timestr == '') then
    timebox = LuaDate()
  else
    timebox = LuaDate(timestr)
  end

  if modifier == nil or modifier == '' then
    modify = {}
  else
    modify = split(string.lower(modifier), ',')
  end

  for _, w in ipairs(modify) do
    --grab NNNN SSSS
    rc, _, mark, num, types = string.find(w, "^%s*([+-]?)([%d.]+)%s*(%w+)%s*$")
    if rc then
      if mark == '' then --do set
        setdatetime(timebox, num, types)
      else --do add
        num = mark .. num
        adddatetime(timebox, num, types)
      end
    else
      --grab start of SSS replace by set
      rc, _, types = string.find(w, "^%s*start of (%a+)%s*$")
      if rc then
        setstartof(timebox, types)
      else
        --grab weekday N
        rc, _, num = string.find(w, "^%s*weekday%s*(%d+)%s*$")
        if rc then
          if timebox:getisoweekday() > tonumber(num) then
            timebox:setisoweekday(num + 7)
          else
            timebox:setisoweekday(num)
          end
        else
          --grab localtime
          rc = string.find(w, "^%s*localtime%s*$")
          if rc then
            timebox:tolocal()
          else
            --grab utc
            rc = string.find(w, "^%s*utc%s*$")
            if rc then
              timebox:toutc()
            end
          end
        end
      end
    end
  end
  return timebox:fmt(format)
end

function STRDATE(timestr, modifier)
  return STRFTIME("%F", timestr, modifier)
end

function STRTIME(timestr, modifier)
  return STRFTIME("%T", timestr, modifier)
end

function STRDATETIME(timestr, modifier)
  return STRFTIME("%F %T", timestr, modifier)
end

--grab unixepoch
--[[
rc,_,num=string.find(str,"^%s*%d+%s*$")
if rc then
end
]] --
