#ifndef _SQLOPT_H
#define _SQLOPT_H

/****************************************************************************
 * (C) Copyright SYSCOM COMPUTER ENGINEERING CO. 2006.
 *   
 * #001 08/30/95 phu   : move '#' flag to the first position
 * #002 10/05/95 tlee  : MR 708 add new option
 * #003 10/07/95 sufen : add new SQLSetConnectOption/SQLGetConnectOption 
 * #004 10/17/95 tlee  : add Input file mode (disable now only for iSQL)
 * #005 11/10/95 tlee  : add get connect ID
 * #006 11/27/95 jedy  : add dump debug info flag
 * #007 12/08/95 tlee  : add get backup ID option
 * #008 12/13/95 riverh: add SQL_CANCEL option of SQLCancel
 * #009 01/25/96 yan   :  add SQL_DUMP_PLAN option
 * #010 01/29/96 phu   : modify 0UL to 0 for solaris warning (compare unsigned-zero)
 * #011 01/29/96 jedy  : add SQL_SHOW_SYSINFO / SQL_BACKUP_MODE
 * #012 02/13/96 tlee  : add BACKUP_DATA and BACKUP_BLOB
 * #013 07/09/96 wjyu  : add some connection options for backup server
 * #014 08/02/96 sufen : add two date format 'yy/mm/dd' and 'yy-mm-dd' for 
 *                       export date data from Access, requested by cathy ?????
 * #015 08/11/96 tlee  : add cursor mode for cross txn
 * #016 10/07/96 riverh: add "DBMaker internal" mode
 * #017 10/28/96 wjyu  : BACKUP_BLOB should be 2 for @3160
 * #018 10/18/96 sufen : add SQL_DDB_LOGIN_TIMEOUT, SQL_DDB_LOCK_TIMEOUT
 * #019 11/15/96 wjyu  : add connection options for replication server
 * #020 02/11/97 ccw   : add prepare commit option in SQLTransact
 * #021 03/25/97 liew  : add SQL_EXTENSION_FONAME for connect option
 * #022 03/31/97 liew  : add SQL_EXTENSION_NAME for stmt option
 * #023 04/02/97 liew  : add SQL_SOURCE, SQL_AUTODETECT
 * #024 04/25/97 liew  : add SQL_DFO_DUP_NULL, SQL_DFO_DUP_COPY
 * #025 04/25/97 liew  : add SQL_DFO_DUP_MODE for connect option
 * #026 05/14/97 paxtsai: add SQL_PROC_NAME for statement option
 * #027 07/18/97 perng :  add SQL_SPOS_FO/SQL_SPOS_LONG for statement option
 * #028 02/26/98 jerry : add SQL_SP_ERRMSG_FNAME for DBAtool
 * #029 03/24/98 cctsai: SQL_CON_STMT_DRVR_START for common opt on stmt & conn
 * #030 03/26/98 cctsai: SQL_FO_TO_SQLTYPE for FO mapping 
 * #031 04/20/98 wjchen: add SQL_CB_PRE_SCAN_LK
 * #032 04/22/98 riverh: remove SQL_SPOS_FO_DATA, for implement SQL_IGNORE 
 * #033 11/19/98 jerry : MR#4887, add SQL_REMOVE_SPACE_PADDING
 * #034 12/11/98 cctsai: change "source" to "SOURCE", "autodet" to "AUTO"
 * #035 09/16/98 paxtsai: add constant definition for ODBC 3
 * #036 10/13/98 hungc: change SQL_NUM_FUNCTIONS to 24
 * #037 12/30/98 cctsai: support Multi-Media Class
 * #038 01/04/99 ccw   : add SQL_MAX_TB_ROW
 * #039 01/28/99 wjyu  : add SQL_ATR_NOCASCADE 
 * #040 04/01/99 phu   : add SQL_GET_TABLE_NAME
 * #041 06/11/99 paxtsai: (MR5200) add SQL_AUTO_IPD, the same as
 *                        SQL_ATTR_ENABLE_AUTO_IPD (for esql runtime
 *                        utilities)
 * #042 06/14/99 wjyu  : support MTS
 * #043 10/05/99 clin  : add global configuration section to dmconfig
 * #044 12/27/99 emma  : add SQL_GETBLOB_FROM_BEGIN, SQL_GETBLOB_FROM_CURRENT,
 *                       SQL_GETBLOB_FROM_END for random access BLOB data
 * #045 03/06/00 paxtsai: (MR5579) move COMMON_OPTION to config.h
 * #046 06/30/00 cctsai: add SQL_DB_REPAIR option for db repair
 * #047 01/21/00 paxtsai:add SQL_DCI_TABLE_CACHE
 * #048 01/31/02 phu   : @6447 add SQL_PROC_TYPE (do not use SQL_PROC_NAME)
 * #049 06/14/02 clin  : @6558 add SQL_CLI_UCODE_TYPE for unicode support
 * #050 10/18/02 phu   : @6688 add SQL_CHECK_EX_TABVER for check ex tree's table version
 * #051 02/11/04 phu   : @7100 add SQL_LINKDB_INFO
 * #052 12/07/04 phu   : @7425 support yyyy.mm.dd format
 * #053 12/30/04 kaiven : #7458, get error message from server
 * #054 07/14/05 emma  : fix MR7436. To support java stored procedure
 * #055 01/16/05 kaiven: MR7400, support read committed
 * #056 09/07/06 emma  : fix MR#7884. add SQL_ATTR_CURRENT_ROW_NUMBER.
 * #057 12/21/07 sun   : MR8132,for UTF-8: set client_char_set 'xxxx';
 * #058 03/03/08 sun   : MR8132,for UTF-8: set errmsg_char_set 'xxxx'; 
 * #059 07/15/09 phu   : @8501 add SQL_CURRENT_SERIAL
 * #060 01/28/13 linda : @9470 support Column Default Attribute
 * #061 01/23/14 luxem : MR9884 add SQL_WORKDIR for create sp and SQLSetStmtAttr/SQLGetStmtAttr
 * #062 01/09/14 linda : @9874,add SQL_ATTR_HIDDEN_SHOW for hidden column
 * #063 08/28/14 linda : @9874 add fgshowHid to show hidden column or not
 * #064 09/22/14 luxem : @10003 need date format 'yyyymmdd' time format 'hhmmss'
 * #065 09/28/14 glow  : MR9882 support schedule daemon
 * #066 10/14/14 luxem : @10003 add extended date time format
 * #067 12/03/14 zheng : @10041 add SQL_PARENT_ICMD
 * #068 04/03/15 glow  : MR9882 support stop_dmschsvr for schedule daemon
 * #069 05/13/15 linda : @10187, unload/load jsoncols should not bind json udf
 * #070 10/22/2015 chingju : MR10296 add SQL_IS_SAME_HOST
 * #071 11/17/15 glow   :MR10328 add SQL_SCHE_PID for schedule daemon
 * #072 03/04/16  glow  : MR10360 schedule daemon log system
 * #073 10/18/17 linda : @10737 code review for jsoncols
 * #074 11/12/17 linda : @10760 code review for hidden column
 * #075 12/20/17 yan    :MR10773 add SQL_DUMP_PLAN_JSON
 * #076 10/19/18 linda : @10848, unload user hidden schema and data default
 * #077 07/04/19 yan    :MR10773 add SQL_DUMP_PLAN_JSON2 for simple format
 * #078 05/11/20 linda : @10760, modify SQL_HIDDEN to SHOW_HIDDEN
 * #079 04/06/23 ching : MR11241 add SQL_ATTR_ENCRYPT_DB for encrypt db
 ****************************************************************************/

/****************************************************************************
 * Following constants are defined in ODBC 2.x, but not in ODBC 3. Our code
 * needs these definitions, so we define these constants (they are available
 * only whne ODBC version is 3.x).  #035
 ****************************************************************************/
#if (ODBCVER >= 0x0300)
#define SQL_CONNECT_OPT_DRVR_START  1000
#define SQL_EXT_API_LAST            SQL_API_SQLBINDPARAMETER
#define SQL_NUM_FUNCTIONS           24              /* #036 */
#define SQL_EXT_API_START           40
#define SQL_NUM_EXTENSIONS          (SQL_EXT_API_LAST-SQL_EXT_API_START+1)
#define SQL_TYPE_MIN                SQL_BIT
#define SQL_TYPE_MAX                SQL_VARCHAR
 
#define SQL_INFO_LAST                       SQL_QUALIFIER_LOCATION
#define SQL_INFO_DRIVER_START               1000    /* ??? */
#define SQL_TXN_VERSIONING                  0x00000010L
#define SQL_FD_FETCH_RESUME                 0x00000040L
 
#define SQL_TYPE_DRIVER_START               SQL_INTERVAL_YEAR
#define SQL_TYPE_DRIVER_END                 SQL_UNICODE_LONGVARCHAR
#endif

/****************************************************************************
 *  add SQL_CANCEL to option group of apiFreeCmd for apiCancel       #008
 ****************************************************************************/
/* SQL_CLOSE           0  */
/* SQL_DROP            1  */
/* SQL_UNBIND          2  */
/* SQL_RESET_PARAMS    3  */
#define SQL_CANCEL     4             

/****************************************************************************
 *  add SQL_PRECMT to option group of SQLTransact                   #020
 ****************************************************************************/
/* #define SQL_COMMIT        0 */
/* #define SQL_ROLLBACK      1 */
#define SQL_PRECMT           2         /* prepare commit               #020 */

/****************************************************************************
 *  remap sql string status to api string status
 ****************************************************************************/
#define API_NULL_DATA   -1    /* NULL DATA in binding variable              */
#define API_NTS         -3    /* input data is null terminated str          */
#define API_EXIST_DATA  NULL  /* set address of bufflag to NULL if          */
                              /* input variable exist                       */
                              /* (used when apiSetParam)                    */

/****************************************************************************
 *  remap binding orientation for variable array           
 ****************************************************************************/
#define API_BIND_BY_COL 0           /* Column-wise binding                  */
#define API_BIND_BY_ROW 1           /* Row-wise binding                     */

/****************************************************************************
 *  blob insert mode                                                   
 ****************************************************************************/
#define BB_INS_REJ           -1
#define BB_INS_ALLOW         0
#define BB_INDIR_ONLY        1

/****************************************************************************
 * extend SQLGetEnvAttr options
 ****************************************************************************/
#define SQL_ENV_OPT_DRVR_START 1000
#define SQL_ATTR_JAVASP_CONNECTION (SQL_ENV_OPT_DRVR_START + 1)


/****************************************************************************
 * extend SQLSetStmtOption/SQLGetStmtOption options                   
 ****************************************************************************/
#define SQL_STMT_OPT_DRVR_START 1000
#define SQL_GET_INCREMENT_VALUE (SQL_STMT_OPT_DRVR_START + 100 + 1)
#define SQL_GET_CURRENT_OID     (SQL_STMT_OPT_DRVR_START + 100 + 2)
#define SQL_GET_BACKUP_ID       (SQL_STMT_OPT_DRVR_START + 100 + 3) /* #007 */
#define SQL_DUMP_PLAN           (SQL_STMT_OPT_DRVR_START + 100 + 4) /* #009 */
#define SQL_PLAN                (SQL_STMT_OPT_DRVR_START + 100 + 5) /* #009 */
#define SQL_PLAN_LEN            (SQL_STMT_OPT_DRVR_START + 100 + 6) /* #009 */
#define SQL_PROC_NAME           (SQL_STMT_OPT_DRVR_START + 100 + 8) /* #026 */
#define SQL_SPOS_FO             (SQL_STMT_OPT_DRVR_START + 100 + 9) /* #027 */
#define SQL_SP_ERRMSG_FNAME     (SQL_STMT_OPT_DRVR_START + 100 +10) /* #028 */
#define SQL_ATR_NOCASCADE       (SQL_STMT_OPT_DRVR_START + 100 +11) /* #039 */
#define SQL_GET_TABLE_NAME      (SQL_STMT_OPT_DRVR_START + 100 +12) /* #040 */
#define SQL_AUTO_IPD            (SQL_STMT_OPT_DRVR_START + 100 +13) /* #041 */
#define SQL_PROC_TYPE           (SQL_STMT_OPT_DRVR_START + 100 +14) /* #048 */
#define SQL_CHECK_EX_TABVER     (SQL_STMT_OPT_DRVR_START + 100 +15) /* #050 */
#define SQL_LINKDB_INFO         (SQL_STMT_OPT_DRVR_START + 100 +16) /* #051 */
#define SQL_ATTR_SVR_STMT       (SQL_STMT_OPT_DRVR_START + 100 +17) /* #054 */
#define SQL_REL_ALL_SLOCKS      (SQL_STMT_OPT_DRVR_START + 100 +18) /* #055 */
#define SQL_CURRENT_ROW_NUMBER  (SQL_STMT_OPT_DRVR_START + 100 +19) /* #056 */
#define SQL_CURRENT_SERIAL      (SQL_STMT_OPT_DRVR_START + 100 +20) /* #059 */
#define SQL_WORKDIR             (SQL_STMT_OPT_DRVR_START + 100 +21) /* #061 */
#define SQL_PARENT_ICMD         (SQL_STMT_OPT_DRVR_START + 100 +22) /* #067 */
/****************************************************************************
 *  extend stmt option values
 ****************************************************************************/
/* #009 */
#define SQL_DUMP_PLAN_ON            1UL
#define SQL_DUMP_PLAN_OFF           0UL
#define SQL_DUMP_PLAN_JSON          2UL    /* #075 */
#define SQL_DUMP_PLAN_JSON2         3UL    /* #077 */
#define SQL_DUMP_PLAN_DEFAULT       SQL_DUMP_PLAN_OFF

/* #027, #032 */
#define SQL_SPOS_FO_CFILE           0x00000200L
#define SQL_SPOS_FO_SFILE           0x00000100L
#define SQL_SPOS_FO_MASK            0xFFFFFF00L

/* #039 */
#define SQL_ATR_NOCASCADE_ON        1UL
#define SQL_ATR_NOCASCADE_OFF       0UL
#define SQL_ATR_NOCASCADE_DEFAULT   SQL_ATR_NOCASCADE_OFF
/****************************************************************************
 * extend SQLSetConnectOption/SQLGetConnectOption options                   
 ****************************************************************************/

/* New option for SQLSetConnectOption/SQLGetConnectOption   #004            */
#define SQL_DB_MODE                  (SQL_CONNECT_OPT_DRVR_START + 100 + 5) 
#define SQL_JOURNAL_MODE             (SQL_CONNECT_OPT_DRVR_START + 100 + 6)
#define SQL_LOCK_TIMEOUT             (SQL_CONNECT_OPT_DRVR_START + 100 + 7)
#define SQL_INPUT_MODE               (SQL_CONNECT_OPT_DRVR_START + 100 + 8)

/* #003 New options for DATE/TIME/TIMESTAMP format                          */
#define SQL_DATE_INPUT_FORMAT        (SQL_CONNECT_OPT_DRVR_START + 100 + 10)  
#define SQL_DATE_OUTPUT_FORMAT       (SQL_CONNECT_OPT_DRVR_START + 100 + 11) 
#define SQL_TIME_INPUT_FORMAT        (SQL_CONNECT_OPT_DRVR_START + 100 + 12)
#define SQL_TIME_OUTPUT_FORMAT       (SQL_CONNECT_OPT_DRVR_START + 100 + 13)
#define SQL_TIMESTAMP_INPUT_FORMAT   (SQL_CONNECT_OPT_DRVR_START + 100 + 14)
#define SQL_TIMESTAMP_OUTPUT_FORMAT  (SQL_CONNECT_OPT_DRVR_START + 100 + 15)


#define SQL_CONNECT_ID               (SQL_CONNECT_OPT_DRVR_START + 100 + 17)

/* #011 */
#define SQL_SYSINFO_CLEAR            (SQL_CONNECT_OPT_DRVR_START + 100 + 19)
#define SQL_BACKUP_MODE              (SQL_CONNECT_OPT_DRVR_START + 100 + 20)

/* #013 */
#define SQL_BKSVR_PID                (SQL_CONNECT_OPT_DRVR_START + 100 + 21) 
#define SQL_BKSVR_JNL_FULL           (SQL_CONNECT_OPT_DRVR_START + 100 + 22) 
#define SQL_BKSVR_PATH               (SQL_CONNECT_OPT_DRVR_START + 100 + 23) 
#define SQL_BKSVR_TIME               (SQL_CONNECT_OPT_DRVR_START + 100 + 24) 
#define SQL_BKSVR_CMP                (SQL_CONNECT_OPT_DRVR_START + 100 + 25) 

/* #015 */
#define SQL_CB_MODE                  (SQL_CONNECT_OPT_DRVR_START + 100 + 26) 

/* #016 */
#define SQL_DM_INTERNAL              (SQL_CONNECT_OPT_DRVR_START + 100 + 27) 

/* #018, the option value is ROPTI_t block, see sviddb.h */
#define SQL_DDB_LOGIN_TIMEOUT        (SQL_CONNECT_OPT_DRVR_START + 100 + 28)
#define SQL_DDB_LOCK_TIMEOUT         (SQL_CONNECT_OPT_DRVR_START + 100 + 29)
 
/* #019 */
#define SQL_RPSVR_TIME               (SQL_CONNECT_OPT_DRVR_START + 100 + 30)
#define SQL_RPSVR_RETRY              (SQL_CONNECT_OPT_DRVR_START + 100 + 31)
#define SQL_RPSVR_CLEAR              (SQL_CONNECT_OPT_DRVR_START + 100 + 32)
#define SQL_RPSVR_FLUSH              (SQL_CONNECT_OPT_DRVR_START + 100 + 33)

/* #025 */
#define SQL_DFO_DUP_MODE             (SQL_CONNECT_OPT_DRVR_START + 100 + 35)

/* #030 */
#define SQL_FO_TO_SQLTYPE            (SQL_CONNECT_OPT_DRVR_START + 100 + 36)

/* #033 */
#define SQL_REMOVE_SPACE_PADDING     (SQL_CONNECT_OPT_DRVR_START + 100 + 37)

/* #038 */
#define SQL_MAX_TB_ROW               (SQL_CONNECT_OPT_DRVR_START + 100 + 38)

/* #042 */
#define SQL_XA_RECOVER               (SQL_CONNECT_OPT_DRVR_START + 100 + 39)

/* #046 */
#define SQL_DB_REPAIR                (SQL_CONNECT_OPT_DRVR_START + 100 + 40)

/* #047 - for creating DCI table cache */
#define SQL_DCI_TABLE_CACHE      (SQL_CONNECT_OPT_DRVR_START + 100 + 41)

/* #049 */
#define SQL_CLI_UCODE_TYPE           (SQL_CONNECT_OPT_DRVR_START + 100 + 42)

/* #053 */
#define SQL_GET_ERR_MSG          (SQL_CONNECT_OPT_DRVR_START + 100 + 43)

/* #057 */
#define SQL_SET_CLIENTCHARSET    (SQL_CONNECT_OPT_DRVR_START + 100 + 44)

/* #058 */
#define SQL_SET_ERRMSG_CHARSET   (SQL_CONNECT_OPT_DRVR_START + 100 + 45)
#define SQL_ATTR_SYSTEM_DEFAULT  (SQL_CONNECT_OPT_DRVR_START + 100 + 46) /* #060 */ 
#define SQL_ATTR_HIDDEN_SHOW     (SQL_CONNECT_OPT_DRVR_START + 100 + 47) /* #062 */
#define SQL_RELOAD_SCHEDULE      (SQL_CONNECT_OPT_DRVR_START + 100 + 48) /* #065 */
#define SQL_TASK_RUNNUMBER      (SQL_CONNECT_OPT_DRVR_START + 100 + 49) /* #065 */
#define SQL_SCHEDULE_FLAG      (SQL_CONNECT_OPT_DRVR_START + 100 + 50) /* #068 */
#define SQL_ATTR_BIND_JSONUDF    (SQL_CONNECT_OPT_DRVR_START + 100 + 51) /* #069 */
#define SQL_IS_SAME_HOST         (SQL_CONNECT_OPT_DRVR_START + 100 + 52) /* #070 */ 
#define SQL_SCHE_PID      (SQL_CONNECT_OPT_DRVR_START + 100 + 53) /* # #071 */
#define SQL_SCHE_LOG_DIR      (SQL_CONNECT_OPT_DRVR_START + 100 + 54) /* #072 */
#define SQL_SCHELOG_LEVEL     (SQL_CONNECT_OPT_DRVR_START + 100 + 55) /* #072 */
#define SQL_LOAD_ENCRYPT_DB   (SQL_CONNECT_OPT_DRVR_START + 100 + 56) /* #079 */
/****************************************************************************
 *  extend option values
 ****************************************************************************/
/* new option for SQLSetConnectOption */

/* SQL_DB_MODE option */
#define SQL_SINGLE                  1UL
#define SQL_MULTI                   0UL
#define SQL_DBMODE_DEFAULT          0UL

/* SQL_JOURNAL_MODE option */
#define SQL_JOURNAL_OFF             0UL
#define SQL_JOURNAL_ON              1UL
#define SQL_JOURNAL_DEFAULT         SQL_JOURNAL_ON

/* SQL_LOCK_TIMEOUT option */
#define SQL_LOCK_WAIT               0xFFFFFFFFL
#define SQL_LOCK_DEFAULT            SQL_LOCK_WAIT


/* SQL_DATE_INPUT_FORMAT/SQL_DATE_OUTPUT_FORMAT options  #003  */
#define SQL_DATE_FORMAT_0           0L     /* mm/dd/yy   #010  */
#define SQL_DATE_FORMAT_1           1L     /* mm-dd-yy         */
#define SQL_DATE_FORMAT_2           2L     /* dd/mon/yy        */
#define SQL_DATE_FORMAT_3           3L     /* dd-mon-yy        */
#define SQL_DATE_FORMAT_4           4L     /* mm/dd/yyyy       */
#define SQL_DATE_FORMAT_5           5L     /* mm-dd-yyyy       */
#define SQL_DATE_FORMAT_6           6L     /* yyyy/mm/dd       */
#define SQL_DATE_FORMAT_7           7L     /* yyyy-mm-dd       */
#define SQL_DATE_FORMAT_8           8L     /* dd/mon/yyyy      */
#define SQL_DATE_FORMAT_9           9L     /* dd-mon-yyyy      */
#define SQL_DATE_FORMAT_10          10L    /* dd.mm.yyyy       */
#define SQL_DATE_FORMAT_11          11L    /* yyyy.mm.dd  #052 */
/* #define SQL_DATE_FORMAT_12          12L    yy/mm/dd  #014       */
/* #define SQL_DATE_FORMAT_13          13L    yy-mm-dd  #014       */
#define SQL_DATE_IN_DEFAULT         12L    /* accept above all #052 #066 */
#define SQL_DATE_FORMAT_12          13L    /* yyyymmdd    #064 */
#define SQL_DATE_FORMAT_MAX         13L    /* #066 the max storage is 15 on apiConn svrFmt */
#define SQL_DATE_OUT_DEFAULT        SQL_DATE_FORMAT_7


/* SQL_TIME_INPUT_FORMAT/SQL_TIME_OUTPUT_FORMAT options  #003               */
#define SQL_TIME_FORMAT_0           0L      /* hh:mm:ss.fff       #010      */
#define SQL_TIME_FORMAT_1           1L      /* hh:mm:ss                     */
#define SQL_TIME_FORMAT_2           2L      /* hh:mm                        */
#define SQL_TIME_FORMAT_3           3L      /* hh                           */
#define SQL_TIME_FORMAT_4           4L      /* hh:mm:ss.fff tt              */
#define SQL_TIME_FORMAT_5           5L      /* hh:mm:ss tt                  */
#define SQL_TIME_FORMAT_6           6L      /* hh:mm tt                     */
#define SQL_TIME_FORMAT_7           7L      /* hh tt                        */
#define SQL_TIME_FORMAT_8           8L      /* tt hh:mm:ss.fff              */
#define SQL_TIME_FORMAT_9           9L      /* tt hh:mm:ss                  */
#define SQL_TIME_FORMAT_10          10L     /* tt hh:mm                     */
#define SQL_TIME_FORMAT_11          11L     /* tt hh                        */
#define SQL_TIME_IN_DEFAULT         12L     /* accept above all             */
#define SQL_TIME_FORMAT_12          13L     /* hhmmss                 #064  */
#define SQL_TIME_FORMAT_MAX         13L     /* #066 the max storage is 15 on apiConn svrFmt */
#define SQL_TIME_OUT_DEFAULT        SQL_TIME_FORMAT_1


/* SQL_TIMESTAMP_INPUT_FORMAT/SQL_TIMESTAMP_OUTPUT_FORMAT options  #003     */
#define SQL_TIMESTAMP_FORMAT_0      0L    /* yyyy-mm-dd hh:mm:ss.fff #010   */
#define SQL_TIMESTAMP_FORMAT_1      1L    /* yyyy-mm-dd hh:mm:ss            */
#define SQL_TIMESTAMP_FORMAT_DEFAULT  SQL_TIMESTAMP_FORMAT_0


/* #004 */
#define SQL_ASCII_INPUT             0UL
#define SQL_FILE_INPUT              1UL
#define SQL_INPUT_DEFAULT           SQL_ASCII_INPUT


/* #011 #012 */
#define SQL_BACKUP_DATA             1UL
#define SQL_BACKUP_BLOB             2UL   /* #017 */
#define SQL_BACKUP_OFF              0UL
#define SQL_BACKUP_DEFAULT          SQL_BACKUP_OFF      

/* #015 */
#define SQL_CB_DEFAULT              SQL_CB_CLOSE

/* SQL_BKSVR_CMP options */
#define SQL_BKSVR_CMP_OFF           0UL
#define SQL_BKSVR_CMP_ON            1UL

/* values of SQL_DM_INTERNAL option   #016 */
#define SQL_DM_INTERNAL_OFF         0
#define SQL_DM_INTERNAL_ON          1

/* SQL_RPSVR_CLEAR options #019 */
#define SQL_RPSVR_CLEAR_OFF         0UL 
#define SQL_RPSVR_CLEAR_ON          1UL 
#define SQL_RPSVR_CLEAR_DEFAULT     SQL_RPSVR_CLEAR_OFF
#define SQL_RPSVR_RETRY_DEFULT      0UL

/* SQL_SELINTO_DDB_FO options #024 */
#define SQL_DFO_DUP_NULL       0x00
#define SQL_DFO_DUP_COPY       0x01

/* SQL_FO_TO_SQLTYPE options                                 #030 */
/* keywork "DB_FOTYP" in dmconfig.ini must be one of these values */
#define SQL_FO_FILE             0     /* SDT_FILE maps to SQL_FILE          */
#define SQL_FO_BLOB             1     /* SDT_FILE maps to SQL_LONGVARBINARY */

/* SQL_REMOVE_SPACE_PADDING options #033 */
/* keywork "DB_RMPAD in dmconfig.ini must be one of these values */
#define SQL_REMOVE_SPACE_PADDING_OFF  0    /* keep space padding for char  */ 
#define SQL_REMOVE_SPACE_PADDING_ON   1    /* remove space padding         */

/* values of SQL_CLI_UCODE_TYPE option   #049 */
#define SQL_CLI_UTYPE_UTF16         0
#define SQL_CLI_UTYPE_UTF8          1
#define SQL_CLI_UTYPE_DEFAULT      SQL_CLI_UTYPE_UTF16

/* SQL_ATTR_SYSTEM_DEFAULT option #060 */
#define  SQL_SYSTEM_ON   0x01
#define  SQL_SYSTEM_OFF  0x00
#define  SQL_SYSTEM_DEFAULT SQL_SYSTEM_ON
#define  setSystemOn(fgSysColDef) ((fgSysColDef) & SQL_SYSTEM_ON) /* #074 */
/* SQL_ATTR_HIDDEN_SHOW option #062 */ /* #078 #076 */
#define  SHOW_HIDDEN_OFF             0UL         /* can not show hidden schema and values */
#define  SHOW_HIDDEN_USER_DATA         1UL
#define  SHOW_HIDDEN_USER_SCHEMA       2UL 
#define  SHOW_HIDDEN_USER_SCHEMA_DATA  3UL
#define  SHOW_HIDDEN_SYSTEM_DATA       4UL
#define  SHOW_HIDDEN_DATA              5UL         /* just show hidden values */
#define  SHOW_HIDDEN_SYSTEM_DATA_USER_SCHEMA_DATA      7UL
#define  SHOW_HIDDEN_SCHEMA            10UL         /* just show hidden schema */
#define  SHOW_HIDDEN_SCHEMA_DATA       15UL         /* show hidden schema and values */
 
#define  SHOW_HIDDEN_DEFAULT        SHOW_HIDDEN_OFF
/* SQL_ATTR_BIND_JSON optiion #069 */
#define  SQL_BIND_JSON_ON   3UL   /* auto bind json udf #073 */
#define  SQL_BIND_JSONCOLS_ON 2UL /* only auto bind jsoncols column #073 */
#define  SQL_BIND_DYNAMIC_OFF 2UL /* #073 */ 
#define  SQL_BIND_DYNAMIC_ON  1UL /* only auto bind dynamic column #073 */
#define  SQL_BIND_JSONCOLS_OFF 1UL /* #073 */
#define  SQL_BIND_JSON_OFF  0UL   /* off auto bind jsoncols and dynamic column #073 */
#define  SQL_BIND_JSON_DEFAULT SQL_BIND_JSON_ON
/****************************************************************************
 * extend SQLSetStmtOption/SQLGetStmtOption &
 *        SQLSetConnectOption/SQLGetStmtOption common options            #029 
 ****************************************************************************/
#define SQL_CON_STMT_OPT_DRVR_START 2000
#define SQL_EXTENSION_NAME   (SQL_CON_STMT_OPT_DRVR_START + 1) /* #021 #022 */
#define SQL_MULTI_MEDIA_CLASS (SQL_CON_STMT_OPT_DRVR_START + 2)     /* #037 */

/* SQL_EXTENSION_NAME options (must be uppercase) #023 */
#define SQL_FOB                     "FOB"                           /* #034 */
#define SQL_SOURCE                  "SOURCE"                        /* #034 */
#define SQL_AUTO                    "AUTO"                          /* #034 */
 
/* SQL_CURSOR_COMMIT_BEHAVIOR and SQL_CURSOR_ROLLBACK_BEHAVIOR values #031  */
#define SQL_CB_PRE_SCAN_LK          0x0003          
#define SQL_CC_PRE_SCAN_LK          SQL_CB_PRE_SCAN_LK      
#define SQL_CR_PRE_SCAN_LK          SQL_CB_PRE_SCAN_LK      

/*****************************************************************************
 *  random access BLOB data options
 ****************************************************************************/
#define SQL_GETBLOB_FROM_BEGIN     1
#define SQL_GETBLOB_FROM_CURRENT   2
#define SQL_GETBLOB_FROM_END       3

/****************************************************************************
 *  blob handle type value
 *  
 *  #define SQL_HANDLE_ENV             1
 *  #define SQL_HANDLE_DBC             2
 *  #define SQL_HANDLE_STMT            3
 *  #define SQL_HANDLE_DESC            4
 ****************************************************************************/
#define SQL_HANDLE_BLOB                5



#endif /* _SQLOPT_H */



