/*
 * Decompiled with CFR 0.152.
 */
package tableModel;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import tableCell.TableHeaderRenderer;
import tableModel.ColumnSorting;
import tableModel.FileSize;

public class DBAToolAbstractTableModel
extends AbstractTableModel {
    private JTable in_table = null;
    private JTable table = null;
    private TableModel model = null;
    private boolean isDesc = false;
    private int sorting_column = -1;
    private String sorting_column_name = null;
    private MouseAdapter listMouseListener = null;
    private TableColumnModelListener tableColumnModelListener = null;
    private boolean isSorting = false;
    private boolean fromEditData = false;
    private int[] realorder = null;

    public DBAToolAbstractTableModel(TableModel model) {
        this.model = model;
        this.realorder = new int[model.getColumnCount()];
        int length = this.realorder.length;
        for (int i = 0; i < length; ++i) {
            this.realorder[i] = i;
        }
    }

    public void setTable(JTable table, boolean fromEditData) {
        this.table = table;
        this.fromEditData = fromEditData;
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.model.getRowCount();
    }

    @Override
    public String getColumnName(int col) {
        if (col < 0 || col >= this.getColumnCount()) {
            return "";
        }
        return this.model.getColumnName(col);
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.model.getValueAt(row, col);
    }

    public Class getColumnClass(int c) {
        return this.model.getColumnClass(c);
    }

    public int getRealColumn(int col) {
        if (col < 0 || col > this.realorder.length) {
            return col;
        }
        return this.realorder[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.realorder[col] != col) {
            return this.model.isCellEditable(row, this.realorder[col]);
        }
        return this.model.isCellEditable(row, col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.model.setValueAt(value, row, col);
        this.fireTableChanged(new TableModelEvent(this));
        if (this.fromEditData) {
            this.table.setRowSelectionInterval(row, row);
        }
    }

    public void sortByColumn(int column) {
        this.isDesc = this.sorting_column == column ? !this.isDesc : false;
        this.sorting_column = column;
        this.sorting_column_name = this.getColumnName(column);
        int row_count = this.model.getRowCount();
        if (row_count <= 0) {
            return;
        }
        Object type = this.model.getValueAt(0, column);
        if (type instanceof Number) {
            this.compareNumberColumn(column, row_count);
            return;
        }
        if (type instanceof String) {
            boolean strtonum = true;
            String temp = null;
            double[] d_array = new double[row_count];
            for (int i = 0; i < row_count; ++i) {
                temp = (String)this.model.getValueAt(i, column);
                if (temp.endsWith("%")) {
                    temp = temp.substring(0, temp.length() - 1);
                }
                try {
                    d_array[i] = Double.parseDouble(temp);
                    continue;
                }
                catch (Exception e) {
                    if (temp.equals("N/A")) {
                        d_array[i] = Double.MAX_VALUE;
                        continue;
                    }
                    strtonum = false;
                    break;
                }
            }
            if (type instanceof String && !strtonum) {
                this.compareStringColumn(column, row_count);
            } else if (type instanceof String && strtonum) {
                this.compareStringToNumberColumn(column, d_array, row_count);
            }
            return;
        }
        if (type instanceof Boolean) {
            this.compareBooleanColumn(column, row_count);
            return;
        }
        this.compareDefaultColumn(column, row_count);
        this.fireTableChanged(new TableModelEvent(this));
    }

    private void compareNumberColumn(int column, int size) {
        int i;
        int result = 0;
        double temp = 0.0;
        double[] d_array = new double[size];
        for (i = 0; i < size; ++i) {
            d_array[i] = ((Number)this.model.getValueAt(i, column)).doubleValue();
        }
        for (i = size - 1; i >= 0; --i) {
            for (int j = 1; j <= i; ++j) {
                result = d_array[j - 1] > d_array[j] ? 1 : (d_array[j - 1] < d_array[j] ? -1 : 0);
                if (result > 0 && !this.isDesc) {
                    ((ColumnSorting)((Object)this.model)).switchOrder(j - 1, j);
                    temp = d_array[j - 1];
                    d_array[j - 1] = d_array[j];
                    d_array[j] = temp;
                    continue;
                }
                if (result >= 0 || !this.isDesc) continue;
                ((ColumnSorting)((Object)this.model)).switchOrder(j - 1, j);
                temp = d_array[j - 1];
                d_array[j - 1] = d_array[j];
                d_array[j] = temp;
            }
        }
    }

    private void compareStringColumn(int column, int size) {
        int result = 0;
        for (int i = size - 1; i >= 0; --i) {
            for (int j = 1; j <= i; ++j) {
                String string2;
                String string1 = (String)this.model.getValueAt(j - 1, column);
                result = string1.compareToIgnoreCase(string2 = (String)this.model.getValueAt(j, column));
                if (result > 0 && !this.isDesc) {
                    ((ColumnSorting)((Object)this.model)).switchOrder(j - 1, j);
                    continue;
                }
                if (result >= 0 || !this.isDesc) continue;
                ((ColumnSorting)((Object)this.model)).switchOrder(j - 1, j);
            }
        }
    }

    private void compareStringToNumberColumn(int column, double[] d_array, int size) {
        int result = 0;
        for (int i = size - 1; i >= 0; --i) {
            for (int j = 1; j <= i; ++j) {
                double temp;
                result = d_array[j - 1] > d_array[j] ? 1 : (d_array[j - 1] < d_array[j] ? -1 : 0);
                if (result > 0 && !this.isDesc) {
                    ((ColumnSorting)((Object)this.model)).switchOrder(j - 1, j);
                    temp = d_array[j - 1];
                    d_array[j - 1] = d_array[j];
                    d_array[j] = temp;
                    continue;
                }
                if (result >= 0 || !this.isDesc) continue;
                ((ColumnSorting)((Object)this.model)).switchOrder(j - 1, j);
                temp = d_array[j - 1];
                d_array[j - 1] = d_array[j];
                d_array[j] = temp;
            }
        }
    }

    private void compareBooleanColumn(int column, int size) {
        int result = 0;
        for (int i = size - 1; i >= 0; --i) {
            for (int j = 1; j <= i; ++j) {
                Boolean boolean2;
                Boolean boolean1 = (Boolean)this.model.getValueAt(j - 1, column);
                result = boolean1.equals(boolean2 = (Boolean)this.model.getValueAt(j, column)) ? 0 : (boolean1 != false ? 1 : -1);
                if (result > 0 && !this.isDesc) {
                    ((ColumnSorting)((Object)this.model)).switchOrder(j - 1, j);
                    continue;
                }
                if (result >= 0 || !this.isDesc) continue;
                ((ColumnSorting)((Object)this.model)).switchOrder(j - 1, j);
            }
        }
    }

    private void compareDefaultColumn(int column, int size) {
        int result = 0;
        for (int i = size - 1; i >= 0; --i) {
            for (int j = 1; j <= i; ++j) {
                Object object1 = this.model.getValueAt(j - 1, column);
                Object object2 = this.model.getValueAt(j, column);
                if (object1 instanceof FileSize && object2 instanceof FileSize) {
                    int int2;
                    int int1 = ((FileSize)object1).getValue();
                    result = int1 > (int2 = ((FileSize)object2).getValue()) ? 1 : (int1 < int2 ? -1 : 0);
                } else {
                    String string1 = object1.toString();
                    String string2 = object2.toString();
                    result = string1.compareTo(string2);
                }
                if (result > 0 && !this.isDesc) {
                    ((ColumnSorting)((Object)this.model)).switchOrder(j - 1, j);
                    continue;
                }
                if (result >= 0 || !this.isDesc) continue;
                ((ColumnSorting)((Object)this.model)).switchOrder(j - 1, j);
            }
        }
    }

    public int getColumnByHeader(String header) {
        int count = this.getColumnCount();
        for (int i = 0; i < count; ++i) {
            if (!this.getColumnName(i).equals(header)) continue;
            return i;
        }
        return -1;
    }

    public void addMouseListenerToHeaderInTable(JTable in_table) {
        final JTable table = in_table;
        TableModel model2 = this.model;
        this.in_table = in_table;
        table.setColumnSelectionAllowed(false);
        if (this.listMouseListener == null) {
            this.listMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (DBAToolAbstractTableModel.this.isSorting) {
                        return;
                    }
                    DBAToolAbstractTableModel.this.isSorting = true;
                    TableColumnModel columnModel = table.getColumnModel();
                    JTableHeader th = (JTableHeader)e.getSource();
                    String header = th.getToolTipText(e);
                    int column = DBAToolAbstractTableModel.this.getColumnByHeader(header);
                    if (column < 0) {
                        return;
                    }
                    DBAToolAbstractTableModel.this.sortByColumn(column);
                    DBAToolAbstractTableModel.this.isSorting = false;
                }
            };
        }
        JTableHeader th = table.getTableHeader();
        th.addMouseListener(this.listMouseListener);
        TableColumn tcol = null;
        for (int i = 0; i < model2.getColumnCount(); ++i) {
            tcol = table.getColumnModel().getColumn(i);
            tcol.setHeaderRenderer(new TableHeaderRenderer());
        }
    }

    public void removeMouseListenerToHeaderInTable(JTable in_table) {
        JTableHeader th = in_table.getTableHeader();
        if (this.listMouseListener != null) {
            th.removeMouseListener(this.listMouseListener);
        }
    }

    public TableModel getModel() {
        return this.model;
    }

    public String getSortingColumn() {
        if (this.sorting_column_name != null) {
            return this.sorting_column_name;
        }
        return this.getColumnName(this.sorting_column);
    }

    public boolean isDescSort() {
        return this.isDesc;
    }
}

