/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.backup;

import ServerMgr.DatabaseConnection;
import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.DbaObject;
import dbaut.DbaUtDef;
import dbaut.GuiUt;
import dbaut.JBackupHistory;
import dbaut.JdmConfig;
import dbaut.JdmTape;
import dbaut.String_array;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaTable;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.text.TextField;
import dbaut.util.JavaTypeUtil;
import dbaut.util.PlatformUtil;
import dbmaker.sql.JdbcOdbcConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import svrmgrwizard.backup.BackupConstants;
import svrmgrwizard.backup.BackupDlg;
import svrmgrwizard.backup.FullBackupTapeTableModel;

public class OnlineFullBackupToTapePanel
extends AbstractWizardPanel {
    private static final long serialVersionUID = 788170057967498555L;
    public static final short LOGICAL_NAME = 0;
    public static final short PHYSICAL_NAME = 1;
    public static final short DESTINATION = 2;
    public static final short FILE_TYPE = 3;
    public static final short DATA_FILE = 0;
    public static final short JOURNAL_FILE = 1;
    private BackupDlg parentDialog = null;
    private AbstractWizardPanel previousPanel = null;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.BackupRes", LocaleManager.getLocale());
    private String title = null;
    private SmHelpButton helpButton = new SmHelpButton();
    private DbaButton cancelButton = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private DbaButton finishButton = new DbaButton(new Dimension(100, 24), this.res.getString("Finish"), 'F', DBAImageResource.getResource(this.getClass(), "/dbautimages/finish.gif"), new ReflectionAction(this, "finishButtonActionPerformed"));
    private DbaButton previousButton = new DbaButton(new Dimension(100, 24), this.res.getString("Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "previousButtonActionPerformed"));
    private JLabel backupDestinationLabel = new JLabel(this.res.getString("Tape_Device_Name_Colon"));
    private JTextField backupDestinationField = new TextField();
    private JRadioButton nonBackup = new JRadioButton(this.res.getString("Turn_Off_Backup_Mode"));
    private JRadioButton backupData = new JRadioButton(this.res.getString("Backup_Data"));
    private JRadioButton backupDataBlob = new JRadioButton(this.res.getString("Backup_Data_And_Blob"));
    private JCheckBox isWriteToConfig = new JCheckBox(this.res.getString("Write_To_Dmconfig"));
    private FullBackupTapeTableModel model = new FullBackupTapeTableModel();
    private DbaTable table = new DbaTable(this.model);
    private DatabaseConnection connection = null;
    private ArrayList connectionInfo = null;
    private String dbName = null;
    private String db_bkdir = null;
    private Integer db_bkzip = null;
    private int bmode = -1;

    public OnlineFullBackupToTapePanel(BackupDlg parentDialog, AbstractWizardPanel previousPanel, DatabaseConnection connection, ArrayList connectionInfo) {
        this.parentDialog = parentDialog;
        this.previousPanel = previousPanel;
        this.connection = connection;
        this.connectionInfo = connectionInfo;
        if (this.connectionInfo.size() <= 0) {
            System.out.println("No connection information." + this.getClass().getName());
            return;
        }
        this.dbName = (String)this.connectionInfo.get(0);
        try {
            CallableStatement cstmt = connection.dbconn.prepareCall("{call GETSYSTEMOPTION('bkzip', ?)}");
            cstmt.registerOutParameter(1, 12);
            cstmt.execute();
            this.db_bkzip = JavaTypeUtil.valueOfInteger(cstmt.getString(1), this.parentDialog);
            cstmt.close();
            this.init();
        }
        catch (SQLException e) {
            GuiUt.showErrorDlg(this.parentDialog, e.getMessage(), "");
        }
    }

    private void init() throws SQLException {
        JPanel jPanel1 = new JPanel();
        jPanel1.setPreferredSize(new Dimension(640, 440));
        jPanel1.setBorder(BorderFactory.createEtchedBorder());
        jPanel1.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new GridLayout(2, 1));
        JPanel destinationPanel = new JPanel(new FlowLayout(0));
        destinationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Destination"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.backupDestinationField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.backupDestinationField.setPreferredSize(new Dimension(440, 24));
        this.backupDestinationField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    OnlineFullBackupToTapePanel.this.backupDestinationFieldKeyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                OnlineFullBackupToTapePanel.this.backupDestinationFieldKeyReleased(e);
            }
        });
        destinationPanel.add(this.backupDestinationLabel);
        destinationPanel.add(this.backupDestinationField);
        JPanel backupModePanel = new JPanel(new BorderLayout());
        backupModePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Backup_Mode"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        JPanel tmpPanel = new JPanel(new FlowLayout(0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.nonBackup);
        bg.add(this.backupData);
        bg.add(this.backupDataBlob);
        tmpPanel.add(this.nonBackup);
        tmpPanel.add(this.backupData);
        tmpPanel.add(this.backupDataBlob);
        backupModePanel.add((Component)tmpPanel, "Center");
        this.isWriteToConfig.setSelected(true);
        backupModePanel.add((Component)this.isWriteToConfig, "East");
        topPanel.add(destinationPanel);
        topPanel.add(backupModePanel);
        JPanel tableContentsPanel = new JPanel(new BorderLayout());
        tableContentsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Backup_Contents"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        JScrollPane tableContentsScrollPane = new JScrollPane();
        tableContentsScrollPane.setBorder(BorderFactory.createEtchedBorder());
        tableContentsScrollPane.getViewport().add(this.table);
        tableContentsPanel.add(tableContentsScrollPane);
        jPanel1.add((Component)topPanel, "North");
        jPanel1.add((Component)tableContentsPanel, "Center");
        this.add((Component)jPanel1, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.finishButton.setHorizontalTextPosition(2);
        this.cancelButton.setHorizontalTextPosition(2);
        SmFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "Help_Backup_OnlineFullBackupToTapePanel", null);
        buttonPanel.add(this.previousButton);
        buttonPanel.add(this.finishButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        this.setButtonBar(buttonPanel);
        this.initBackupMode();
        this.initColumnSizes(this.table);
        this.initTableContents();
        this.setFinishButtonStatus();
    }

    private void backupDestinationFieldKeyReleased(KeyEvent e) {
        this.setFinishButtonStatus();
        if (e.getKeyCode() == 10) {
            this.finishButtonActionPerformed(null);
        }
    }

    private void initBackupMode() {
        try {
            this.bmode = ((JdbcOdbcConnection)this.connection.dbconn).getOptionInt(1120);
            if (this.bmode == 0) {
                this.nonBackup.setSelected(true);
            } else if (this.bmode == 1) {
                this.backupData.setSelected(true);
            } else {
                this.backupDataBlob.setSelected(true);
                this.backupData.setEnabled(false);
            }
        }
        catch (SQLException e) {
            GuiUt.showErrorDlg(this.parentDialog, e.getMessage(), "");
        }
    }

    private void initColumnSizes(JTable table) {
        table.setAutoscrolls(true);
    }

    private void initTableContents() throws SQLException {
        this.db_bkdir = JdmConfig.getOnlineBackupDir(this.dbName, this.connection.dbconn);
        this.getDmConfigBackupInfo("dmconfig.ini");
        this.getDataFileBackupInfo();
        this.getJournalFileBackupInfo(this.dbName);
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    private void getDmConfigBackupInfo(String fileName) {
        JdmConfig dmConfig = new JdmConfig();
        String dmConfigFilePath = dmConfig.filePath(fileName);
        String tmpFileName = null;
        if (dmConfigFilePath != null && dmConfigFilePath.length() > 0) {
            int index = dmConfigFilePath.lastIndexOf(BackupConstants.FILE_SEPARATOR);
            tmpFileName = dmConfigFilePath.substring(index + 1);
        }
        Object[] one_row = new Object[]{"CONFIG", dmConfigFilePath, this.db_bkdir + BackupConstants.FILE_SEPARATOR + tmpFileName, new Short(0)};
        this.model.addValue(one_row);
    }

    private void getDataFileBackupInfo() {
        String temp = null;
        Statement stmt = null;
        try {
            stmt = this.connection.dbconn.createStatement();
            String query = "select FILE_NAME, GETFILENAME(FILE_NAME) from SYSTEM.SYSFILE where FILE_NAME != 'SYSJNL'";
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                Object[] one_row = new Object[4];
                temp = rs.getString(1);
                one_row[0] = rs.wasNull() ? "" : temp.trim();
                temp = rs.getString(2);
                String physical_name = rs.wasNull() ? "" : temp.trim();
                one_row[1] = physical_name;
                int index = physical_name.lastIndexOf(BackupConstants.FILE_SEPARATOR);
                if (index > 0) {
                    physical_name = new String(physical_name.substring(index + BackupConstants.FILE_SEPARATOR_LEN));
                }
                String tmpDes = this.db_bkdir + BackupConstants.FILE_SEPARATOR + physical_name;
                if (this.db_bkzip == 1) {
                    tmpDes = tmpDes + ".gz";
                }
                one_row[2] = tmpDes;
                one_row[3] = new Short(0);
                this.model.addValue(one_row);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this, null, sqle);
            DbaObject.close(stmt);
        }
    }

    private void getJournalFileBackupInfo(String dbName) {
        String dbDir = JdmConfig.getDBDir(dbName);
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", dbName, "r");
        if (rc != 0) {
            return;
        }
        String_array files = (String_array)config.getPara("DB_JNFIL", 53504);
        config.fileClose();
        for (int i = 0; i < files.size(); ++i) {
            String str = files.content[i];
            if (str.length() == 0) continue;
            int g = str.lastIndexOf(BackupConstants.FILE_SEPARATOR);
            String filename = g >= 0 ? new String(str.substring(g + 1)) : str;
            Object[] one_row = new Object[4];
            one_row[0] = "SYSJNL";
            one_row[1] = g >= 0 ? str : dbDir + BackupConstants.FILE_SEPARATOR + filename;
            String tmpDes = this.db_bkdir + BackupConstants.FILE_SEPARATOR + filename;
            if (this.db_bkzip == 1) {
                tmpDes = tmpDes + ".gz";
            }
            one_row[2] = tmpDes;
            one_row[3] = new Short(1);
            this.model.addValue(one_row);
        }
    }

    public void previousButtonActionPerformed(ActionEvent e) {
        this.parentDialog.next(this.previousPanel);
    }

    public void finishButtonActionPerformed(ActionEvent e) {
        this.runBackupTask();
    }

    public int getBackupMode() {
        int backupMode = -1;
        backupMode = this.nonBackup.isSelected() ? 0 : (this.backupData.isSelected() ? 1 : 2);
        return backupMode;
    }

    private void runBackupTask() {
        String devname = this.backupDestinationField.getText();
        JBackupHistory hist = new JBackupHistory(SmFrame.frame);
        String hisFilePath = hist.FilePath(this.dbName, "", "0");
        int rc = hist.FileOpen(this.dbName, hisFilePath, "1");
        if (rc != DbaUtDef.RTN_OK) {
            System.out.println("Error open backup history file " + hisFilePath + ". And err no = " + rc);
            return;
        }
        Statement stmt = null;
        try {
            String db_file;
            String logical_name;
            int i;
            JdmTape dmtape;
            stmt = this.connection.dbconn.createStatement();
            stmt.execute("BEGIN BACKUP");
            int newBMode = this.getBackupMode();
            if (newBMode != this.bmode) {
                ((JdbcOdbcConnection)this.connection.dbconn).setOption(1120, newBMode);
            }
            if ((rc = (dmtape = new JdmTape()).beginBackupTape(devname, this.dbName, 1)) != DbaUtDef.RTN_OK) {
                throw new Exception("rc = " + rc + " " + dmtape.getError(rc));
            }
            for (i = 0; i < this.model.getRowCount(); ++i) {
                logical_name = (String)this.model.getValueAt(i, 0);
                db_file = (String)this.model.getValueAt(i, 1);
                if (logical_name.equals("SYSJNL")) continue;
                rc = dmtape.prepareTapeFile(logical_name, db_file);
                if (rc != DbaUtDef.RTN_OK) {
                    throw new Exception("rc = " + rc + " " + dmtape.getError(rc));
                }
                if (i == 0) {
                    hist.setBackupData(0, 3, db_file, logical_name, devname + ":" + logical_name, 1);
                    continue;
                }
                hist.setBackupData(0, 3, db_file, logical_name, devname + ":" + logical_name, 0);
            }
            stmt.execute("END BACKUP DATAFILE");
            for (i = 0; i < this.model.getRowCount(); ++i) {
                logical_name = (String)this.model.getValueAt(i, 0);
                db_file = (String)this.model.getValueAt(i, 1);
                if (!logical_name.equals("SYSJNL")) continue;
                rc = dmtape.prepareTapeFile(logical_name, db_file);
                if (rc != DbaUtDef.RTN_OK) {
                    throw new Exception("rc = " + rc + " " + dmtape.getError(rc));
                }
                if (i == this.model.getRowCount() - 1) {
                    hist.setBackupData(0, 3, db_file, logical_name, devname + ":" + logical_name, 2);
                    continue;
                }
                hist.setBackupData(0, 3, db_file, logical_name, devname + ":" + logical_name, 0);
            }
            stmt.execute("END BACKUP JOURNAL");
            stmt.close();
            hist.FileClose();
            JdmConfig dmconfig = new JdmConfig();
            if (this.isWriteToConfig.isSelected()) {
                dmconfig.fileOpen("dmconfig.ini", this.dbName, "r+");
                dmconfig.insertPara("DB_BMODE", new Integer(newBMode), 8192);
                dmconfig.fileClose();
            }
            if ((rc = dmtape.prepareTapeFile("dmconfig.ini", dmconfig.filePath("dmconfig.ini"))) != DbaUtDef.RTN_OK) {
                throw new Exception("rc = " + rc + " " + dmtape.getError(rc));
            }
            System.out.println("write dmconfig.ini to tape successfully == " + dmconfig.filePath("dmconfig.ini"));
            rc = dmtape.prepareTapeFile("dmBackup.his", hisFilePath);
            if (rc != DbaUtDef.RTN_OK) {
                throw new Exception("rc = " + rc + " " + dmtape.getError(rc));
            }
            System.out.println("write Backup history to tape successfully");
            while ((rc = dmtape.writeToTape()) == 10002) {
                do {
                    if ((rc = dmtape.ejectTape(devname)) != 0) {
                        throw new Exception("rc = " + rc + " " + dmtape.getError(rc));
                    }
                    if (0 == GuiUt.showOptionDlg(this, "Load another tape", "Please load another tape")) continue;
                    throw new Exception();
                } while ((rc = dmtape.loadBackupTape(devname)) != 0);
            }
            dmtape.endBackupTape();
            GuiUt.showInformationDlg(this, this.res.getString("Backup_Successfully_FullStop"));
            this.cancelButtonActionPerformed(null);
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            if (msg.length() > 0) {
                GuiUt.showErrorDlg(this.parentDialog, msg, null);
            }
            try {
                stmt.execute("ABORT BACKUP");
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        if (this.connection.isConnected()) {
            this.connection.disconnect();
        }
        this.parentDialog.setVisible(false);
        this.parentDialog.dispose();
    }

    @Override
    public void windowClosing() {
        this.cancelButtonActionPerformed(null);
    }

    @Override
    public String getTitle() {
        this.title = "Online_Full_Backup_To_Tape";
        return this.title;
    }

    private void setFinishButtonStatus() {
        if (this.backupDestinationField.getText() == null || this.backupDestinationField.getText().trim().length() == 0) {
            this.finishButton.setEnabled(false);
        } else {
            this.finishButton.setEnabled(true);
        }
    }
}

