/*
 * Decompiled with CFR 0.152.
 */
package queryAnalyzer;

import dbatool.DbFrame;
import dbaut.GuiUt;
import dbaut.comp.DbaFileChooser;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ToolBarButton;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleChangeListener;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JToolBar;
import queryAnalyzer.QueryFrame;
import queryAnalyzer.RunBatchDlg;
import queryAnalyzer.SaveCommandDlg;

public class QueryToolBar
extends JToolBar
implements LocaleChangeListener {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("resource.jsqltool", LocaleManager.getLocale());
    public ToolBarButton runCommandButton = new ToolBarButton("/images/execute.gif", this.res.getString("Run_SQL_F12"));
    public ToolBarButton undoButton = new ToolBarButton("/images/undo.png", this.res.getString("Undo"));
    public ToolBarButton redoButton = new ToolBarButton("/images/redo.png", this.res.getString("Redo"));
    public ToolBarButton saveCommandButton = new ToolBarButton("/images/save.gif", this.res.getString("Save_Command"));
    public ToolBarButton loadCommandButton = new ToolBarButton("/images/load.gif", this.res.getString("Load_Command"));
    public ToolBarButton clearCommandButton = new ToolBarButton("/images/delete.gif", this.res.getString("Clear_command_F4"));
    public ToolBarButton executeBatchButton = new ToolBarButton("/images/executeBatch.gif", this.res.getString("Execute_Batch"));

    public QueryToolBar() {
        this.setLayout(new GridLayout(1, 5, 2, 2));
        this.setFloatable(false);
        this.runCommandButton.addActionListener(new ReflectionAction(this, "runCommandButton_actionPerformed"));
        this.undoButton.addActionListener(new ReflectionAction(this, "undoButton_actionPerformed"));
        this.redoButton.addActionListener(new ReflectionAction(this, "redoButton_actionPerformed"));
        this.saveCommandButton.addActionListener(new ReflectionAction(this, "saveCommandButton_actionPerformed"));
        this.loadCommandButton.addActionListener(new ReflectionAction(this, "loadCommandButton_actionPerformed"));
        this.clearCommandButton.addActionListener(new ReflectionAction(this, "clearCommandButton_actionPerformed"));
        this.executeBatchButton.addActionListener(new ReflectionAction(this, "executeBatchItem_actionPerformed"));
        this.clearCommandButton.setEnabled(false);
        this.add(this.runCommandButton);
        this.add(this.undoButton);
        this.add(this.redoButton);
        this.add(this.saveCommandButton);
        this.add(this.loadCommandButton);
        this.add(this.clearCommandButton);
        this.add(this.executeBatchButton);
    }

    public void runCommandButton_actionPerformed(ActionEvent e) {
        QueryFrame.frame.ExecuteCommand();
        this.runCommandButton.setFocusPainted(false);
    }

    public void undoButton_actionPerformed(ActionEvent e) {
        QueryFrame.frame.sqlTextArea.undo();
        this.undoButton.setEnabled(QueryFrame.frame.sqlTextArea.canUndo());
        this.redoButton.setEnabled(QueryFrame.frame.sqlTextArea.canRedo());
    }

    public void redoButton_actionPerformed(ActionEvent e) {
        QueryFrame.frame.sqlTextArea.redo();
        this.undoButton.setEnabled(QueryFrame.frame.sqlTextArea.canUndo());
        this.redoButton.setEnabled(QueryFrame.frame.sqlTextArea.canRedo());
    }

    public void saveCommandButton_actionPerformed(ActionEvent e) {
        new SaveCommandDlg(DbFrame.frame, true);
        this.saveCommandButton.setFocusPainted(false);
    }

    public void loadCommandButton_actionPerformed(ActionEvent e) {
        block13: {
            DbaFileChooser outputFile = null;
            outputFile = QueryFrame.frame.px.getBlobFilePath() != null ? new DbaFileChooser(QueryFrame.frame.px.getBlobFilePath()) : new DbaFileChooser(QueryFrame.frame.px.getSelectedDirectory());
            int loadResponse = outputFile.showOpenDialog(QueryFrame.frame);
            if (loadResponse == 0) {
                File file = outputFile.getSelectedFile();
                String enc = null;
                InputStreamReader reader = null;
                try {
                    QueryFrame.frame.setMessageField(this.res.getString("Load_Command"));
                    file.toURL();
                    if (file.exists()) {
                        FileInputStream stream = new FileInputStream(file);
                        int size = stream.available();
                        byte[] b = new byte[3];
                        stream.read(b, 0, 3);
                        Byte b1 = new Byte(b[0]);
                        Byte b2 = new Byte(b[1]);
                        if (b1.intValue() == -2 && b2.intValue() == -1) {
                            enc = "UnicodeBig";
                            size = (size - 2) / 2;
                            stream = new FileInputStream(file);
                            reader = new InputStreamReader((InputStream)stream, enc);
                        } else if (b1.intValue() == -1 && b2.intValue() == -2) {
                            enc = "UnicodeLittle";
                            size = (size - 2) / 2;
                            stream = new FileInputStream(file);
                            reader = new InputStreamReader((InputStream)stream, enc);
                        } else if (b[0] == -17 && b[1] == -69 && b[2] == -65) {
                            enc = "UTF-8";
                            reader = new InputStreamReader((InputStream)stream, enc);
                        } else {
                            stream = new FileInputStream(file);
                            reader = new InputStreamReader(stream);
                        }
                        char[] CC = new char[size];
                        int breakpoint = 0;
                        reader.read(CC);
                        reader.close();
                        for (int n = size; n > 0; --n) {
                            if (CC[n - 1] == '\u0000') continue;
                            breakpoint = n;
                            break;
                        }
                        QueryFrame.frame.sqlTextArea.setText(new String(CC, 0, breakpoint));
                        GuiUt.showInformationDlg(DbFrame.frame, this.res.getString("Load_file_successful"));
                        if (size > 0) {
                            QueryFrame.frame.clearButtonStatus(true);
                        } else {
                            QueryFrame.frame.clearButtonStatus(false);
                        }
                        break block13;
                    }
                    String s1 = this.res.getString("file_does_not_exist");
                    String s2 = GuiUt.mapStringForProperty(s1, file.toString());
                    GuiUt.showWarningDlg(DbFrame.frame, this.res.getString("Warning"), s2);
                    return;
                }
                catch (Exception ee) {
                    QueryFrame.frame.setMessageField(this.res.getString("Load_Failed"));
                    GuiUt.showWarningDlg(DbFrame.frame, this.res.getString("Warning"), ee.getMessage());
                    return;
                }
            }
        }
        this.loadCommandButton.setFocusPainted(false);
    }

    public void clearCommandButton_actionPerformed(ActionEvent e) {
        this.clearCommandButton.setEnabled(false);
        QueryFrame.frame.clearResultPane();
        QueryFrame.frame.clearNonQueryPane();
        QueryFrame.frame.clearQueryPane();
        QueryFrame.frame.askFocus();
        this.clearCommandButton.setFocusPainted(false);
    }

    public void executeBatchItem_actionPerformed(ActionEvent e) {
        RunBatchDlg encDlg = new RunBatchDlg(QueryFrame.frame, true);
        GuiUt.setCenterLocation(DbFrame.frame, encDlg);
        encDlg.show();
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        DBAResourceBundle res = QueryFrame.frame.res;
        this.runCommandButton.setToolTipText(res.getString("Run_SQL_F5"));
        this.undoButton.setToolTipText(res.getString("Undo"));
        this.redoButton.setToolTipText(res.getString("Redo"));
        this.saveCommandButton.setToolTipText(res.getString("Save_Command"));
        this.loadCommandButton.setToolTipText(res.getString("Load_Command"));
        this.clearCommandButton.setToolTipText(res.getString("Clear_command_F4"));
    }
}

