/*
 * Decompiled with CFR 0.152.
 */
package queryAnalyzer;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import dbatool.DbFrame;
import dbatool.tableCell.JSONJTextPane;
import dbaut.GuiUt;
import dbaut.comp.DbaFileChooser;
import dbaut.comp.DbaToggleButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ToolBarButton;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import executionPlan.SaveAsJpg;
import executionPlan.ShowPlanJPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileNameExtensionFilter;
import queryAnalyzer.QueryFrame;

public class AsShowPlanPane
extends JPanel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("resource.jsqltool", LocaleManager.getLocale());
    private String jsonstr = "";
    ShowPlanJPanel plan = null;
    JSONJTextPane textPane = null;
    DbaToggleButton rawJsonSource = new DbaToggleButton("JSON", DBAImageResource.getResource(this.getClass(), "/images/jsonsource.png"));
    DbaToggleButton showGraphic = new DbaToggleButton(this.res.getString("Graphic"), DBAImageResource.getResource(this.getClass(), "/images/graphic.png"));
    JScrollPane contentPanel = new JScrollPane();

    public AsShowPlanPane(String sqlStatement, String json) {
        this.jsonstr = json;
        System.out.println("json=" + json);
        JToolBar toolbar = new JToolBar();
        toolbar.setLayout(new FlowLayout(0, 2, 0));
        ToolBarButton saveAsImage = new ToolBarButton("/images/save.png", this.res.getString("save_as_img"));
        saveAsImage.addActionListener(new ReflectionAction(this, "saveAs_actionPerformed"));
        this.rawJsonSource.addActionListener(new ReflectionAction(this, "rawJsonSource_actionPerformed"));
        this.showGraphic.addActionListener(new ReflectionAction(this, "showGraphic_actionPerformed"));
        toolbar.setFloatable(false);
        toolbar.setBorder(BorderFactory.createEtchedBorder());
        toolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        toolbar.add(this.rawJsonSource);
        toolbar.add(this.showGraphic);
        toolbar.addSeparator();
        toolbar.add(saveAsImage);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rawJsonSource);
        bg.add(this.showGraphic);
        this.showGraphic.setSelected(true);
        JPanel centerPanel = new JPanel();
        JLabel sql = new JLabel("SQL> " + sqlStatement);
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)sql, "North");
        this.plan = new ShowPlanJPanel(this.jsonstr);
        this.plan.setBorder(BorderFactory.createEmptyBorder());
        this.contentPanel.getViewport().add(this.plan);
        centerPanel.add((Component)this.contentPanel, "Center");
        JPanel jp = new JPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)toolbar, "North");
        this.add((Component)centerPanel, "Center");
    }

    public void saveAs_actionPerformed(ActionEvent e) {
        if (this.showGraphic.isSelected()) {
            DbaFileChooser outputFileChooser = new DbaFileChooser(QueryFrame.frame.px.getBlobFilePath());
            outputFileChooser.setFileFilter(new FileNameExtensionFilter(".png", "png"));
            outputFileChooser.setFileFilter(new FileNameExtensionFilter(".jpg", "jpg"));
            int saveResponse = outputFileChooser.showDialog(QueryFrame.frame, this.res.getString("save_as"));
            if (saveResponse == 0) {
                String extname = outputFileChooser.getFileFilter().getDescription();
                String path = outputFileChooser.getSelectedFile().getPath();
                if (path.toLowerCase().endsWith(".jpg") || path.toLowerCase().endsWith(".png")) {
                    extname = "";
                    File file2 = new File(path);
                    if (file2.exists()) {
                        if (!file2.canWrite()) {
                            String s1 = this.res.getString("file_cannot_be_written");
                            String s2 = GuiUt.mapStringForProperty(s1, file2.toString());
                            GuiUt.showWarningDlg(DbFrame.frame, this.res.getString("Warning"), s2);
                            return;
                        }
                        String s1 = this.res.getString("file_cannot_is_existed");
                        String s2 = GuiUt.mapStringForProperty(s1, file2.toString());
                        int answer = GuiUt.showOptionDlg(DbFrame.frame, this.res.getString("Warning"), s2);
                        if (answer == 0) {
                            file2.delete();
                        } else {
                            return;
                        }
                    }
                }
                SaveAsJpg.componentToImage(this.plan, path + extname);
                GuiUt.showInformationDlg(DbFrame.frame, this.res.getString("Save_table_successful"));
            }
        } else {
            DbaFileChooser outputFileChooser = new DbaFileChooser(QueryFrame.frame.px.getBlobFilePath());
            outputFileChooser.setFileFilter(new FileNameExtensionFilter(".txt", "txt"));
            int saveResponse = outputFileChooser.showDialog(QueryFrame.frame, this.res.getString("save_as"));
            File file = outputFileChooser.getSelectedFile();
            if (saveResponse == 0) {
                String ss = file.getPath() + ".txt";
                file = new File(ss);
                try {
                    BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                    out.write(this.textPane.getText());
                    out.close();
                }
                catch (FileNotFoundException e1) {
                    GuiUt.showErrorDlg(DbFrame.frame, this.res.getString("Save_table_fail"), "");
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    GuiUt.showErrorDlg(DbFrame.frame, this.res.getString("Save_table_fail"), "");
                    e1.printStackTrace();
                }
                GuiUt.showInformationDlg(DbFrame.frame, this.res.getString("Save_table_successful"));
            }
        }
    }

    public void rawJsonSource_actionPerformed(ActionEvent e) {
        if (this.textPane == null) {
            JsonElement root = new JsonParser().parse(this.jsonstr);
            this.textPane = new JSONJTextPane(root);
        }
        this.contentPanel.getViewport().removeAll();
        this.contentPanel.getViewport().add(this.textPane);
    }

    public void showGraphic_actionPerformed(ActionEvent e) {
        this.contentPanel.getViewport().removeAll();
        this.contentPanel.getViewport().add(this.plan);
    }
}

