/*
 * Decompiled with CFR 0.152.
 */
package monitor;

import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.locale.LocaleManager;
import dbaut.privilege.UserPrivilege;
import dbmaker.sql.JdbcOdbcConnection;
import java.awt.Component;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import monitor.LoginDlg;
import monitor.MonitorDlg;
import monitor.MonitorFrame;

public class DatabaseConnection {
    public static String dbLoginStr = "jdbc:dbmaker:";
    public static String dbDriverName = "dbmaker.sql.JdbcOdbcDriver";
    private Connection dbconn = null;
    String dbname = "";
    String username = "";
    String dbdir = "";
    private float fileVersion = 0.0f;
    private float version = 0.0f;
    private Component dlg = null;
    private boolean startDB = false;
    private boolean isIDCAP = true;
    private UserPrivilege userPrivilege = null;

    public DatabaseConnection(String dbname, String username, String password, Component dlg) {
        this.dlg = dlg == null ? MonitorFrame.frame : dlg;
        Object stmt = null;
        try {
            this.dbname = dbname;
            this.username = username;
            Class.forName(dbDriverName);
            JdmConfig config = new JdmConfig();
            if (config.isTerminalServer(dbname)) {
                System.setProperty("DM_DRIVER_MODE", "SINGLE_USER");
                if (!GuiUt.isWindows()) {
                    System.out.println("DM_CONNECT_MODE=START_DB");
                    System.setProperty("DM_CONNECT_MODE", "START_DB");
                    this.startDB = true;
                } else {
                    System.out.println("DM_CONNECT_MODE=SQL_DMTOOL_CONNECT_DB");
                    System.setProperty("DM_CONNECT_MODE", "SQL_DMTOOL_CONNECT_DB");
                }
            } else {
                System.out.println("DM_DRIVER_MODE=CLIENT_SERVER");
                System.setProperty("DM_DRIVER_MODE", "CLIENT_SERVER");
                System.out.println("DM_CONNECT_MODE=SQL_DMTOOL_CONNECT_DB");
                System.setProperty("DM_CONNECT_MODE", "SQL_DMTOOL_CONNECT_DB");
            }
            String errlcode = LocaleManager.getErrlcode();
            String conStr = dbLoginStr + dbname + ";errlcode=" + errlcode;
            this.dbconn = DriverManager.getConnection(conStr, username, password);
            this.dbconn.setAutoCommit(true);
            ((JdbcOdbcConnection)this.dbconn).setOption(1126, 2);
            this.setIDCAP(this.getIDCAP());
            MonitorFrame.frame.isConnect = this.initPrivilege(this.dbconn, this.username, this.dlg);
            this.getFileVersion();
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(MonitorFrame.frame, null, sqle);
            MonitorFrame.frame.isConnect = false;
            if (dlg instanceof MonitorDlg) {
                ((MonitorDlg)((Object)dlg)).setResult(false);
            }
            if (dlg instanceof LoginDlg) {
                MonitorFrame.frame.isConnect = false;
            }
            DbaObject.close(stmt);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Connection getConnection() {
        return this.dbconn;
    }

    private boolean initPrivilege(Connection conn, String userName, Component comp) {
        boolean result = true;
        try {
            if (this.isIDCAP()) {
                userName = userName.toUpperCase();
            }
            this.setUserPrivilege(new UserPrivilege(conn, userName, comp));
        }
        catch (SQLException ex) {
            result = false;
            ex.printStackTrace();
        }
        return result;
    }

    public UserPrivilege getUserPrivilege() {
        return this.userPrivilege;
    }

    private void setUserPrivilege(UserPrivilege userPrivilege) {
        this.userPrivilege = userPrivilege;
    }

    public float getDBFileVersion() {
        return this.fileVersion;
    }

    private void getFileVersion() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.dbconn.createStatement();
            rs = stmt.executeQuery("select VALUE from SYSTEM.SYSINFO WHERE INFO in ('FILE_VERSION')");
            if (rs.next()) {
                this.fileVersion = new Float(rs.getString(1)).floatValue();
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            GuiUt.showSQLException(this.dlg, null, e);
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
    }

    public boolean disconnect() {
        try {
            if (this.dbconn != null) {
                if (this.startDB) {
                    System.out.println("DM_DISCONNECT_MODE=TERMINATE_DB");
                    System.setProperty("DM_DISCONNECT_MODE", "TERMINATE_DB");
                }
                this.dbconn.close();
            }
            return true;
        }
        catch (SQLException E) {
            GuiUt.showSQLException(MonitorFrame.frame, null, E);
            System.out.println("Transaction failed : " + E.getMessage());
            E.printStackTrace();
            return false;
        }
    }

    private boolean getIDCAP() throws SQLException {
        boolean result = false;
        int value = ((JdbcOdbcConnection)this.dbconn).getOptionInt(28);
        if (value == 1) {
            result = true;
        }
        return result;
    }

    public boolean isIDCAP() {
        return this.isIDCAP;
    }

    private void setIDCAP(boolean isIDCAP) {
        this.isIDCAP = isIDCAP;
    }
}

