/*
 * Decompiled with CFR 0.152.
 */
package monitor;

import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleChangeListener;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import monitor.DataObject;
import monitor.DataSet;
import monitor.TablePanel;

public class DataTableModel
extends AbstractTableModel
implements LocaleChangeListener {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("Monitorproperties.Monitor.MonitorRes", LocaleManager.getLocale());
    private String[] columnNames = new String[]{this.res.getString("TableModel_Line"), this.res.getString("TableModel_Scale"), this.res.getString("TableModel_Name"), this.res.getString("TableModel_Value")};
    private DataSet dataset = null;
    private TablePanel tablepanel;

    public DataTableModel(DataSet dataset) {
        this.dataset = dataset;
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataset.getItemCount();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        DataObject obj = this.dataset.getItem(row);
        int last = 60 - this.dataset.linepos - 1;
        long[] lastvalue = obj.getData();
        switch (col) {
            case 0: {
                return obj;
            }
            case 1: {
                return obj.proportion.toString();
            }
            case 2: {
                return this.res.getString(obj.key);
            }
            case 3: {
                if (last < 0) {
                    return new String();
                }
                if (obj.keyindex == 31 || obj.keyindex == 32 || obj.keyindex == 33) {
                    return new Long(lastvalue[last]).toString();
                }
                if (lastvalue[last] < 0L) {
                    return new String("N/A");
                }
                return new Long(lastvalue[last]).toString();
            }
        }
        return null;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = e == null ? DBAResourceBundle.getDBAResourceBundle("Monitorproperties.Monitor.MonitorRes", LocaleManager.getLocale()) : DBAResourceBundle.getDBAResourceBundle("Monitorproperties.Monitor.MonitorRes", e.getLocale());
        this.columnNames = new String[]{this.res.getString("TableModel_Line"), this.res.getString("TableModel_Scale"), this.res.getString("TableModel_Name"), this.res.getString("TableModel_Value")};
        TableCellRenderer xx = TablePanel.table.getColumnModel().getColumn(0).getCellRenderer();
        int col_1 = TablePanel.table.getColumnModel().getColumn(0).getWidth();
        int col_2 = TablePanel.table.getColumnModel().getColumn(1).getWidth();
        int col_3 = TablePanel.table.getColumnModel().getColumn(2).getWidth();
        int col_4 = TablePanel.table.getColumnModel().getColumn(3).getWidth();
        this.fireTableStructureChanged();
        TablePanel.table.getColumnModel().getColumn(0).setPreferredWidth(col_1);
        TablePanel.table.getColumnModel().getColumn(1).setPreferredWidth(col_2);
        TablePanel.table.getColumnModel().getColumn(2).setPreferredWidth(col_3);
        TablePanel.table.getColumnModel().getColumn(3).setPreferredWidth(col_4);
        TablePanel.table.getColumnModel().getColumn(0).setCellRenderer(xx);
    }
}

