/*
 * Decompiled with CFR 0.152.
 */
package framework.data;

import dbaut.Logical_file;
import framework.DMConfigManager;
import framework.DatabaseConnector;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import junit.framework.Assert;

public class TablespaceManager {
    private static final String logicFile = "F111";
    private static final String phyFile = "F111";
    private static final String fileSize = "300";
    private static Logical_file lf = new Logical_file("F111", "300");

    public static void createTablespace(String dbName, String sql) throws SQLException {
        Connection con = DatabaseConnector.connectDatabase(dbName);
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        DatabaseConnector.disconnectDatabase(con);
    }

    public static void dropTablespace(String dbName, String sql) throws SQLException {
        Connection con = DatabaseConnector.connectDatabase(dbName);
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        DatabaseConnector.disconnectDatabase(con);
    }

    public static void createTS(String dbName, String tsName) {
        try {
            DMConfigManager.insertKeyword("TESTDB", "F111", lf, 53760);
            String sql = "create tablespace " + tsName + " datafile " + "F111" + " type=data";
            TablespaceManager.createTablespace("TESTDB", sql);
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void dropTS(String dbName, String tsName) {
        try {
            ArrayList files = TablespaceManager.getTablespaceFiles("TESTDB", tsName);
            String sql = "drop tablespace " + tsName;
            TablespaceManager.dropTablespace("TESTDB", sql);
            TablespaceManager.deleteTablespaceFiles(files);
            DMConfigManager.deleteKeyword("TESTDB", "F111");
        }
        catch (SQLException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static ArrayList getTablespaceFiles(String dbName, String tsName) throws SQLException {
        String sql = "select FILE_NAME, GETFILENAME(FILE_NAME)  from SYSTEM.SYSFILE where TS_NAME = '" + tsName + "'";
        Connection con = DatabaseConnector.connectDatabase(dbName);
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        ArrayList<String> files = new ArrayList<String>();
        while (rs.next()) {
            files.add(rs.getString(2).trim());
        }
        rs.close();
        stmt.close();
        DatabaseConnector.disconnectDatabase(con);
        return files;
    }

    public static void deleteTablespaceFiles(ArrayList files) {
        if (files == null || files.size() <= 0) {
            return;
        }
        String s = null;
        File f = null;
        for (int i = 0; i < files.size(); ++i) {
            s = (String)files.get(i);
            f = new File(s);
            if (!f.exists()) continue;
            f.delete();
        }
    }
}

