/*
 * Decompiled with CFR 0.152.
 */
package executionPlan;

import com.google.gson.JsonElement;
import dbaut.text.TextField;
import executionPlan.Arrow;
import executionPlan.ShowPlanJPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class SingleExecutePlanPanel
extends JPanel
implements MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = 3646912531250856052L;
    private static final Color POPUP_INFO_COLOR = new Color(Integer.decode("#d2e9ff"));
    private static final Color SCAN_BLOCK_COLOR = new Color(Integer.decode("#ffd2d2"));
    private static final int TOTAL_WIDTH = 100;
    private static final int TOTAL_HEIGHT = 100;
    private String title = "";
    private String title2 = null;
    private JPopupMenu pop = new JPopupMenu();
    private static Point lastPos = new Point(0, 0);
    public static final int DEFAULT_WIDTH = 140;
    public static final int DEFAULT_HEIGHT = 80;
    public static final int DEFAULT_X_SPACE = 50;
    public static final int DEFAULT_Y_SPACE = 30;
    private ArrayList<SingleExecutePlanPanel> children = new ArrayList();

    public static void create(ShowPlanJPanel showPanel, SingleExecutePlanPanel parent, Point pos, JsonElement elm) {
        if (elm.isJsonArray()) {
            Iterator it = elm.getAsJsonArray().iterator();
            while (it.hasNext()) {
                SingleExecutePlanPanel.create(showPanel, parent, pos, (JsonElement)it.next());
                pos = new Point(pos.x, SingleExecutePlanPanel.lastPos.y + 110);
            }
        } else if (elm.isJsonObject()) {
            Set set = elm.getAsJsonObject().entrySet();
            for (Map.Entry entry : set) {
                String key0 = (String)entry.getKey();
                JsonElement value0 = (JsonElement)entry.getValue();
                if (key0.toLowerCase().contains("block")) {
                    SingleExecutePlanPanel p = new SingleExecutePlanPanel(showPanel, pos, key0, value0);
                    if (parent == null) continue;
                    parent.children.add(p);
                    continue;
                }
                if (!SingleExecutePlanPanel.withBlock(value0)) continue;
                SingleExecutePlanPanel.create(showPanel, parent, pos, value0);
            }
        } else {
            throw new IllegalArgumentException("jsonElement is an unknown element type.");
        }
    }

    private static boolean withBlock(JsonElement elm) {
        boolean result;
        block3: {
            Map.Entry entry;
            String key0;
            block2: {
                result = false;
                if (!elm.isJsonArray()) break block2;
                Iterator it = elm.getAsJsonArray().iterator();
                while (it.hasNext() && !(result = SingleExecutePlanPanel.withBlock((JsonElement)it.next()))) {
                }
                break block3;
            }
            if (!elm.isJsonObject()) break block3;
            Set set = elm.getAsJsonObject().entrySet();
            Iterator i$ = set.iterator();
            while (i$.hasNext() && !(result = (key0 = (String)(entry = (Map.Entry)i$.next()).getKey()).toLowerCase().contains("block")) && !(result = SingleExecutePlanPanel.withBlock((JsonElement)entry.getValue()))) {
            }
        }
        return result;
    }

    private static String getChildValue(JsonElement elm, String key) {
        JsonElement obj = elm.getAsJsonObject().get(key);
        if (obj != null) {
            return obj.getAsString();
        }
        return null;
    }

    private void addArrow(ShowPlanJPanel showPanel) {
        if (this.children.isEmpty()) {
            return;
        }
        ListIterator<SingleExecutePlanPanel> list = this.children.listIterator();
        Point p0 = this.getLocation();
        Point p1 = null;
        SingleExecutePlanPanel next = null;
        while (list.hasNext()) {
            next = (SingleExecutePlanPanel)list.next();
            p1 = next.getLocation();
            showPanel.add(new Arrow(p0, p1));
            p0 = p1;
        }
    }

    private static String getCostInfo(JsonElement elm) {
        JsonElement obj = elm.getAsJsonObject().get("Cost Info");
        if (obj == null) {
            return null;
        }
        Set set1 = obj.getAsJsonObject().entrySet();
        String result = null;
        for (Map.Entry entry1 : set1) {
            String key1 = (String)entry1.getKey();
            if (!key1.contains("Cost")) continue;
            if (result == null) {
                result = ((JsonElement)entry1.getValue()).getAsString();
                continue;
            }
            result = result + "," + ((JsonElement)entry1.getValue()).getAsString();
        }
        return result;
    }

    public SingleExecutePlanPanel(ShowPlanJPanel showPanel, Point pos, String key, JsonElement elm) {
        this.setBounds(pos.x, pos.y, 140, 80);
        this.setBackground(Color.WHITE);
        showPanel.add(this);
        lastPos = pos;
        String s = null;
        this.title2 = "";
        this.title = SingleExecutePlanPanel.getChildValue(elm, "ON Type");
        if (this.title == null) {
            this.title = SingleExecutePlanPanel.getChildValue(elm, "Method");
        }
        if (this.title == null) {
            this.title = key;
        }
        if ((s = SingleExecutePlanPanel.getChildValue(elm, "Table Name")) != null) {
            this.title2 = this.title2 + (this.title2.length() == 0 ? "" : ",") + s;
        }
        if ((s = SingleExecutePlanPanel.getChildValue(elm, "Scan Type")) != null) {
            this.title2 = this.title2 + (this.title2.length() == 0 ? "" : ",") + s;
        }
        if ((s = SingleExecutePlanPanel.getChildValue(elm, "Type")) != null) {
            this.title2 = this.title2 + (this.title2.length() == 0 ? "" : ",") + s;
        }
        if ((s = SingleExecutePlanPanel.getCostInfo(elm)) != null) {
            this.title2 = this.title2 + (this.title2.length() == 0 ? "" : ",\n") + "cost:[" + s + "]";
        }
        LinkedHashMap<String, String> mp = null;
        if (elm.isJsonArray()) {
            Iterator it = elm.getAsJsonArray().iterator();
            while (it.hasNext()) {
                SingleExecutePlanPanel.create(showPanel, this, pos, (JsonElement)it.next());
                pos = new Point(pos.x, SingleExecutePlanPanel.lastPos.y + 110);
            }
        } else if (elm.isJsonObject()) {
            Set set = elm.getAsJsonObject().entrySet();
            mp = new LinkedHashMap<String, String>();
            int count = 0;
            for (Map.Entry entry : set) {
                JsonElement value1;
                String key1;
                Set set1;
                String key0 = (String)entry.getKey();
                JsonElement value0 = (JsonElement)entry.getValue();
                if (key0.toLowerCase().contains("block")) {
                    Point pos0 = null;
                    pos0 = count == 0 ? new Point(pos.x + 140 + 50, SingleExecutePlanPanel.lastPos.y) : new Point(pos.x + 140 + 50, SingleExecutePlanPanel.lastPos.y + 80 + 30);
                    SingleExecutePlanPanel p = new SingleExecutePlanPanel(showPanel, pos0, key0, value0);
                    this.children.add(p);
                    ++count;
                    continue;
                }
                if (key0.equalsIgnoreCase("Cost Info")) {
                    set1 = value0.getAsJsonObject().entrySet();
                    for (Map.Entry entry1 : set1) {
                        key1 = (String)entry1.getKey();
                        value1 = (JsonElement)entry1.getValue();
                        mp.put(key1, value1.toString());
                    }
                    continue;
                }
                if (SingleExecutePlanPanel.withBlock(value0)) {
                    set1 = value0.getAsJsonObject().entrySet();
                    for (Map.Entry entry1 : set1) {
                        key1 = (String)entry1.getKey();
                        value1 = (JsonElement)entry1.getValue();
                        if (key1.toLowerCase().contains("block")) continue;
                        mp.put(key1, value1.toString());
                    }
                    Point pos0 = new Point(pos.x + 140 + 50, SingleExecutePlanPanel.lastPos.y);
                    SingleExecutePlanPanel.create(showPanel, this, pos0, value0);
                    continue;
                }
                mp.put(key0, value0.toString());
            }
        }
        this.initContent(mp);
        this.addArrow(showPanel);
    }

    private void initContent(Map<String, String> mp) {
        if (this.title.startsWith("\"") && this.title.endsWith("\"")) {
            this.title = this.title.substring(1, this.title.length() - 1);
        }
        if (this.title2 != null && this.title2.startsWith("\"") && this.title2.endsWith("\"")) {
            this.title2 = this.title2.substring(1, this.title2.length() - 1);
        }
        SimpleTableModel tbModel = new SimpleTableModel(mp);
        JPanel panel = new JPanel();
        JTable tb = new JTable(tbModel){
            private static final long serialVersionUID = -8661921330712359894L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component component = super.prepareRenderer(renderer, row, column);
                int rendererWidth = component.getPreferredSize().width;
                TableColumn tableColumn = this.getColumnModel().getColumn(column);
                tableColumn.setPreferredWidth(Math.max(rendererWidth + this.getIntercellSpacing().width, tableColumn.getPreferredWidth()));
                return component;
            }
        };
        tb.setAutoResizeMode(0);
        tb.setGridColor(Color.LIGHT_GRAY);
        tb.setBackground(POPUP_INFO_COLOR);
        panel.add(tb);
        this.pop.add(panel);
        if (this.title.contains("Scan")) {
            this.setBackground(SCAN_BLOCK_COLOR);
        }
        TextField f1 = new TextField(this.title);
        f1.setBorder(null);
        f1.setBackground(this.getBackground());
        f1.setHorizontalAlignment(0);
        JTextPane f2 = new JTextPane();
        f2.setText(this.title2);
        StyledDocument doc = f2.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        f2.setBorder(null);
        f2.setBackground(this.getBackground());
        this.setLayout(new BorderLayout(4, 4));
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.add((Component)f1, "North");
        this.add((Component)f2, "Center");
        f1.addMouseMotionListener(this);
        f1.addMouseListener(this);
        f2.addMouseMotionListener(this);
        f2.addMouseListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.pop.show(e.getComponent(), e.getX() + 8, e.getY() + 8);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.pop.setVisible(false);
    }

    class SimpleTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 6219894430059946139L;
        Map<String, String> mp = null;
        Object[] keys = null;

        SimpleTableModel(Map<String, String> mp) {
            this.mp = mp;
            this.keys = this.mp.keySet().toArray();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.keys.length;
        }

        @Override
        public Object getValueAt(int arg0, int arg1) {
            if (arg1 == 0) {
                return this.keys[arg0];
            }
            return this.mp.get(this.keys[arg0]);
        }
    }
}

