/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importText;

import dbaut.SqlTypeDef;
import dbaut.infoObject.ColumnInfoObject;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dttwizard.importText.SchemaTypes;
import dttwizard.importText.TransferRowInfo;
import dttwizard.importText.TransferSetting;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class TransferCols
extends AbstractTableModel {
    private static final long serialVersionUID = -6197541480167278597L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportTextRes", LocaleManager.getLocale());
    private final String[] columnNames = new String[]{this.res.getString("Source_Col"), this.res.getString("Destination_Col"), this.res.getString("Type"), this.res.getString("Precision"), this.res.getString("Scale"), this.res.getString("Nullable"), this.res.getString("Encrypt")};
    private ActionListener listener = null;
    private Vector<TransferRowInfo> data = new Vector();
    private boolean isColumn = false;
    public boolean isSchemaEditable = true;

    public TransferCols(TransferSetting paraTransferSetting) {
    }

    public TransferCols(boolean isColumn) {
        this.isColumn = isColumn;
    }

    public TransferCols() {
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col].toString();
    }

    @Override
    public Object getValueAt(int row, int col) {
        TransferRowInfo rowData = this.data.elementAt(row);
        return rowData.getValueAt(col);
    }

    @Override
    public Class<?> getColumnClass(int c) {
        TransferRowInfo rowData = this.data.elementAt(0);
        return rowData.getValueAt(c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        TransferRowInfo rowData = this.data.elementAt(row);
        if (this.isSchemaEditable) {
            String type = rowData.getType();
            if (col == 0) {
                return false;
            }
            if (col == 4) {
                return type.equals("decimal");
            }
            if (col == 3) {
                if (type.equals("smallint") || type.equals("integer") || type.equals("bigint") || type.equals("real") || type.equals("double") || type.equals("date") || type.equals("time") || type.equals("oid") || type.equals("timestamp") || type.equals("file") || type.equals("long varbinary") || type.equals("long varchar") || type.equals("serial") || type.equals("bigserial") || type.equals("nclob") || type.equals("clob") || type.equals("blob")) {
                    return false;
                }
                return !SchemaTypes.isDomainType(type);
            }
            if (col == 5) {
                return !type.equals("serial") && !type.equals("bigserial") && !type.equals("file");
            }
            return true;
        }
        return col == 1;
    }

    public void addValue(TransferRowInfo newData) {
        this.data.addElement(newData);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value == null) {
            return;
        }
        TransferRowInfo rowData = this.data.elementAt(row);
        Object oldValue = rowData.getValueAt(col);
        if (value.equals(oldValue)) {
            if (this.listener != null) {
                this.listener.actionPerformed(null);
            }
            return;
        }
        rowData.setValueAt(value, col);
        if (col == 1) {
            Object obj = rowData.getValueAt(col);
            ColumnInfoObject cio = (ColumnInfoObject)obj;
            if (cio.isEditable) {
                cio.dataType = this.getValueAt(row, 2).toString().toLowerCase().trim();
                cio.type = SqlTypeDef.getDBMakerDataTypeToInt(cio.dataType);
                cio.local_type = cio.dataType;
                if (this.getValueAt(row, 3).toString().trim().length() != 0) {
                    cio.precision = Integer.parseInt(this.getValueAt(row, 3).toString().trim());
                }
                if (this.getValueAt(row, 4).toString().trim().length() != 0) {
                    cio.scale = Integer.parseInt(this.getValueAt(row, 4).toString().trim());
                }
            }
            String type = "";
            String precision = "";
            String scale = "";
            type = this.isColumn ? cio.getDBMakerDataType() : cio.dataType.toLowerCase().trim();
            precision = new Integer(cio.precision).toString();
            scale = new Integer(cio.scale).toString();
            if (type.equals("smallint") || type.equals("integer") || type.equals("bigint") || type.equals("real") || type.equals("double") || type.equals("date") || type.equals("time") || type.equals("oid") || type.equals("timestamp") || type.equals("file") || type.equals("long varbinary") || type.equals("long varchar") || type.equals("serial") || type.equals("bigserial") || type.equals("nclob") || type.equals("clob") || type.equals("blob")) {
                precision = "";
                scale = "";
            }
            if (!type.equals("decimal")) {
                scale = "";
            }
            this.setValueAt(type, row, 2);
            this.setValueAt(precision, row, 3);
            this.setValueAt(scale, row, 4);
            this.setValueAt(cio.getNullable(), row, 5);
            this.setValueAt(cio.isEncrypted, row, 6);
        }
        if (col == 2) {
            String type = value.toString().toLowerCase();
            if (type.equals("smallint") || type.equals("integer") || type.equals("bigint") || type.equals("real") || type.equals("double") || type.equals("date") || type.equals("time") || type.equals("oid") || type.equals("timestamp") || type.equals("file") || type.equals("long varbinary") || type.equals("long varchar") || type.equals("serial") || type.equals("bigserial") || type.equals("nclob") || type.equals("clob") || type.equals("blob")) {
                rowData.setValueAt("", col + 1);
            }
            if (!type.equals("decimal")) {
                rowData.setValueAt("", col + 2);
            }
            if ((type.equals("char") || type.equals("binary") || type.equals("varchar") || type.equals("nchar") || type.equals("nvarchar")) && rowData.getValueAt(col + 1).toString().length() == 0) {
                rowData.setValueAt("10", col + 1);
            }
            if (type.equals("decimal")) {
                rowData.setValueAt("10", col + 1);
                rowData.setValueAt("0", col + 2);
            }
            if (type.equals("serial") || type.equals("bigserial")) {
                rowData.setValueAt("", col + 1);
                rowData.setValueAt(Boolean.TRUE, col + 3);
            }
            if (SchemaTypes.isDomainType(type)) {
                rowData.setValueAt("", col + 1);
                rowData.setValueAt("", col + 2);
            }
            this.fireTableChanged(new TableModelEvent(this));
        }
        this.fireTableChanged(new TableModelEvent(this));
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    public void removeAll() {
        this.data.removeAllElements();
    }

    public String getColType(int row) {
        TransferRowInfo rowData = this.data.elementAt(row);
        return rowData.getType();
    }

    public String getTypeSize(int row) {
        TransferRowInfo rowData = this.data.elementAt(row);
        return rowData.getPrecision();
    }

    public String getScale(int row) {
        TransferRowInfo rowData = this.data.elementAt(row);
        return rowData.getScale();
    }

    public Object getNullable(int row) {
        TransferRowInfo rowData = this.data.elementAt(row);
        return rowData.getNullable();
    }

    public void removeSelectedRow(int row) {
        this.data.remove(row);
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public Vector<TransferRowInfo> getCloneData() {
        Object[] objArray = this.data.toArray();
        Vector<TransferRowInfo> v = new Vector<TransferRowInfo>(objArray.length);
        for (int i = 0; i < objArray.length; ++i) {
            v.add(((TransferRowInfo)objArray[i]).getDuplicate());
        }
        return v;
    }

    public void setData(Vector<TransferRowInfo> v) {
        this.data = v;
    }
}

