/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importODBC;

import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import dbaut.ComboEditorField;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.DetailDialog;
import dbaut.CommonUt.EmptyPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.SqlTypeDef;
import dbaut.comp.ComboBoxCellEditor;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaFileFilter;
import dbaut.comp.ReflectionAction;
import dbaut.dbalib;
import dbaut.infoObject.ColumnInfoObject;
import dbaut.infoObject.TableInfoObject;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dttwizard.importODBC.ButtonEditor;
import dttwizard.importODBC.ButtonRenderer;
import dttwizard.importODBC.ColumnMapTransfer;
import dttwizard.importODBC.DetailInfo;
import dttwizard.importODBC.QueryObject;
import dttwizard.importODBC.QueryStatementDlg;
import dttwizard.importODBC.SqlQueryModel;
import dttwizard.importODBC.odbcDialog;
import dttwizard.importXML.XmlElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SqlQueryStatement
extends AbstractWizardPanel {
    private static final long serialVersionUID = 3110561837500955243L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportOdbcRes", LocaleManager.getLocale());
    private String title = this.res.getString("Page_title_SourceQuery");
    private odbcDialog odbcdlg = null;
    private AbstractWizardPanel previous = null;
    private AbstractWizardPanel next1 = null;
    private DbaButton next_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("Execute"), 'E', DBAImageResource.getResource(this.getClass(), "/dbautimages/execute.gif"), new ReflectionAction(this, "next_Button_actionPerformed"));
    private DbaButton removeRowButton = new DbaButton(new Dimension(120, 24), false, this.res.getString("Remove"), 'R', DBAImageResource.getResource(this.getClass(), "/dttimages/remove_SQL.gif"), new ReflectionAction(this, "removeRowButton_actionPerformed"));
    private DbaButton saveBatch = new DbaButton(new Dimension(120, 24), false, this.res.getString("Save_batch"), 'S', DBAImageResource.getResource(this.getClass(), "/dttimages/save_batch.gif"), new ReflectionAction(this, "saveBatch_actionPerformed"));
    private String[] header = new String[]{this.res.getString("Query"), this.res.getString("Destination_Table"), this.res.getString("Transform")};
    SqlQueryModel sqlQueryModel = new SqlQueryModel(this.header);
    private JTable sqlQueryStatementTable = new JTable(this.sqlQueryModel);
    JComboBox destinationCombo = new JComboBox();
    private ComboBoxCellEditor cbce = null;
    boolean isLoadBatch = false;

    public SqlQueryStatement(odbcDialog odbcdlg, AbstractWizardPanel previous, boolean isLoadBatch) {
        try {
            this.odbcdlg = odbcdlg;
            this.previous = previous;
            this.isLoadBatch = isLoadBatch;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton back_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "back_Button_actionPerformed"));
        DbaButton cancel_Button = new DbaButton(new Dimension(100, 24), false, this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancel_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        DbaButton addSqlButton = new DbaButton(new Dimension(120, 24), false, this.res.getString("Add_SQL"), 'A', DBAImageResource.getResource(this.getClass(), "/dttimages/add_SQL.gif"), new ReflectionAction(this, "addSqlButton_actionPerformed"));
        JPanel panel6 = new JPanel(new BorderLayout());
        JPanel panel10 = new JPanel(new FlowLayout(0));
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("Press_add_button"));
        JScrollPane jscroll1 = new JScrollPane(area1);
        JScrollPane jscroll2 = new JScrollPane(this.sqlQueryStatementTable);
        this.destinationCombo.setEditor(new ComboEditorField());
        this.destinationCombo.setEditable(true);
        this.saveBatch.setEnabled(false);
        this.next_Button.setHorizontalTextPosition(2);
        JPanel panel5 = new JPanel();
        panel5.setPreferredSize(new Dimension(100, 0));
        jscroll2.setBorder(null);
        jscroll2.setPreferredSize(new Dimension(480, 240));
        jscroll2.setVerticalScrollBarPolicy(20);
        this.sqlQueryStatementTable.setBorder(BorderFactory.createLoweredBevelBorder());
        this.sqlQueryStatementTable.setRowHeight(24);
        this.sqlQueryStatementTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SqlQueryStatement.this.sqlQueryStatementTable_mouseClicked(e);
            }
        });
        JPanel panel4 = new JPanel(new FlowLayout(2));
        panel4.add(back_Button);
        panel4.add(this.next_Button);
        panel4.add(new EmptyPanel());
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        panel10.add(addSqlButton);
        panel10.add(this.removeRowButton);
        panel10.add(panel5);
        panel10.add(this.saveBatch);
        panel6.add((Component)jscroll2, "North");
        panel6.add((Component)panel10, "Center");
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ImportODBC.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        this.saveBatch.setEnabled(false);
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ImportODBC_QueryStatement", null);
        this.removeRowButton.setEnabled(false);
        this.assignTableName(this.odbcdlg.destinationConnection.getDbConnection());
        this.initTable();
        this.next_Button.setEnabled(false);
        this.destinationCombo.addActionListener(new ReflectionAction(this, "destinationCombo_actionPerformed"));
        this.sqlQueryModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SqlQueryStatement.this.checkTargetValue();
            }
        });
        if (this.isLoadBatch) {
            this.loadSettingFromXML();
            if (this.sqlQueryModel.getRowCount() > 0) {
                this.next_Button.setEnabled(true);
                this.saveBatch.setEnabled(true);
            }
        }
    }

    public boolean loadSettingFromXML() {
        int size = this.odbcdlg.xmlFile.root.child.size();
        Vector<XmlElement> xmlElementVector = new Vector<XmlElement>();
        XmlElement celm = null;
        for (int i = 0; i < size; ++i) {
            celm = (XmlElement)this.odbcdlg.xmlFile.root.child.elementAt(i);
            if (!celm.name.equalsIgnoreCase("TABLE_TRANSFER")) continue;
            xmlElementVector.add(celm);
        }
        XmlElement column_mapping_element = null;
        String table_action = null;
        String d_owner = null;
        String d_name = null;
        TableInfoObject dtio = null;
        QueryObject sqo = null;
        ColumnMapTransfer cmt = null;
        for (int i = 0; i < xmlElementVector.size(); ++i) {
            XmlElement d_element;
            XmlElement element = (XmlElement)xmlElementVector.elementAt(i);
            table_action = element.getAttributeValue("TABLE_ACTION");
            XmlElement s_element = element.searchElement("SOURCE");
            if (s_element != null) {
                sqo = new QueryObject(s_element.data.trim(), i);
            }
            if ((d_element = element.searchElement("DESTINATION")) != null) {
                d_owner = d_element.getAttributeValue("TABLE_OWNER");
                d_name = d_element.getAttributeValue("TABLE_NAME");
            }
            if (d_owner != null && d_name != null) {
                dtio = new TableInfoObject(d_owner, d_name, false, "", this.odbcdlg.destinationConnection.getUserName());
            } else {
                String[] sA = this.getOwnerAndTable(d_element.data, this.odbcdlg.destinationDbName);
                dtio = new TableInfoObject(sA[0], sA[1], false, "", this.odbcdlg.destinationConnection.getUserName());
            }
            DetailDialog ddlg = new DetailDialog(this.odbcdlg, true);
            cmt = dtio.owner.length() == 0 && dtio.name.length() != 0 ? new ColumnMapTransfer(ddlg, this.odbcdlg, sqo, dtio, true, true) : new ColumnMapTransfer(ddlg, this.odbcdlg, sqo, dtio, false, true);
            Vector<XmlElement> col_map_vector = new Vector<XmlElement>();
            for (int k = 0; k < element.child.size(); ++k) {
                column_mapping_element = (XmlElement)element.child.elementAt(k);
                if (!column_mapping_element.name.equalsIgnoreCase("COLUMN_MAPPING")) continue;
                col_map_vector.add(column_mapping_element);
            }
            if (table_action.equalsIgnoreCase("create")) {
                cmt.create_RadioButton.setSelected(true);
                cmt.create_RadioButton.setEnabled(true);
                cmt.delete_RadioButton.setEnabled(false);
                cmt.append_RadioButton.setEnabled(false);
                cmt.append_RadioButton.setEnabled(false);
                cmt.radioButtonValue = 1;
            } else if (table_action.equalsIgnoreCase("delete")) {
                cmt.delete_RadioButton.setSelected(true);
                cmt.delete_RadioButton.setEnabled(true);
                cmt.create_RadioButton.setEnabled(false);
                cmt.append_RadioButton.setEnabled(true);
                cmt.append_RadioButton.setEnabled(true);
                cmt.radioButtonValue = (short)2;
            } else if (table_action.equalsIgnoreCase("append")) {
                cmt.append_RadioButton.setSelected(true);
                cmt.append_RadioButton.setEnabled(true);
                cmt.create_RadioButton.setEnabled(false);
                cmt.delete_RadioButton.setEnabled(true);
                cmt.append_RadioButton.setEnabled(true);
                cmt.radioButtonValue = (short)3;
            } else if (table_action.equalsIgnoreCase("replace")) {
                cmt.append_RadioButton.setSelected(true);
                cmt.append_RadioButton.setEnabled(true);
                cmt.create_RadioButton.setEnabled(false);
                cmt.delete_RadioButton.setEnabled(true);
                cmt.append_RadioButton.setEnabled(true);
                cmt.radioButtonValue = (short)4;
            } else if (dtio.owner.length() == 0) {
                cmt.create_RadioButton.setSelected(true);
                cmt.create_RadioButton.setEnabled(true);
                cmt.delete_RadioButton.setEnabled(false);
                cmt.append_RadioButton.setEnabled(false);
                cmt.append_RadioButton.setEnabled(false);
                cmt.radioButtonValue = 1;
            } else {
                cmt.append_RadioButton.setSelected(true);
                cmt.append_RadioButton.setEnabled(true);
                cmt.create_RadioButton.setEnabled(false);
                cmt.delete_RadioButton.setEnabled(true);
                cmt.append_RadioButton.setEnabled(true);
                cmt.radioButtonValue = (short)3;
            }
            if (cmt.jtable.getRowCount() <= 0) {
                this.odbcdlg.isLoadSuccess = false;
                return false;
            }
            XmlElement tmp_element = null;
            ColumnInfoObject cio = null;
            String colname = null;
            String type = null;
            int precision = -100;
            int scale = -100;
            for (int k = 0; k < col_map_vector.size(); ++k) {
                column_mapping_element = (XmlElement)col_map_vector.elementAt(k);
                tmp_element = column_mapping_element.searchElement("SOURCE_COL");
                if (tmp_element != null) {
                    cmt.jtable.setValueAt(tmp_element.data, k, 0);
                }
                if ((tmp_element = column_mapping_element.searchElement("DESTINATION_COL")) != null) {
                    colname = tmp_element.data;
                }
                if ((tmp_element = column_mapping_element.searchElement("TYPE")) != null) {
                    type = tmp_element.data.toLowerCase();
                }
                if ((tmp_element = column_mapping_element.searchElement("PRECISION")) != null) {
                    precision = tmp_element.data.trim().length() == 0 ? 10 : Integer.parseInt(tmp_element.data);
                }
                if ((tmp_element = column_mapping_element.searchElement("SCALE")) != null) {
                    scale = tmp_element.data.trim().length() == 0 ? 0 : Integer.parseInt(tmp_element.data);
                }
                if ((tmp_element = column_mapping_element.searchElement("NULLABLE")) != null) {
                    if (tmp_element.data.equalsIgnoreCase("true")) {
                        if (colname != null && type != null && precision != -100 && scale != -100) {
                            cio = new ColumnInfoObject(colname, SqlTypeDef.getDBMakerDataTypeToInt(type), precision, scale, true, false, type);
                        }
                    } else if (colname != null && type != null && precision != -100 && scale != -100) {
                        cio = new ColumnInfoObject(colname, SqlTypeDef.getDBMakerDataTypeToInt(type), precision, scale, false, false, type);
                    }
                    cmt.jtable.setValueAt(cio, k, 1);
                }
                colname = null;
                type = null;
                precision = -100;
                scale = -100;
            }
            XmlElement transformation_element = null;
            tmp_element = element.searchElement("TRANSFORMATION");
            if (tmp_element != null) {
                transformation_element = tmp_element.searchElement("SELECT_SQL");
                if (transformation_element != null) {
                    cmt.select_TextPane.setText(transformation_element.data);
                    cmt.select_Str = transformation_element.data;
                }
                if ((transformation_element = tmp_element.searchElement("INSERT_SQL")) != null) {
                    cmt.insert_TextPane.setText(transformation_element.data);
                    cmt.insert_Str = transformation_element.data;
                }
            }
            cmt.preVector = cmt.curTransferCols.getCloneData();
            Object[] oa = new Object[]{sqo, dtio, cmt};
            this.sqlQueryModel.addValue(oa);
        }
        return true;
    }

    public void destinationCombo_actionPerformed(ActionEvent e) {
        int index = this.cbce.x.getSelectedIndex();
        if (this.destinationCombo.getSelectedIndex() <= 0) {
            this.destinationCombo.setEditable(true);
        } else {
            this.destinationCombo.setEditable(false);
            this.cbce.x.setSelectedIndex(index);
        }
    }

    private void initTable() {
        TableColumnModel tcmodel = this.sqlQueryStatementTable.getColumnModel();
        TableColumn col = tcmodel.getColumn(0);
        col.setPreferredWidth(120);
        col = tcmodel.getColumn(1);
        col.setPreferredWidth(310);
        this.cbce = new ComboBoxCellEditor(this.destinationCombo, false, this.odbcdlg.destinationConnection.getUserName());
        col.setCellEditor(this.cbce);
        col.setCellRenderer(new DefaultTableCellRenderer());
        col = tcmodel.getColumn(2);
        col.setPreferredWidth(70);
        col.setCellEditor(new ButtonEditor(this.odbcdlg));
        col.setCellRenderer(new ButtonRenderer(this.odbcdlg));
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        this.sqlQueryStatementTable.editingStopped(null);
        if (this.sqlQueryModel.getRowCount() == 0) {
            GuiUt.showWarningDlg(this.odbcdlg, this.res.getString("Warning"), this.res.getString("Please_select_sometable"));
            return;
        }
        if (this.checkTargetValue()) {
            GuiUt.showWarningDlg(this.odbcdlg, this.res.getString("Warning"), this.res.getString("Please_input_newtable"));
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.next1 = new DetailInfo(this.odbcdlg, this);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.odbcdlg.Next(this.next1);
    }

    public boolean checkTargetValue() {
        int rowCount = this.sqlQueryModel.getRowCount();
        boolean b = false;
        int targetLen = 0;
        for (int i = 0; i < rowCount; ++i) {
            targetLen = this.sqlQueryModel.getValueAt(i, 1).toString().trim().length();
            if (targetLen != 0) continue;
            b = true;
            break;
        }
        if (b) {
            this.next_Button.setEnabled(false);
            this.saveBatch.setEnabled(false);
        } else {
            this.next_Button.setEnabled(true);
            this.saveBatch.setEnabled(true);
        }
        return b;
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.odbcdlg.dispose();
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.odbcdlg.Next(this.previous);
    }

    public void addSqlButton_actionPerformed(ActionEvent e) {
        QueryStatementDlg oid = new QueryStatementDlg(this.odbcdlg, true, this);
        oid.setVisible(true);
        this.sqlQueryModel.fireTableChanged(new TableModelEvent(this.sqlQueryModel));
    }

    public void removeRowButton_actionPerformed(ActionEvent e) {
        this.removeRowButton.setEnabled(false);
        int i = this.sqlQueryStatementTable.getSelectedRow();
        this.sqlQueryModel.removeRow(i);
        this.sqlQueryModel.fireTableChanged(new TableModelEvent(this.sqlQueryModel));
        if (this.sqlQueryStatementTable.getRowCount() == 0) {
            this.next_Button.setEnabled(false);
        }
    }

    public void sqlQueryStatementTable_mouseClicked(MouseEvent e) {
        this.removeRowButton.setEnabled(true);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void saveBatch_actionPerformed(ActionEvent e) {
        this.sqlQueryStatementTable.editingStopped(null);
        if (this.checkTargetValue()) {
            GuiUt.showWarningDlg(this.odbcdlg, this.res.getString("Warning"), this.res.getString("Please_input_a_new_table"));
            return;
        }
        JFileChooser filechooser = new JFileChooser();
        filechooser.addChoosableFileFilter(new DbaFileFilter("xml", "XML Files (*.xml)"));
        int rc = filechooser.showDialog(this.odbcdlg, this.res.getString("Save_batch_file"));
        String fileName = "";
        if (rc == 0) {
            int reply;
            fileName = filechooser.getSelectedFile().toString().trim();
            String ss = null;
            if (fileName.length() <= 4) {
                fileName = fileName + ".xml";
            } else {
                ss = fileName.substring(fileName.length() - 4, fileName.length());
                if (!ss.equalsIgnoreCase(".xml")) {
                    fileName = fileName + ".xml";
                }
            }
            File f = new File(fileName);
            if (f.exists() && (reply = GuiUt.showOptionDlg(this.odbcdlg, this.res.getString("Warning"), this.res.getString("File") + " " + fileName + " " + this.res.getString("Already_exits_overwrite_it"))) != 0) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            dbalib lib = new dbalib();
            String xmlString = "<?xml version=\"1.0\" encoding=";
            int language = lib.getLicLCode();
            switch (language) {
                case 0: {
                    xmlString = xmlString + "\"ASCII\"?>\n\n";
                    break;
                }
                case 1: {
                    xmlString = xmlString + "\"BIG5\"?>\n\n";
                    break;
                }
                case 2: {
                    xmlString = xmlString + "\"Shift_JIS\"?>\n\n";
                    break;
                }
                case 3: {
                    xmlString = xmlString + "\"GB2312\"?>\n\n";
                    break;
                }
                case 4: {
                    xmlString = xmlString + "\"ISO8859_1\"?>\n\n";
                    break;
                }
                case 5: {
                    xmlString = xmlString + "\"ISO8859_2\"?>\n\n";
                    break;
                }
                case 6: {
                    xmlString = xmlString + "\"ISO8859_5\"?>\n\n";
                    break;
                }
                case 7: {
                    xmlString = xmlString + "\"ISO8859_7\"?>\n\n";
                    break;
                }
                case 8: {
                    xmlString = xmlString + "\"EUC\"?>\n\n";
                    break;
                }
                case 9: {
                    xmlString = xmlString + "\"GB18030\"?>\n\n";
                    break;
                }
                case 10: {
                    xmlString = xmlString + "\"UTF-8\"?>\n\n";
                }
            }
            try {
                FileWriter fw = new FileWriter(fileName);
                this.odbcdlg.WriteFileContent(fw, 0, xmlString);
                xmlString = "";
                String dbbrand = "DBMAKER";
                if (!LocaleManager.getIsDBMaker()) {
                    dbbrand = "DBMASTER";
                }
                xmlString = "<" + dbbrand + "_DATATRANSFER STYLE=\"IMPORT_ODBC\" SOURCE_DB=\"" + this.odbcdlg.sourceDbName + "\" SOURCE_ID=\"" + this.odbcdlg.sourceUserID + "\" DESTINATION_DB=\"" + this.odbcdlg.destinationDbName + "\" DESTINATION_ID=\"" + this.odbcdlg.destinationUserID + "\">\n";
                this.odbcdlg.WriteFileContent(fw, 0, xmlString);
                xmlString = "";
                xmlString = "<TRANSFER_SETTING TYPE=\"";
                xmlString = xmlString + "QUERY_TYPE\"/>\n";
                this.odbcdlg.WriteFileContent(fw, 4, xmlString);
                xmlString = "";
                int rowCount = this.sqlQueryStatementTable.getRowCount();
                ColumnMapTransfer cmt = null;
                QueryObject sqo = null;
                TableInfoObject dtio = null;
                for (int i = 0; i < rowCount; ++i) {
                    sqo = (QueryObject)this.sqlQueryStatementTable.getValueAt(i, 0);
                    dtio = (TableInfoObject)this.sqlQueryStatementTable.getValueAt(i, 1);
                    cmt = (ColumnMapTransfer)this.sqlQueryStatementTable.getValueAt(i, 2);
                    if (cmt == null) {
                        DetailDialog ddlg = new DetailDialog(this.odbcdlg, true);
                        if (dtio.owner.length() == 0 && dtio.name.length() != 0) {
                            cmt = new ColumnMapTransfer(ddlg, this.odbcdlg, sqo, dtio, true, true);
                            this.sqlQueryStatementTable.setValueAt(cmt, i, 2);
                        } else {
                            cmt = new ColumnMapTransfer(ddlg, this.odbcdlg, sqo, dtio, false, true);
                            this.sqlQueryStatementTable.setValueAt(cmt, i, 2);
                        }
                    }
                    xmlString = "";
                    xmlString = "<TABLE_TRANSFER TABLE_ACTION=\"";
                    xmlString = cmt.create_RadioButton.isSelected() ? xmlString + "CREATE\">\n" : (cmt.delete_RadioButton.isSelected() ? xmlString + "DELETE\">\n" : (cmt.append_RadioButton.isSelected() ? xmlString + "APPEND\">\n" : xmlString + "REPLACE\">\n"));
                    this.odbcdlg.WriteFileContent(fw, 4, xmlString);
                    xmlString = "";
                    xmlString = "<SOURCE>" + sqo.queryData + "</SOURCE>\n";
                    this.odbcdlg.WriteFileContent(fw, 8, xmlString);
                    xmlString = "";
                    xmlString = dtio.owner.trim().length() == 0 ? "<DESTINATION TABLE_NAME=\"" + dtio.name.trim() + "\">" + dtio.name.trim() + "</DESTINATION>\n" : "<DESTINATION TABLE_OWNER=\"" + dtio.owner.trim() + "\" TABLE_NAME=\"" + dtio.name.trim() + "\">" + cmt.destinationTableInfo_TextField.getText().trim() + "</DESTINATION>\n";
                    this.odbcdlg.WriteFileContent(fw, 8, xmlString);
                    xmlString = "";
                    int cmtRowCount = cmt.jtable.getRowCount();
                    for (int j = 0; j < cmtRowCount; ++j) {
                        xmlString = "<COLUMN_MAPPING>\n";
                        this.odbcdlg.WriteFileContent(fw, 8, xmlString);
                        xmlString = "";
                        xmlString = "<SOURCE_COL>" + cmt.jtable.getValueAt(j, 0).toString().trim() + "</SOURCE_COL>\n";
                        this.odbcdlg.WriteFileContent(fw, 12, xmlString);
                        xmlString = "";
                        xmlString = "<DESTINATION_COL>" + cmt.jtable.getValueAt(j, 1).toString().trim() + "</DESTINATION_COL>\n";
                        this.odbcdlg.WriteFileContent(fw, 12, xmlString);
                        xmlString = "";
                        xmlString = "<TYPE>" + cmt.jtable.getValueAt(j, 2).toString().trim() + "</TYPE>\n";
                        this.odbcdlg.WriteFileContent(fw, 12, xmlString);
                        xmlString = "";
                        xmlString = "<PRECISION>" + cmt.jtable.getValueAt(j, 3).toString().trim() + "</PRECISION>\n";
                        this.odbcdlg.WriteFileContent(fw, 12, xmlString);
                        xmlString = "";
                        xmlString = "<SCALE>" + cmt.jtable.getValueAt(j, 4).toString().trim() + "</SCALE>\n";
                        this.odbcdlg.WriteFileContent(fw, 12, xmlString);
                        xmlString = "";
                        xmlString = "<NULLABLE>" + cmt.jtable.getValueAt(j, 5).toString().trim() + "</NULLABLE>\n";
                        this.odbcdlg.WriteFileContent(fw, 12, xmlString);
                        xmlString = "";
                        xmlString = "</COLUMN_MAPPING>\n";
                        this.odbcdlg.WriteFileContent(fw, 8, xmlString);
                    }
                    xmlString = "";
                    if (cmt.select_TextPane.getText().trim().length() != 0 || cmt.insert_TextPane.getText().trim().length() != 0) {
                        xmlString = "<TRANSFORMATION>\n";
                        this.odbcdlg.WriteFileContent(fw, 8, xmlString);
                        if (cmt.select_TextPane.getText().trim().length() != 0) {
                            xmlString = "";
                            xmlString = "<SELECT_SQL>" + cmt.select_TextPane.getText().trim() + "</SELECT_SQL>\n";
                            this.odbcdlg.WriteFileContent(fw, 12, xmlString);
                        }
                        if (cmt.insert_TextPane.getText().trim().length() != 0) {
                            xmlString = "";
                            xmlString = "<INSERT_SQL>" + cmt.insert_TextPane.getText().trim() + "</INSERT_SQL>\n";
                            this.odbcdlg.WriteFileContent(fw, 12, xmlString);
                        }
                        xmlString = "";
                        xmlString = "</TRANSFORMATION>\n";
                        this.odbcdlg.WriteFileContent(fw, 8, xmlString);
                    }
                    xmlString = "";
                    xmlString = "</TABLE_TRANSFER>\n";
                    this.odbcdlg.WriteFileContent(fw, 4, xmlString);
                }
                xmlString = "";
                xmlString = "</" + dbbrand + "_DATATRANSFER>\n";
                this.odbcdlg.WriteFileContent(fw, 0, xmlString);
                fw.close();
                GuiUt.showInformationDlg(this.odbcdlg, "Save " + fileName + "  " + this.res.getString("successfully"));
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            catch (IOException ioe) {
                GuiUt.showErrorDlg(this.odbcdlg, ioe.getMessage(), null);
                return;
            }
        }
    }

    private void assignTableName(Connection connection) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            String query = "select TABLE_OWNER, TABLE_NAME, TABLE_TYPE from SYSTABLE where TABLE_TYPE = 'TABLE' order by TABLE_NAME ";
            rs = stmt.executeQuery(query);
            Vector<TableInfoObject> v = new Vector<TableInfoObject>();
            TableInfoObject tio = null;
            while (rs.next()) {
                String owner = rs.getString(1).trim();
                String table = rs.getString(2).trim();
                String type = rs.getString(3).trim();
                tio = new TableInfoObject(owner, table, false, type, this.odbcdlg.destinationConnection.getUserName());
                v.add(tio);
                tio = null;
            }
            tio = new TableInfoObject("", "", false, "", this.odbcdlg.destinationConnection.getUserName());
            v.insertElementAt(tio, 0);
            DefaultComboBoxModel cbm = new DefaultComboBoxModel(v);
            this.destinationCombo.setModel(cbm);
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this.odbcdlg, null, sqle);
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
    }

    public String[] getOwnerAndTable(String total, String owner) {
        String myTblName;
        String myOwner;
        String[] sA = new String[2];
        int startdot = 0;
        int end = 0;
        int other = 0;
        startdot = total.indexOf(".");
        if (total.startsWith("\"")) {
            myOwner = "";
            myTblName = total.substring(1, total.length() - 1);
        } else {
            other = total.indexOf("\"");
            end = total.length();
            startdot = total.indexOf(".");
            if (other > 0) {
                myOwner = total.substring(0, startdot);
                myTblName = total.substring(other + 1, end - 1);
            } else if (startdot > 0) {
                myOwner = total.substring(0, startdot);
                myTblName = total.substring(startdot + 1, end);
            } else {
                myOwner = "";
                myTblName = total;
            }
        }
        sA[0] = myOwner;
        sA[1] = myTblName;
        return sA;
    }
}

