/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.text.TextField;
import dbaut.textField.DbaTextField;
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class SmallintField
extends TextField
implements DbaTextField {
    private static final long serialVersionUID = -8902067029464907895L;
    private NumberFormat smallintFormatter = NumberFormat.getNumberInstance(Locale.US);
    private static String MAX_VALUE = "32767";
    private static String MIN_VALUE = "-32768";

    public SmallintField() {
        this.smallintFormatter.setParseIntegerOnly(true);
    }

    public SmallintField(short value) {
        this();
        this.setValue(value);
    }

    public SmallintField(boolean positive) {
        this();
    }

    @Override
    public Object getValue() {
        int retVal = 0;
        try {
            String t = this.getText().trim();
            if (this.isOverFlow(t)) {
                Toolkit.getDefaultToolkit().beep();
                System.out.println(t + " is over flow the smallint range");
                retVal = t.startsWith("-") ? Short.MIN_VALUE : Short.MAX_VALUE;
            } else {
                retVal = this.smallintFormatter.parse(this.getText()).shortValue();
            }
        }
        catch (ParseException e) {
            Toolkit.getDefaultToolkit().beep();
            return null;
        }
        return new Short((short)retVal);
    }

    public boolean isOverFlow(String t) {
        if (t.startsWith("-")) {
            if (t.length() > MIN_VALUE.length()) {
                return true;
            }
            if (t.length() < MIN_VALUE.length()) {
                return false;
            }
            int size = t.length();
            for (int i = 0; i < size; ++i) {
                if (t.charAt(i) > MIN_VALUE.charAt(i)) {
                    return true;
                }
                if (t.charAt(i) >= MIN_VALUE.charAt(i)) continue;
                return false;
            }
        } else {
            if (t.length() > MAX_VALUE.length()) {
                return true;
            }
            if (t.length() < MAX_VALUE.length()) {
                return false;
            }
            int size = t.length();
            for (int i = 0; i < size; ++i) {
                if (t.charAt(i) > MAX_VALUE.charAt(i)) {
                    return true;
                }
                if (t.charAt(i) >= MAX_VALUE.charAt(i)) continue;
                return false;
            }
        }
        return false;
    }

    public void setValue(short value) {
        this.setText(this.smallintFormatter.format(value));
    }

    @Override
    protected Document createDefaultModel() {
        return new SmallintDocument();
    }

    @Override
    public void setInitValue(String value) {
        throw new UnsupportedOperationException("Method setInitValue() not yet implemented.");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Method isEmpty() not yet implemented.");
    }

    @Override
    public boolean isChanged() {
        throw new UnsupportedOperationException("Method isChanged() not yet implemented.");
    }

    protected class SmallintDocument
    extends PlainDocument {
        private static final long serialVersionUID = -432065638218719626L;

        protected SmallintDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            int size = str.length();
            for (int i = 0; i < size; ++i) {
                if (Character.isDigit(str.charAt(i)) || str.charAt(i) == '-') continue;
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

