/*
 * Decompiled with CFR 0.152.
 */
package dbaut.editorPanel;

import dbaut.editorPanel.AutoIndentationEditor;
import dbaut.editorPanel.SQLSPColorEditorKit;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.EditorKit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class SQLTextPaneIndentation
extends JEditorPane {
    public SQLTextPaneIndentation() {
        this.jbInit();
    }

    private void jbInit() {
        super.setEditorKit(new SQLSPColorEditorKit());
        this.setCaretColor(Color.RED);
        this.setFont(new Font("Monospaced", 0, 14));
        AbstractDocument doc = (AbstractDocument)this.getDocument();
        AutoIndentationEditor indentFilter = new AutoIndentationEditor();
        doc.setDocumentFilter(indentFilter);
        final UndoManager undo = new UndoManager();
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                undo.addEdit(e.getEdit());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if ((e.getModifiersEx() & 0x80) != 0 && e.getKeyCode() == 90) {
                    try {
                        if (undo.canUndo()) {
                            undo.undo();
                        }
                    }
                    catch (CannotUndoException ex) {
                        UIManager.getLookAndFeel().provideErrorFeedback(SQLTextPaneIndentation.this);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(String text) {
        Document d = this.getDocument();
        if (!(d instanceof AbstractDocument)) {
            super.setText(text);
            return;
        }
        AbstractDocument doc = (AbstractDocument)d;
        DocumentFilter oldFilter = doc.getDocumentFilter();
        doc.setDocumentFilter(null);
        try {
            doc.remove(0, doc.getLength());
            if (text != null && !text.isEmpty()) {
                DefaultEditorKit plain = new DefaultEditorKit();
                StringReader r = new StringReader(text);
                ((EditorKit)plain).read(r, (Document)doc, 0);
            }
        }
        catch (IOException | BadLocationException e) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        }
        finally {
            doc.setDocumentFilter(oldFilter);
        }
    }
}

