/*
 * Decompiled with CFR 0.152.
 */
package dbaut.editorPanel;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;

public class AutoIndentationEditor
extends DocumentFilter {
    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String str, AttributeSet attr) throws BadLocationException {
        if ("\n".equals(str)) {
            str = this.addWhiteSpace(fb.getDocument(), offset);
        }
        super.insertString(fb, offset, str, attr);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        if ("\n".equals(text)) {
            text = this.addWhiteSpace(fb.getDocument(), offset);
        }
        super.replace(fb, offset, length, text, attrs);
    }

    private String addWhiteSpace(Document doc, int offset) throws BadLocationException {
        String temp;
        StringBuilder whiteSpace = new StringBuilder("\n");
        Element rootElement = doc.getDefaultRootElement();
        int line = rootElement.getElementIndex(offset);
        int i = rootElement.getElement(line).getStartOffset();
        while ((temp = doc.getText(i, 1)).equals(" ")) {
            whiteSpace.append(temp);
            ++i;
        }
        return whiteSpace.toString();
    }
}

