/*
 * Decompiled with CFR 0.152.
 */
package dbaut.comp;

import com.borland.jbcl.layout.VerticalFlowLayout;
import dbaut.comp.DbaButton;
import dbaut.comp.DragNDrogList;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DbaListChooser
extends JPanel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dbautproperties.dbaut.Res", LocaleManager.getLocale());
    private DbaButton Add_Button = new DbaButton(new Dimension(100, 24), true);
    private DbaButton Remove_Button = new DbaButton(new Dimension(100, 24), true);
    private DbaButton Add_All_Button = new DbaButton(new Dimension(100, 24), true);
    private DbaButton Remove_All_Button = new DbaButton(new Dimension(100, 24), true);
    private DragNDrogList leftlist = new DragNDrogList();
    private DragNDrogList rightlist = new DragNDrogList();
    private ActionListener listener = null;
    int listwidth = 160;

    public void setDataFlavor(DataFlavor df) {
        this.leftlist.setDataFlavor(df);
        this.rightlist.setDataFlavor(df);
    }

    public DbaListChooser() {
        this(160);
    }

    public DbaListChooser(int listwidth) {
        try {
            this.listwidth = listwidth;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("ListChooserPanel");
        this.Add_All_Button.setName("AddAllButton");
        this.Add_Button.setName("AddButton");
        this.Remove_All_Button.setName("RemoveAllButton");
        this.Remove_Button.setName("RemoveButton");
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jPanel1 = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.setLayout(new GridBagLayout());
        jPanel1.setLayout((LayoutManager)new VerticalFlowLayout(1));
        JPanel panel3 = new JPanel(new FlowLayout(1));
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(1));
        this.leftlist.setModel(new DefaultListModel());
        this.rightlist.setModel(new DefaultListModel());
        this.Add_Button.setHorizontalTextPosition(2);
        this.Add_All_Button.setHorizontalTextPosition(2);
        this.Add_Button.setText(this.res.getString("Add"));
        this.Add_All_Button.setText(this.res.getString("Add_All"));
        this.Remove_Button.setText(this.res.getString("Remove"));
        this.Remove_All_Button.setText(this.res.getString("Remove_All"));
        this.Add_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/add.gif"));
        this.Add_All_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/add_all.gif"));
        this.Remove_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/remove.gif"));
        this.Remove_All_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/remove_all.gif"));
        this.Add_Button.addActionListener(new ReflectionAction(this, "Add_Button_actionPerformed"));
        this.Remove_Button.addActionListener(new ReflectionAction(this, "Remove_Button_actionPerformed"));
        this.Add_All_Button.addActionListener(new ReflectionAction(this, "Add_All_Button_actionPerformed"));
        this.Remove_All_Button.addActionListener(new ReflectionAction(this, "Remove_All_Button_actionPerformed"));
        this.leftlist.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DbaListChooser.this.leftlist_valueChanged(e);
            }
        });
        this.rightlist.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DbaListChooser.this.rightlist_valueChanged(e);
            }
        });
        this.leftlist.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DbaListChooser.this.leftlist_mouseClicked(e);
            }
        });
        this.rightlist.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DbaListChooser.this.rightlist_mouseClicked(e);
            }
        });
        this.add((Component)jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), this.listwidth, 0));
        jScrollPane1.getViewport().add(this.leftlist);
        this.add((Component)jPanel1, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel2.add((Component)this.Add_Button, null);
        panel2.add((Component)this.Remove_Button, null);
        panel2.add((Component)this.Add_All_Button, null);
        panel2.add((Component)this.Remove_All_Button, null);
        panel3.add((Component)panel2, null);
        jPanel1.add((Component)panel3, null);
        this.add((Component)jScrollPane2, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), this.listwidth, 0));
        jScrollPane2.getViewport().add(this.rightlist);
        this.setButtonStatus();
    }

    public Object[] getSelection() {
        DefaultListModel rmodel = (DefaultListModel)this.rightlist.getModel();
        return rmodel.toArray();
    }

    public boolean isSelection() {
        DefaultListModel rmodel = (DefaultListModel)this.rightlist.getModel();
        return rmodel.size() > 0;
    }

    public void setLeftList(Object[] obj) {
        if (obj == null) {
            return;
        }
        DefaultListModel<Object> lmodel = new DefaultListModel<Object>();
        int size = obj.length;
        for (int i = 0; i < size; ++i) {
            lmodel.addElement(obj[i]);
        }
        this.leftlist.setModel(lmodel);
        this.setButtonStatus();
    }

    public void setLeftList(Vector v) {
        if (v.size() == 0) {
            return;
        }
        DefaultListModel lmodel = new DefaultListModel();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            lmodel.addElement(v.elementAt(i));
        }
        this.leftlist.setModel(lmodel);
        this.setButtonStatus();
    }

    public void Add_Button_actionPerformed(ActionEvent e) {
        int i;
        int[] selected = this.leftlist.getSelectedIndices();
        DefaultListModel lmodel = (DefaultListModel)this.leftlist.getModel();
        DefaultListModel rmodel = (DefaultListModel)this.rightlist.getModel();
        int length = selected.length;
        for (i = 0; i < length; ++i) {
            rmodel.addElement(lmodel.getElementAt(selected[i]));
        }
        for (i = length - 1; i >= 0; --i) {
            lmodel.removeElementAt(selected[i]);
        }
        this.setButtonStatus();
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    public void Remove_Button_actionPerformed(ActionEvent e) {
        int i;
        int[] selected = this.rightlist.getSelectedIndices();
        DefaultListModel rmodel = (DefaultListModel)this.rightlist.getModel();
        DefaultListModel lmodel = (DefaultListModel)this.leftlist.getModel();
        int length = selected.length;
        for (i = 0; i < length; ++i) {
            lmodel.addElement(rmodel.getElementAt(selected[i]));
        }
        for (i = length - 1; i >= 0; --i) {
            rmodel.removeElementAt(selected[i]);
        }
        this.setButtonStatus();
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    public void Add_All_Button_actionPerformed(ActionEvent e) {
        this.leftlist.setSelectionInterval(0, this.leftlist.getModel().getSize() - 1);
        this.Add_Button_actionPerformed(e);
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    public void Remove_All_Button_actionPerformed(ActionEvent e) {
        this.rightlist.setSelectionInterval(0, this.rightlist.getModel().getSize() - 1);
        this.Remove_Button_actionPerformed(e);
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    private void setButtonStatus() {
        this.Add_Button.setEnabled(!this.leftlist.getSelectionModel().isSelectionEmpty());
        this.Add_All_Button.setEnabled(this.leftlist.getModel().getSize() > 0);
        this.Remove_Button.setEnabled(!this.rightlist.getSelectionModel().isSelectionEmpty());
        this.Remove_All_Button.setEnabled(this.rightlist.getModel().getSize() > 0);
    }

    void leftlist_valueChanged(ListSelectionEvent e) {
        this.setButtonStatus();
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    void rightlist_valueChanged(ListSelectionEvent e) {
        this.setButtonStatus();
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    void leftlist_mouseClicked(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        this.Add_Button_actionPerformed(null);
    }

    void rightlist_mouseClicked(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        this.Remove_Button_actionPerformed(null);
    }

    public void emptyLeftList() {
        this.leftlist.setModel(new DefaultListModel());
        this.setButtonStatus();
    }

    public void emptyRightList() {
        this.rightlist.setModel(new DefaultListModel());
        this.setButtonStatus();
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
        if (this.listener != null) {
            this.rightlist.addActionListener(this.listener);
        }
    }
}

