/*
 * Decompiled with CFR 0.152.
 */
package dbaut;

import dbaut.DataSource;
import dbaut.LinuxDSN;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinuxLib {
    private static Pattern _section = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
    private static Pattern _keyValue = Pattern.compile("\\s*([^=]*)=(.*)");

    public static void main(String[] args) {
        Vector dsnNames = LinuxLib.getUnixOdbcDSNNames();
        String dsn = null;
        for (int i = 0; i < dsnNames.size(); ++i) {
            LinuxLib.testConnect(dsn, "SYSADM", "");
        }
    }

    private static void testConnect(LinuxDSN dsn, String userName, String passWord) {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String dsnUrl = "jdbc:odbc:" + dsn.getDsnName() + ";" + "DRIVER={" + dsn.getDriver() + "};" + "DATABASE=" + dsn.getDatabase();
            System.out.println(dsnUrl);
            Connection conn = DriverManager.getConnection(dsnUrl, userName, passWord);
            String catalog = conn.getCatalog();
            System.out.println(catalog);
            conn.close();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void testConnect(String dsn, String userName, String passWord) {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String dsnUrl = "jdbc:odbc:" + dsn;
            System.out.println(dsnUrl);
            Connection conn = DriverManager.getConnection(dsnUrl, userName, passWord);
            String catalog = conn.getCatalog();
            System.out.println(catalog);
            conn.close();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Vector getUnixOdbcDSNNames() {
        ArrayList unixOdbcDSNs = LinuxLib.getUnixOdbcDSNs();
        Vector<Object> dsnNames = new Vector<Object>(Arrays.asList(unixOdbcDSNs.toArray()));
        return dsnNames;
    }

    public static Vector<DataSource> getUnixOdbcDSNNames2() {
        Vector<DataSource> dsnNames = new Vector<DataSource>();
        try {
            File sysODBCINI;
            String usrHome = System.getProperties().getProperty("user.home");
            File usrODBCINI = new File(usrHome + "/.odbc.ini");
            if (usrODBCINI.exists()) {
                Vector<DataSource> tmp = LinuxLib.parseINI(usrODBCINI);
                dsnNames.addAll(tmp);
            }
            if ((sysODBCINI = new File("/etc/odbc.ini")).exists()) {
                Vector<DataSource> tmp = LinuxLib.parseINI(sysODBCINI);
                dsnNames.addAll(tmp);
            } else {
                sysODBCINI = new File("/usr/local/etc/odbc.ini");
                Vector<DataSource> tmp = LinuxLib.parseINI(sysODBCINI);
                dsnNames.addAll(tmp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dsnNames;
    }

    private static ArrayList getUnixOdbcDSNs() {
        File sysODBCINI;
        ArrayList dsnNames = new ArrayList();
        String usrHome = System.getProperties().getProperty("user.home");
        File usrODBCINI = new File(usrHome + "/.odbc.ini");
        if (usrODBCINI.exists()) {
            LinuxLib.parseINIFile(dsnNames, usrODBCINI);
        }
        if ((sysODBCINI = new File("/etc/odbc.ini")).exists()) {
            LinuxLib.parseINIFile(dsnNames, sysODBCINI);
        } else {
            sysODBCINI = new File("/usr/local/etc/odbc.ini");
            if (sysODBCINI.exists()) {
                LinuxLib.parseINIFile(dsnNames, sysODBCINI);
            }
        }
        return dsnNames;
    }

    public static Vector<DataSource> parseINI(File fileName) throws IOException {
        BufferedReader isr = new BufferedReader(new FileReader(fileName));
        Map<String, Properties> map = LinuxLib.parseINI(isr);
        Vector<DataSource> v = new Vector<DataSource>();
        for (Map.Entry<String, Properties> entry : map.entrySet()) {
            v.add(new DataSource(entry.getKey(), entry.getValue().getProperty("Driver")));
        }
        return v;
    }

    private static Map<String, Properties> parseINI(BufferedReader reader) throws IOException {
        String line;
        HashMap<String, Properties> result = new HashMap<String, Properties>();
        String section = null;
        while ((line = reader.readLine()) != null) {
            Matcher m = _section.matcher(line);
            if (m.matches()) {
                section = m.group(1).trim();
                result.put(section, new Properties());
                continue;
            }
            if (section == null || !(m = _keyValue.matcher(line)).matches()) continue;
            String key = m.group(1).trim();
            String value = m.group(2).trim();
            Properties p = (Properties)result.get(section);
            if (p == null) {
                p = new Properties();
                result.put(section, p);
            }
            p.put(key, value);
        }
        return result;
    }

    private static void parseINIFile(ArrayList dsnNames, File fileName) {
        try {
            FileInputStream fis = new FileInputStream(fileName);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader bf = new BufferedReader(isr);
            String line = null;
            int preIndex = -1;
            int sufIndex = -1;
            String dsnName = null;
            while ((line = bf.readLine()) != null) {
                preIndex = line.indexOf("[");
                sufIndex = line.indexOf("]");
                if (preIndex != -1 && sufIndex != -1) {
                    dsnName = line.substring(preIndex + 1, sufIndex);
                }
                if (dsnName == null || dsnName.length() <= 0) continue;
                if (!dsnNames.contains(dsnName)) {
                    dsnNames.add(dsnName);
                    dsnName = null;
                    continue;
                }
                System.out.println("Omit DSN name: \"" + dsnName + "\" in config file " + fileName.getAbsolutePath() + " .");
                dsnName = null;
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Can not get " + fileName + " file.");
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

