/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Trigger;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.TreeNode.TableTreeNode;
import dbatool.tableModel.ColumnSorting;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.DbaTable;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;

public class TriggerList
extends DbaTabbedPane
implements ComponentPrivilege {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private TriggerCols model1 = null;
    private DBAToolAbstractTableModel absModel = null;
    private JTable table = null;
    private DbaButton Prop_Create_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Prop_Create_Button_actionPerformed"));
    private DbaButton Prop_Drop_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Prop_Drop_Button_actionPerformed"));
    private String table_owner = null;
    private String table_name = null;
    private DefaultMutableTreeNode parent_node = null;

    public TriggerList(TableTreeNode tableNode) {
        try {
            this.table_owner = tableNode.getTableOwner();
            this.table_name = tableNode.getTableName();
            this.parent_node = this.parent_node;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TriggerList() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("TriggersTabbedPane");
        this.Prop_Drop_Button.setName("DropButton");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "trigger.list");
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        this.model1 = new TriggerCols();
        this.absModel = new DBAToolAbstractTableModel(this.model1);
        this.table = new DbaTable(this.absModel);
        this.absModel.addMouseListenerToHeaderInTable(this.table);
        jPanel1.setLayout(new BorderLayout());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TriggerList.this.table_mouseClicked(e);
            }
        });
        this.add((Component)jPanel1, this.res.getTitle("Triggers"));
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.setName("TriggersButtonPanel");
        this.Prop_Create_Button.setName("CreateButton");
        jPanel2.add((Component)this.Prop_Create_Button, null);
        jPanel2.add((Component)this.Prop_Drop_Button, null);
        jPanel1.add((Component)jScrollPane1, "Center");
        jScrollPane1.getViewport().add((Component)this.table, null);
        this.table.setName("TriggersListTable");
        this.table.setAutoResizeMode(4);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table_valueChanged"));
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.grant(false);
        this.getTriggerList();
    }

    @Override
    public int getComponentType() {
        return 15;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Prop_Create_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.Prop_Drop_Button.setEnabled(enabled);
    }

    public void table_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
        } else {
            int r = this.table.getSelectedRow();
            Object value = this.table.getValueAt(r, 0);
            String owner = (String)value;
            this.authority.authorise(owner);
        }
    }

    private void getTriggerList() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select TBOWNER, TBNAME, TRIGNAME, TRIGEVENT, TRIGTYPE, STATUS from SYSTEM.SYSTRIGGER where RESERVE1 != 1 ";
            if (this.table_name != null) {
                query = query + "and TBOWNER = '" + this.table_owner + "' " + "and TBNAME = '" + this.table_name + "' ";
            }
            query = query + "order by TRIGNAME";
            rs = stmt.executeQuery(query);
            String table_name = null;
            RowInfo aTrigger = null;
            while (rs.next()) {
                String trigname = GuiUt.rightTrim(rs.getString(3));
                String table_owner = GuiUt.rightTrim(rs.getString(1));
                table_name = GuiUt.rightTrim(rs.getString(2));
                aTrigger = new RowInfo(table_owner, table_name, trigname, rs.getShort(4), rs.getShort(5), rs.getShort(6));
                this.model1.addValue(aTrigger);
            }
            if (this.model1.getRowCount() == 0) {
                DbFrame.frame.setStatusDisc(this.res.getString("No_data_found"));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(this.res.getString("The_number_of_triggers_is"), Integer.toString(this.model1.getRowCount())));
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    public void Prop_Drop_Button_actionPerformed(ActionEvent e) {
        String trgname;
        String tbowner;
        String tbname;
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            return;
        }
        if (this.table_name != null) {
            tbname = this.table_name;
            tbowner = this.table_owner;
            trgname = (String)this.model1.getValueAt(row, 2);
        } else {
            tbowner = (String)this.model1.getValueAt(row, 0);
            tbname = (String)this.model1.getValueAt(row, 1);
            trgname = (String)this.model1.getValueAt(row, 2);
        }
        if (DbFrame.conn_DatabaseConnection.dropTrigger(trgname, tbowner, tbname)) {
            DbFrame.frame.treePanel.afterDropTrigger(tbowner, tbname);
        }
    }

    public void Prop_Create_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.CreateObjectChoice(5, this.table_owner, this.table_name);
    }

    void table_mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            int row = this.table.getSelectedRow();
            if (row < 0 || row >= this.absModel.getRowCount()) {
                return;
            }
            if (this.table_name == null) {
                String owner = (String)this.absModel.getValueAt(row, 0);
                String name = (String)this.absModel.getValueAt(row, 1);
                String trgname = (String)this.absModel.getValueAt(row, 2);
                DbFrame.frame.treePanel.openTriggerTree(owner, name, trgname);
            } else {
                String owner = this.table_owner;
                String name = this.table_name;
                String trgname = (String)this.absModel.getValueAt(row, 2);
                DbFrame.frame.treePanel.openTableObjectTree(owner, name, trgname, 3);
            }
        }
    }

    public class TriggerCols
    extends AbstractTableModel
    implements ColumnSorting {
        private String[] allColumnNames;
        private String[] columnNames;
        private Vector data;

        public TriggerCols() {
            this.allColumnNames = new String[]{TriggerList.this.res.getString("Schema_Name_Big"), TriggerList.this.res.getString("Table_Name"), TriggerList.this.res.getString("Name"), TriggerList.this.res.getString("Enable"), TriggerList.this.res.getString("Event"), TriggerList.this.res.getString("Time"), TriggerList.this.res.getString("Type")};
            this.columnNames = new String[]{TriggerList.this.res.getString("Name"), TriggerList.this.res.getString("Enable"), TriggerList.this.res.getString("Event"), TriggerList.this.res.getString("Time"), TriggerList.this.res.getString("Type")};
            this.data = new Vector();
        }

        @Override
        public int getColumnCount() {
            if (TriggerList.this.parent_node != null) {
                return this.columnNames.length;
            }
            return this.allColumnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            if (TriggerList.this.parent_node != null) {
                return this.columnNames[col];
            }
            return this.allColumnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            RowInfo rowData = (RowInfo)this.data.elementAt(row);
            return rowData.getValueAt(col);
        }

        public Class getColumnClass(int c) {
            RowInfo rowData = (RowInfo)this.data.elementAt(0);
            return rowData.getValueAt(c).getClass();
        }

        public void addValue(RowInfo newData) {
            this.data.addElement(newData);
        }

        public void removeAll() {
            this.data.removeAllElements();
        }

        @Override
        public void switchOrder(int godown, int goup) {
            Object downRow = this.data.elementAt(godown);
            Object upRow = this.data.elementAt(goup);
            this.data.setElementAt(downRow, goup);
            this.data.setElementAt(upRow, godown);
        }
    }

    private class RowInfo {
        Object[] data = new Object[7];

        public RowInfo(String table_owner, String table_name, String trigname, short trigevent, short trigtype, short status) {
            this.data[0] = table_owner;
            this.data[1] = table_name;
            this.data[2] = trigname;
            switch (status) {
                case 0: {
                    this.data[3] = new Boolean(false);
                    break;
                }
                case 1: {
                    this.data[3] = new Boolean(true);
                    break;
                }
                default: {
                    this.data[3] = new Boolean(false);
                }
            }
            switch (trigevent) {
                case 1: {
                    this.data[4] = new String(TriggerList.this.res.getString("Insert"));
                    break;
                }
                case 2: {
                    this.data[4] = new String(TriggerList.this.res.getString("Delete"));
                    break;
                }
                case 3: {
                    this.data[4] = new String(TriggerList.this.res.getString("Update"));
                    break;
                }
                case 4: {
                    this.data[4] = new String(TriggerList.this.res.getString("Update_Column"));
                    break;
                }
                default: {
                    this.data[4] = new String("");
                }
            }
            switch (trigtype) {
                case 1: {
                    this.data[5] = new String(TriggerList.this.res.getString("Before"));
                    this.data[6] = new String(TriggerList.this.res.getString("For_each_statement"));
                    break;
                }
                case 2: {
                    this.data[5] = new String(TriggerList.this.res.getString("Before"));
                    this.data[6] = new String(TriggerList.this.res.getString("For_each_row"));
                    break;
                }
                case 4: {
                    this.data[5] = new String(TriggerList.this.res.getString("After"));
                    this.data[6] = new String(TriggerList.this.res.getString("For_each_statement"));
                    break;
                }
                case 8: {
                    this.data[5] = new String(TriggerList.this.res.getString("After"));
                    this.data[6] = new String(TriggerList.this.res.getString("For_each_row"));
                    break;
                }
                default: {
                    this.data[5] = new String("");
                    this.data[6] = new String("");
                }
            }
        }

        public Object getValueAt(int index) {
            if (TriggerList.this.parent_node != null) {
                return this.data[index + 2];
            }
            return this.data[index];
        }
    }
}

