/*
 * Decompiled with CFR 0.152.
 */
package dbatool.TreeNode;

import dbatool.DbFrame;
import dbatool.Popupmenu.List_Popupmenu;
import dbatool.StoredCommand.StoredCommandInfo;
import dbatool.TreeNode.DBATreeNode;
import dbaut.GuiUt;
import dbaut.locale.LocaleChangeEvent;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;

public class CommandTreeNode
extends DBATreeNode {
    private String modulename;
    private String owner;
    private String name;
    private int num_parm;
    private static ImageIcon icon = null;
    private String toString = null;

    public CommandTreeNode(String modulename, String owner, String name, int num_parm) {
        this.modulename = modulename;
        this.owner = GuiUt.rightTrim(owner);
        this.name = GuiUt.rightTrim(name);
        this.num_parm = num_parm;
        this.toString = this.owner + "." + this.name;
    }

    @Override
    public String getHelpID() {
        return "storedcommand.info";
    }

    @Override
    public String toString() {
        return this.toString;
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = DBAImageResource.getResource(this.getClass(), "/jdbaimages/single_stored_command.gif");
        }
        return icon;
    }

    @Override
    public void displayObject() {
        DBAResourceBundle res = DbFrame.frame.getResourceBundle();
        DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(res.getString("Information_about"), this.modulename + "." + this.owner + "." + this.name));
        DbFrame.frame.setContentPanel(new StoredCommandInfo(this.modulename, this.owner, this.name, this.num_parm));
    }

    @Override
    public void displayMenu(MouseEvent e) {
        List_Popupmenu popup = new List_Popupmenu(this);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
    }

    @Override
    public boolean isFound(String s1, String s2, String s3) {
        return this.owner.equalsIgnoreCase(s1) && this.name.equalsIgnoreCase(s2);
    }

    @Override
    public void refresh() {
        this.displayObject();
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }
}

