/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Task;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.Task.PlanDialog2;
import dbatool.Task.PlanRowInfo;
import dbatool.Task.PlanTableModel;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.editorPanel.SQLTextPane;
import dbaut.resource.DBAImageResource;
import dbaut.text.TextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;

public class TaskInfo
extends DbaTabbedPane
implements ComponentPrivilege {
    private String owner;
    private String name;
    private String type;
    private DbaButton Drop_Button;
    private DbaButton Create_Button;
    private DbaButton Modify_Button;
    private DbaButton Reload_Button;
    private PlanTableModel model;
    private DBAToolAbstractTableModel absModel;
    private JTable plan_table;
    private SQLTextPane Source;
    private DbaButton Sc_Cancel_Button;
    private DbaButton Sc_Confirm_Button;
    private DbaButton Sc_Modify_Button;
    private JComboBox type_ComboBox;

    public TaskInfo(String owner, String name) {
        this.Drop_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/dbautimages/drop.gif"), new ReflectionAction(this, "Drop_Button_actionPerformed"));
        this.Create_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/confirm.gif"), new ReflectionAction(this, "Create_Button_actionPerformed"));
        this.Modify_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Start_Modify"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"), new ReflectionAction(this, "Modify_Button_actionPerformed"));
        this.Reload_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Reload"), 'R', DBAImageResource.getResource(this.getClass(), "/dbautimages/reload.gif"), new ReflectionAction(this, "Reload_Button_actionPerformed"));
        this.model = null;
        this.absModel = null;
        this.plan_table = null;
        this.Source = new SQLTextPane();
        this.Sc_Cancel_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "Sc_Cancel_Button_actionPerformed"));
        this.Sc_Confirm_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Confirm"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/confirm.gif"), new ReflectionAction(this, "Sc_Confirm_Button_actionPerformed"));
        this.Sc_Modify_Button = new DbaButton(new Dimension(100, 24), DbFrame.frame.res.getString("Start_Modify"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"), new ReflectionAction(this, "Sc_Modify_Button_actionPerformed"));
        this.type_ComboBox = new JComboBox();
        this.owner = GuiUt.rightTrim(owner);
        this.name = GuiUt.rightTrim(name);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("TaskTabbedPane");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "task.info.properties");
        DbaPanel jPanel4 = new DbaPanel(DbFrame.helpres, "task.info.plan");
        JScrollPane jScrollPane1 = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        TextField Task_Name = new TextField();
        TextField Owner_Name = new TextField();
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        this.model = new PlanTableModel(this.owner, this.name);
        this.absModel = new DBAToolAbstractTableModel(this.model);
        this.plan_table = new JTable(this.absModel);
        this.plan_table.getTableHeader().setReorderingAllowed(false);
        jPanel1.setLayout(new BorderLayout(5, 5));
        jScrollPane1.setBorder(BorderFactory.createEtchedBorder());
        jLabel1.setText(DbFrame.frame.res.getString("Owner"));
        jLabel2.setText(DbFrame.frame.res.getString("Name"));
        jLabel3.setText(DbFrame.frame.res.getString("Type"));
        jPanel3.setLayout(new BorderLayout(5, 5));
        jPanel3.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), DbFrame.frame.res.getString("Statement")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        Owner_Name.setText(this.owner);
        Task_Name.setText(this.name);
        Owner_Name.setEnabled(false);
        Task_Name.setEnabled(false);
        jPanel4.setLayout(new BorderLayout(5, 5));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.Source.setEditable(false);
        this.add((Component)jPanel1, DbFrame.frame.res.getTitle("Properties"));
        JPanel flowPanel = new JPanel(new FlowLayout(0));
        flowPanel.add(jPanel2);
        jPanel1.add((Component)flowPanel, "North");
        this.getTypeName();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setName("TaskPanel");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        JPanel toolbar1 = new JPanel(new FlowLayout(0));
        toolbar1.add(this.Sc_Modify_Button);
        toolbar1.add(this.Sc_Confirm_Button);
        toolbar1.add(this.Sc_Cancel_Button);
        jPanel2.add((Component)toolbar1, gbc);
        ++gbc.gridy;
        jLabel1.setPreferredSize(new Dimension(100, jLabel1.getPreferredSize().height));
        gbc.gridx = 0;
        jPanel2.add((Component)jLabel1, gbc);
        Owner_Name.setPreferredSize(new Dimension(400, Owner_Name.getPreferredSize().height));
        gbc.gridx = 1;
        jPanel2.add((Component)Owner_Name, gbc);
        ++gbc.gridy;
        jLabel2.setPreferredSize(new Dimension(100, jLabel2.getPreferredSize().height));
        gbc.gridx = 0;
        jPanel2.add((Component)jLabel2, gbc);
        Task_Name.setPreferredSize(new Dimension(400, Task_Name.getPreferredSize().height));
        gbc.gridx = 1;
        jPanel2.add((Component)Task_Name, gbc);
        ++gbc.gridy;
        jLabel3.setPreferredSize(new Dimension(100, jLabel3.getPreferredSize().height));
        gbc.gridx = 0;
        jPanel2.add((Component)jLabel3, gbc);
        this.type_ComboBox.setPreferredSize(new Dimension(400, this.type_ComboBox.getPreferredSize().height));
        gbc.gridx = 1;
        jPanel2.add((Component)this.type_ComboBox, gbc);
        this.Sc_Confirm_Button.setEnabled(false);
        this.Sc_Cancel_Button.setEnabled(false);
        jPanel1.add((Component)jPanel3, "Center");
        jPanel3.add((Component)jScrollPane1, "Center");
        this.add((Component)jPanel4, DbFrame.frame.res.getTitle("Plans"));
        jPanel4.add((Component)jPanel5, "North");
        jPanel5.add((Component)this.Modify_Button, null);
        jPanel5.add((Component)this.Create_Button, null);
        jPanel5.add((Component)this.Drop_Button, null);
        jPanel5.add((Component)this.Reload_Button, null);
        jPanel4.add((Component)jScrollPane2, "Center");
        jScrollPane2.getViewport().add((Component)this.plan_table, null);
        jScrollPane1.getViewport().add((Component)this.Source, null);
        this.getTaskInfo();
        this.getPlans();
        this.type_ComboBox.setSelectedItem(this.type);
        this.type_ComboBox.setEnabled(false);
        this.absModel.addMouseListenerToHeaderInTable(this.plan_table);
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce(this.owner);
        this.plan_table.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table_valueChanged"));
        if (this.plan_table.getSelectionModel().isSelectionEmpty()) {
            this.grant(false);
        }
        this.plan_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TaskInfo.this.table_mouseClicked(e);
            }
        });
    }

    public void table_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
        } else {
            int r = this.plan_table.getSelectedRow();
            Object value = this.plan_table.getValueAt(r, 1);
            String owner = (String)value;
            this.authority.authorise(owner);
        }
    }

    private void getTypeName() {
        String[] types = new String[]{"SQL_STATEMENT", "STORE_PROCEDURE", "EXECUTABLE"};
        DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>(types);
        this.type_ComboBox.setModel(cbm);
    }

    @Override
    public int getComponentType() {
        return 27;
    }

    @Override
    public void grantOnce(boolean enabled) {
    }

    @Override
    public void grant(boolean enabled) {
        this.Modify_Button.setEnabled(enabled);
        this.Drop_Button.setEnabled(enabled);
    }

    private void getTaskInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select TASK_TYPE, ACTIONS from SYSTEM.SYSTASK WHERE TASK_OWNER = '" + this.owner + "'" + "and TASK_NAME = '" + this.name + "'";
            rs = stmt.executeQuery(query);
            String source = null;
            String[] types = new String[]{"SQL_STATEMENT", "STORE_PROCEDURE", "EXECUTABLE"};
            while (rs.next()) {
                this.type = types[rs.getInt(1) - 1];
                source = rs.getString(2);
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            if (source != null) {
                this.Source.setText(source);
            }
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    private void getPlans() {
        this.model.removeAll();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select SCHEDULE_OWNER, SCHEDULE_NAME, TASK_NAME, START_TIME, END_TIME, STATUS, TIMETABLE from SYSSCHEDULE where TASK_NAME = '" + this.name + "' " + "and SCHEDULE_OWNER = '" + this.owner + "' " + "ORDER BY SCHEDULE_OWNER, SCHEDULE_NAME, TASK_NAME";
            boolean status = false;
            PlanRowInfo one_row = null;
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String owner = GuiUt.rightTrim(rs.getString(1));
                String name = GuiUt.rightTrim(rs.getString(2));
                String taskName = GuiUt.rightTrim(rs.getString(3));
                String startTime = rs.getString(4);
                String endTime = rs.getString(5);
                status = rs.getBoolean(6);
                String timeTable = rs.getString(7);
                one_row = new PlanRowInfo(owner, name, taskName, timeTable, startTime, endTime, status);
                this.model.addValue(one_row);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    public void Modify_Button_actionPerformed(ActionEvent e) {
        int row = this.plan_table.getSelectedRow();
        if (row < 0) {
            return;
        }
        this.fixTabbedPanelAt(this.getSelectedIndex());
        PlanRowInfo rowData = this.model.getRow(row);
        PlanDialog2 dialog = new PlanDialog2(DbFrame.frame, rowData);
        dialog.setVisible(true);
        this.releaseTabbedPanel();
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        this.getPlans();
    }

    public void Create_Button_actionPerformed(ActionEvent e) {
        PlanDialog2 dialog = new PlanDialog2(DbFrame.frame, this.owner, this.name);
        dialog.setVisible(true);
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        this.releaseTabbedPanel();
        this.getPlans();
    }

    public void Drop_Button_actionPerformed(ActionEvent e) {
        int row = this.plan_table.getSelectedRow();
        if (row < 0) {
            return;
        }
        String str1 = DbFrame.frame.res.getString("Do_you_want_to_drop_plan");
        String schedule_owner = (String)this.model.getValueAt(row, 0);
        String schedule_name = (String)this.model.getValueAt(row, 1);
        String str2 = GuiUt.mapStringForProperty(str1, schedule_owner + "." + schedule_name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, DbFrame.frame.res.getString("Drop_Plan"), str2 + "?");
        if (reply != 0) {
            return;
        }
        String value = GuiUt.getIDString(schedule_owner) + "." + GuiUt.getIDString(schedule_name);
        String query = "{call SCHEDULE_DROP( '" + value + "')}";
        boolean result = DatabaseConnection.executeSQL(this, query);
        if (!result) {
            return;
        }
        GuiUt.showInformationDlg(DbFrame.frame, DbFrame.frame.res.getString("Schedule_is_dropped_successful"));
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        this.releaseTabbedPanel();
        this.getPlans();
    }

    public void Reload_Button_actionPerformed(ActionEvent e) {
        String query = "call \"SYSTEM\".\"SCHEDULE_RELOAD\"";
        boolean result = DatabaseConnection.executeSQL(this, query);
        if (!result) {
            return;
        }
        GuiUt.showInformationDlg(DbFrame.frame, DbFrame.frame.res.getString("Schedule_is_reloaded_successful"));
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        this.releaseTabbedPanel();
        this.getPlans();
    }

    public void Sc_Modify_Button_actionPerformed(ActionEvent e) {
        this.fixTabbedPanelAt(this.getSelectedIndex());
        this.Sc_Modify_Button.setEnabled(false);
        this.Sc_Confirm_Button.setEnabled(true);
        this.Sc_Cancel_Button.setEnabled(true);
        this.Source.setEditable(true);
        this.type_ComboBox.setEnabled(true);
    }

    public void Sc_Cancel_Button_actionPerformed(ActionEvent e) {
        this.getTaskInfo();
        this.revalidate();
        this.repaint();
        this.releaseTabbedPanel();
        this.Source.setEditable(false);
        this.type_ComboBox.setEnabled(false);
        this.Sc_Modify_Button.setEnabled(true);
        this.Sc_Confirm_Button.setEnabled(false);
        this.Sc_Cancel_Button.setEnabled(false);
    }

    public void Sc_Confirm_Button_actionPerformed(ActionEvent e) {
        String modifySql = this.Source.getText().trim();
        this.type = this.type_ComboBox.getSelectedItem().toString();
        modifySql = modifySql.replace("'", "''");
        String executeSql = "{call TASK_ALTER( '" + GuiUt.getIDString(this.owner) + "." + GuiUt.getIDString(this.name) + "','" + this.type + "','" + modifySql + "')}";
        Statement stmt = null;
        Object rs = null;
        JDialog dialog = new JDialog();
        GuiUt.setCenterLocation(DbFrame.frame, dialog);
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            stmt.execute(executeSql);
            stmt.close();
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(dialog, null, sqle);
            DbaObject.close(stmt);
            return;
        }
        dialog.setVisible(false);
        dialog.dispose();
        this.getTaskInfo();
        this.Source.setEditable(false);
        this.type_ComboBox.setEnabled(false);
        this.revalidate();
        this.repaint();
        this.releaseTabbedPanel();
        this.Sc_Confirm_Button.setEnabled(false);
        this.Sc_Cancel_Button.setEnabled(false);
        this.Sc_Modify_Button.setEnabled(true);
    }

    private void table_mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            this.Modify_Button_actionPerformed(null);
        }
    }
}

