/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Task;

import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.Task.PlanRowInfo;
import dbatool.Task.Scheduler;
import dbaut.ComboEditorField;
import dbaut.GuiUt;
import dbaut.comp.ReflectionAction;
import dbaut.textField.DateFieldWithChooser;
import dbaut.textField.TimeField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PlanDialog2
extends JDialog {
    JTextField nameField = new JTextField(20);
    String[] planTypes;
    JComboBox<String> planTypeComboBox;
    JCheckBox enabledCheckBox;
    DateFieldWithChooser onceDateField;
    TimeField onceTimeField;
    String[] minuteOptions;
    JComboBox<String> minuteComboBox;
    String[] hourOptions;
    JComboBox<String> hourComboBox;
    String[] dayOptions;
    JComboBox<String> dayComboBox;
    String[] monthOptions;
    JComboBox<String> monthComboBox;
    JCheckBox[] dayCheckBox;
    JTextField startTimeField;
    DateFieldWithChooser startDateField;
    JRadioButton noEndDateButton;
    JRadioButton endDateButton;
    DateFieldWithChooser endDateField;
    JTextField endTimeField;
    JTextArea descriptionArea;
    JButton validateButton;
    JRadioButton nowButton;
    JRadioButton specifyButton;
    JButton okButton;
    JButton cancelButton;
    JButton helpButton;
    private String taskName;
    private String taskOwner;
    PlanRowInfo data;

    public static void setDayCheckBoxes(String dayField, JCheckBox[] dayCheckBox, Map<String, Integer> dayMap) {
        String[] parts;
        if (dayField.compareTo("*") == 0) {
            for (JCheckBox checkBox : dayCheckBox) {
                checkBox.setSelected(true);
            }
            return;
        }
        for (JCheckBox checkBox : dayCheckBox) {
            checkBox.setSelected(false);
        }
        for (String part : parts = dayField.split(",")) {
            if (part.contains("-")) {
                String[] range = part.split("-");
                Integer startIndex = dayMap.get(range[0].toUpperCase());
                Integer endIndex = dayMap.get(range[1].toUpperCase());
                if (startIndex == null || endIndex == null) continue;
                for (int i = startIndex.intValue(); i <= endIndex; ++i) {
                    dayCheckBox[i].setSelected(true);
                }
                continue;
            }
            Integer dayIndex = dayMap.get(part.toUpperCase());
            if (dayIndex == null) continue;
            dayCheckBox[dayIndex].setSelected(true);
        }
    }

    public PlanDialog2(JFrame parent, PlanRowInfo rowData) {
        this(parent, (String)rowData.getValueAt(0), (String)rowData.getValueAt(2));
        this.data = rowData;
        this.nameField.setText((String)this.data.getValueAt(1));
        String cronText = (String)this.data.getValueAt(3);
        String startTime = (String)this.data.getValueAt(4);
        String endTime = (String)this.data.getValueAt(5);
        String[] strs = cronText.split("\\s+", 5);
        if (strs == null) {
            return;
        }
        if (strs.length == 1 || strs.length != 5) {
            if (strs[0].compareToIgnoreCase("@once") == 0) {
                this.planTypeComboBox.setSelectedIndex(1);
                String[] s0 = startTime.split(" ", 2);
                this.onceDateField.setText(s0[0]);
                this.onceTimeField.setText(s0[1]);
            } else {
                String[] s0 = startTime.split(" ", 2);
                this.startDateField.setText(s0[0]);
                this.startTimeField.setText(s0[1]);
                if (endTime != null || endTime.length() > 0) {
                    this.endDateButton.setSelected(true);
                    String[] s1 = endTime.split(" ", 2);
                    this.endDateField.setText(s1[0]);
                    this.endTimeField.setText(s1[1]);
                } else {
                    this.noEndDateButton.setSelected(true);
                }
                this.descriptionArea.setText(cronText);
            }
        } else {
            DefaultComboBoxModel model;
            if (strs[0].compareTo("*") == 0) {
                this.minuteComboBox.setSelectedIndex(1);
            } else if (strs[0].compareTo("*/10") == 0) {
                this.minuteComboBox.setSelectedIndex(2);
            } else if (strs[0].compareTo("*/30") == 0) {
                this.minuteComboBox.setSelectedIndex(2);
            } else {
                model = (DefaultComboBoxModel)this.minuteComboBox.getModel();
                model.removeElementAt(0);
                model.insertElementAt(strs[0], 0);
                this.minuteComboBox.setSelectedIndex(0);
            }
            if (strs[1].compareTo("*") == 0) {
                this.hourComboBox.setSelectedIndex(1);
            } else if (strs[1].compareTo("*/6") == 0) {
                this.hourComboBox.setSelectedIndex(2);
            } else if (strs[1].compareTo("*/12") == 0) {
                this.hourComboBox.setSelectedIndex(2);
            } else {
                model = (DefaultComboBoxModel)this.hourComboBox.getModel();
                model.removeElementAt(0);
                model.insertElementAt(strs[1], 0);
                this.hourComboBox.setSelectedIndex(0);
            }
            if (strs[2].compareTo("*") == 0) {
                this.dayComboBox.setSelectedIndex(1);
            } else if (strs[2].compareTo("*/10") == 0) {
                this.dayComboBox.setSelectedIndex(2);
            } else {
                model = (DefaultComboBoxModel)this.dayComboBox.getModel();
                model.removeElementAt(0);
                model.insertElementAt(strs[2], 0);
                this.dayComboBox.setSelectedIndex(0);
            }
            if (strs[3].compareTo("*") == 0) {
                this.monthComboBox.setSelectedIndex(1);
            } else if (strs[3].compareTo("*/2") == 0) {
                this.monthComboBox.setSelectedIndex(2);
            } else {
                model = (DefaultComboBoxModel)this.monthComboBox.getModel();
                model.removeElementAt(0);
                model.insertElementAt(strs[3], 0);
                this.monthComboBox.setSelectedIndex(0);
            }
            HashMap<String, Integer> dayMap = new HashMap<String, Integer>();
            String[] days = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
            int i = 0;
            for (String day : days) {
                dayMap.put(day.toUpperCase(), i);
                dayMap.put(String.valueOf(i), i);
                ++i;
            }
            dayMap.put(String.valueOf(i), 0);
            PlanDialog2.setDayCheckBoxes(strs[4], this.dayCheckBox, dayMap);
        }
        this.descriptionArea.setText(cronText);
    }

    public PlanDialog2(JFrame parent, String taskOwner, String taskName) {
        super(parent, "Create New Job Plan", true);
        this.planTypes = new String[]{DbFrame.frame.res.getString("Recurring"), DbFrame.frame.res.getString("One_Time")};
        this.planTypeComboBox = new JComboBox<String>(this.planTypes);
        this.enabledCheckBox = new JCheckBox(DbFrame.frame.res.getString("Enabled"));
        this.onceDateField = new DateFieldWithChooser(this);
        this.onceTimeField = new TimeField();
        this.minuteOptions = new String[]{"", "every minute", "every 10 minutes", "every 30 minutes"};
        this.minuteComboBox = new JComboBox<String>(this.minuteOptions);
        this.hourOptions = new String[]{"", "every hour", "every 6 hours", "every 12 hours"};
        this.hourComboBox = new JComboBox<String>(this.hourOptions);
        this.dayOptions = new String[]{"", "every day", "every 10 days"};
        this.dayComboBox = new JComboBox<String>(this.dayOptions);
        this.monthOptions = new String[]{"", "every month", "every 2 months"};
        this.monthComboBox = new JComboBox<String>(this.monthOptions);
        this.dayCheckBox = new JCheckBox[7];
        this.startTimeField = new TimeField();
        this.startDateField = new DateFieldWithChooser(this);
        this.noEndDateButton = new JRadioButton(DbFrame.frame.res.getString("No_End_Date"));
        this.endDateButton = new JRadioButton(DbFrame.frame.res.getString("End_Date"));
        this.endDateField = new DateFieldWithChooser(this);
        this.endTimeField = new TimeField();
        this.descriptionArea = new JTextArea(1, 20);
        this.validateButton = new JButton(DbFrame.frame.res.getString("Validate"));
        this.nowButton = new JRadioButton("Now()");
        this.specifyButton = new JRadioButton("Date/Time:");
        this.okButton = new JButton(DbFrame.frame.res.getString("OK"));
        this.cancelButton = new JButton(DbFrame.frame.res.getString("Cancel"));
        this.helpButton = new JButton(DbFrame.frame.res.getString("Help"));
        this.taskName = null;
        this.taskOwner = null;
        this.data = null;
        this.setSize(600, 640);
        this.setLocationRelativeTo(parent);
        this.taskName = taskName;
        this.taskOwner = taskOwner;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        int row = 0;
        gbc.gridx = 0;
        gbc.gridy = row;
        panel.add((Component)new JLabel(DbFrame.frame.res.getString("Plan_Name")), gbc);
        gbc.gridx = 1;
        gbc.gridy = row++;
        gbc.gridwidth = 4;
        panel.add((Component)this.nameField, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = row;
        panel.add((Component)new JLabel(DbFrame.frame.res.getString("Plan_Type")), gbc);
        gbc.gridx = 1;
        gbc.gridy = row;
        panel.add(this.planTypeComboBox, gbc);
        gbc.gridx = 2;
        gbc.gridy = row++;
        panel.add((Component)this.enabledCheckBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = row++;
        gbc.gridwidth = 5;
        panel.add((Component)this.getTextSeparator(DbFrame.frame.res.getString("Execute_Once")), gbc);
        gbc.gridwidth = 1;
        ButtonGroup group0 = new ButtonGroup();
        group0.add(this.nowButton);
        group0.add(this.specifyButton);
        gbc.gridx = 0;
        gbc.gridy = row;
        panel.add((Component)this.nowButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = row;
        panel.add((Component)this.specifyButton, gbc);
        gbc.gridx = 2;
        gbc.gridy = row;
        panel.add((Component)this.onceDateField, gbc);
        gbc.gridx = 3;
        gbc.gridy = row++;
        panel.add((Component)this.onceTimeField, gbc);
        gbc.gridx = 0;
        gbc.gridy = row++;
        gbc.gridwidth = 5;
        panel.add((Component)this.getTextSeparator(DbFrame.frame.res.getString("Frequency")), gbc);
        gbc.gridwidth = 1;
        int col = 0;
        int row0 = row;
        gbc.gridx = col;
        gbc.gridy = row0;
        panel.add((Component)new JLabel("Minute:"), gbc);
        gbc.gridx = col + 1;
        gbc.gridy = row0;
        panel.add(this.minuteComboBox, gbc);
        this.minuteComboBox.setEditor(new ComboEditorField());
        this.minuteComboBox.setEditable(true);
        gbc.gridx = col + 2;
        gbc.gridy = row0++;
        gbc.gridwidth = 3;
        panel.add((Component)new JLabel("Format: * , - / 0-59"), gbc);
        gbc.gridwidth = 1;
        gbc.gridx = col;
        gbc.gridy = row0;
        panel.add((Component)new JLabel("Hour:"), gbc);
        gbc.gridx = col + 1;
        gbc.gridy = row0;
        panel.add(this.hourComboBox, gbc);
        this.hourComboBox.setEditor(new ComboEditorField());
        this.hourComboBox.setEditable(true);
        gbc.gridx = col + 2;
        gbc.gridy = row0++;
        gbc.gridwidth = 3;
        panel.add((Component)new JLabel("Format: * , - / 0-23"), gbc);
        gbc.gridwidth = 1;
        gbc.gridx = col;
        gbc.gridy = row0;
        panel.add((Component)new JLabel("Day:"), gbc);
        gbc.gridx = col + 1;
        gbc.gridy = row0;
        panel.add(this.dayComboBox, gbc);
        this.dayComboBox.setEditor(new ComboEditorField());
        this.dayComboBox.setEditable(true);
        gbc.gridx = col + 2;
        gbc.gridy = row0++;
        gbc.gridwidth = 3;
        panel.add((Component)new JLabel("Format: * , - / 1-31"), gbc);
        gbc.gridwidth = 1;
        gbc.gridx = col;
        gbc.gridy = row0;
        panel.add((Component)new JLabel("Month:"), gbc);
        gbc.gridx = col + 1;
        gbc.gridy = row0;
        panel.add(this.monthComboBox, gbc);
        this.monthComboBox.setEditor(new ComboEditorField());
        this.monthComboBox.setEditable(true);
        gbc.gridx = col + 2;
        gbc.gridy = row0++;
        gbc.gridwidth = 3;
        panel.add((Component)new JLabel("Format: * , - / 1-12 JAN-DEC"), gbc);
        gbc.gridwidth = 1;
        JPanel daysPanel = new JPanel(new GridLayout(1, 7));
        String[] days = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        int i = 0;
        for (String day : days) {
            this.dayCheckBox[i] = new JCheckBox(day);
            this.dayCheckBox[i].setSelected(true);
            daysPanel.add(this.dayCheckBox[i]);
            ++i;
        }
        gbc.gridx = col;
        gbc.gridy = row0;
        gbc.gridwidth = 5;
        panel.add((Component)daysPanel, gbc);
        gbc.gridwidth = 1;
        row = row0 + 1;
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.add((Component)new JLabel(DbFrame.frame.res.getString("Specify")), "West");
        JScrollPane scrollPane = new JScrollPane(this.descriptionArea);
        panel1.add((Component)scrollPane, "Center");
        panel1.add((Component)this.validateButton, "East");
        this.validateButton.addActionListener(new ReflectionAction(this, "validateButton_actionPerformed"));
        ++row;
        gbc.gridx = 0;
        gbc.gridy = row++;
        gbc.gridwidth = 5;
        panel.add((Component)panel1, gbc);
        panel1 = new JPanel(new BorderLayout());
        panel1.add(new JLabel(DbFrame.frame.res.getString("For_Example")));
        gbc.gridx = 0;
        gbc.gridy = row++;
        gbc.gridwidth = 5;
        panel.add((Component)panel1, gbc);
        panel1 = new JPanel(new BorderLayout());
        panel1.add(new JLabel("\u20180 22 * * 1-5\u2019 At 22:00 on every day-of-week from Monday through Friday."));
        gbc.gridx = 0;
        gbc.gridy = row++;
        gbc.gridwidth = 5;
        panel.add((Component)panel1, gbc);
        gbc.gridx = 0;
        gbc.gridy = row++;
        gbc.gridwidth = 5;
        panel.add((Component)this.getTextSeparator(DbFrame.frame.res.getString("Duration")), gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = row;
        panel.add((Component)new JLabel(DbFrame.frame.res.getString("Start_Date")), gbc);
        gbc.gridx = 1;
        gbc.gridy = row++;
        panel.add((Component)this.startDateField, gbc);
        gbc.gridx = 2;
        panel.add((Component)this.startTimeField, gbc);
        gbc.gridx = 0;
        gbc.gridy = row;
        ButtonGroup dateGroup = new ButtonGroup();
        dateGroup.add(this.noEndDateButton);
        dateGroup.add(this.endDateButton);
        gbc.gridx = 0;
        gbc.gridy = row++;
        panel.add((Component)this.endDateButton, gbc);
        gbc.gridx = 1;
        panel.add((Component)this.endDateField, gbc);
        gbc.gridx = 2;
        panel.add((Component)this.endTimeField, gbc);
        gbc.gridx = 0;
        gbc.gridy = row++;
        panel.add((Component)this.noEndDateButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = row++;
        gbc.gridwidth = 0;
        gbc.weighty = 1.0;
        panel.add((Component)new JLabel(), gbc);
        gbc.gridx = 0;
        gbc.gridy = row;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.anchor = 22;
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        panel.add((Component)buttonPanel, gbc);
        gbc.gridwidth = 1;
        this.add(panel);
        this.okButton.addActionListener(new ReflectionAction(this, "okButton_actionPerformed"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanDialog2.this.setVisible(false);
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Help");
            }
        });
        this.minuteComboBox.addActionListener(new ReflectionAction(this, "comboBox_actionPerformed"));
        this.hourComboBox.addActionListener(new ReflectionAction(this, "comboBox_actionPerformed"));
        this.dayComboBox.addActionListener(new ReflectionAction(this, "comboBox_actionPerformed"));
        this.monthComboBox.addActionListener(new ReflectionAction(this, "comboBox_actionPerformed"));
        this.addDocumentListenerToComboBoxEditor(this.minuteComboBox);
        this.addDocumentListenerToComboBoxEditor(this.hourComboBox);
        this.addDocumentListenerToComboBoxEditor(this.dayComboBox);
        this.addDocumentListenerToComboBoxEditor(this.monthComboBox);
        this.minuteComboBox.setSelectedIndex(1);
        this.hourComboBox.setSelectedIndex(1);
        this.dayComboBox.setSelectedIndex(1);
        this.monthComboBox.setSelectedIndex(1);
        this.noEndDateButton.setSelected(true);
        this.nowButton.setSelected(true);
        this.enabledCheckBox.setSelected(true);
        this.planTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanDialog2.this.setDisplay();
                PlanDialog2.this.updateDescriptionArea();
            }
        });
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PlanDialog2.this.setDisplay();
            }
        };
        this.noEndDateButton.addItemListener(listener);
        this.nowButton.addItemListener(listener);
        this.okButton.setEnabled(!this.nameField.getText().trim().isEmpty());
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            void updateButtonState() {
                PlanDialog2.this.okButton.setEnabled(!PlanDialog2.this.nameField.getText().trim().isEmpty());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateButtonState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateButtonState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateButtonState();
            }
        });
        this.onceTimeField.setTimeToNow(5);
        this.setDisplay();
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public void validateButton_actionPerformed(ActionEvent e) {
        String cronStr = this.descriptionArea.getText();
        Scheduler scheduler = new Scheduler();
        try {
            scheduler.initTimetable(cronStr);
            GuiUt.showInformationDlg(DbFrame.frame, DbFrame.frame.res.getString("Timetable_string_is_valid"));
        }
        catch (IllegalArgumentException e0) {
            GuiUt.showErrorDlg(DbFrame.frame, DbFrame.frame.res.getString("Timetable_string_is_invalid"), null);
        }
    }

    public void okButton_actionPerformed(ActionEvent e) {
        boolean result;
        StringBuilder cronBuilder = new StringBuilder();
        String startTime = null;
        String endTime = null;
        if (this.planTypeComboBox.getSelectedIndex() == 1) {
            cronBuilder.append("@once");
            startTime = this.nowButton.isSelected() ? "now()" : this.onceDateField.getText() + " " + this.onceTimeField.getText();
        } else {
            cronBuilder.append(this.descriptionArea.getText());
            startTime = this.startDateField.getText() + " " + this.startTimeField.getText();
            if (this.endDateButton.isSelected()) {
                endTime = this.endDateField.getText() + " " + this.endTimeField.getText();
            }
        }
        String query = null;
        query = this.data != null ? "{call SCHEDULE_ALTER( '" + GuiUt.getIDString(this.taskOwner) + "." + GuiUt.getIDString(this.nameField.getText()) + "','" + GuiUt.getIDString(this.taskOwner) + "." + GuiUt.getIDString(this.taskName) + "','" + cronBuilder.toString() + "','" + startTime + "'," : "{call SCHEDULE_CREATE( '" + GuiUt.getIDString(this.taskOwner) + "." + GuiUt.getIDString(this.nameField.getText()) + "','" + GuiUt.getIDString(this.taskOwner) + "." + GuiUt.getIDString(this.taskName) + "','" + cronBuilder.toString() + "','" + startTime + "',";
        query = endTime == null ? query + "NULL)};\n" : query + "'" + endTime + "')};\n";
        if (this.data != null) {
            Boolean enable = (Boolean)this.data.getValueAt(6);
            if (enable.booleanValue() && !this.enabledCheckBox.isSelected()) {
                query = query + "{call SCHEDULE_DISABLE ( '" + GuiUt.getIDString(this.taskOwner) + "." + GuiUt.getIDString(this.nameField.getText()) + "')}";
            } else if (!enable.booleanValue() && this.enabledCheckBox.isSelected()) {
                query = query + "{call SCHEDULE_ENABLE ( '" + GuiUt.getIDString(this.taskOwner) + "." + GuiUt.getIDString(this.nameField.getText()) + "')}";
            }
        } else if (this.enabledCheckBox.isSelected()) {
            query = query + "{call SCHEDULE_ENABLE ( '" + GuiUt.getIDString(this.taskOwner) + "." + GuiUt.getIDString(this.nameField.getText()) + "')}";
        }
        if (query != null && !(result = DatabaseConnection.executeMultiSQL(query))) {
            return;
        }
        if (this.data != null) {
            GuiUt.showInformationDlg(DbFrame.frame, DbFrame.frame.res.getString("Schedule_is_altered_successful"));
        } else {
            GuiUt.showInformationDlg(DbFrame.frame, DbFrame.frame.res.getString("Schedule_is_created_successful"));
        }
        this.cancelButton_actionPerformed(null);
    }

    public void comboBox_actionPerformed(ActionEvent e) {
        JComboBox comboBox = (JComboBox)e.getSource();
        int index = comboBox.getSelectedIndex();
        if (comboBox.getSelectedIndex() <= 0) {
            comboBox.setEditable(true);
        } else {
            comboBox.setEditable(false);
            comboBox.setSelectedIndex(index);
        }
        this.updateDescriptionArea();
    }

    private void updateDescriptionArea() {
        StringBuilder descriptionBuilder = new StringBuilder();
        if (this.planTypeComboBox.getSelectedIndex() == 1) {
            this.descriptionArea.setText("@once");
            return;
        }
        if (this.minuteComboBox.getSelectedIndex() <= 0) {
            descriptionBuilder.append(this.minuteComboBox.getEditor().getItem().toString());
        } else if (this.minuteComboBox.getSelectedIndex() > 0) {
            switch (this.minuteComboBox.getSelectedIndex()) {
                case 1: {
                    descriptionBuilder.append("*");
                    break;
                }
                case 2: {
                    descriptionBuilder.append("*/10");
                    break;
                }
                case 3: {
                    descriptionBuilder.append("*/30");
                }
            }
        }
        descriptionBuilder.append(" ");
        if (this.hourComboBox.getSelectedIndex() <= 0) {
            descriptionBuilder.append(this.hourComboBox.getEditor().getItem().toString());
        } else if (this.hourComboBox.getSelectedIndex() > 0) {
            switch (this.hourComboBox.getSelectedIndex()) {
                case 1: {
                    descriptionBuilder.append("*");
                    break;
                }
                case 2: {
                    descriptionBuilder.append("*/6");
                    break;
                }
                case 3: {
                    descriptionBuilder.append("*/12");
                }
            }
        }
        descriptionBuilder.append(" ");
        if (this.dayComboBox.getSelectedIndex() <= 0) {
            descriptionBuilder.append(this.dayComboBox.getEditor().getItem().toString());
        } else if (this.dayComboBox.getSelectedIndex() > 0) {
            switch (this.dayComboBox.getSelectedIndex()) {
                case 1: {
                    descriptionBuilder.append("*");
                    break;
                }
                case 2: {
                    descriptionBuilder.append("*/10");
                }
            }
        }
        descriptionBuilder.append(" ");
        if (this.monthComboBox.getSelectedIndex() <= 0) {
            descriptionBuilder.append(this.monthComboBox.getEditor().getItem().toString());
        } else if (this.monthComboBox.getSelectedIndex() > 0) {
            switch (this.monthComboBox.getSelectedIndex()) {
                case 1: {
                    descriptionBuilder.append("*");
                    break;
                }
                case 2: {
                    descriptionBuilder.append("*/2");
                }
            }
        }
        descriptionBuilder.append(" ");
        descriptionBuilder.append(this.simplifyDayString());
        this.descriptionArea.setText(descriptionBuilder.toString().trim());
    }

    private String simplifyDayString() {
        boolean allChecked = true;
        StringBuilder dayStr = new StringBuilder();
        for (int i = 0; i < this.dayCheckBox.length; ++i) {
            if (this.dayCheckBox[i].isSelected()) {
                if (dayStr.length() > 0) {
                    dayStr.append(",");
                }
                dayStr.append(i);
                continue;
            }
            allChecked = false;
        }
        if (allChecked) {
            return "0-6";
        }
        return dayStr.toString();
    }

    private void addDocumentListenerToComboBoxEditor(JComboBox<String> comboBox) {
        JTextField editorComponent = (JTextField)comboBox.getEditor().getEditorComponent();
        editorComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PlanDialog2.this.updateDescriptionArea();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PlanDialog2.this.updateDescriptionArea();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PlanDialog2.this.updateDescriptionArea();
            }
        });
    }

    void setDisplay() {
        if (this.planTypeComboBox.getSelectedIndex() == 0) {
            this.nowButton.setEnabled(false);
            this.specifyButton.setEnabled(false);
            this.onceDateField.setEnabled(false);
            this.onceTimeField.setEnabled(false);
            this.startDateField.setEnabled(true);
            this.startTimeField.setEnabled(true);
            this.noEndDateButton.setEnabled(true);
            this.endDateButton.setEnabled(true);
            if (this.noEndDateButton.isSelected()) {
                this.endDateField.setEnabled(false);
                this.endTimeField.setEnabled(false);
            } else {
                this.endDateField.setEnabled(true);
                this.endTimeField.setEnabled(true);
            }
            this.minuteComboBox.setEnabled(true);
            this.hourComboBox.setEnabled(true);
            this.dayComboBox.setEnabled(true);
            this.monthComboBox.setEnabled(true);
            for (JCheckBox checkBox : this.dayCheckBox) {
                checkBox.setEnabled(true);
                checkBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        PlanDialog2.this.updateDescriptionArea();
                    }
                });
            }
            this.descriptionArea.setEnabled(true);
            this.descriptionArea.setEditable(true);
        } else {
            this.nowButton.setEnabled(true);
            this.specifyButton.setEnabled(true);
            if (this.nowButton.isSelected()) {
                this.onceDateField.setEnabled(false);
                this.onceTimeField.setEnabled(false);
            } else {
                this.onceDateField.setEnabled(true);
                this.onceTimeField.setEnabled(true);
            }
            this.startDateField.setEnabled(false);
            this.noEndDateButton.setEnabled(false);
            this.endDateButton.setEnabled(false);
            this.endDateField.setEnabled(false);
            this.descriptionArea.setEditable(false);
            this.descriptionArea.setEditable(false);
            this.minuteComboBox.setEnabled(false);
            this.hourComboBox.setEnabled(false);
            this.dayComboBox.setEnabled(false);
            this.monthComboBox.setEnabled(false);
            for (JCheckBox checkBox : this.dayCheckBox) {
                checkBox.setEnabled(false);
            }
            this.startTimeField.setEnabled(false);
            this.endTimeField.setEnabled(false);
        }
    }

    private JPanel getSeparator(JComponent comp) {
        JPanel separatorPanel = new JPanel(new GridBagLayout());
        GridBagConstraints separatorGbc = new GridBagConstraints();
        separatorGbc.fill = 2;
        separatorGbc.insets = new Insets(0, 0, 0, 0);
        JSeparator separator = new JSeparator();
        separatorGbc.gridx = 0;
        separatorGbc.gridy = 0;
        separatorPanel.add((Component)comp, separatorGbc);
        separatorGbc.gridx = 2;
        separatorGbc.gridy = 0;
        separatorGbc.weightx = 1.0;
        separatorPanel.add((Component)separator, separatorGbc);
        return separatorPanel;
    }

    private JPanel getTextSeparator(String text) {
        JLabel separatorLabel = new JLabel(text);
        return this.getSeparator(separatorLabel);
    }
}

