/*
 * Decompiled with CFR 0.152.
 */
package dbatool.TDE;

import dbatool.DbFrame;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;

public class AddTDEDlg
extends JDialog {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    DbaButton OK_Button = new DbaButton(new Dimension(100, 24), this.res.getString("OK"), 'O', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "OK_Button_actionPerformed"));
    DbaButton Cancel_Button = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "Cancel_Button_actionPerformed"));

    public AddTDEDlg(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public AddTDEDlg(Frame frame) {
        super(frame);
        this.setModal(true);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DefaultMutableTreeNode root = this.getTree();
        JTree tree = new JTree(root);
        tree.setCellRenderer(new MyTreeCellRenderer());
        tree.setCellEditor(new MyTreeCellEditor(tree, (DefaultTreeCellRenderer)tree.getCellRenderer()));
        tree.setEditable(true);
        this.add((Component)new JScrollPane(tree), "Center");
        JPanel panel0 = new JPanel(new FlowLayout(2));
        panel0.add(this.OK_Button);
        panel0.add(this.Cancel_Button);
        this.add((Component)panel0, "South");
        this.setDefaultCloseOperation(2);
        this.setSize(400, 400);
        this.setPreferredSize(this.getSize());
    }

    private DefaultMutableTreeNode getTree() {
        DefaultMutableTreeNode root = null;
        TableNode last = null;
        String tableName = null;
        String columnName = null;
        int reserve5 = 0;
        boolean isEncrypted = false;
        try {
            root = new DefaultMutableTreeNode("Root");
            Connection conn = DbFrame.conn_DatabaseConnection.getDbConnection();
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select col.TABLE_OWNER, col.TABLE_NAME, COLUMN_NAME, col.RESERVE5 FROM SYSTEM.SYSCOLUMN col, SYSTEM.SYSTABLE tb where col.TABLE_OWNER != 'SYSTEM' AND col.TABLE_OWNER = tb.TABLE_OWNER AND col.TABLE_NAME = tb.TABLE_NAME AND tb.TABLE_TYPE = 'TABLE' ORDER BY col.TABLE_OWNER, col.TABLE_NAME, col.COLUMN_ORDER");
            while (rs.next()) {
                String tableOwner = rs.getString(1).trim();
                tableName = rs.getString(2).trim();
                columnName = rs.getString(3).trim();
                reserve5 = rs.getInt(4);
                boolean bl = isEncrypted = (reserve5 & 8) != 0;
                if (last == null || last.tableOwner.compareTo(tableOwner) != 0 || last.tableName.compareTo(tableName) != 0) {
                    last = new TableNode(tableOwner, tableName);
                    root.add(last);
                }
                last.add(new ColumnNode(columnName, isEncrypted));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return root;
    }

    class ColumnNode
    extends DefaultMutableTreeNode {
        String columnName = null;
        boolean isEncrypted = false;

        ColumnNode(String columnName, boolean isEncrypted) {
            this.columnName = columnName;
            this.isEncrypted = isEncrypted;
        }

        @Override
        public String toString() {
            return this.columnName;
        }
    }

    class TableNode
    extends DefaultMutableTreeNode {
        String tableOwner;
        String tableName;

        TableNode(String tableOwner, String tableName) {
            this.tableOwner = tableOwner;
            this.tableName = tableName;
        }

        @Override
        public String toString() {
            return this.tableOwner + "." + this.tableName;
        }
    }

    private class MyTreeCellEditor
    extends DefaultTreeCellEditor {
        private JCheckBox checkBox;

        public MyTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
            this.checkBox = new JCheckBox();
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            if (value instanceof ColumnNode) {
                ColumnNode node = (ColumnNode)value;
                this.checkBox.setText(node.columnName);
                this.checkBox.setSelected(node.isEncrypted);
                return this.checkBox;
            }
            return super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        }
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private JCheckBox checkBox = new JCheckBox();

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component renderer = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof ColumnNode) {
                ColumnNode node = (ColumnNode)value;
                this.checkBox.setText(node.columnName);
                this.checkBox.setSelected(node.isEncrypted);
                return this.checkBox;
            }
            return renderer;
        }
    }
}

