/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Monitor;

import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.HelpButton;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PrioritySettingDlg
extends JDialog {
    public static final int LEVEL_COUNT = 5;
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private DbaButton okButton = new DbaButton(new Dimension(100, 24), this.res.getString("OK"), 'O', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "okButtonActionPerformed"));
    private DbaButton cancelButton = new DbaButton(new Dimension(100, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private HelpButton helpButton = new HelpButton();
    private Frame frame = null;
    private String connectionID = null;
    private int priorityLevel = 3;
    private ArrayList<JRadioButton> priorityList = new ArrayList();
    private ArrayList<String> priorityNameList = new ArrayList();

    public PrioritySettingDlg(Frame frame, String connectionID, int priorityLevel) {
        super(frame, true);
        this.frame = frame;
        this.connectionID = connectionID;
        this.priorityLevel = priorityLevel;
        this.init();
        this.setPreferredSize(new Dimension(400, 200));
        this.pack();
        GuiUt.setCenterLocation(frame, this);
        this.setVisible(true);
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            this.okButton.requestFocus();
        }
    }

    private void init() {
        this.setName("PrioritySettingDialog");
        this.okButton.setName("OKButton");
        this.cancelButton.setName("CancelButton");
        this.priorityNameList.add(this.res.getString("Lowest"));
        this.priorityNameList.add(this.res.getString("Lower"));
        this.priorityNameList.add(this.res.getString("Normal"));
        this.priorityNameList.add(this.res.getString("Higher"));
        this.priorityNameList.add(this.res.getString("Highest"));
        this.setTitle(this.res.getString("Priority_Setting"));
        this.setDefaultCloseOperation(0);
        WindowAdapter closeListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PrioritySettingDlg.this.cancelButtonActionPerformed(null);
            }
        };
        this.addWindowListener(closeListener);
        DbFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "PrioritySettingDialog", null);
        JRadioButton cpuPriorityRadioButton = null;
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < 5; ++i) {
            cpuPriorityRadioButton = new JRadioButton(this.priorityNameList.get(i));
            cpuPriorityRadioButton.setName("Level" + (i + 1));
            this.priorityList.add(cpuPriorityRadioButton);
            group.add(cpuPriorityRadioButton);
        }
        JPanel contentPanel = new JPanel(new GridLayout(5, 1));
        contentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Priority"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        for (int i = 0; i < 5; ++i) {
            JRadioButton tmpRB = this.priorityList.get(i);
            contentPanel.add(tmpRB);
        }
        JPanel emptyPanel = new JPanel();
        JPanel emptyPanel1 = new JPanel();
        JPanel upPanel = new JPanel(new BorderLayout());
        upPanel.add((Component)emptyPanel, "West");
        upPanel.add((Component)contentPanel, "Center");
        upPanel.add((Component)emptyPanel1, "East");
        Container container = this.getContentPane();
        container.add(upPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        container.add((Component)buttonPanel, "South");
        this.initPriorityLevel();
    }

    private void initPriorityLevel() {
        for (int i = 0; i < 5; ++i) {
            if (i + 1 == this.priorityLevel) {
                this.priorityList.get(i).setSelected(true);
                continue;
            }
            this.priorityList.get(i).setSelected(false);
        }
    }

    public void okButtonActionPerformed(ActionEvent e) {
        int level = -1;
        for (int i = 0; i < 5; ++i) {
            if (!this.priorityList.get(i).isSelected()) continue;
            level = i + 1;
        }
        String sql = "call SETPRIORITY(" + this.connectionID + ", " + level + ")";
        boolean isOK = DatabaseConnection.executeSQL(DbFrame.frame, sql);
        if (isOK) {
            GuiUt.showSuccessDlg(this, this.res.getString("Set_CPU_priority_successfully"), null);
        }
        this.setVisible(false);
        this.dispose();
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }
}

