/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Monitor;

import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.tableModel.BasicInfoTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.alarm.Alarm2;
import dbaut.alarm.Sleeper;
import dbaut.comp.DbaPanel;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;

public class MonitorInfo
extends DbaTabbedPane
implements Sleeper {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.MonitorRes", LocaleManager.getLocale());
    private BasicInfoTableModel model = new BasicInfoTableModel();
    private Alarm2 clock = null;
    private static boolean isRefreshing = false;

    public MonitorInfo() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("DatabaseMonitorTabbedPane");
        JTable table = new JTable(this.model);
        table.setName("DatabaseMonitorTable");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "monitor.info");
        jPanel1.setLayout(new BorderLayout());
        this.add((Component)jPanel1, this.res.getTitle("Database_Monitor"));
        jPanel1.add((Component)table, "North");
        table.getTableHeader().setReorderingAllowed(false);
        boolean result = this.getMonitorInfo();
        if (result) {
            this.clock = new Alarm2();
            this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
        }
    }

    private synchronized boolean getMonitorInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.model.removeAll();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "SELECT COUNT(USER_NAME) FROM SYSUSER";
            rs = stmt.executeQuery(query);
            int total = 0;
            while (rs.next()) {
                total = rs.getInt(1);
            }
            rs.close();
            if (DbFrame.conn_DatabaseConnection.isSecure) {
                query = "SELECT COUNT(user.USER_NAME) FROM SYSUSER user, SYSAUTHUSER authuser WHERE authuser.USER_NAME = user.USER_NAME ";
                rs = stmt.executeQuery(query);
                int user = 0;
                while (rs.next()) {
                    user = rs.getInt(1);
                }
                rs.close();
                Object[] one_row = new Object[]{new String(this.res.getString("Number_of_users")), new String("" + total)};
                this.model.addValue(one_row);
                one_row = new Object[]{new String(this.res.getString("Number_of_demon")), new String("" + (total - user))};
                this.model.addValue(one_row);
                one_row = new Object[]{new String(this.res.getString("Number_of_users1")), new String("" + user)};
                this.model.addValue(one_row);
            } else {
                Object[] one_row = new Object[]{new String(this.res.getString("Number_of_users")), new String("" + total)};
                this.model.addValue(one_row);
            }
            stmt.close();
            String cpuSql = "call GETCPUNUMBER(?)";
            Connection con = DbFrame.conn_DatabaseConnection.getDbConnection();
            CallableStatement cstmt = con.prepareCall(cpuSql);
            cstmt.registerOutParameter(1, 4);
            cstmt.execute();
            int cpunumbers = cstmt.getInt(1);
            cstmt.close();
            Object[] one_row = new Object[]{new String(this.res.getString("Number_of_cpu")), new Integer(cpunumbers)};
            this.model.addValue(one_row);
            this.model.fireTableChanged(new TableModelEvent(this.model));
            return true;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
            return false;
        }
    }

    @Override
    public synchronized void wakeUp() {
        if (isRefreshing) {
            this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
            return;
        }
        if (this.isShowing() && DbFrame.frame.px.getAutoRefresh()) {
            isRefreshing = true;
            if (this.getMonitorInfo()) {
                this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
            }
            isRefreshing = false;
        }
    }
}

