/*
 * Decompiled with CFR 0.152.
 */
package dbatool;

import dbatool.DbFrame;
import dbatool.TreeNode.DBATreeNode;
import dbatool.TreeNode.DatabaseTreeNode;
import dbatool.TreeNode.TableTreeNode;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DbaTree
extends dbaut.comp.DbaTree {
    private static final long serialVersionUID = -4774351499468741339L;
    private String lastSearch = "";

    public DbaTree(DefaultTreeModel model) {
        super(model);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = DbaTree.this.getClosestRowForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    boolean outside;
                    Rectangle bounds = DbaTree.this.getRowBounds(selRow);
                    boolean bl = outside = e.getX() < bounds.x || e.getX() > bounds.x + bounds.width || e.getY() < bounds.y || e.getY() >= bounds.y + bounds.height;
                    if (outside) {
                        DbaTree.this.setSelectionRow(selRow);
                        System.out.println("manual selection: " + selRow);
                        if (e.getClickCount() == 2) {
                            if (DbaTree.this.isCollapsed(selRow)) {
                                DbaTree.this.expandRow(selRow);
                            } else if (DbaTree.this.isExpanded(selRow)) {
                                DbaTree.this.collapseRow(selRow);
                            }
                        }
                    } else {
                        System.out.println("auto selection: " + selRow);
                    }
                }
            }
        };
        this.addMouseListener(ml);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                Object selected;
                if (evt.getKeyCode() == 127 && (selected = DbaTree.this.getLastSelectedPathComponent()) instanceof TableTreeNode) {
                    if (DbFrame.conn_DatabaseConnection.dropTable((TableTreeNode)selected)) {
                        DbFrame.frame.treePanel.afterDropObject(1);
                    }
                }
            }
        });
    }

    @Override
    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        int max = this.getRowCount();
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (startingRow < 0 || startingRow >= max) {
            throw new IllegalArgumentException();
        }
        prefix = prefix.toUpperCase();
        int increment = bias == Position.Bias.Forward ? 1 : -1;
        int row = startingRow;
        Object selected = this.getLastSelectedPathComponent();
        if (selected instanceof DatabaseTreeNode) {
            Enumeration<TreeNode> children = ((DatabaseTreeNode)selected).children();
            DefaultMutableTreeNode child = null;
            while (children.hasMoreElements()) {
                child = (DefaultMutableTreeNode)children.nextElement();
                String text = this.convertValueToText(child, this.isRowSelected(row), this.isExpanded(row), true, row, false);
                if (!text.toUpperCase().contains(prefix)) continue;
                return new TreePath(child.getPath());
            }
        } else if (selected instanceof DBATreeNode) {
            DefaultMutableTreeNode next = null;
            next = prefix.contains(this.lastSearch) && prefix.compareTo(this.lastSearch) > 0 ? (DBATreeNode)selected : ((DBATreeNode)selected).getNextSibling();
            boolean startover = false;
            while (!startover || next != selected) {
                String text;
                if (!startover && next == null) {
                    startover = true;
                    next = (DefaultMutableTreeNode)((DBATreeNode)selected).getParent().getChildAt(0);
                }
                if ((text = this.convertValueToText(next, this.isRowSelected(row), this.isExpanded(row), true, row, false)).toUpperCase().contains(prefix)) {
                    this.lastSearch = prefix;
                    return new TreePath(next.getPath());
                }
                next = ((DBATreeNode)next).getNextSibling();
            }
        } else {
            do {
                TreePath path;
                String text;
                if (!(text = this.convertValueToText((path = this.getPathForRow(row)).getLastPathComponent(), this.isRowSelected(row), this.isExpanded(row), true, row, false)).toUpperCase().contains(prefix)) continue;
                return path;
            } while ((row = (row + increment + max) % max) != startingRow);
        }
        return null;
    }
}

