/*
 * Decompiled with CFR 0.152.
 */
package ServerMgr;

import ServerMgr.DatabaseConnection;
import ServerMgr.FileTableModel;
import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import ServerMgr.UserPasswordDlg;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.borland.jbcl.layout.XYConstraints;
import com.borland.jbcl.layout.XYLayout;
import com.syscom.dm.svrmgr.sca.DefaultSvrmgrAuthority;
import dbaut.DbaObject;
import dbaut.DbaUtDef;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.String_array;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBox;
import dbaut.resource.DBAImageResource;
import dbaut.winlib;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

public class DeleteDatabaseDlg
extends JDialog {
    private SteppedComboBox Database_Name = new SteppedComboBox();
    private FileTableModel model = new FileTableModel();
    private JTable table = new JTable(this.model);
    private String fileseparator = System.getProperty("file.separator");
    private String dbname = "";
    private String svr_address = null;
    private DatabaseConnection connection = null;
    private Integer svr_portnum = null;
    private int fileseparator_len = this.fileseparator.length();
    private boolean isTerminalServer = false;
    private boolean isServerOn = false;
    private DbaButton Delete_Button;
    private JCheckBox Delete_FileObjectDir;
    private JLabel FileObjectDir;

    public DeleteDatabaseDlg(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.Delete_Button = new DbaButton(SmFrame.frame.res.getString("Delete"), 'D', new ReflectionAction(this, "Delete_Button_actionPerformed"));
        this.Delete_FileObjectDir = new JCheckBox();
        this.FileObjectDir = new JLabel();
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DeleteDatabaseDlg(Frame frame) {
        super(frame);
        this.Delete_Button = new DbaButton(SmFrame.frame.res.getString("Delete"), 'D', new ReflectionAction(this, "Delete_Button_actionPerformed"));
        this.Delete_FileObjectDir = new JCheckBox();
        this.FileObjectDir = new JLabel();
        this.setModal(true);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setName("DeleteDatabaseDialog");
        this.Database_Name.setName("DatabaseNameComboBox");
        float fvm = SmFrame.getJVMVersion();
        System.out.println("fvm = " + fvm);
        if ((double)fvm > 1.3) {
            this.Database_Name.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        } else {
            this.Database_Name.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        }
        DbaButton Cancel_Button = new DbaButton(SmFrame.frame.res.getString("Cancel"), 'C', new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        JPanel panel1 = new JPanel((LayoutManager)new VerticalFlowLayout());
        JPanel jPanel1 = new JPanel((LayoutManager)new XYLayout());
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1));
        SmHelpButton help_Button = new SmHelpButton(new Dimension(71, 24));
        JLabel jLabel1 = new JLabel();
        SmFrame.frame.enableDialogHelp(this.getRootPane(), help_Button, "DeleteDatabaseDlgHelpIDInformation", null);
        this.setTitle(SmFrame.frame.res.getString("Delete_Database"));
        jLabel1.setText(SmFrame.frame.res.getString("Database_Name"));
        this.Database_Name.setPreferredSize(new Dimension(128, 24));
        this.Database_Name.addActionListener(new ReflectionAction(this, "Database_Name_actionPerformed"));
        this.Delete_Button.setName("DeleteButton");
        this.Delete_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/delete.gif"));
        Cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        jScrollPane1.setPreferredSize(new Dimension(410, 200));
        this.Delete_FileObjectDir.setPreferredSize(new Dimension(170, 24));
        this.Delete_FileObjectDir.setSelected(true);
        this.Delete_FileObjectDir.setText(SmFrame.frame.res.getString("Remove_File_Object"));
        this.getContentPane().add(panel1);
        jPanel1.add((Component)jLabel1, new XYConstraints(0, 0, 120, 20));
        jPanel1.add((Component)this.Database_Name, new XYConstraints(130, 0, 200, -1));
        jPanel1.add((Component)jPanel3, new XYConstraints(340, 0, 80, 60));
        jPanel3.add((Component)this.Delete_Button, null);
        jPanel3.add((Component)Cancel_Button, null);
        jPanel3.add((Component)help_Button, null);
        jPanel1.add((Component)this.Delete_FileObjectDir, new XYConstraints(0, 21, 310, -1));
        jPanel1.add((Component)this.FileObjectDir, new XYConstraints(18, 43, 296, 18));
        panel1.add((Component)jPanel1, null);
        panel1.add((Component)jScrollPane1, null);
        jScrollPane1.getViewport().add((Component)this.table, null);
        Vector<String> dbnames = JdmConfig.getDatabaseNames("dmconfig.ini", true);
        dbnames.insertElementAt(new String("  "), 0);
        DefaultComboBoxModel<String> comboModel = new DefaultComboBoxModel<String>(dbnames);
        this.Database_Name.setModel((ComboBoxModel)comboModel);
        this.initColumnSizes(this.table);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.FileObjectDir.setText("");
        this.Delete_Button.setEnabled(false);
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(220);
    }

    private String getFoDir(String name) {
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", name, "r");
        if (rc != DbaUtDef.RTN_OK) {
            System.out.println("Open dmconfig ini error " + rc);
            return null;
        }
        String fodir = (String)config.getPara("DB_FODIR", 4096);
        config.fileClose();
        return "( " + fodir + " )";
    }

    private void getDataFileBackupInfo(DatabaseConnection connection) {
        Statement stmt = null;
        try {
            stmt = connection.dbconn.createStatement();
            String query = "select FILE_NAME, GETFILENAME(FILE_NAME) from SYSTEM.SYSFILE where FILE_NAME != 'SYSJNL'";
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                Object[] one_row = new Object[2];
                String temp = rs.getString(1);
                one_row[0] = rs.wasNull() ? "" : temp.trim();
                temp = rs.getString(2);
                String physical_name = rs.wasNull() ? "" : temp.trim();
                one_row[1] = physical_name;
                this.model.addValue(one_row);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this, null, sqle);
            DbaObject.close(stmt);
        }
    }

    private void getJournalFileBackupInfo(DatabaseConnection connection) {
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", this.dbname, "r");
        if (rc != 0) {
            return;
        }
        String db_dir = JdmConfig.getDBDir(this.dbname);
        String_array files = (String_array)config.getPara("DB_JNFIL", 53504);
        config.fileClose();
        for (int i = 0; i < files.size(); ++i) {
            String str = files.content[i];
            if (str.length() == 0) continue;
            int g = str.lastIndexOf(this.fileseparator);
            Object[] one_row = new Object[]{"SYSJNL", g >= 0 ? str : db_dir + this.fileseparator + str};
            this.model.addValue(one_row);
        }
    }

    public void Database_Name_actionPerformed(ActionEvent e) {
        ((SteppedComboBox)e.getSource()).hidePopup();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.FileObjectDir.setText("");
        String name = (String)this.Database_Name.getSelectedItem();
        this.model.removeAll();
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.Delete_Button.setEnabled(false);
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
        this.dbname = name;
        if (name.equals("  ")) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        JdmConfig config = new JdmConfig();
        this.isTerminalServer = config.isTerminalServer(this.dbname);
        System.out.println("isTerminalServer = " + this.isTerminalServer);
        int rc = config.fileOpen("dmconfig.ini", this.dbname, "r");
        if (rc != 0) {
            System.out.println("can't open dmconfig.ini");
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        String svr_address = (String)config.getPara("DB_SVADR", 4096);
        Integer svr_portnum = (Integer)config.getPara("DB_PTNUM", 8192);
        String fodir = (String)config.getPara("DB_FODIR", 4096);
        config.fileClose();
        UserPasswordDlg dlg = null;
        dlg = SmFrame.isWindows() ? new UserPasswordDlg((Dialog)this, name, "DeleteDatabaseDlgHelpIDInformation") : new UserPasswordDlg(this, "", true, name, "DeleteDatabaseDlgHelpIDInformation");
        GuiUt.setCenterLocation(this, dlg);
        dlg.show();
        if (!dlg.getResult()) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (!this.isTerminalServer) {
            try {
                this.isServerOn = DatabaseConnection.isServerOn(name, dlg.getUserName(), dlg.getPassword());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            System.out.println("isServerOn = " + this.isServerOn);
            if (!this.isServerOn) {
                this.setTerminalServer(true, name, null, null);
            }
        }
        this.connection = new DatabaseConnection(name, dlg.getUserName(), dlg.getPassword(), this);
        if (this.connection == null || !this.connection.result) {
            if (!this.isTerminalServer && !this.isServerOn) {
                this.setTerminalServer(false, name, svr_address, svr_portnum);
            }
            this.connection = null;
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        DefaultSvrmgrAuthority authority = new DefaultSvrmgrAuthority(this.connection);
        if (!authority.isAboveDba()) {
            authority.errorIsNotDBA(this);
            this.connection.disconnect();
            this.connection = null;
            if (!this.isTerminalServer && !this.isServerOn) {
                this.setTerminalServer(false, name, svr_address, svr_portnum);
            }
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (this.connection.getFileVersion() < 3.6f) {
            GuiUt.showErrorDlg(this, SmFrame.frame.res.getString("file_version_is_too_old"), "");
            this.connection.disconnect();
            this.connection = null;
            if (!this.isTerminalServer && !this.isServerOn) {
                this.setTerminalServer(false, name, svr_address, svr_portnum);
            }
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        this.getDataFileBackupInfo(this.connection);
        this.getJournalFileBackupInfo(this.connection);
        if (fodir == null || fodir.length() == 0) {
            this.Delete_FileObjectDir.setSelected(false);
            this.Delete_FileObjectDir.setEnabled(false);
        } else {
            File fo = new File(fodir);
            if (fo.exists()) {
                this.Delete_FileObjectDir.setSelected(true);
                this.Delete_FileObjectDir.setEnabled(true);
                this.FileObjectDir.setText(fodir);
            } else {
                this.Delete_FileObjectDir.setSelected(false);
                this.Delete_FileObjectDir.setEnabled(false);
                this.FileObjectDir.setText(fodir);
            }
        }
        if (!this.isTerminalServer && !this.isServerOn) {
            this.setTerminalServer(false, name, svr_address, svr_portnum);
        }
        if (!this.isServerOn) {
            this.connection.disconnect();
            this.connection = null;
        }
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.Delete_Button.setEnabled(true);
        this.Database_Name.hidePopup();
        this.pack();
        this.setResizable(false);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void setTerminalServer(boolean flag, String dbname, String svr_address, Integer svr_portnum) {
        JdmConfig config = new JdmConfig();
        if (flag) {
            System.out.println("set terminal server on for " + dbname);
            int rc = config.fileOpen("dmconfig.ini", dbname, "r+");
            if (rc != 0) {
                return;
            }
            config.procDelete("DB_SVADR", 0);
            config.procDelete("DB_PTNUM", 0);
            config.fileClose();
        } else {
            System.out.println("set terminal server off for " + dbname);
            int rc = config.fileOpen("dmconfig.ini", dbname, "r+");
            if (rc != 0) {
                return;
            }
            config.insertPara("DB_SVADR", svr_address, 4096);
            config.insertPara("DB_PTNUM", svr_portnum, 8192);
            config.fileClose();
        }
    }

    public void Delete_Button_actionPerformed(ActionEvent e) {
        winlib wlib;
        boolean result;
        JdmConfig config;
        int rc;
        if (this.dbname == null || this.dbname.length() == 0) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        String str1 = SmFrame.frame.res.getString("Do_you_want_to_delete_database");
        String str2 = GuiUt.mapStringForProperty(str1, this.dbname);
        int reply = GuiUt.showOptionDlg(this, SmFrame.frame.res.getString("Delete_Database"), str2 + " ?");
        if (reply != 0) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (this.isServerOn && this.connection != null) {
            System.setProperty("DM_DISCONNECT_MODE", "TERMINATE_DB");
            boolean b = this.connection.disconnect();
            this.connection = null;
            System.setProperty("DM_DISCONNECT_MODE", "DISCONNECT_DB");
            if (!b) {
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
        }
        String filename = "";
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            filename = (String)this.model.getValueAt(i, 1);
            File file = new File(filename);
            boolean b = file.delete();
            if (b) continue;
            String strx = SmFrame.frame.res.getString("Could_not_delete_file");
            String stry = GuiUt.mapStringForProperty(strx, file.getName());
            GuiUt.showErrorDlg(this, stry + " !", null);
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (this.Delete_FileObjectDir.isSelected()) {
            filename = this.FileObjectDir.getText();
            File file = new File(filename);
            file.delete();
        }
        if ((rc = (config = new JdmConfig()).fileOpen("dmconfig.ini", this.dbname, "r+")) != 0) {
            System.out.println("Error open dmconfig.ini via JdmConfig.");
            config.fileClose();
        } else {
            String tmpDir = (String)config.getPara("DB_TMPDIR", 4096);
            File file = new File(tmpDir);
            file.delete();
            config.procDelete("", 0);
            config.fileClose();
        }
        if (SmFrame.isWindows() && !(result = (wlib = new winlib()).removeRegistryKey(-2147483646L, this.dbname))) {
            result = wlib.removeRegistryKey(-2147483647L, this.dbname);
        }
        GuiUt.showInformationDlg(this, SmFrame.frame.res.getString("Delete_Database_Successfully"));
        this.setVisible(false);
        this.dispose();
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
        this.setVisible(false);
        this.dispose();
        this.setCursor(Cursor.getDefaultCursor());
    }

    void this_keyReleased(KeyEvent e) {
        if (this.Delete_Button.isEnabled()) {
            this.Delete_Button_actionPerformed(null);
        }
    }
}

