/*
 * Decompiled with CFR 0.152.
 */
package DmEditor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class Passwd {
    private File file;
    private BufferedReader rdr;
    public String pw_name;
    public String pw_passwd;
    public int pw_uid;
    public int pw_gid;
    public String pw_gecos;
    public String pw_dir;
    public String pw_shell;

    public boolean getpwent() throws IOException {
        String line;
        if (this.rdr == null) {
            this.setpwent();
        }
        if ((line = this.rdr.readLine()) == null) {
            return false;
        }
        StringTokenizer tok = new StringTokenizer(line, ":", true);
        String[] s = new String[7];
        String preStr = "";
        int i = 0;
        while (tok.hasMoreTokens()) {
            String ss = tok.nextToken();
            if (ss.equals(":") && preStr.equals(":")) {
                preStr = ss;
                s[i] = "";
                ++i;
                continue;
            }
            if (ss.equals(":") && !preStr.equals(":")) {
                preStr = ss;
                continue;
            }
            preStr = ss;
            s[i] = ss;
            ++i;
        }
        this.pw_name = s[0];
        this.pw_passwd = s[1];
        this.pw_uid = Passwd.parseNum(s[2]);
        this.pw_gid = Passwd.parseNum(s[3]);
        this.pw_gecos = s[4];
        this.pw_dir = s[5];
        this.pw_shell = s[6];
        return true;
    }

    private static int parseNum(String s) {
        if (s == null) {
            return -1;
        }
        try {
            return Integer.parseInt(s.trim());
        }
        catch (NumberFormatException n) {
            return -1;
        }
    }

    public Passwd(String path) {
        this.file = new File(path);
    }

    public Passwd() {
        this("/etc/passwd");
    }

    public void setpwent() throws IOException {
        if (this.rdr != null) {
            this.rdr.close();
        }
        this.rdr = new BufferedReader(new FileReader(this.file));
    }

    public boolean getpwuid(int uid) throws IOException {
        this.setpwent();
        while (this.getpwent()) {
            if (this.pw_uid != uid) continue;
            return true;
        }
        return false;
    }

    public boolean getpwnam(String nam) throws IOException {
        this.setpwent();
        while (this.getpwent()) {
            if (this.pw_name == null || !this.pw_name.equals(nam)) continue;
            return true;
        }
        return false;
    }

    public boolean putpwent() throws IOException {
        throw new RuntimeException("Not Implemented");
    }

    public void endpwent() {
        if (this.rdr != null) {
            try {
                this.rdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

