/*
 * Decompiled with CFR 0.152.
 */
package DmEditor;

import DmEditor.AllSectionInfo.DetailInfo;
import DmEditor.AllSectionInfo.DetailParent;
import DmEditor.DatabasePopupMenu;
import DmEditor.DmConfigMenuBar;
import DmEditor.DmConfigPopupMenu;
import DmEditor.Preferences.Preferences;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.comp.DbaPanel;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleChangeListener;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.resource.HelpResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.help.DefaultHelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class MainFrame
extends JFrame
implements LocaleChangeListener {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", LocaleManager.getLocale());
    private JScrollPane jScrollPane1 = new JScrollPane();
    public JScrollPane jScrollPane2 = new JScrollPane();
    public JTree tree = null;
    public static MainFrame frame = null;
    public DefaultMutableTreeNode dmconfigNode = null;
    private DefaultMutableTreeNode sectionNode = null;
    public DefaultTreeModel treeModel = null;
    private Vector dataSource = new Vector();
    private DmConfigMenuBar menubar = null;
    private JPanel imagePanel;
    public DetailInfo detailInfo = null;
    public DetailParent detailParent = null;
    private DefaultMutableTreeNode curNode = null;
    private DefaultTreeSelectionModel tsmodel = new DefaultTreeSelectionModel();
    private JSplitPane jSplitPane1 = new JSplitPane();

    public MainFrame() {
        this.enableEvents(64L);
        try {
            frame = this;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initHelpSet() {
        String helpsetName = null;
        try {
            Preferences.mainHS = null;
            Preferences.mainHB = null;
            Preferences.helpres = new HelpResourceBundle("configproperties.help");
            ClassLoader cl = MainFrame.class.getClassLoader();
            helpsetName = Preferences.getHelpSetName();
            URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)helpsetName);
            Preferences.mainHS = new HelpSet(cl, url);
            Preferences.mainHB = (DefaultHelpBroker)Preferences.mainHS.createHelpBroker();
            Preferences.mainHB.enableHelpKey((Component)this.getRootPane(), Preferences.helpres.getString("home"), null);
        }
        catch (Exception ex) {
            System.out.println("Help Set " + helpsetName + " not found");
            ex.printStackTrace();
        }
        catch (ExceptionInInitializerError ex) {
            System.err.println("initialization error:");
            ex.getException().printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("DmconfigFrame");
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
        URL url = this.getClass().getResource("/configimages/logo16.gif");
        if (url != null) {
            this.setIconImage(this.getToolkit().getImage(url));
        }
        this.initHelpSet();
        this.menubar = new DmConfigMenuBar();
        this.setJMenuBar(this.menubar);
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(this.res.getString("JConfiguration_Tool"));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.jSplitPane1.setBorder(null);
        this.jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jScrollPane1.setAutoscrolls(true);
        this.jScrollPane2.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jScrollPane2.setAutoscrolls(true);
        final ImageIcon imgIcon = DBAImageResource.getResource(this.getClass(), "/configimages/JConfiguration_Tool.jpg");
        this.imagePanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(imgIcon.getImage(), 0, 0, this.getWidth(), this.getHeight(), null);
            }
        };
        this.imagePanel.setLayout(new BorderLayout());
        this.tsmodel.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MainFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                MainFrame.this.tree_valueChanged(e);
                MainFrame.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.initTree();
        if (screenSize.getWidth() == 640.0) {
            this.jScrollPane1.setPreferredSize(new Dimension(122, 570));
            this.imagePanel.setPreferredSize(new Dimension(480, 570));
        } else {
            this.imagePanel.setPreferredSize(new Dimension(900, 640));
            this.jScrollPane1.setPreferredSize(new Dimension(172, 570));
        }
        this.jSplitPane1.setRightComponent(this.imagePanel);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jScrollPane2.revalidate();
        this.jScrollPane2.repaint();
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.pack();
    }

    public void checkBeforeExit() {
        try {
            int result;
            if (MainFrame.frame.detailInfo == null) {
                frame.exitApplication();
            }
            if (!frame.scanChanged(MainFrame.frame.detailInfo)) {
                frame.exitApplication();
            }
            if ((result = GuiUt.showOption3Dlg(frame, this.res.getString("Question"), this.res.getString("Are_you_want_to_save"))) == 0) {
                MainFrame.frame.detailParent.saveChange();
                frame.exitApplication();
            } else if (result == 1) {
                frame.exitApplication();
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.checkBeforeExit();
        }
    }

    public void initTree() {
        ImageIcon icon;
        this.dmconfigNode = new DefaultMutableTreeNode("dmconfig.ini");
        this.treeModel = new DefaultTreeModel(this.dmconfigNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setName("DmConfigTree");
        TreeUI treeUI = this.tree.getUI();
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MainFrame.this.tree_mousePressed(e);
            }
        });
        if (treeUI instanceof MetalTreeUI) {
            MetalTreeUI mTreeUI = (MetalTreeUI)treeUI;
            icon = DBAImageResource.getResource(this.getClass(), "/configimages/minus.gif");
            mTreeUI.setExpandedIcon(icon);
            icon = DBAImageResource.getResource(this.getClass(), "/configimages/plus.gif");
            mTreeUI.setCollapsedIcon(icon);
        }
        Object object = this.tree.getClientProperty("JTree.lineStyle");
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setToolTipText("");
        icon = DBAImageResource.getResource(this.getClass(), "/configimages/host.gif");
        ImageIcon iconleaf = DBAImageResource.getResource(this.getClass(), "/configimages/database.gif");
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setClosedIcon(icon);
        renderer.setOpenIcon(icon);
        renderer.setLeafIcon(iconleaf);
        this.tree.setCellRenderer(renderer);
        this.tree.setShowsRootHandles(true);
        this.jScrollPane1.getViewport().add(this.tree);
        ArrayList<String> dbNameList = JdmConfig.getAllDBNames();
        if (dbNameList != null && !dbNameList.isEmpty()) {
            for (String dbName : dbNameList) {
                this.dmconfigNode.add(new DefaultMutableTreeNode(dbName, false));
            }
        }
        this.tsmodel.setSelectionMode(1);
        this.tree.setSelectionModel(this.tsmodel);
        TreePath aTreePath = this.tree.getPathForRow(0);
        this.tree.expandPath(aTreePath);
        this.tree.setSelectionPath(aTreePath);
    }

    public boolean scanChanged(DetailInfo myDetailInfo) {
        if (this.detailInfo == null) {
            return false;
        }
        this.detailInfo.editingStopped();
        return myDetailInfo.isChanged();
    }

    void tree_valueChanged(TreeSelectionEvent e) {
        this.jScrollPane2.getViewport().setVisible(true);
        if (Preferences.selectedSection.equalsIgnoreCase("dmconfig.ini")) {
            this.curNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (this.curNode == null) {
                return;
            }
            Preferences.selectedSection = this.curNode.toString();
            if (this.curNode.isRoot()) {
                this.menubar.NewSection_Menuitem.setEnabled(true);
                this.menubar.DeleteSection_Menuitem.setEnabled(false);
                this.jScrollPane2.getViewport().removeAll();
                this.jSplitPane1.setRightComponent(this.imagePanel);
                if (Preferences.mainHB != null) {
                    Preferences.mainHB.enableHelpKey((Component)this.getRootPane(), Preferences.helpres.getString("home"), null);
                    Preferences.mainHB.enableHelpOnButton((Component)this.menubar.Help_Menuitem, Preferences.helpres.getString("home"), null);
                }
            } else {
                this.menubar.NewSection_Menuitem.setEnabled(false);
                this.menubar.DeleteSection_Menuitem.setEnabled(true);
                if (this.detailInfo == null) {
                    this.detailInfo = new DetailInfo(this, Preferences.behavior);
                    this.detailParent = new DetailParent(this, this.detailInfo);
                    DbaPanel p = (DbaPanel)this.detailInfo.getComponentAt(0);
                    if (Preferences.mainHB != null) {
                        Preferences.mainHB.enableHelpKey((Component)frame.getRootPane(), p.getHelpIDString(), null);
                    }
                    frame.setHelpMenuitem(p.getHelpIDString());
                    if (this.detailInfo.isError) {
                        this.detailParent.saveButton.setEnabled(false);
                    } else {
                        this.detailParent.saveButton.setEnabled(true);
                    }
                    this.detailParent.add((Component)this.detailInfo, "Center");
                    this.jSplitPane1.setRightComponent(this.jScrollPane2);
                    this.jScrollPane2.getViewport().removeAll();
                    this.jScrollPane2.getViewport().add((Component)this.detailParent, null);
                    this.detailInfo.repaint();
                    this.detailInfo.revalidate();
                    this.detailParent.repaint();
                    this.detailParent.revalidate();
                } else {
                    DbaPanel p = (DbaPanel)this.detailInfo.getComponentAt(0);
                    if (Preferences.mainHB != null) {
                        Preferences.mainHB.enableHelpKey((Component)frame.getRootPane(), p.getHelpIDString(), null);
                    }
                    frame.setHelpMenuitem(p.getHelpIDString());
                    this.detailInfo.getUserFilesPanel().clearTableContents();
                    this.detailInfo.initExistDetailInfo();
                    if (this.detailInfo.isError) {
                        this.detailParent.saveButton.setEnabled(false);
                    } else {
                        this.detailParent.saveButton.setEnabled(true);
                    }
                    this.jSplitPane1.setRightComponent(this.jScrollPane2);
                    this.jScrollPane2.getViewport().removeAll();
                    this.jScrollPane2.getViewport().add((Component)this.detailParent, null);
                    this.detailInfo.repaint();
                    this.detailInfo.revalidate();
                    this.detailParent.repaint();
                    this.detailParent.revalidate();
                }
            }
            this.jScrollPane2.revalidate();
            this.jScrollPane2.repaint();
            this.repaint();
        } else {
            if (this.scanChanged(this.detailInfo)) {
                int result = GuiUt.showOptionDlg(frame, this.res.getString("Question"), this.res.getString("Are_you_want_to_save"));
                if (result == 0) {
                    this.detailParent.saveChange();
                }
            }
            this.curNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (this.curNode == null) {
                return;
            }
            Preferences.selectedSection = this.curNode.toString();
            if (this.curNode.isRoot()) {
                this.menubar.NewSection_Menuitem.setEnabled(true);
                this.menubar.DeleteSection_Menuitem.setEnabled(false);
                this.jScrollPane2.getViewport().removeAll();
                this.jSplitPane1.setRightComponent(this.imagePanel);
                this.jScrollPane2.revalidate();
                this.jScrollPane2.repaint();
                if (Preferences.mainHB != null) {
                    Preferences.mainHB.enableHelpKey((Component)this.getRootPane(), Preferences.helpres.getString("home"), null);
                    Preferences.mainHB.enableHelpOnButton((Component)this.menubar.Help_Menuitem, Preferences.helpres.getString("home"), null);
                }
                this.repaint();
            } else {
                DbaPanel p = (DbaPanel)this.detailInfo.getComponentAt(0);
                if (Preferences.mainHB != null) {
                    Preferences.mainHB.enableHelpKey((Component)frame.getRootPane(), p.getHelpIDString(), null);
                }
                frame.setHelpMenuitem(p.getHelpIDString());
                this.menubar.NewSection_Menuitem.setEnabled(false);
                this.menubar.DeleteSection_Menuitem.setEnabled(true);
                this.detailInfo.getUserFilesPanel().clearTableContents();
                this.detailInfo.initExistDetailInfo();
                if (this.detailInfo.isError) {
                    this.detailParent.saveButton.setEnabled(false);
                } else {
                    this.detailParent.saveButton.setEnabled(true);
                }
                this.jSplitPane1.setRightComponent(this.jScrollPane2);
                this.jScrollPane2.getViewport().removeAll();
                this.jScrollPane2.getViewport().add((Component)this.detailParent, null);
                this.detailInfo.repaint();
                this.detailInfo.revalidate();
                this.detailParent.repaint();
                this.detailParent.revalidate();
                this.jScrollPane2.revalidate();
                this.jScrollPane2.repaint();
                this.repaint();
            }
        }
    }

    public static boolean isWindows() {
        String fileseparator = System.getProperty("file.separator");
        return fileseparator.equals("\\");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void SaveAs_Menuitem_actionPerformed(ActionEvent e) {
        String curDir = Preferences.dmConfigPath;
        if (curDir == null || curDir.length() == 0) {
            curDir = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser(curDir);
        chooser.setName("SaveAs");
        int state = chooser.showDialog(this, this.res.getString("Save_As"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileHidingEnabled(false);
        chooser.setEnabled(false);
        File file = chooser.getSelectedFile();
        if (file != null && state == 0) {
            int reply;
            if (file.exists() && (reply = GuiUt.showOptionDlg(this, this.res.getString("Warning"), this.res.getString("File_already") + " " + file + " " + this.res.getString("Already_exits_overwrite_it"))) != 0) {
                return;
            }
            if (this.detailInfo != null) {
                this.detailInfo.editingStopped();
                this.detailParent.saveChange();
            }
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new PrintWriter(file.getAbsolutePath()));
                ArrayList<String> dbNameList = JdmConfig.getAllDBNames();
                if (dbNameList != null && !dbNameList.isEmpty()) {
                    Iterator<String> i$ = dbNameList.iterator();
                    while (i$.hasNext()) {
                        JdmConfig dmConfig = new JdmConfig();
                        String dbName = i$.next();
                        int rc = dmConfig.fileOpen("dmconfig.ini", dbName, "r");
                        if (rc != 0) continue;
                        String sectionHeader = "[" + dbName + "]";
                        bw.write(sectionHeader);
                        bw.newLine();
                        ArrayList<String> lines = dmConfig.getExistLines();
                        for (String line : lines) {
                            bw.write(line);
                            bw.newLine();
                        }
                    }
                }
                bw.flush();
                bw.close();
            }
            catch (IOException e1) {
                System.out.println("dmconfig.ini save as failed: " + e1.getMessage());
                e1.printStackTrace();
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    void DeleteSection_Menu_actionPerformed(ActionEvent e) {
        DefaultMutableTreeNode myNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        int result = GuiUt.showOptionDlg(frame, this.res.getString("Question"), this.res.getString("Are_you_want_to_delete"));
        if (result == 0) {
            JdmConfig dmConfig = new JdmConfig();
            int rc = dmConfig.fileOpen("dmconfig.ini", (String)myNode.getUserObject(), "r+");
            if (rc != 0) {
                return;
            }
            rc = dmConfig.procDelete("", 0);
            if (rc != 0) {
                return;
            }
            rc = dmConfig.fileClose();
            if (rc != 0) {
                return;
            }
            this.treeModel.removeNodeFromParent(myNode);
            this.treeModel.reload(this.dmconfigNode);
            this.tree.setSelectionRow(0);
        }
    }

    public void exitApplication() {
        try {
            this.setVisible(false);
            this.dispose();
            System.exit(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void tree_mousePressed(MouseEvent e) {
        if (e.getModifiers() == 4) {
            TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null) {
                path = null;
                return;
            }
            this.tree.setSelectionPath(path);
            if (node.isRoot()) {
                DmConfigPopupMenu popup = new DmConfigPopupMenu();
                popup.show(e.getComponent(), e.getX(), e.getY());
            } else {
                DatabasePopupMenu popup = new DatabasePopupMenu();
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public void refreshTree() {
        Object newNode = null;
        this.dmconfigNode.removeAllChildren();
        ArrayList<String> dbNameList = JdmConfig.getAllDBNames();
        if (dbNameList != null && !dbNameList.isEmpty()) {
            for (String dbName : dbNameList) {
                this.dmconfigNode.add(new DefaultMutableTreeNode(dbName, false));
            }
        }
    }

    public void setHelpMenuitem(String id) {
        if (Preferences.mainHB == null) {
            return;
        }
        Preferences.mainHB.enableHelp((Component)this.menubar.Help_Menuitem, id, null);
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = e == null ? DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", LocaleManager.getLocale()) : DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", e.getLocale());
        this.setTitle(this.res.getString("JConfiguration_Tool"));
        this.menubar.localeChanged(e);
    }
}

