/*
 * Decompiled with CFR 0.152.
 */
package DmEditor.AllSectionInfo.statistics;

import DmEditor.AllSectionInfo.AllSectionInfo;
import DmEditor.AllSectionInfo.ConfigItem;
import DmEditor.ConfigDateTimeObject;
import DmEditor.ConfigTimeIntervalObject;
import DmEditor.Preferences.Preferences;
import dbaut.boundaryValue.BoundaryDate;
import dbaut.boundaryValue.BoundaryInterval;
import dbaut.boundaryValue.BoundaryManager;
import dbaut.comp.DbaPanel;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleChangeListener;
import dbaut.locale.LocaleManager;
import dbaut.panel.PanelWithVerticalLayout;
import dbaut.resource.DBAResourceBundle;
import dbaut.resource.HelpResourceBundle;
import dbaut.textField.IntegerRangeField;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class StatisticsPanel
extends DbaPanel
implements LocaleChangeListener {
    private static final long serialVersionUID = -4998118571208929084L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", LocaleManager.getLocale());
    private boolean fromRunTimeSetting;
    private JLabel header = null;
    private JCheckBox stsvrCheckBox = new JCheckBox();
    private JPanel modePanel = new PanelWithVerticalLayout("North");
    private JRadioButton stmod0 = new JRadioButton();
    private JRadioButton stmod1 = new JRadioButton();
    private JLabel dbSTSTVLabel = new JLabel();
    private BoundaryInterval boundarySTSTV = (BoundaryInterval)BoundaryManager.getInstance().get("DB_STSTV");
    private ConfigTimeIntervalObject dbSTSTVConfigTimeIntervalObject = new ConfigTimeIntervalObject(Integer.parseInt(this.boundarySTSTV.getMaxDay()), Integer.parseInt(this.boundarySTSTV.getMinDay()), this.boundarySTSTV.getDefaultDay(), this.boundarySTSTV.getDefaultTime());
    private JLabel dbSTSTMLabel = new JLabel();
    private BoundaryDate boundarySTSTM = (BoundaryDate)BoundaryManager.getInstance().get("DB_STSTM");
    private ConfigDateTimeObject dbSTSTMConfigDateTimeObject = new ConfigDateTimeObject(this.boundarySTSTM.getMaxDate(), this.boundarySTSTM.getMinDate(), this.boundarySTSTM.getDefaultDate(), this.boundarySTSTM.getMaxTime(), this.boundarySTSTM.getMinTime(), this.boundarySTSTM.getDefaultTime());
    private JPanel samplePanel = new PanelWithVerticalLayout("North");
    private JRadioButton sample0 = new JRadioButton();
    private JRadioButton sample1 = new JRadioButton();
    private JRadioButton sampleRatio = new JRadioButton();
    private IntegerRangeField sspField = new IntegerRangeField(100, 100, -1, false);
    private JLabel percentLabel = new JLabel();
    private static final ArrayList<String> KEYS = new ArrayList();
    private static final int STSSP_MAX = 100;
    private static final int STSSP_OFF = 0;
    private static final int STSSP_SMART = -1;
    private static final int STSSP_MIN = -1;
    private static final int STSSP_DEFAULT = 100;

    public StatisticsPanel(HelpResourceBundle helpres, String helpid2) {
        this(helpres, helpid2, false);
    }

    public StatisticsPanel(HelpResourceBundle helpres, String helpid2, boolean fromRunTimeSetting) {
        super(helpres, helpid2);
        this.fromRunTimeSetting = fromRunTimeSetting;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        if (!this.fromRunTimeSetting) {
            this.header = new JLabel(this.res.getString("*_All_the_following_setting_are_applied_on_server_end"));
            this.header.setFont(Preferences.bigFont);
        }
        this.stsvrCheckBox.setText(this.res.getString("Start_Statistics_Server"));
        this.stsvrCheckBox.setBounds(10, 10, 200, 25);
        this.stsvrCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatisticsPanel.this.stsvrCheckBoxActionPerformed(e);
            }
        });
        this.add(this.stsvrCheckBox);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.stmod0);
        bg.add(this.stmod1);
        this.stmod0.setText(this.res.getString("General_mode"));
        this.stmod1.setText(this.res.getString("Every_table_setting_mode"));
        this.modePanel.setBounds(10, 35, 400, 90);
        this.modePanel.add(this.stmod0);
        this.modePanel.add(this.stmod1);
        this.modePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Statistics_Mode"), 1, 2));
        this.add(this.modePanel);
        this.dbSTSTMLabel.setText(this.res.getString("Start_Time_Of_Statistics"));
        JPanel timePanel = new JPanel();
        timePanel.setLayout(new FlowLayout(0));
        timePanel.add(this.dbSTSTMLabel);
        timePanel.add(this.dbSTSTMConfigDateTimeObject);
        timePanel.setBounds(10, 130, 500, 28);
        this.add(timePanel);
        this.dbSTSTVLabel.setText(this.res.getString("Statistics_Interval"));
        JPanel intervalPanel = new JPanel();
        intervalPanel.setLayout(new FlowLayout(0));
        intervalPanel.add(this.dbSTSTVLabel);
        intervalPanel.add(this.dbSTSTVConfigTimeIntervalObject);
        intervalPanel.setBounds(10, 160, 500, 28);
        this.add(intervalPanel);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.sample0);
        bg2.add(this.sample1);
        bg2.add(this.sampleRatio);
        this.sample0.setText(this.res.getString("Smart_sample_ratio"));
        this.sample1.setText(this.res.getString("Not_do_update_statistics"));
        this.sampleRatio.setText(this.res.getString("Sample_Ratio"));
        this.sample0.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StatisticsPanel.this.sample0Changed();
            }
        });
        this.sample1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StatisticsPanel.this.sample1Changed();
            }
        });
        this.sampleRatio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StatisticsPanel.this.sampleRatioChanged();
            }
        });
        this.sspField.Value_Field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                StatisticsPanel.this.stsspFocusLost();
            }
        });
        this.sspField.Value_Field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                StatisticsPanel.this.setSampleSelected();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                StatisticsPanel.this.setSampleSelected();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                StatisticsPanel.this.setSampleSelected();
            }
        });
        this.samplePanel.setBounds(10, 190, 400, 150);
        this.samplePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Statistics_sample"), 1, 2));
        JPanel sample0Panel = new JPanel();
        sample0Panel.setLayout(new FlowLayout(0));
        sample0Panel.add(this.sample0);
        this.samplePanel.add(sample0Panel);
        JPanel sample1Panel = new JPanel();
        sample1Panel.setLayout(new FlowLayout(0));
        sample1Panel.add(this.sample1);
        this.samplePanel.add(sample1Panel);
        JPanel sspPanel = new JPanel();
        sspPanel.setLayout(new FlowLayout(0));
        sspPanel.add(this.sampleRatio);
        this.sspField.setPreferredSize(new Dimension(50, 20));
        sspPanel.add(this.sspField);
        this.percentLabel = new JLabel("%");
        sspPanel.add(this.percentLabel);
        this.samplePanel.add(sspPanel);
        this.add(this.samplePanel);
        this.setName("StatisticsPanel");
        this.stsvrCheckBox.setName("STServerCheckBox");
        this.dbSTSTMConfigDateTimeObject.setName("STTMPanel");
        this.dbSTSTVConfigTimeIntervalObject.setName("STITVPanel");
        this.stmod0.setName("GeneralModeRadioButton");
        this.stmod1.setName("EveryTableSettingModeRadioButton");
        this.sample0.setName("SmartSampleRatioRadioButton");
        this.sample1.setName("NotDoUpdateStatisticsRadioButton");
        this.sampleRatio.setName("SampleRadioButton");
        this.sspField.setName("SampleFieldPanel");
    }

    private void sample0Changed() {
        Integer value;
        if (this.sample0.isSelected() && (value = this.sspField.getValue()) != null && value != -1) {
            this.sspField.setValue(-1);
        }
    }

    private void sample1Changed() {
        Integer value;
        if (this.sample1.isSelected() && (value = this.sspField.getValue()) != null && value != 0) {
            this.sspField.setValue(0);
        }
    }

    private void sampleRatioChanged() {
        Integer value;
        this.sspField.setEnabled(this.sampleRatio.isSelected() && this.sampleRatio.isEnabled());
        if (this.sampleRatio.isSelected() && (value = this.sspField.getValue()) != null && (value < 1 || value > 100)) {
            this.sspField.setValue(100);
        }
    }

    private void stsspFocusLost() {
        Integer value = this.sspField.getValue();
        if (value == null || value < -1 || value > 100) {
            this.sspField.setValue(100);
        }
    }

    private void setSampleSelected() {
        Integer value = this.sspField.getValue();
        if (value != null) {
            if (value == -1) {
                this.sample0.setSelected(true);
            } else if (value == 0) {
                this.sample1.setSelected(true);
            } else {
                this.sampleRatio.setSelected(true);
            }
        }
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.modePanel.setEnabled(flag);
        this.stmod0.setEnabled(flag);
        this.stmod1.setEnabled(flag);
        this.dbSTSTMLabel.setEnabled(flag);
        this.dbSTSTMConfigDateTimeObject.setComponentEnabled(flag);
        this.dbSTSTVLabel.setEnabled(flag);
        this.dbSTSTVConfigTimeIntervalObject.setEnabled(flag);
        this.samplePanel.setEnabled(flag);
        this.sample0.setEnabled(flag);
        this.sample1.setEnabled(flag);
        this.sampleRatio.setEnabled(flag);
        this.sspField.setEnabled(flag && this.sampleRatio.isSelected());
        this.percentLabel.setEnabled(flag && this.sampleRatio.isSelected());
    }

    public void setAllEnabled(boolean flag) {
        super.setEnabled(flag);
        this.stsvrCheckBox.setEnabled(flag);
        if (flag) {
            this.modePanel.setForeground(Color.BLACK);
        } else {
            this.modePanel.setForeground(Color.GRAY);
        }
        this.stmod0.setEnabled(flag);
        this.stmod1.setEnabled(flag);
        this.dbSTSTMLabel.setEnabled(flag);
        this.dbSTSTMConfigDateTimeObject.setComponentEnabled(flag);
        this.dbSTSTVLabel.setEnabled(flag);
        this.dbSTSTVConfigTimeIntervalObject.setEnabled(flag);
        if (flag) {
            this.samplePanel.setForeground(Color.BLACK);
        } else {
            this.samplePanel.setForeground(Color.GRAY);
        }
        this.sample0.setEnabled(flag);
        this.sample1.setEnabled(flag);
        this.sampleRatio.setEnabled(flag);
        this.sspField.setEnabled(flag && this.sampleRatio.isSelected());
        this.percentLabel.setEnabled(flag && this.sampleRatio.isSelected());
    }

    public void initComponents(AllSectionInfo allSectionInfo) {
        ConfigItem item = null;
        for (String key : KEYS) {
            item = allSectionInfo.getItem(key);
            item.initDefaultValue();
        }
        boolean b = allSectionInfo.booleanValue("db_stsvr");
        this.setEnabled(b);
    }

    public void addComponents(Vector ht) {
        ht.add(new ConfigItem("stsvr", this.stsvrCheckBox, "1", 0));
        Hashtable<String, JRadioButton> htSTMode = new Hashtable<String, JRadioButton>();
        htSTMode.put("0", this.stmod0);
        htSTMode.put("1", this.stmod1);
        ht.add(new ConfigItem("stmod", htSTMode, "0", 6));
        ht.add(new ConfigItem("ststm", this.dbSTSTMConfigDateTimeObject, "1970/01/01 03:00:00", 2));
        ht.add(new ConfigItem("ststv", this.dbSTSTVConfigTimeIntervalObject, "1-00:00:00", 4));
        ht.add(new ConfigItem("stssp", this.sspField, String.valueOf(100), 7));
    }

    public void setSectionInfo(AllSectionInfo allSectionInfo) {
        allSectionInfo.add("db_stsvr", this.stsvrCheckBox, "1", (short)0);
        Hashtable<String, JRadioButton> htSTMode = new Hashtable<String, JRadioButton>();
        htSTMode.put("0", this.stmod0);
        htSTMode.put("1", this.stmod1);
        allSectionInfo.add("db_stmod", htSTMode, "0", (short)6);
        allSectionInfo.add("db_ststm", this.dbSTSTMConfigDateTimeObject, "1970/01/01 03:00:00", (short)2);
        allSectionInfo.add("db_ststv", this.dbSTSTVConfigTimeIntervalObject, "1-00:00:00", (short)4);
        allSectionInfo.add("db_stssp", this.sspField, String.valueOf(100), (short)7);
    }

    public void stsvrCheckBoxActionPerformed(ActionEvent e) {
        if (this.stsvrCheckBox.isSelected()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = e == null ? DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", LocaleManager.getLocale()) : DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", e.getLocale());
        this.stsvrCheckBox.setText(this.res.getString("Start_Statistics_Server"));
        this.modePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Statistics_Mode"), 1, 2));
        this.stmod0.setText(this.res.getString("General_mode"));
        this.stmod1.setText(this.res.getString("Every_table_setting_mode"));
        this.dbSTSTMLabel.setText(this.res.getString("Start_Time_Of_Statistics"));
        this.dbSTSTVLabel.setText(this.res.getString("Statistics_Interval"));
        this.samplePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Statistics_sample"), 1, 2));
        this.sample0.setText(this.res.getString("General_mode"));
        this.sample1.setText(this.res.getString("Every_table_setting_mode"));
        this.sampleRatio.setText(this.res.getString("Sample_Ratio"));
        if (this.header != null) {
            this.header.setText(this.res.getString("*_All_the_following_setting_are_applied_on_server_end"));
        }
    }

    static {
        KEYS.add("db_stsvr");
        KEYS.add("db_stmod");
        KEYS.add("db_ststm");
        KEYS.add("db_ststv");
        KEYS.add("db_stssp");
    }
}

