/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import java.lang.reflect.Array;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.template.Template;
import org.msgpack.unpacker.Unpacker;

public class ObjectArrayTemplate
extends AbstractTemplate {
    protected Class componentClass;
    protected Template componentTemplate;

    /*
     * WARNING - void declaration
     */
    public ObjectArrayTemplate(Class componentClass, Template componentTemplate) {
        void var2_2;
        void var1_1;
        this.componentClass = var1_1;
        this.componentTemplate = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(Packer packer, Object v, boolean required) throws IOException {
        void var1_1;
        Object[] objectArray;
        if (v == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            packer.writeNil();
            return;
        }
        if (!(v instanceof Object[]) || !this.componentClass.isAssignableFrom(v.getClass().getComponentType())) {
            throw new MessageTypeException();
        }
        objectArray = objectArray;
        int n2 = objectArray.length;
        packer.writeArrayBegin(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.componentTemplate.write(packer, objectArray[i2], required);
        }
        var1_1.writeArrayEnd();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object read(Unpacker unpacker, Object to, boolean required) throws IOException {
        void var1_1;
        if (!required && unpacker.trySkipNil()) {
            return null;
        }
        int n2 = unpacker.readArrayBegin();
        Object[] objectArray = (Object[])Array.newInstance(this.componentClass, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = this.componentTemplate.read(unpacker, null, required);
        }
        var1_1.readArrayEnd();
        return objectArray;
    }
}

