/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import javassist.bytecode.Descriptor;

public class SerialVersionUID {
    public static void setSerialVersionUID(CtClass clazz) throws CannotCompileException, NotFoundException {
        try {
            clazz.getDeclaredField("serialVersionUID");
            return;
        }
        catch (NotFoundException notFoundException) {
            CtClass ctClass;
            Object object = clazz;
            ClassPool classPool = ((CtClass)object).getClassPool();
            if (!((CtClass)object).subtypeOf(classPool.get("java.io.Serializable"))) {
                return;
            }
            object = new CtField(CtClass.longType, "serialVersionUID", clazz);
            ((CtField)object).setModifiers(26);
            clazz.addField((CtField)object, SerialVersionUID.a(ctClass) + "L");
            return;
        }
    }

    private static long a(CtClass ctClass) throws CannotCompileException {
        try {
            int n2;
            int n3;
            int n4;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            ClassFile classFile = ctClass.getClassFile();
            Object object = ctClass;
            CtMethod[] ctMethodArray = Descriptor.toJavaName(Descriptor.toJvmName((CtClass)object));
            dataOutputStream.writeUTF((String)ctMethodArray);
            ctMethodArray = ctClass.getDeclaredMethods();
            int n5 = ctClass.getModifiers();
            if ((n5 & 0x200) != 0) {
                n5 = ctMethodArray.length > 0 ? (n5 |= 0x400) : (n5 &= 0xFFFFFBFF);
            }
            dataOutputStream.writeInt(n5);
            Object[] objectArray = classFile.getInterfaces();
            for (n4 = 0; n4 < objectArray.length; ++n4) {
                object = objectArray[n4];
                objectArray[n4] = Descriptor.toJavaName(Descriptor.toJvmName((String)object));
            }
            Arrays.sort(objectArray);
            for (n4 = 0; n4 < objectArray.length; ++n4) {
                dataOutputStream.writeUTF((String)objectArray[n4]);
            }
            CtField[] ctFieldArray = ctClass.getDeclaredFields();
            Arrays.sort(ctFieldArray, new Comparator(){

                public final int compare(Object o1, Object o2) {
                    CtField ctField;
                    CtField ctField2 = (CtField)o1;
                    ctField = ctField;
                    return ctField2.getName().compareTo(ctField.getName());
                }
            });
            for (int i2 = 0; i2 < ctFieldArray.length; ++i2) {
                object = ctFieldArray[i2];
                int n6 = ((CtField)object).getModifiers();
                if ((n6 & 2) != 0 && (n6 & 0x88) != 0) continue;
                dataOutputStream.writeUTF(((CtField)object).getName());
                dataOutputStream.writeInt(n6);
                dataOutputStream.writeUTF(((CtField)object).getFieldInfo2().getDescriptor());
            }
            if (classFile.getStaticInitializer() != null) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            CtConstructor[] ctConstructorArray = ctClass.getDeclaredConstructors();
            Arrays.sort(ctConstructorArray, new Comparator(){

                public final int compare(Object o1, Object o2) {
                    CtConstructor ctConstructor;
                    CtConstructor ctConstructor2 = (CtConstructor)o1;
                    ctConstructor = ctConstructor;
                    return ctConstructor2.getMethodInfo2().getDescriptor().compareTo(ctConstructor.getMethodInfo2().getDescriptor());
                }
            });
            for (n3 = 0; n3 < ctConstructorArray.length; ++n3) {
                CtConstructor ctConstructor = ctConstructorArray[n3];
                n2 = ctConstructor.getModifiers();
                if ((n2 & 2) != 0) continue;
                dataOutputStream.writeUTF("<init>");
                dataOutputStream.writeInt(n2);
                dataOutputStream.writeUTF(ctConstructor.getMethodInfo2().getDescriptor().replace('/', '.'));
            }
            Arrays.sort(ctMethodArray, new Comparator(){

                public final int compare(Object o1, Object o2) {
                    CtMethod ctMethod;
                    CtMethod ctMethod2 = (CtMethod)o1;
                    ctMethod = ctMethod;
                    int n2 = ctMethod2.getName().compareTo(ctMethod.getName());
                    if (n2 == 0) {
                        n2 = ctMethod2.getMethodInfo2().getDescriptor().compareTo(ctMethod.getMethodInfo2().getDescriptor());
                    }
                    return n2;
                }
            });
            for (n3 = 0; n3 < ctMethodArray.length; ++n3) {
                CtMethod ctMethod = ctMethodArray[n3];
                n2 = ctMethod.getModifiers() & 0xD3F;
                if ((n2 & 2) != 0) continue;
                dataOutputStream.writeUTF(ctMethod.getName());
                dataOutputStream.writeInt(n2);
                dataOutputStream.writeUTF(ctMethod.getMethodInfo2().getDescriptor().replace('/', '.'));
            }
            dataOutputStream.flush();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            byte[] byArray = messageDigest.digest(byteArrayOutputStream.toByteArray());
            long l2 = 0L;
            for (int i3 = Math.min(byArray.length, 8) - 1; i3 >= 0; --i3) {
                l2 = l2 << 8 | (long)(byArray[i3] & 0xFF);
            }
            return l2;
        }
        catch (IOException iOException) {
            throw new CannotCompileException(iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CannotCompileException(noSuchAlgorithmException);
        }
    }
}

