/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.PropertyUtil;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.media.jai.JaiI18N;
import javax.media.jai.PropertyChangeSupportJAI;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.WritablePropertySource;
import javax.media.jai.WritablePropertySourceImpl;

public final class RenderableImageAdapter
implements RenderableImage,
WritablePropertySource {
    private RenderableImage im;
    private PropertyChangeSupportJAI eventManager = null;
    private WritablePropertySourceImpl properties = null;

    public RenderableImageAdapter(RenderableImage renderableImage) {
        if (renderableImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.im = renderableImage;
        this.eventManager = new PropertyChangeSupportJAI(this);
        this.properties = new WritablePropertySourceImpl(null, null, this.eventManager);
    }

    public static RenderableImageAdapter wrapRenderableImage(RenderableImage renderableImage) {
        if (renderableImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (renderableImage instanceof RenderableImageAdapter) {
            return (RenderableImageAdapter)renderableImage;
        }
        return new RenderableImageAdapter(renderableImage);
    }

    public final Vector getSources() {
        return this.im.getSources();
    }

    public final Object getProperty(String string) {
        Object object = this.properties.getProperty(string);
        if (object == Image.UndefinedProperty) {
            object = this.im.getProperty(string);
        }
        return object;
    }

    public Class getPropertyClass(String string) {
        Object object;
        Class<?> clazz = this.properties.getPropertyClass(string);
        if (clazz == null && (object = this.getProperty(string)) != Image.UndefinedProperty) {
            clazz = object.getClass();
        }
        return clazz;
    }

    public final String[] getPropertyNames() {
        return RenderedImageAdapter.mergePropertyNames(this.properties.getPropertyNames(), this.im.getPropertyNames());
    }

    public String[] getPropertyNames(String string) {
        return PropertyUtil.getPropertyNames(this.getPropertyNames(), string);
    }

    public void setProperty(String string, Object object) {
        this.properties.setProperty(string, object);
    }

    public void removeProperty(String string) {
        this.properties.removeProperty(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(string, propertyChangeListener);
    }

    public final float getWidth() {
        return this.im.getWidth();
    }

    public final float getHeight() {
        return this.im.getHeight();
    }

    public final float getMinX() {
        return this.im.getMinX();
    }

    public final float getMinY() {
        return this.im.getMinY();
    }

    public final boolean isDynamic() {
        return this.im.isDynamic();
    }

    public final RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) {
        return this.im.createScaledRendering(n, n2, renderingHints);
    }

    public final RenderedImage createDefaultRendering() {
        return this.im.createDefaultRendering();
    }

    public final RenderedImage createRendering(RenderContext renderContext) {
        return this.im.createRendering(renderContext);
    }
}

