/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.SeekableOutputStream;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codec.TIFFField;
import com.sun.media.jai.codecimpl.JPEGImageEncoder;
import com.sun.media.jai.codecimpl.JaiI18N;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.Deflater;

public class TIFFImageEncoder
extends ImageEncoderImpl {
    private static final int TIFF_UNSUPPORTED = -1;
    private static final int TIFF_BILEVEL_WHITE_IS_ZERO = 0;
    private static final int TIFF_BILEVEL_BLACK_IS_ZERO = 1;
    private static final int TIFF_GRAY = 2;
    private static final int TIFF_PALETTE = 3;
    private static final int TIFF_RGB = 4;
    private static final int TIFF_CMYK = 5;
    private static final int TIFF_YCBCR = 6;
    private static final int TIFF_CIELAB = 7;
    private static final int TIFF_GENERIC = 8;
    private static final int COMP_NONE = 1;
    private static final int COMP_JPEG_TTN2 = 7;
    private static final int COMP_PACKBITS = 32773;
    private static final int COMP_DEFLATE = 32946;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    private static final int TIFF_YCBCR_POSITIONING = 531;
    private static final int TIFF_REF_BLACK_WHITE = 532;
    private static final int EXTRA_SAMPLE_UNSPECIFIED = 0;
    private static final int EXTRA_SAMPLE_ASSOCIATED_ALPHA = 1;
    private static final int EXTRA_SAMPLE_UNASSOCIATED_ALPHA = 2;
    private static final int DEFAULT_ROWS_PER_STRIP = 8;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    public TIFFImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new TIFFEncodeParam();
        }
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        this.writeFileHeader();
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        Iterator iterator = tIFFEncodeParam.getExtraImages();
        if (iterator != null) {
            boolean bl;
            int n = 8;
            RenderedImage renderedImage2 = renderedImage;
            TIFFEncodeParam tIFFEncodeParam2 = tIFFEncodeParam;
            do {
                n = this.encode(renderedImage2, tIFFEncodeParam2, n, !(bl = iterator.hasNext()));
                if (!bl) continue;
                Object e = iterator.next();
                if (e instanceof RenderedImage) {
                    renderedImage2 = (RenderedImage)e;
                    tIFFEncodeParam2 = tIFFEncodeParam;
                    continue;
                }
                if (!(e instanceof Object[])) continue;
                Object[] objectArray = (Object[])e;
                renderedImage2 = (RenderedImage)objectArray[0];
                tIFFEncodeParam2 = (TIFFEncodeParam)objectArray[1];
            } while (bl);
        } else {
            this.encode(renderedImage, tIFFEncodeParam, 8, true);
        }
    }

    private int encode(RenderedImage renderedImage, TIFFEncodeParam tIFFEncodeParam, int n, boolean bl) throws IOException {
        int n2;
        Object object;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Object object2;
        Object object3;
        Object object4;
        int n10;
        Object object5;
        long l;
        int n11;
        int n12;
        int n13;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        int n14;
        int n15 = tIFFEncodeParam.getCompression();
        boolean bl2 = tIFFEncodeParam.getWriteTiled();
        int n16 = renderedImage.getMinX();
        int n17 = renderedImage.getMinY();
        int n18 = renderedImage.getWidth();
        int n19 = renderedImage.getHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int[] nArray = sampleModel.getSampleSize();
        int n20 = 1;
        while (n20 < nArray.length) {
            if (nArray[n20] != nArray[0]) {
                throw new Error(JaiI18N.getString("TIFFImageEncoder0"));
            }
            ++n20;
        }
        int n21 = sampleModel.getNumBands();
        if ((nArray[0] == 1 || nArray[0] == 4) && n21 != 1) {
            throw new Error(JaiI18N.getString("TIFFImageEncoder1"));
        }
        int n22 = sampleModel.getDataType();
        switch (n22) {
            case 0: {
                if (nArray[0] == 1 || nArray[0] != 4 || nArray[0] == 8) break;
                throw new Error(JaiI18N.getString("TIFFImageEncoder2"));
            }
            case 1: 
            case 2: {
                if (nArray[0] == 16) break;
                throw new Error(JaiI18N.getString("TIFFImageEncoder3"));
            }
            case 3: 
            case 4: {
                if (nArray[0] == 32) break;
                throw new Error(JaiI18N.getString("TIFFImageEncoder4"));
            }
            default: {
                throw new Error(JaiI18N.getString("TIFFImageEncoder5"));
            }
        }
        boolean bl3 = n22 == 2 || n22 == 1;
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel != null && colorModel instanceof IndexColorModel && n22 != 0) {
            throw new Error(JaiI18N.getString("TIFFImageEncoder6"));
        }
        IndexColorModel indexColorModel = null;
        int n23 = 0;
        int[] nArray2 = null;
        int n24 = -1;
        int n25 = 0;
        int n26 = 0;
        if (colorModel instanceof IndexColorModel) {
            indexColorModel = (IndexColorModel)colorModel;
            n14 = indexColorModel.getMapSize();
            if (nArray[0] == 1 && n21 == 1) {
                if (n14 != 2) {
                    throw new IllegalArgumentException(JaiI18N.getString("TIFFImageEncoder7"));
                }
                byArray3 = new byte[n14];
                indexColorModel.getReds(byArray3);
                byArray2 = new byte[n14];
                indexColorModel.getGreens(byArray2);
                byArray = new byte[n14];
                indexColorModel.getBlues(byArray);
                n24 = (byArray3[0] & 0xFF) == 0 && (byArray3[1] & 0xFF) == 255 && (byArray2[0] & 0xFF) == 0 && (byArray2[1] & 0xFF) == 255 && (byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) == 255 ? 1 : ((byArray3[0] & 0xFF) == 255 && (byArray3[1] & 0xFF) == 0 && (byArray2[0] & 0xFF) == 255 && (byArray2[1] & 0xFF) == 0 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 0 ? 0 : 3);
            } else if (n21 == 1) {
                n24 = 3;
            }
        } else if (colorModel == null) {
            if (nArray[0] == 1 && n21 == 1) {
                n24 = 1;
            } else {
                n24 = 8;
                if (n21 > 1) {
                    n25 = n21 - 1;
                }
            }
        } else {
            ColorSpace colorSpace = colorModel.getColorSpace();
            switch (colorSpace.getType()) {
                case 9: {
                    n24 = 5;
                    break;
                }
                case 6: {
                    n24 = 2;
                    break;
                }
                case 1: {
                    n24 = 7;
                    break;
                }
                case 5: {
                    if (n15 == 7 && tIFFEncodeParam.getJPEGCompressRGBToYCbCr()) {
                        n24 = 6;
                        break;
                    }
                    n24 = 4;
                    break;
                }
                case 3: {
                    n24 = 6;
                    break;
                }
                default: {
                    n24 = 8;
                }
            }
            if (n24 == 8) {
                n25 = n21 - 1;
            } else if (n21 > 1) {
                n25 = n21 - colorSpace.getNumComponents();
            }
            if (n25 == 1 && colorModel.hasAlpha()) {
                int n27 = n26 = colorModel.isAlphaPremultiplied() ? 1 : 2;
            }
        }
        if (n24 == -1) {
            throw new Error(JaiI18N.getString("TIFFImageEncoder8"));
        }
        if (n15 == 7) {
            if (n24 == 3) {
                throw new Error(JaiI18N.getString("TIFFImageEncoder11"));
            }
            if (nArray[0] != 8 || n24 != 2 && n24 != 4 && n24 != 6) {
                throw new Error(JaiI18N.getString("TIFFImageEncoder9"));
            }
        }
        n14 = -1;
        switch (n24) {
            case 0: {
                n14 = 0;
                break;
            }
            case 1: {
                n14 = 1;
                break;
            }
            case 2: 
            case 8: {
                n14 = 1;
                break;
            }
            case 3: {
                n14 = 3;
                indexColorModel = (IndexColorModel)colorModel;
                n23 = indexColorModel.getMapSize();
                byArray3 = new byte[n23];
                indexColorModel.getReds(byArray3);
                byArray2 = new byte[n23];
                indexColorModel.getGreens(byArray2);
                byArray = new byte[n23];
                indexColorModel.getBlues(byArray);
                int n28 = 0;
                int n29 = n23;
                int n30 = 2 * n23;
                nArray2 = new int[n23 * 3];
                int n31 = 0;
                while (n31 < n23) {
                    nArray2[n28++] = byArray3[n31] << 8 & 0xFFFF;
                    nArray2[n29++] = byArray2[n31] << 8 & 0xFFFF;
                    nArray2[n30++] = byArray[n31] << 8 & 0xFFFF;
                    ++n31;
                }
                n23 *= 3;
                break;
            }
            case 4: {
                n14 = 2;
                break;
            }
            case 5: {
                n14 = 5;
                break;
            }
            case 6: {
                n14 = 6;
                break;
            }
            case 7: {
                n14 = 8;
                break;
            }
            default: {
                throw new Error(JaiI18N.getString("TIFFImageEncoder8"));
            }
        }
        if (bl2) {
            n13 = tIFFEncodeParam.getTileWidth() > 0 ? tIFFEncodeParam.getTileWidth() : renderedImage.getTileWidth();
            n12 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : renderedImage.getTileHeight();
        } else {
            n13 = n18;
            n12 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : 8;
        }
        JPEGEncodeParam jPEGEncodeParam = null;
        if (n15 == 7) {
            int n32;
            int n33;
            jPEGEncodeParam = tIFFEncodeParam.getJPEGEncodeParam();
            n11 = jPEGEncodeParam.getHorizontalSubsampling(0);
            int n34 = jPEGEncodeParam.getVerticalSubsampling(0);
            int n35 = 1;
            while (n35 < n21) {
                n33 = jPEGEncodeParam.getHorizontalSubsampling(n35);
                if (n33 > n11) {
                    n11 = n33;
                }
                if ((n32 = jPEGEncodeParam.getVerticalSubsampling(n35)) > n34) {
                    n34 = n32;
                }
                ++n35;
            }
            n33 = 8 * n34;
            if ((n12 = (int)((float)n12 / (float)n33 + 0.5f) * n33) < n33) {
                n12 = n33;
            }
            if (bl2 && (n13 = (int)((float)n13 / (float)(n32 = 8 * n11) + 0.5f) * n32) < n32) {
                n13 = n32;
            }
        }
        n11 = bl2 ? (n18 + n13 - 1) / n13 * ((n19 + n12 - 1) / n12) : (int)Math.ceil((double)n19 / (double)n12);
        long[] lArray = new long[n11];
        long l2 = (long)Math.ceil((double)nArray[0] / 8.0 * (double)n13 * (double)n21);
        long l3 = l2 * (long)n12;
        int n36 = 0;
        while (n36 < n11) {
            lArray[n36] = l3;
            ++n36;
        }
        if (!bl2) {
            l = n19 - n12 * (n11 - 1);
            lArray[n11 - 1] = l * l2;
        }
        l = l3 * (long)(n11 - 1) + lArray[n11 - 1];
        long[] lArray2 = new long[n11];
        TreeSet<TIFFField> treeSet = new TreeSet<TIFFField>();
        treeSet.add(new TIFFField(256, 4, 1, new long[]{n18}));
        treeSet.add(new TIFFField(257, 4, 1, new long[]{n19}));
        treeSet.add(new TIFFField(258, 3, n21, nArray));
        treeSet.add(new TIFFField(259, 3, 1, new int[]{n15}));
        treeSet.add(new TIFFField(262, 3, 1, new int[]{n14}));
        if (!bl2) {
            treeSet.add(new TIFFField(273, 4, n11, lArray2));
        }
        treeSet.add(new TIFFField(277, 3, 1, new int[]{n21}));
        if (!bl2) {
            treeSet.add(new TIFFField(278, 4, 1, new long[]{n12}));
            treeSet.add(new TIFFField(279, 4, n11, lArray));
        }
        if (nArray2 != null) {
            treeSet.add(new TIFFField(320, 3, n23, nArray2));
        }
        if (bl2) {
            treeSet.add(new TIFFField(322, 4, 1, new long[]{n13}));
            treeSet.add(new TIFFField(323, 4, 1, new long[]{n12}));
            treeSet.add(new TIFFField(324, 4, n11, lArray2));
            treeSet.add(new TIFFField(325, 4, n11, lArray));
        }
        if (n25 > 0) {
            object5 = new int[n25];
            n10 = 0;
            while (n10 < n25) {
                object5[n10] = n26;
                ++n10;
            }
            treeSet.add(new TIFFField(338, 3, n25, object5));
        }
        if (n22 != 0) {
            object5 = new int[n21];
            object5[0] = n22 == 4 ? 3 : (n22 == 1 ? 1 : 2);
            n10 = 1;
            while (n10 < n21) {
                object5[n10] = object5[0];
                ++n10;
            }
            treeSet.add(new TIFFField(339, 3, n21, object5));
        }
        object5 = null;
        com.sun.image.codec.jpeg.JPEGImageEncoder jPEGImageEncoder = null;
        int n37 = 0;
        if (n15 == 7) {
            n37 = 0;
            switch (n24) {
                case 2: 
                case 3: {
                    n37 = 1;
                    break;
                }
                case 4: {
                    n37 = 2;
                    break;
                }
                case 6: {
                    n37 = 3;
                }
            }
            object4 = renderedImage.getTile(0, 0);
            object5 = JPEGCodec.getDefaultJPEGEncodeParam((Raster)object4, (int)n37);
            JPEGImageEncoder.modifyEncodeParam(jPEGEncodeParam, (com.sun.image.codec.jpeg.JPEGEncodeParam)object5, n21);
            if (jPEGEncodeParam.getWriteImageOnly()) {
                object5.setImageInfoValid(false);
                object5.setTableInfoValid(true);
                object3 = new ByteArrayOutputStream();
                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)object3, (com.sun.image.codec.jpeg.JPEGEncodeParam)object5);
                jPEGImageEncoder.encode((Raster)object4);
                object2 = ((ByteArrayOutputStream)object3).toByteArray();
                treeSet.add(new TIFFField(347, 7, ((Object)object2).length, object2));
                jPEGImageEncoder = null;
            }
        }
        if (n24 == 6) {
            int n38 = 1;
            int n39 = 1;
            if (n15 == 7) {
                n38 = jPEGEncodeParam.getHorizontalSubsampling(0);
                n39 = jPEGEncodeParam.getVerticalSubsampling(0);
                int n40 = 1;
                while (n40 < n21) {
                    n9 = jPEGEncodeParam.getHorizontalSubsampling(n40);
                    if (n9 > n38) {
                        n38 = n9;
                    }
                    if ((n8 = jPEGEncodeParam.getVerticalSubsampling(n40)) > n39) {
                        n39 = n8;
                    }
                    ++n40;
                }
            }
            treeSet.add(new TIFFField(530, 3, 2, new int[]{n38, n39}));
            treeSet.add(new TIFFField(531, 3, 1, new int[]{n15 == 7 ? 1 : 2}));
            object2 = n15 == 7 ? (Object)new long[][]{{0L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}} : (Object)new long[][]{{15L, 1L}, {235L, 1L}, {128L, 1L}, {240L, 1L}, {128L, 1L}, {240L, 1L}};
            treeSet.add(new TIFFField(532, 5, 6, object2));
        }
        if ((object4 = tIFFEncodeParam.getExtraFields()) != null) {
            object3 = new ArrayList<Integer>(treeSet.size());
            object2 = treeSet.iterator();
            while (object2.hasNext()) {
                TIFFField tIFFField = (TIFFField)object2.next();
                ((ArrayList)object3).add(new Integer(tIFFField.getTag()));
            }
            n9 = ((TIFFField[])object4).length;
            n8 = 0;
            while (n8 < n9) {
                TIFFField tIFFField = object4[n8];
                Integer n41 = new Integer(tIFFField.getTag());
                if (!((ArrayList)object3).contains(n41)) {
                    treeSet.add(tIFFField);
                    ((ArrayList)object3).add(n41);
                }
                ++n8;
            }
        }
        int n42 = this.getDirectorySize(treeSet);
        lArray2[0] = n + n42;
        object2 = null;
        byte[] byArray4 = null;
        File file = null;
        int n43 = 0;
        boolean bl4 = false;
        Deflater deflater = null;
        int n44 = -1;
        boolean bl5 = false;
        if (n15 == 1) {
            n7 = 0;
            if (nArray[0] == 16 && lArray2[0] % 2L != 0L) {
                n7 = 1;
                lArray2[0] = lArray2[0] + 1L;
            } else if (nArray[0] == 32 && lArray2[0] % 4L != 0L) {
                n7 = (int)(4L - lArray2[0] % 4L);
                lArray2[0] = lArray2[0] + (long)n7;
            }
            int n45 = 1;
            while (n45 < n11) {
                lArray2[n45] = lArray2[n45 - 1] + lArray[n45 - 1];
                ++n45;
            }
            if (!bl && (n43 = (int)(lArray2[0] + l)) % 2 != 0) {
                ++n43;
                bl4 = true;
            }
            this.writeDirectory(n, treeSet, n43);
            if (n7 != 0) {
                n6 = 0;
                while (n6 < n7) {
                    this.output.write(0);
                    ++n6;
                }
            }
        } else {
            if (this.output instanceof SeekableOutputStream) {
                ((SeekableOutputStream)this.output).seek(lArray2[0]);
            } else {
                object2 = this.output;
                try {
                    file = File.createTempFile("jai-SOS-", ".tmp");
                    file.deleteOnExit();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    this.output = new SeekableOutputStream(randomAccessFile);
                }
                catch (Exception exception) {
                    this.output = new ByteArrayOutputStream((int)l);
                }
            }
            n7 = 0;
            switch (n15) {
                case 32773: {
                    n7 = (int)(l3 + (l2 + 127L) / 128L * (long)n12);
                    break;
                }
                case 7: {
                    n7 = 0;
                    if (n24 == 6 && colorModel != null && colorModel.getColorSpace().getType() == 5) {
                        bl5 = true;
                    }
                }
                case 32946: {
                    n7 = (int)l3;
                    deflater = new Deflater(tIFFEncodeParam.getDeflateLevel());
                    break;
                }
                default: {
                    n7 = 0;
                }
            }
            if (n7 != 0) {
                byArray4 = new byte[n7];
            }
        }
        int[] nArray3 = null;
        float[] fArray = null;
        n6 = nArray[0] == 1 && sampleModel instanceof MultiPixelPackedSampleModel && n22 == 0 || nArray[0] == 8 && sampleModel instanceof ComponentSampleModel ? 1 : 0;
        byte[] byArray5 = null;
        if (n15 != 7) {
            if (n22 == 0) {
                byArray5 = new byte[n12 * n13 * n21];
            } else if (bl3) {
                byArray5 = new byte[2 * n12 * n13 * n21];
            } else if (n22 == 3 || n22 == 4) {
                byArray5 = new byte[4 * n12 * n13 * n21];
            }
        }
        int n46 = n17 + n19;
        int n47 = n16 + n18;
        int n48 = 0;
        int n49 = n17;
        while (n49 < n46) {
            n5 = bl2 ? n12 : Math.min(n12, n46 - n49);
            n4 = n5 * n13 * n21;
            n3 = n16;
            while (n3 < n47) {
                int n50;
                int n51;
                int n52;
                object = renderedImage.getData(new Rectangle(n3, n49, n13, n5));
                n2 = 0;
                if (n15 != 7) {
                    if (n6 != 0) {
                        if (nArray[0] == 8) {
                            ComponentSampleModel componentSampleModel = (ComponentSampleModel)((Raster)object).getSampleModel();
                            int[] nArray4 = componentSampleModel.getBankIndices();
                            int[] nArray5 = componentSampleModel.getBandOffsets();
                            n52 = componentSampleModel.getPixelStride();
                            n51 = componentSampleModel.getScanlineStride();
                            if (n52 != n21 || (long)n51 != l2) {
                                n2 = 0;
                            } else {
                                n2 = 1;
                                n50 = 0;
                                while (n2 != 0 && n50 < n21) {
                                    if (nArray4[n50] != 0 || nArray5[n50] != n50) {
                                        n2 = 0;
                                    }
                                    ++n50;
                                }
                            }
                        } else {
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)((Raster)object).getSampleModel();
                            if (multiPixelPackedSampleModel.getNumBands() == 1 && multiPixelPackedSampleModel.getDataBitOffset() == 0 && multiPixelPackedSampleModel.getPixelBitStride() == 1) {
                                n2 = 1;
                            }
                        }
                    }
                    if (n2 == 0) {
                        if (n22 == 4) {
                            fArray = ((Raster)object).getPixels(n3, n49, n13, n5, fArray);
                        } else {
                            nArray3 = ((Raster)object).getPixels(n3, n49, n13, n5, nArray3);
                        }
                    }
                }
                int n53 = 0;
                int n54 = 0;
                switch (nArray[0]) {
                    case 1: {
                        int n55;
                        if (n2 != 0) {
                            byte[] byArray6 = ((DataBufferByte)((Raster)object).getDataBuffer()).getData();
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)((Raster)object).getSampleModel();
                            n50 = multiPixelPackedSampleModel.getScanlineStride();
                            int n56 = multiPixelPackedSampleModel.getOffset(n3 - ((Raster)object).getSampleModelTranslateX(), n49 - ((Raster)object).getSampleModelTranslateY());
                            if (n50 == (int)l2) {
                                System.arraycopy(byArray6, n56, byArray5, 0, (int)l2 * n5);
                            } else {
                                int n57 = 0;
                                n55 = 0;
                                while (n55 < n5) {
                                    System.arraycopy(byArray6, n56, byArray5, n57, (int)l2);
                                    n56 += n50;
                                    n57 += (int)l2;
                                    ++n55;
                                }
                            }
                        } else {
                            int n58 = 0;
                            n52 = 0;
                            while (n52 < n5) {
                                n51 = 0;
                                while (n51 < n13 / 8) {
                                    n53 = nArray3[n58++] << 7 | nArray3[n58++] << 6 | nArray3[n58++] << 5 | nArray3[n58++] << 4 | nArray3[n58++] << 3 | nArray3[n58++] << 2 | nArray3[n58++] << 1 | nArray3[n58++];
                                    byArray5[n54++] = (byte)n53;
                                    ++n51;
                                }
                                if (n13 % 8 > 0) {
                                    n53 = 0;
                                    n50 = 0;
                                    while (n50 < n13 % 8) {
                                        n53 |= nArray3[n58++] << 7 - n50;
                                        ++n50;
                                    }
                                    byArray5[n54++] = (byte)n53;
                                }
                                ++n52;
                            }
                        }
                        if (n15 == 1) {
                            this.output.write(byArray5, 0, n5 * ((n13 + 7) / 8));
                            break;
                        }
                        if (n15 == 32773) {
                            int n59 = TIFFImageEncoder.compressPackBits(byArray5, n5, (int)l2, byArray4);
                            lArray[n48++] = n59;
                            this.output.write(byArray4, 0, n59);
                            break;
                        }
                        if (n15 != 32946) break;
                        int n60 = TIFFImageEncoder.deflate(deflater, byArray5, byArray4);
                        lArray[n48++] = n60;
                        this.output.write(byArray4, 0, n60);
                        break;
                    }
                    case 4: {
                        int n61 = 0;
                        n52 = 0;
                        while (n52 < n5) {
                            n51 = 0;
                            while (n51 < n13 / 2) {
                                n53 = nArray3[n61++] << 4 | nArray3[n61++];
                                byArray5[n54++] = (byte)n53;
                                ++n51;
                            }
                            if (n13 % 2 == 1) {
                                n53 = nArray3[n61++] << 4;
                                byArray5[n54++] = (byte)n53;
                            }
                            ++n52;
                        }
                        if (n15 == 1) {
                            this.output.write(byArray5, 0, n5 * ((n13 + 1) / 2));
                            break;
                        }
                        if (n15 == 32773) {
                            n51 = TIFFImageEncoder.compressPackBits(byArray5, n5, (int)l2, byArray4);
                            lArray[n48++] = n51;
                            this.output.write(byArray4, 0, n51);
                            break;
                        }
                        if (n15 != 32946) break;
                        n51 = TIFFImageEncoder.deflate(deflater, byArray5, byArray4);
                        lArray[n48++] = n51;
                        this.output.write(byArray4, 0, n51);
                        break;
                    }
                    case 8: {
                        int n55;
                        if (n15 != 7) {
                            if (n2 != 0) {
                                byte[] byArray7 = ((DataBufferByte)((Raster)object).getDataBuffer()).getData();
                                ComponentSampleModel componentSampleModel = (ComponentSampleModel)((Raster)object).getSampleModel();
                                int n62 = componentSampleModel.getOffset(n3 - ((Raster)object).getSampleModelTranslateX(), n49 - ((Raster)object).getSampleModelTranslateY());
                                int n63 = componentSampleModel.getScanlineStride();
                                if (n63 == (int)l2) {
                                    System.arraycopy(byArray7, n62, byArray5, 0, (int)l2 * n5);
                                } else {
                                    n55 = 0;
                                    int n64 = 0;
                                    while (n64 < n5) {
                                        System.arraycopy(byArray7, n62, byArray5, n55, (int)l2);
                                        n62 += n63;
                                        n55 += (int)l2;
                                        ++n64;
                                    }
                                }
                            } else {
                                n51 = 0;
                                while (n51 < n4) {
                                    byArray5[n51] = (byte)nArray3[n51];
                                    ++n51;
                                }
                            }
                        }
                        if (n15 == 1) {
                            this.output.write(byArray5, 0, n4);
                            break;
                        }
                        if (n15 == 32773) {
                            n51 = TIFFImageEncoder.compressPackBits(byArray5, n5, (int)l2, byArray4);
                            lArray[n48++] = n51;
                            this.output.write(byArray4, 0, n51);
                            break;
                        }
                        if (n15 == 7) {
                            long l4 = this.getOffset(this.output);
                            if (jPEGImageEncoder == null || object5.getWidth() != ((Raster)object).getWidth() || object5.getHeight() != ((Raster)object).getHeight()) {
                                object5 = JPEGCodec.getDefaultJPEGEncodeParam((Raster)object, (int)n37);
                                JPEGImageEncoder.modifyEncodeParam(jPEGEncodeParam, (com.sun.image.codec.jpeg.JPEGEncodeParam)object5, n21);
                                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)this.output, (com.sun.image.codec.jpeg.JPEGEncodeParam)object5);
                            }
                            if (bl5) {
                                WritableRaster writableRaster = null;
                                if (object instanceof WritableRaster) {
                                    writableRaster = (WritableRaster)object;
                                } else {
                                    writableRaster = ((Raster)object).createCompatibleWritableRaster();
                                    writableRaster.setRect((Raster)object);
                                }
                                if (writableRaster.getMinX() != 0 || writableRaster.getMinY() != 0) {
                                    writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
                                }
                                BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
                                jPEGImageEncoder.encode(bufferedImage);
                            } else {
                                jPEGImageEncoder.encode(((Raster)object).createTranslatedChild(0, 0));
                            }
                            long l5 = this.getOffset(this.output);
                            lArray[n48++] = (int)(l5 - l4);
                            break;
                        }
                        if (n15 != 32946) break;
                        n51 = TIFFImageEncoder.deflate(deflater, byArray5, byArray4);
                        lArray[n48++] = n51;
                        this.output.write(byArray4, 0, n51);
                        break;
                    }
                    case 16: {
                        n51 = 0;
                        n50 = 0;
                        while (n50 < n4) {
                            short s = (short)nArray3[n50];
                            byArray5[n51++] = (byte)((s & 0xFF00) >> 8);
                            byArray5[n51++] = (byte)(s & 0xFF);
                            ++n50;
                        }
                        if (n15 == 1) {
                            this.output.write(byArray5, 0, n4 * 2);
                            break;
                        }
                        if (n15 == 32773) {
                            int n65 = TIFFImageEncoder.compressPackBits(byArray5, n5, (int)l2, byArray4);
                            lArray[n48++] = n65;
                            this.output.write(byArray4, 0, n65);
                            break;
                        }
                        if (n15 != 32946) break;
                        int n66 = TIFFImageEncoder.deflate(deflater, byArray5, byArray4);
                        lArray[n48++] = n66;
                        this.output.write(byArray4, 0, n66);
                        break;
                    }
                    case 32: {
                        int n67;
                        int n68;
                        int n55;
                        if (n22 == 3) {
                            n68 = 0;
                            n67 = 0;
                            while (n67 < n4) {
                                n55 = nArray3[n67];
                                byArray5[n68++] = (byte)((n55 & 0xFF000000) >> 24);
                                byArray5[n68++] = (byte)((n55 & 0xFF0000) >> 16);
                                byArray5[n68++] = (byte)((n55 & 0xFF00) >> 8);
                                byArray5[n68++] = (byte)(n55 & 0xFF);
                                ++n67;
                            }
                        } else {
                            n68 = 0;
                            n67 = 0;
                            while (n67 < n4) {
                                n55 = Float.floatToIntBits(fArray[n67]);
                                byArray5[n68++] = (byte)((n55 & 0xFF000000) >> 24);
                                byArray5[n68++] = (byte)((n55 & 0xFF0000) >> 16);
                                byArray5[n68++] = (byte)((n55 & 0xFF00) >> 8);
                                byArray5[n68++] = (byte)(n55 & 0xFF);
                                ++n67;
                            }
                        }
                        if (n15 == 1) {
                            this.output.write(byArray5, 0, n4 * 4);
                            break;
                        }
                        if (n15 == 32773) {
                            n68 = TIFFImageEncoder.compressPackBits(byArray5, n5, (int)l2, byArray4);
                            lArray[n48++] = n68;
                            this.output.write(byArray4, 0, n68);
                            break;
                        }
                        if (n15 != 32946) break;
                        n68 = TIFFImageEncoder.deflate(deflater, byArray5, byArray4);
                        lArray[n48++] = n68;
                        this.output.write(byArray4, 0, n68);
                    }
                }
                n3 += n13;
            }
            n49 += n12;
        }
        if (n15 == 1) {
            if (bl4) {
                this.output.write(0);
            }
        } else {
            n5 = 0;
            n4 = 1;
            while (n4 < n11) {
                n3 = (int)lArray[n4 - 1];
                n5 += n3;
                lArray2[n4] = lArray2[n4 - 1] + (long)n3;
                ++n4;
            }
            n43 = bl ? 0 : n + n42 + (n5 += (int)lArray[n11 - 1]);
            boolean bl6 = bl4 = n43 % 2 != 0;
            if (object2 == null) {
                if (bl4) {
                    this.output.write(0);
                }
                SeekableOutputStream seekableOutputStream = (SeekableOutputStream)this.output;
                long l6 = seekableOutputStream.getFilePointer();
                seekableOutputStream.seek(n);
                this.writeDirectory(n, treeSet, n43);
                seekableOutputStream.seek(l6);
            } else if (file != null) {
                FileInputStream fileInputStream = new FileInputStream(file);
                this.output.close();
                this.output = object2;
                this.writeDirectory(n, treeSet, n43);
                object = new byte[8192];
                n2 = 0;
                while (n2 < n5) {
                    int n69 = fileInputStream.read((byte[])object);
                    if (n69 == -1) break;
                    this.output.write((byte[])object, 0, n69);
                    n2 += n69;
                }
                fileInputStream.close();
                file.delete();
                if (bl4) {
                    this.output.write(0);
                }
            } else if (this.output instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.output;
                this.output = object2;
                this.writeDirectory(n, treeSet, n43);
                byteArrayOutputStream.writeTo(this.output);
                if (bl4) {
                    this.output.write(0);
                }
            } else {
                throw new IllegalStateException();
            }
        }
        return n43;
    }

    private int getDirectorySize(SortedSet sortedSet) {
        int n = sortedSet.size();
        int n2 = 2 + n * 12 + 4;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            TIFFField tIFFField = (TIFFField)iterator.next();
            int n3 = tIFFField.getCount() * sizeOfType[tIFFField.getType()];
            if (n3 <= 4) continue;
            n2 += n3;
        }
        return n2;
    }

    private void writeFileHeader() throws IOException {
        this.output.write(77);
        this.output.write(77);
        this.output.write(0);
        this.output.write(42);
        this.writeLong(8L);
    }

    private void writeDirectory(int n, SortedSet sortedSet, int n2) throws IOException {
        int n3 = sortedSet.size();
        long l = n + 12 * n3 + 4 + 2;
        ArrayList<TIFFField> arrayList = new ArrayList<TIFFField>();
        this.writeUnsignedShort(n3);
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            TIFFField tIFFField = (TIFFField)iterator.next();
            int n4 = tIFFField.getTag();
            this.writeUnsignedShort(n4);
            int n5 = tIFFField.getType();
            this.writeUnsignedShort(n5);
            int n6 = tIFFField.getCount();
            int n7 = TIFFImageEncoder.getValueSize(tIFFField);
            this.writeLong(n5 == 2 ? (long)n7 : (long)n6);
            if (n7 > 4) {
                this.writeLong(l);
                l += (long)n7;
                arrayList.add(tIFFField);
                continue;
            }
            this.writeValuesAsFourBytes(tIFFField);
        }
        this.writeLong(n2);
        int n8 = 0;
        while (n8 < arrayList.size()) {
            this.writeValues((TIFFField)arrayList.get(n8));
            ++n8;
        }
    }

    private static final int getValueSize(TIFFField tIFFField) {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        int n3 = 0;
        if (n == 2) {
            int n4 = 0;
            while (n4 < n2) {
                byte[] byArray = tIFFField.getAsString(n4).getBytes();
                n3 += byArray.length;
                if (byArray[byArray.length - 1] != 0) {
                    ++n3;
                }
                ++n4;
            }
        } else {
            n3 = n2 * sizeOfType[n];
        }
        return n3;
    }

    private void writeValuesAsFourBytes(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: {
                byte[] byArray = tIFFField.getAsBytes();
                int n3 = 0;
                while (n3 < n2) {
                    this.output.write(byArray[n3]);
                    ++n3;
                }
                int n4 = 0;
                while (n4 < 4 - n2) {
                    this.output.write(0);
                    ++n4;
                }
                break;
            }
            case 3: {
                int[] nArray = tIFFField.getAsInts();
                int n5 = 0;
                while (n5 < n2) {
                    this.writeUnsignedShort(nArray[n5]);
                    ++n5;
                }
                int n6 = 0;
                while (n6 < 2 - n2) {
                    this.writeUnsignedShort(0);
                    ++n6;
                }
                break;
            }
            case 4: {
                long[] lArray = tIFFField.getAsLongs();
                int n7 = 0;
                while (n7 < n2) {
                    this.writeLong(lArray[n7]);
                    ++n7;
                }
                break;
            }
        }
    }

    private void writeValues(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: 
            case 6: 
            case 7: {
                byte[] byArray = tIFFField.getAsBytes();
                int n3 = 0;
                while (n3 < n2) {
                    this.output.write(byArray[n3]);
                    ++n3;
                }
                break;
            }
            case 3: 
            case 8: {
                int[] nArray = tIFFField.getAsInts();
                int n4 = 0;
                while (n4 < n2) {
                    this.writeUnsignedShort(nArray[n4]);
                    ++n4;
                }
                break;
            }
            case 4: 
            case 9: {
                long[] lArray = tIFFField.getAsLongs();
                int n5 = 0;
                while (n5 < n2) {
                    this.writeLong(lArray[n5]);
                    ++n5;
                }
                break;
            }
            case 11: {
                float[] fArray = tIFFField.getAsFloats();
                int n6 = 0;
                while (n6 < n2) {
                    int n7 = Float.floatToIntBits(fArray[n6]);
                    this.writeLong(n7);
                    ++n6;
                }
                break;
            }
            case 12: {
                double[] dArray = tIFFField.getAsDoubles();
                int n8 = 0;
                while (n8 < n2) {
                    long l = Double.doubleToLongBits(dArray[n8]);
                    this.writeLong((int)(l >> 32));
                    this.writeLong((int)(l & 0xFFFFFFFFFFFFFFFFL));
                    ++n8;
                }
                break;
            }
            case 5: 
            case 10: {
                long[][] lArray = tIFFField.getAsRationals();
                int n9 = 0;
                while (n9 < n2) {
                    this.writeLong(lArray[n9][0]);
                    this.writeLong(lArray[n9][1]);
                    ++n9;
                }
                break;
            }
            case 2: {
                int n10 = 0;
                while (n10 < n2) {
                    byte[] byArray = tIFFField.getAsString(n10).getBytes();
                    this.output.write(byArray);
                    if (byArray[byArray.length - 1] != 0) {
                        this.output.write(0);
                    }
                    ++n10;
                }
                break;
            }
            default: {
                throw new Error(JaiI18N.getString("TIFFImageEncoder10"));
            }
        }
    }

    private void writeUnsignedShort(int n) throws IOException {
        this.output.write((n & 0xFF00) >>> 8);
        this.output.write(n & 0xFF);
    }

    private void writeLong(long l) throws IOException {
        this.output.write((int)((l & 0xFFFFFFFFFF000000L) >>> 24));
        this.output.write((int)((l & 0xFF0000L) >>> 16));
        this.output.write((int)((l & 0xFF00L) >>> 8));
        this.output.write((int)l & 0xFF);
    }

    private long getOffset(OutputStream outputStream) throws IOException {
        if (outputStream instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)outputStream).size();
        }
        if (outputStream instanceof SeekableOutputStream) {
            return ((SeekableOutputStream)outputStream).getFilePointer();
        }
        throw new IllegalStateException();
    }

    private static int compressPackBits(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            n4 = TIFFImageEncoder.packBits(byArray, n3, n2, byArray2, n4);
            n3 += n2;
            ++n5;
        }
        return n4;
    }

    private static int packBits(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n + n2 - 1;
        int n5 = n4 - 1;
        while (n <= n4) {
            int n6 = 1;
            byte by = byArray[n];
            while (n6 < 127 && n < n4 && byArray[n] == byArray[n + 1]) {
                ++n6;
                ++n;
            }
            if (n6 > 1) {
                ++n;
                byArray2[n3++] = (byte)(-(n6 - 1));
                byArray2[n3++] = by;
            }
            n6 = 0;
            int n7 = n3;
            while (n6 < 128 && (n < n4 && byArray[n] != byArray[n + 1] || n < n5 && byArray[n] != byArray[n + 2])) {
                ++n6;
                byArray2[++n3] = byArray[n++];
            }
            if (n6 > 0) {
                byArray2[n7] = (byte)(n6 - 1);
                ++n3;
            }
            if (n != n4) continue;
            if (n6 > 0 && n6 < 128) {
                int n8 = n7;
                byArray2[n8] = (byte)(byArray2[n8] + 1);
                byArray2[n3++] = byArray[n++];
                continue;
            }
            byArray2[n3++] = 0;
            byArray2[n3++] = byArray[n++];
        }
        return n3;
    }

    private static int deflate(Deflater deflater, byte[] byArray, byte[] byArray2) {
        deflater.setInput(byArray);
        deflater.finish();
        int n = deflater.deflate(byArray2);
        deflater.reset();
        return n;
    }
}

