/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import com.sun.media.jai.codecimpl.util.RasterFactory;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class PNMImage
extends SimpleRenderedImage {
    private static final int PBM_ASCII = 49;
    private static final int PGM_ASCII = 50;
    private static final int PPM_ASCII = 51;
    private static final int PBM_RAW = 52;
    private static final int PGM_RAW = 53;
    private static final int PPM_RAW = 54;
    private static final int LINE_FEED = 10;
    private SeekableStream input;
    private byte[] lineSeparator;
    private int variant;
    private int maxValue;
    private WritableRaster theTile = null;
    private int numBands;
    private int dataType;

    public PNMImage(SeekableStream seekableStream) {
        this.input = seekableStream;
        String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        this.lineSeparator = string.getBytes();
        try {
            if (this.input.read() != 80) {
                throw new RuntimeException(JaiI18N.getString("PNMImageDecoder0"));
            }
            this.variant = this.input.read();
            if (this.variant < 49 || this.variant > 54) {
                throw new RuntimeException(JaiI18N.getString("PNMImageDecoder1"));
            }
            this.width = this.readInteger(this.input);
            this.height = this.readInteger(this.input);
            this.maxValue = this.variant == 49 || this.variant == 52 ? 1 : this.readInteger(this.input);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(JaiI18N.getString("PNMImageDecoder2"));
        }
        if (this.isRaw(this.variant) && this.maxValue >= 256) {
            this.maxValue = 255;
        }
        this.tileWidth = this.width;
        this.tileHeight = this.height;
        this.numBands = this.variant == 51 || this.variant == 54 ? 3 : 1;
        this.dataType = this.maxValue < 256 ? 0 : (this.maxValue < 65536 ? 1 : 3);
        if (this.variant == 49 || this.variant == 52) {
            this.sampleModel = new MultiPixelPackedSampleModel(0, this.width, this.height, 1);
            this.colorModel = ImageCodec.createGrayIndexColorModel(this.sampleModel, true);
        } else {
            this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(this.dataType, this.width, this.height, this.numBands);
            this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
        }
    }

    private boolean isRaw(int n) {
        return n >= 52;
    }

    private int readInteger(SeekableStream seekableStream) throws IOException {
        int n;
        int n2 = 0;
        boolean bl = false;
        while ((n = seekableStream.read()) != -1) {
            char c = (char)n;
            if (Character.isDigit(c)) {
                n2 = n2 * 10 + Character.digit(c, 10);
                bl = true;
                continue;
            }
            if (c == '#') {
                int n3 = this.lineSeparator.length;
                while ((n = seekableStream.read()) != -1) {
                    boolean bl2 = false;
                    int n4 = 0;
                    while (n4 < n3) {
                        if (n == this.lineSeparator[n4]) {
                            bl2 = true;
                            break;
                        }
                        ++n4;
                    }
                    if (bl2) break;
                }
                if (n == -1) break;
            }
            if (bl) break;
        }
        return n2;
    }

    private Raster computeTile(int n, int n2) {
        if (this.theTile != null) {
            return this.theTile;
        }
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        this.theTile = Raster.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = this.theTile.getBounds();
        try {
            block35: {
                switch (this.variant) {
                    case 49: 
                    case 52: {
                        DataBuffer dataBuffer = this.theTile.getDataBuffer();
                        byte[] byArray = new byte[8 * this.width];
                        byte[] byArray2 = null;
                        if (this.isRaw(this.variant)) {
                            byArray2 = new byte[this.width];
                        }
                        int n3 = 0;
                        while (n3 < this.height) {
                            int n4;
                            int n5 = Math.min(8, this.height - n3);
                            int n6 = (n5 * this.width + 7) / 8;
                            if (this.isRaw(this.variant)) {
                                n4 = 0;
                                while (n4 < n6) {
                                    n4 += this.input.read(byArray2, n4, n6 - n4);
                                }
                                int n7 = 0;
                                while (n7 < n6) {
                                    byte by = byArray2[n7];
                                    byArray[8 * n7] = (byte)(by >> 7 & 1);
                                    byArray[8 * n7 + 1] = (byte)(by >> 6 & 1);
                                    byArray[8 * n7 + 2] = (byte)(by >> 5 & 1);
                                    byArray[8 * n7 + 3] = (byte)(by >> 4 & 1);
                                    byArray[8 * n7 + 4] = (byte)(by >> 3 & 1);
                                    byArray[8 * n7 + 5] = (byte)(by >> 2 & 1);
                                    byArray[8 * n7 + 6] = (byte)(by >> 1 & 1);
                                    byArray[8 * n7 + 7] = (byte)(by & 1);
                                    ++n7;
                                }
                            } else {
                                n4 = 0;
                                while (n4 < n5 * this.width) {
                                    byArray[n4] = (byte)this.readInteger(this.input);
                                    ++n4;
                                }
                            }
                            this.sampleModel.setDataElements(rectangle.x, n3, rectangle.width, n5, byArray, dataBuffer);
                            n3 += 8;
                        }
                        break;
                    }
                    case 50: 
                    case 51: 
                    case 53: 
                    case 54: {
                        int n8 = this.width * this.height * this.numBands;
                        switch (this.dataType) {
                            case 0: {
                                DataBufferByte dataBufferByte = (DataBufferByte)this.theTile.getDataBuffer();
                                byte[] byArray = dataBufferByte.getData();
                                if (this.isRaw(this.variant)) {
                                    this.input.readFully(byArray);
                                    if (this.numBands == 3) {
                                        int n9 = 0;
                                        while (n9 < n8) {
                                            byte by = byArray[n9];
                                            byArray[n9] = byArray[n9 + 2];
                                            byArray[n9 + 2] = by;
                                            n9 += 3;
                                        }
                                    }
                                } else if (this.numBands == 1) {
                                    int n10 = 0;
                                    while (n10 < n8) {
                                        byArray[n10] = (byte)this.readInteger(this.input);
                                        ++n10;
                                    }
                                } else {
                                    int n11 = 0;
                                    while (n11 < n8) {
                                        byArray[n11 + 2] = (byte)this.readInteger(this.input);
                                        byArray[n11 + 1] = (byte)this.readInteger(this.input);
                                        byArray[n11] = (byte)this.readInteger(this.input);
                                        n11 += 3;
                                    }
                                }
                                break block35;
                            }
                            case 1: {
                                DataBufferUShort dataBufferUShort = (DataBufferUShort)this.theTile.getDataBuffer();
                                short[] sArray = dataBufferUShort.getData();
                                if (this.numBands == 1) {
                                    int n12 = 0;
                                    while (n12 < n8) {
                                        sArray[n12] = (short)this.readInteger(this.input);
                                        ++n12;
                                    }
                                } else {
                                    int n13 = 0;
                                    while (n13 < n8) {
                                        sArray[n13 + 2] = (short)this.readInteger(this.input);
                                        sArray[n13 + 1] = (short)this.readInteger(this.input);
                                        sArray[n13] = (short)this.readInteger(this.input);
                                        n13 += 3;
                                    }
                                }
                                break block35;
                            }
                            case 3: {
                                DataBufferInt dataBufferInt = (DataBufferInt)this.theTile.getDataBuffer();
                                int[] nArray = dataBufferInt.getData();
                                if (this.numBands == 1) {
                                    int n14 = 0;
                                    while (n14 < n8) {
                                        nArray[n14] = this.readInteger(this.input);
                                        ++n14;
                                    }
                                } else {
                                    int n15 = 0;
                                    while (n15 < n8) {
                                        nArray[n15 + 2] = this.readInteger(this.input);
                                        nArray[n15 + 1] = this.readInteger(this.input);
                                        nArray[n15] = this.readInteger(this.input);
                                        n15 += 3;
                                    }
                                    break block1;
                                }
                            }
                        }
                    }
                }
            }
            this.input.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(JaiI18N.getString("PNMImageDecoder3"));
        }
        return this.theTile;
    }

    public synchronized Raster getTile(int n, int n2) {
        if (n != 0 || n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("PNMImageDecoder4"));
        }
        return this.computeTile(n, n2);
    }
}

