/*
 * Decompiled with CFR 0.152.
 */
package dbmaker.sql;

import dbmaker.sql.JdbcOdbc;
import dbmaker.sql.JdbcOdbcBoundParam;
import dbmaker.sql.JdbcOdbcConnection;
import dbmaker.sql.JdbcOdbcParameterMetaData;
import dbmaker.sql.JdbcOdbcResultSetMetaData;
import dbmaker.sql.JdbcOdbcStatement;
import dbmaker.sql.ODBCDef;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Vector;

public class JdbcOdbcPreparedStatement
extends JdbcOdbcStatement
implements PreparedStatement {
    protected JdbcOdbcBoundParam[] boundParam;
    private int nProj;
    private boolean hasParam;
    protected int nParam;
    protected static int PARAM_INT_LEN = 4;
    protected static int PARAM_REAL_LEN = 4;
    protected static int PARAM_FLOAT_LEN = 8;
    protected static int PARAM_DOUBLE_LEN = 8;
    protected static int PARAM_BIGINT_LEN = 8;
    protected static int PARAM_DATE_LEN = 32;
    protected static int PARAM_TIME_LEN = 32;
    protected static int PARAM_TIMESTAMP_LEN = 32;
    protected static int INPUT_STREAM_BUF_LEN = 2048;
    private String origSql = null;
    private static final int SET_ASCII_STREAM = 1;
    private static final int SET_BIG_DECINAL = 2;
    private static final int SET_BINARY_STREAM = 3;
    private static final int SET_BLOB = 4;
    private static final int SET_BOOLEAN = 5;
    private static final int SET_BYTE = 6;
    private static final int SET_BYTES = 7;
    private static final int SET_CHARACTER_STREAM = 8;
    private static final int SET_CLOB = 9;
    private static final int SET_DATE = 10;
    private static final int SET_DEFAULT = 11;
    private static final int SET_DOUBLE = 12;
    private static final int SET_FLOAT = 13;
    private static final int SET_INT = 14;
    private static final int SET_LONG = 15;
    private static final int SET_NULL = 16;
    private static final int SET_OBJECT = 17;
    private static final int SET_SHORT = 18;
    private static final int SET_STRING = 19;
    private static final int SET_TIME = 20;
    private static final int SET_TIMESTAMP = 21;
    private Param[] curBatch = null;
    private Vector batchVector = null;
    private boolean executingBatch = false;

    public JdbcOdbcPreparedStatement(JdbcOdbcConnection jdbcOdbcConnection, long l, String string) throws SQLException {
        super(jdbcOdbcConnection, l);
        this.origSql = string.toUpperCase();
        this.initialize();
    }

    private void initialize() throws SQLException {
        try {
            this.nParam = this.ODBCOBJ.jdbcNumParams(this.hSTMT);
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        if (this.nParam > 0) {
            this.boundParam = new JdbcOdbcBoundParam[this.nParam];
            int n = 0;
            while (n < this.nParam) {
                this.boundParam[n] = new JdbcOdbcBoundParam();
                this.boundParam[n].sqlType = (short)this.ODBCOBJ.jdbcGetParamType(this.hSTMT, n + 1);
                long[] lArray = new long[1];
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                this.ODBCOBJ.jdbcDescribeParam(this.hSTMT, n + 1, null, lArray, nArray, nArray2);
                this.boundParam[n].prec = (int)lArray[0];
                this.boundParam[n].releasePointers[4] = lArray[0];
                this.boundParam[n].releasePointers[5] = nArray[0];
                ++n;
            }
            this.hasParam = true;
        } else {
            this.hasParam = false;
        }
        try {
            this.nProj = this.ODBCOBJ.jdbcNumResultCol(this.hSTMT);
            if (this.nProj > 0) {
                this.hasResult = true;
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    protected void finalize() {
        this.trace("PreparedStatement.finalize()");
        try {
            if (!this.myConnection.fgJavaSP) {
                this.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.executeQuery");
        }
        this.checkClosed(this.isClosed());
        if (this.execute()) {
            return this.getResultSet();
        }
        return null;
    }

    public int executeUpdate() throws SQLException {
        int n = -1;
        if (this.needTrace) {
            this.trace("PreparedStatement.executeUpdate");
        }
        this.checkClosed(this.isClosed());
        if (!this.execute()) {
            n = this.getUpdateCount();
        }
        return n;
    }

    public int[] executeBatch() throws SQLException {
        if (this.needTrace) {
            this.trace("executeBatch");
        }
        if (this.batchVector == null || this.batchVector.size() == 0) {
            return new int[]{this.executeUpdate()};
        }
        int[] nArray = new int[this.batchVector.size() + 1];
        boolean bl = this.myConnection.getAutoCommit();
        this.myConnection.setAutoCommit(false);
        try {
            try {
                int n = 0;
                nArray[n++] = this.executeUpdate();
                this.executingBatch = true;
                Iterator iterator = ((AbstractList)this.batchVector).iterator();
                while (iterator.hasNext()) {
                    Param[] paramArray = (Param[])iterator.next();
                    int n2 = 0;
                    while (n2 < paramArray.length) {
                        int n3 = n2 + 1;
                        if (paramArray[n2] != null) {
                            Object[] objectArray = paramArray[n2].values;
                            switch (paramArray[n2].type) {
                                case 1: {
                                    this.setAsciiStream(n3, (InputStream)objectArray[0], (Integer)objectArray[1]);
                                    break;
                                }
                                case 2: {
                                    this.setBigDecimal(n3, (BigDecimal)objectArray[0]);
                                    break;
                                }
                                case 3: {
                                    this.setBinaryStream(n3, (InputStream)objectArray[0], (Integer)objectArray[1]);
                                    break;
                                }
                                case 4: {
                                    this.setBlob(n3, (Blob)objectArray[0]);
                                    break;
                                }
                                case 5: {
                                    this.setBoolean(n3, (Boolean)objectArray[0]);
                                    break;
                                }
                                case 6: {
                                    this.setByte(n3, (Byte)objectArray[0]);
                                    break;
                                }
                                case 7: {
                                    this.setBytes(n3, (byte[])objectArray[0]);
                                    break;
                                }
                                case 8: {
                                    this.setCharacterStream(n3, (Reader)objectArray[0], (Integer)objectArray[1]);
                                    break;
                                }
                                case 9: {
                                    this.setClob(n3, (Clob)objectArray[0]);
                                    break;
                                }
                                case 10: {
                                    this.setDate(n3, (Date)objectArray[0]);
                                    break;
                                }
                                case 11: {
                                    this.setDefault(n3, (Integer)objectArray[0]);
                                    break;
                                }
                                case 12: {
                                    this.setDouble(n3, (Double)objectArray[0]);
                                    break;
                                }
                                case 13: {
                                    this.setFloat(n3, ((Float)objectArray[0]).floatValue());
                                    break;
                                }
                                case 14: {
                                    this.setInt(n3, (Integer)objectArray[0]);
                                    break;
                                }
                                case 15: {
                                    this.setLong(n3, (Long)objectArray[0]);
                                    break;
                                }
                                case 16: {
                                    this.setNull(n3, (Integer)objectArray[0]);
                                    break;
                                }
                                case 17: {
                                    this.setObject(n3, objectArray[0], (Integer)objectArray[1], (int)((Integer)objectArray[2]));
                                    break;
                                }
                                case 18: {
                                    this.setShort(n3, (Short)objectArray[0]);
                                    break;
                                }
                                case 19: {
                                    this.setString(n3, (String)objectArray[0]);
                                    break;
                                }
                                case 20: {
                                    this.setTime(n3, (Time)objectArray[0]);
                                    break;
                                }
                                case 21: {
                                    this.setTimestamp(n3, (Timestamp)objectArray[0]);
                                }
                            }
                        }
                        ++n2;
                    }
                    nArray[n++] = this.executeUpdate();
                }
                this.myConnection.commit();
                this.batchVector = null;
                this.curBatch = null;
            }
            catch (SQLException sQLException) {
                this.myConnection.rollback();
                throw sQLException;
            }
            Object var10_10 = null;
            this.executingBatch = false;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.executingBatch = false;
            this.myConnection.setAutoCommit(bl);
            throw throwable;
        }
        this.myConnection.setAutoCommit(bl);
        return nArray;
    }

    public void clearBatch() throws SQLException {
        if (this.needTrace) {
            this.trace("clearBatch");
        }
        this.batchVector = null;
        this.curBatch = null;
    }

    public boolean execute() throws SQLException {
        JdbcOdbcConnection jdbcOdbcConnection;
        boolean bl = false;
        if (this.needTrace) {
            this.trace("Preparedstatemnt.execute");
        }
        this.checkClosed(this.isClosed());
        if (this.executed && this.myResultset != null && !this.myResultset.isClosed()) {
            this.JDBCError("JERR_PREV_RS_NOT_CLOSED", null);
        }
        try {
            JdbcOdbcConnection jdbcOdbcConnection2 = this.myConnection;
            synchronized (jdbcOdbcConnection2) {
                bl = this.ODBCOBJ.jdbcExecute(this.getHSTMT());
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        int n = 0;
        JdbcOdbcBoundParam jdbcOdbcBoundParam = null;
        InputStream inputStream = null;
        byte[] byArray = null;
        int n2 = 0;
        long l = 0L;
        long l2 = 0L;
        boolean bl2 = false;
        block36: while (bl) {
            try {
                n = -1;
                jdbcOdbcConnection = this.myConnection;
                synchronized (jdbcOdbcConnection) {
                    n = this.ODBCOBJ.jdbcParamData(this.getHSTMT());
                }
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
            if (n > 0) {
                int n3;
                long l3;
                jdbcOdbcBoundParam = this.boundParam[n - 1];
                inputStream = jdbcOdbcBoundParam.getInputStream();
                l = l2 = jdbcOdbcBoundParam.getInputStreamLen();
                n2 = (int)((l - 1L) / (long)INPUT_STREAM_BUF_LEN + 1L);
                int n4 = this.boundParam[n - 1].getStreamType();
                if (n4 == 1) {
                    byArray = new byte[INPUT_STREAM_BUF_LEN];
                    if (l == Integer.MAX_VALUE) {
                        do {
                            try {
                                l3 = inputStream.read(byArray);
                            }
                            catch (IOException iOException) {
                                throw new SQLException(iOException.getMessage());
                            }
                            if (l3 != -1L || l2 == 0L) {
                                try {
                                    jdbcOdbcConnection = this.myConnection;
                                    synchronized (jdbcOdbcConnection) {
                                        this.ODBCOBJ.jdbcPutData(this.getHSTMT(), byArray, l3);
                                    }
                                }
                                catch (SQLWarning sQLWarning) {
                                    this.lastWarning = sQLWarning;
                                }
                                bl2 = true;
                                continue;
                            }
                            if (bl2) continue block36;
                            this.JDBCError("JERR_CANNOT_GET_ENOUGH_STREAM", "" + l2);
                        } while (l3 == (long)INPUT_STREAM_BUF_LEN);
                        continue;
                    }
                    n3 = 0;
                    while (n3 < n2) {
                        try {
                            l3 = inputStream.read(byArray);
                        }
                        catch (IOException iOException) {
                            throw new SQLException(iOException.getMessage());
                        }
                        if (l3 != -1L || l2 == 0L) {
                            long l4 = l > (long)INPUT_STREAM_BUF_LEN ? (long)INPUT_STREAM_BUF_LEN : l;
                            try {
                                jdbcOdbcConnection = this.myConnection;
                                synchronized (jdbcOdbcConnection) {
                                    this.ODBCOBJ.jdbcPutData(this.getHSTMT(), byArray, l4);
                                }
                            }
                            catch (SQLWarning sQLWarning) {
                                this.lastWarning = sQLWarning;
                            }
                            bl2 = true;
                        } else {
                            if (bl2) continue block36;
                            this.JDBCError("JERR_CANNOT_GET_ENOUGH_STREAM", "" + l2);
                        }
                        ++n3;
                        l -= (long)INPUT_STREAM_BUF_LEN;
                    }
                    continue;
                }
                if (n4 != 2) continue;
                Reader reader = this.boundParam[n - 1].getReader();
                char[] cArray = new char[INPUT_STREAM_BUF_LEN];
                n3 = 0;
                while (n3 < n2) {
                    try {
                        l3 = reader.read(cArray);
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException.getMessage());
                    }
                    if (l3 != -1L) {
                        try {
                            byArray = new String(cArray, 0, (int)l3).getBytes(ODBCDef.DM_UNICODE);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            throw new SQLException("encoding unsupported");
                        }
                        jdbcOdbcConnection = this.myConnection;
                        synchronized (jdbcOdbcConnection) {
                            this.ODBCOBJ.jdbcPutData(this.getHSTMT(), byArray, byArray.length);
                        }
                        bl2 = true;
                    } else {
                        if (bl2) continue block36;
                        this.JDBCError("JERR_CANNOT_GET_ENOUGH_STREAM", "" + l2);
                    }
                    ++n3;
                    l -= (long)INPUT_STREAM_BUF_LEN;
                }
                continue;
            }
            bl = false;
        }
        try {
            jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.nProj = this.ODBCOBJ.jdbcNumResultCol(this.getHSTMT());
            }
            if (this.nProj > 0) {
                this.hasResult = true;
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        this.hasResult = this.nProj > 0;
        this.executed = true;
        jdbcOdbcConnection = (JdbcOdbcConnection)this.getConnection();
        if (jdbcOdbcConnection.getAutoCommit()) {
            jdbcOdbcConnection.closeBCList(true);
        }
        if (this.origSql.startsWith("SET") && !this.hasResult && this.getUpdateCount() == -1) {
            jdbcOdbcConnection.initDateTimeFormat();
        }
        return this.hasResult;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "PreparedStatement.executeQuery(String)", null);
    }

    public int executeUpdate(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "PreparedStatement.executeUpdate(String)", null);
    }

    public void setNull(int n, int n2) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setNull (" + n + ", " + n2 + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(16, new Object[]{new Integer(n2)});
            return;
        }
        if (n2 == 2004) {
            n2 = -4;
        } else if (n2 == 2005) {
            n2 = -1;
        } else if (n2 == 2011) {
            n2 = -16;
        } else if (n2 == 2) {
            n2 = 4;
        } else if (n2 == -3) {
            n2 = -2;
        } else if (n2 == -6) {
            n2 = 4;
        }
        this.checkType(n2);
        this.checkClosed(this.isClosed());
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        jdbcOdbcBoundParam.setInputParameter(true);
        jdbcOdbcBoundParam.setBoundValue(null);
        long[] lArray = jdbcOdbcBoundParam.getIndBuf();
        long[] lArray2 = jdbcOdbcBoundParam.releasePointers;
        if (n2 == -15) {
            n2 = -8;
        } else if (n2 == -16) {
            n2 = -10;
        }
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcBindInParameterNull(this.getHSTMT(), n, n2, lArray, lArray2);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setBoolean (" + n + ", " + bl + ")");
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(5, new Object[]{new Boolean(bl)});
            return;
        }
        short s = 0;
        if (bl) {
            s = 1;
        }
        this.setShort(n, s);
    }

    public void setByte(int n, byte by) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setByte (" + n + ", " + by + ")");
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(6, new Object[]{new Byte(by)});
            return;
        }
        this.setShort(n, by);
    }

    public void setShort(int n, short s) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setShort (" + n + ", " + s + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(18, new Object[]{new Short(s)});
            return;
        }
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        jdbcOdbcBoundParam.setInputParameter(true);
        jdbcOdbcBoundParam.setBoundValue(new Short(s));
        if (jdbcOdbcBoundParam.type != 5) {
            this.freeGlobalVar(jdbcOdbcBoundParam);
            jdbcOdbcBoundParam.dataBuf = jdbcOdbcBoundParam.allocDataBuf(PARAM_INT_LEN);
            jdbcOdbcBoundParam.type = (short)5;
        }
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcBindInParameterInt(this.getHSTMT(), n, 5, s, jdbcOdbcBoundParam.dataBuf, jdbcOdbcBoundParam.releasePointers);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setInt (" + n + ", " + n2 + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(14, new Object[]{new Integer(n2)});
            return;
        }
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        jdbcOdbcBoundParam.setInputParameter(true);
        jdbcOdbcBoundParam.setBoundValue(new Integer(n2));
        if (jdbcOdbcBoundParam.type != 4) {
            this.freeGlobalVar(jdbcOdbcBoundParam);
            jdbcOdbcBoundParam.dataBuf = jdbcOdbcBoundParam.allocDataBuf(PARAM_INT_LEN);
            jdbcOdbcBoundParam.type = (short)4;
        }
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcBindInParameterInt(this.getHSTMT(), n, 4, n2, jdbcOdbcBoundParam.dataBuf, jdbcOdbcBoundParam.releasePointers);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setFloat (" + n + ", " + f + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(13, new Object[]{new Float(f)});
            return;
        }
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        jdbcOdbcBoundParam.setInputParameter(true);
        jdbcOdbcBoundParam.setBoundValue(new Float(f));
        if (jdbcOdbcBoundParam.type != 6) {
            this.freeGlobalVar(jdbcOdbcBoundParam);
            jdbcOdbcBoundParam.dataBuf = jdbcOdbcBoundParam.allocDataBuf(PARAM_FLOAT_LEN);
            jdbcOdbcBoundParam.type = (short)6;
        }
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcBindInParameterFloat(this.getHSTMT(), n, 6, f, jdbcOdbcBoundParam.dataBuf, jdbcOdbcBoundParam.releasePointers);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setDouble (" + n + ", " + d + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(12, new Object[]{new Double(d)});
            return;
        }
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        if (jdbcOdbcBoundParam.sqlType == 3) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setGroupingUsed(false);
            numberFormat.setMaximumFractionDigits(100);
            this.setString(n, numberFormat.format(d));
        } else {
            jdbcOdbcBoundParam.setInputParameter(true);
            jdbcOdbcBoundParam.setBoundValue(new Double(d));
            if (jdbcOdbcBoundParam.type != 8) {
                this.freeGlobalVar(jdbcOdbcBoundParam);
                jdbcOdbcBoundParam.dataBuf = jdbcOdbcBoundParam.allocDataBuf(PARAM_DOUBLE_LEN);
                jdbcOdbcBoundParam.type = (short)8;
            }
            try {
                JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
                synchronized (jdbcOdbcConnection) {
                    this.ODBCOBJ.jdbcBindInParameterDouble(this.getHSTMT(), n, d, jdbcOdbcBoundParam.dataBuf, jdbcOdbcBoundParam.releasePointers);
                }
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
    }

    public void setString(int n, String string) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setString (" + n + ", " + string + ")");
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(19, new Object[]{string});
            return;
        }
        if (string == null) {
            this.setNull(n, this.boundParam[n - 1].type);
            return;
        }
        this.boundParam[n - 1].setBoundValue(string);
        this.setChar(n, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setBytes (" + n + ", " + byArray + ")");
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(7, new Object[]{byArray});
            return;
        }
        this.setBinary(n, -2, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setDate (" + n + ", " + date + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(10, new Object[]{date});
            return;
        }
        this.checkClosed(this.isClosed());
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        jdbcOdbcBoundParam.setInputParameter(true);
        jdbcOdbcBoundParam.setBoundValue(date);
        if (jdbcOdbcBoundParam.type != 9) {
            this.freeGlobalVar(jdbcOdbcBoundParam);
            jdbcOdbcBoundParam.dataBuf = jdbcOdbcBoundParam.allocDataBuf(PARAM_DATE_LEN);
            jdbcOdbcBoundParam.type = (short)9;
        }
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcBindInParameterDate(this.getHSTMT(), n, date, jdbcOdbcBoundParam.dataBuf, jdbcOdbcBoundParam.releasePointers);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setTime (" + n + ", " + time + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(20, new Object[]{time});
            return;
        }
        this.setString(n, ((JdbcOdbcConnection)this.getConnection()).getStringfromTime(time));
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setTimestamp (" + n + ", " + timestamp + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(21, new Object[]{timestamp});
            return;
        }
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        jdbcOdbcBoundParam.setInputParameter(true);
        jdbcOdbcBoundParam.setBoundValue(timestamp);
        if (jdbcOdbcBoundParam.type != 11) {
            this.freeGlobalVar(jdbcOdbcBoundParam);
            jdbcOdbcBoundParam.dataBuf = jdbcOdbcBoundParam.allocDataBuf(PARAM_TIMESTAMP_LEN);
            jdbcOdbcBoundParam.type = (short)11;
        }
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcBindInParameterTimestamp(this.getHSTMT(), n, timestamp, jdbcOdbcBoundParam.dataBuf, jdbcOdbcBoundParam.releasePointers);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            throw new SQLWarning("Prepared statement has bee close");
        }
        super.close();
        this.freeBoundParam();
    }

    public void clearParameters() throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.clearParameters");
        }
        this.checkClosed(this.isClosed());
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcFreeStmt(this.getHSTMT(), 3);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        this.freeBoundParam();
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        int n4 = 0;
        if (this.needTrace) {
            this.trace("PreparedStatement.setObject (" + n + ", " + object + ", " + n2 + ", " + n3 + ")");
        }
        if (object == null) {
            n4 = this.getSQLType(n2);
            this.setNull(n, n4);
            return;
        }
        String string = null;
        string = object instanceof byte[] ? new String("byte[]") : new String(object.getClass().getName());
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(17, new Object[]{object, new Integer(n2), new Integer(n3)});
            return;
        }
        switch (n2) {
            case 0: {
                n4 = this.getSQLType(n2);
                this.setNull(n, n4);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.math.BigDecimal") || string.equalsIgnoreCase("java.lang.Boolean") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.lang.Float") || string.equalsIgnoreCase("java.lang.Double") || string.equalsIgnoreCase("java.sql.Date") || string.equalsIgnoreCase("java.sql.Time") || string.equalsIgnoreCase("java.sql.Timestamp")) {
                    n4 = this.getSQLType(n2);
                    this.boundParam[n - 1].setBoundValue(object);
                    this.setChar(n, n4, object.toString());
                    break;
                }
                throw new SQLException("Conversion not supported by setObject!!");
            }
            case -4: 
            case -3: 
            case -2: {
                n4 = this.getSQLType(n2);
                this.setBinary(n, n4, (byte[])object);
                break;
            }
            case 4: {
                if (object instanceof Number) {
                    this.setInt(n, ((Number)object).intValue());
                    break;
                }
                if (string.equalsIgnoreCase("java.lang.String")) {
                    n4 = this.getSQLType(n2);
                    this.boundParam[n - 1].setBoundValue(object);
                    this.setChar(n, n4, (String)object);
                    break;
                }
                this.JDBCError("JERR_INV_JDBC_DATA_TYPE", "" + n2);
                break;
            }
            case 5: {
                if (object instanceof Number) {
                    this.setShort(n, ((Number)object).shortValue());
                    break;
                }
                if (string.equalsIgnoreCase("java.lang.String")) {
                    n4 = this.getSQLType(n2);
                    this.boundParam[n - 1].setBoundValue(object);
                    this.setChar(n, n4, (String)object);
                    break;
                }
                this.JDBCError("JERR_INV_JDBC_DATA_TYPE", "" + n2);
                break;
            }
            case -7: {
                this.setBoolean(n, (Boolean)object);
                break;
            }
            case 7: {
                if (object instanceof Number) {
                    this.setReal(n, ((Number)object).floatValue());
                    break;
                }
                if (string.equalsIgnoreCase("java.lang.String")) {
                    n4 = this.getSQLType(n2);
                    this.boundParam[n - 1].setBoundValue(object);
                    this.setChar(n, n4, (String)object);
                    break;
                }
                this.JDBCError("JERR_INV_JDBC_DATA_TYPE", "" + n2);
                break;
            }
            case 6: 
            case 8: {
                if (object instanceof Number) {
                    this.setDouble(n, ((Number)object).doubleValue());
                    break;
                }
                if (string.equalsIgnoreCase("java.lang.String")) {
                    n4 = this.getSQLType(n2);
                    this.boundParam[n - 1].setBoundValue(object);
                    this.setChar(n, n4, (String)object);
                    break;
                }
                this.JDBCError("JERR_INV_JDBC_DATA_TYPE", "" + n2);
                break;
            }
            case 3: {
                if (object instanceof BigDecimal) {
                    this.setBigDecimal(n, (BigDecimal)object);
                    break;
                }
                n4 = this.getSQLType(n2);
                this.boundParam[n - 1].setBoundValue(object);
                this.setChar(n, n4, object.toString());
                break;
            }
            case -5: {
                if (object instanceof Number) {
                    this.setLong(n, ((Number)object).longValue());
                    break;
                }
                if (string.equalsIgnoreCase("java.lang.String")) {
                    n4 = this.getSQLType(n2);
                    this.boundParam[n - 1].setBoundValue(object);
                    this.setChar(n, n4, (String)object);
                    break;
                }
                this.JDBCError("JERR_INV_JDBC_DATA_TYPE", "" + n2);
                break;
            }
            case 91: {
                if (string.equalsIgnoreCase("java.lang.String")) {
                    this.setDate(n, Date.valueOf(object.toString()));
                    break;
                }
                if (string.equalsIgnoreCase("java.sql.Timestamp")) {
                    this.setDate(n, new Date(((java.util.Date)Timestamp.valueOf(object.toString())).getTime()));
                    break;
                }
                if (string.equalsIgnoreCase("java.sql.Date")) {
                    this.setDate(n, (Date)object);
                    break;
                }
                throw new SQLException("Conversion not supported by setObject!!");
            }
            case 92: {
                if (string.equalsIgnoreCase("java.lang.String")) {
                    this.setTime(n, Time.valueOf(object.toString()));
                    break;
                }
                if (string.equalsIgnoreCase("java.sql.Timestamp")) {
                    this.setTime(n, new Time(((java.util.Date)Timestamp.valueOf(object.toString())).getTime()));
                    break;
                }
                if (string.equalsIgnoreCase("java.sql.Time")) {
                    this.setTime(n, (Time)object);
                    break;
                }
                throw new SQLException("Conversion not supported by setObject!!");
            }
            case 93: {
                if (string.equalsIgnoreCase("java.lang.String")) {
                    this.setTimestamp(n, Timestamp.valueOf(object.toString()));
                    break;
                }
                if (string.equalsIgnoreCase("java.sql.Date")) {
                    this.setTimestamp(n, new Timestamp(Date.valueOf(object.toString()).getTime()));
                    break;
                }
                if (string.equalsIgnoreCase("java.sql.Timestamp")) {
                    this.setTimestamp(n, (Timestamp)object);
                    break;
                }
                throw new SQLException("Conversion not supported by setObject!!");
            }
            case 2: {
                if (string.equalsIgnoreCase("java.lang.String")) {
                    this.setString(n, (String)object);
                    break;
                }
                this.JDBCError("JERR_DRIVER_NOT_SUPPORT_SQL_TYPE", "" + n2);
                break;
            }
            case -6: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                this.JDBCError("JERR_DRIVER_NOT_SUPPORT_SQL_TYPE", "" + n2);
            }
            default: {
                this.JDBCError("JERR_INV_JDBC_DATA_TYPE", "" + n2);
            }
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setObject (" + n + ", " + object + ", " + n2 + ")");
        }
        this.checkClosed(this.isClosed());
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setObject (" + n + ", " + object + ")");
        }
        this.checkClosed(this.isClosed());
        this.setObject(n, object, this.getObjectType(object), 0);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setAsciiStream (" + n + ", " + n2 + ")");
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(1, new Object[]{inputStream, new Integer(n2)});
            return;
        }
        this.setParamAtexec(n, inputStream, n2, 1, -1);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setBinaryStream (" + n + ", " + n2 + ")");
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(3, new Object[]{inputStream, new Integer(n2)});
            return;
        }
        this.setParamAtexec(n, inputStream, n2, -2, -4);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setBlob (" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(4, new Object[]{blob});
            return;
        }
        this.setParamAtexec(n, blob.getBinaryStream(), (int)blob.length(), -2, -4);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setClob (" + n + ")");
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(9, new Object[]{clob});
            return;
        }
        this.setParamAtexec(n, clob.getAsciiStream(), (int)clob.length(), 1, -1);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.getMetaData");
        }
        this.checkClosed(this.isClosed());
        if (this.hasResult) {
            return new JdbcOdbcResultSetMetaData(this.ODBCOBJ, this);
        }
        return null;
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setDate( " + n + "," + date + "," + calendar + ")");
        }
        this.checkClosed(this.isClosed());
        Date date2 = (Date)this.modifyDateTimeDiff(date, 91, calendar);
        this.setDate(n, date2);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setTime( " + n + "," + time + "," + calendar + ")");
        }
        this.checkClosed(this.isClosed());
        Time time2 = (Time)this.modifyDateTimeDiff(time, 92, calendar);
        this.setTime(n, time2);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setTimestamp( " + n + "," + timestamp + "," + calendar + ")");
        }
        this.checkClosed(this.isClosed());
        Timestamp timestamp2 = (Timestamp)this.modifyDateTimeDiff(timestamp, 93, calendar);
        this.setTimestamp(n, timestamp2);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setBigDecimal (" + n + ", " + bigDecimal + ")");
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(2, new Object[]{bigDecimal});
            return;
        }
        int n2 = 39;
        if (bigDecimal.abs() != bigDecimal) {
            ++n2;
        }
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
        String string = bigDecimal.toString();
        char c = decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
        if ((string = string.replace('.', c)).length() > n2) {
            this.JDBCError("JERR_DEC_EXCEED_MAX_DIGIT", " : 39");
        }
        this.boundParam[n - 1].setBoundValue(bigDecimal);
        this.setChar(n, string);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "PreparedStatement.setUnicodeStream(int, InputStream, int)", null);
    }

    public void addBatch(String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "PreparedStatement.addBatch(sql)", null);
    }

    public void addBatch() throws SQLException {
        if (this.curBatch != null) {
            this.batchVector.addElement(this.curBatch);
            this.curBatch = new Param[this.nParam];
        } else {
            this.batchVector = new Vector();
            this.curBatch = new Param[this.nParam];
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setCharacterStream (" + n + ", " + n2 + ")");
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(8, new Object[]{reader, new Integer(n2)});
            return;
        }
        this.setReaderParamAtexec(n, reader, n2, -8, this.boundParam[n - 1].sqlType);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "PreparedStatement.setRef(int, Ref)", null);
    }

    public void setArray(int n, Array array) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "PreparedStatement.setArray(int, Array)", null);
    }

    public void setLong(int n, long l) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setLong (" + n + ", " + l + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        this.checkClosed(this.isClosed());
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(15, new Object[]{new Long(l)});
            return;
        }
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        jdbcOdbcBoundParam.setInputParameter(true);
        jdbcOdbcBoundParam.setBoundValue(new Long(l));
        if (jdbcOdbcBoundParam.type != -5) {
            this.freeGlobalVar(jdbcOdbcBoundParam);
            jdbcOdbcBoundParam.dataBuf = jdbcOdbcBoundParam.allocDataBuf(PARAM_BIGINT_LEN);
            jdbcOdbcBoundParam.type = (short)-5;
        }
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcBindInParameterLong(this.getHSTMT(), n, -5, l, jdbcOdbcBoundParam.dataBuf, jdbcOdbcBoundParam.releasePointers);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "PreparedStatement.setNull(int, int, String)", null);
    }

    private void setChar(int n, String string) throws SQLException {
        this.setChar(n, this.boundParam[n - 1].sqlType, string);
    }

    private void setChar(int n, int n2, String string) throws SQLException {
        boolean bl;
        if (this.needTrace) {
            this.trace("PrepareStatement.setChar (" + n + ", " + n2 + ", " + string + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        jdbcOdbcBoundParam.setInputParameter(true);
        byte[] byArray = JdbcOdbc.convert(string);
        boolean bl2 = bl = jdbcOdbcBoundParam.type == -8 && byArray.length + 2 <= jdbcOdbcBoundParam.dataBuf.length;
        if (!bl) {
            int n3 = (jdbcOdbcBoundParam.prec + 1) * 2 < byArray.length || jdbcOdbcBoundParam.prec > 4000 ? byArray.length + 2 : (jdbcOdbcBoundParam.prec + 1) * 2;
            this.freeGlobalVar(jdbcOdbcBoundParam);
            jdbcOdbcBoundParam.dataBuf = jdbcOdbcBoundParam.allocDataBuf(n3);
            jdbcOdbcBoundParam.type = (short)-8;
        }
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcBindInParameterString(this.getHSTMT(), n, n2, byArray, jdbcOdbcBoundParam.dataBuf, jdbcOdbcBoundParam.indBuf, jdbcOdbcBoundParam.releasePointers);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    private void setBinary(int n, int n2, byte[] byArray) throws SQLException {
        if (this.needTrace) {
            this.trace("PrepareStatement.setBinary (" + n + ", " + n2 + ", " + byArray + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        jdbcOdbcBoundParam.setInputParameter(true);
        jdbcOdbcBoundParam.setBoundValue(byArray);
        if (jdbcOdbcBoundParam.type != -2 || byArray.length > jdbcOdbcBoundParam.dataBuf.length) {
            this.freeGlobalVar(jdbcOdbcBoundParam);
            jdbcOdbcBoundParam.dataBuf = jdbcOdbcBoundParam.allocDataBuf(byArray.length);
            jdbcOdbcBoundParam.type = (short)-2;
        }
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcBindInParameterBinary(this.getHSTMT(), n, n2, byArray, jdbcOdbcBoundParam.dataBuf, jdbcOdbcBoundParam.getIndBuf(), jdbcOdbcBoundParam.releasePointers);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    private void setReal(int n, float f) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setReal (" + n + ", " + f + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        jdbcOdbcBoundParam.setInputParameter(true);
        jdbcOdbcBoundParam.setBoundValue(new Float(f));
        if (jdbcOdbcBoundParam.type != 7) {
            this.freeGlobalVar(jdbcOdbcBoundParam);
            jdbcOdbcBoundParam.dataBuf = jdbcOdbcBoundParam.allocDataBuf(PARAM_REAL_LEN);
            jdbcOdbcBoundParam.type = (short)7;
        }
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcBindInParameterFloat(this.getHSTMT(), n, 7, f, jdbcOdbcBoundParam.dataBuf, jdbcOdbcBoundParam.releasePointers);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    protected void freeGlobalVar(JdbcOdbcBoundParam jdbcOdbcBoundParam) throws SQLException {
        if (jdbcOdbcBoundParam.releasePointers[0] != 0L) {
            this.ODBCOBJ.jdbcReleaseGlobalPtr(jdbcOdbcBoundParam.releasePointers[0], jdbcOdbcBoundParam.releasePointers[1]);
            jdbcOdbcBoundParam.releasePointers[1] = 0L;
            jdbcOdbcBoundParam.releasePointers[0] = 0L;
        }
        if (jdbcOdbcBoundParam.releasePointers[2] != 0L) {
            this.ODBCOBJ.jdbcReleaseGlobalPtr(jdbcOdbcBoundParam.releasePointers[2], jdbcOdbcBoundParam.releasePointers[3]);
            jdbcOdbcBoundParam.releasePointers[3] = 0L;
            jdbcOdbcBoundParam.releasePointers[2] = 0L;
        }
    }

    protected void freeBoundParam() throws SQLException {
        int n = 0;
        while (this.boundParam != null && n < this.boundParam.length) {
            this.boundParam[n].setInputParameter(false);
            this.boundParam[n].setOutputParameter(false);
            this.boundParam[n].boundValue = null;
            this.freeGlobalVar(this.boundParam[n]);
            ++n;
        }
    }

    private void setReaderParamAtexec(int n, Reader reader, int n2, int n3, int n4) throws SQLException {
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        if (jdbcOdbcBoundParam.type != 201 || jdbcOdbcBoundParam.getStreamType() != 2) {
            this.freeGlobalVar(jdbcOdbcBoundParam);
            jdbcOdbcBoundParam.dataBuf = jdbcOdbcBoundParam.allocDataBuf(4);
            jdbcOdbcBoundParam.type = (short)201;
            jdbcOdbcBoundParam.setStreamType(2);
        }
        jdbcOdbcBoundParam.setInputStreamLen(n2);
        jdbcOdbcBoundParam.setReader(reader);
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcBindInParameterAtexec(this.getHSTMT(), n, n3, n4, jdbcOdbcBoundParam.dataBuf, jdbcOdbcBoundParam.indBuf, jdbcOdbcBoundParam.releasePointers);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    public void t3SetParamAtExec(int n, int n2, int n3, int n4) throws SQLException {
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        jdbcOdbcBoundParam.setInputParameter(true);
        if (jdbcOdbcBoundParam.type != 201 || jdbcOdbcBoundParam.getStreamType() != 5) {
            this.freeGlobalVar(jdbcOdbcBoundParam);
            jdbcOdbcBoundParam.dataBuf = jdbcOdbcBoundParam.allocDataBuf(4);
            jdbcOdbcBoundParam.type = (short)201;
            jdbcOdbcBoundParam.setStreamType(5);
        }
        jdbcOdbcBoundParam.setInputStreamLen(n2);
        try {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.ODBCOBJ.jdbcBindInParameterAtexec(this.getHSTMT(), n, n3, this.boundParam[n - 1].sqlType, jdbcOdbcBoundParam.dataBuf, jdbcOdbcBoundParam.indBuf, jdbcOdbcBoundParam.releasePointers);
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    public boolean t3Execute() throws SQLException {
        boolean bl = false;
        if (this.needTrace) {
            this.trace("Preparedstatemnt.t3Execute");
        }
        this.checkClosed(this.isClosed());
        if (this.executed && this.myResultset != null && !this.myResultset.isClosed()) {
            this.JDBCError("JERR_PREV_RS_NOT_CLOSED", null);
        }
        this.hasResult = this.nProj > 0;
        try {
            bl = this.ODBCOBJ.jdbcExecute(this.getHSTMT());
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        return bl;
    }

    public int t3ParamData() throws SQLException {
        return this.ODBCOBJ.jdbcParamData(this.getHSTMT());
    }

    public int t3PutData(byte[] byArray, long l) throws SQLException {
        this.ODBCOBJ.jdbcPutData(this.getHSTMT(), byArray, l);
        return 0;
    }

    public boolean t3ExecuteFinal() throws SQLException {
        this.executed = true;
        JdbcOdbcConnection jdbcOdbcConnection = (JdbcOdbcConnection)this.getConnection();
        if (jdbcOdbcConnection.getAutoCommit()) {
            jdbcOdbcConnection.closeBCList(true);
        }
        try {
            this.nProj = this.ODBCOBJ.jdbcNumResultCol(this.getHSTMT());
            if (this.nProj > 0) {
                this.hasResult = true;
            }
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        this.hasResult = this.nProj > 0;
        return this.hasResult;
    }

    private void setParamAtexec(int n, InputStream inputStream, int n2, int n3, int n4) throws SQLException {
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        jdbcOdbcBoundParam.setInputParameter(true);
        if (jdbcOdbcBoundParam.type != 201 || jdbcOdbcBoundParam.getStreamType() != 1) {
            this.freeGlobalVar(jdbcOdbcBoundParam);
            jdbcOdbcBoundParam.dataBuf = jdbcOdbcBoundParam.allocDataBuf(4);
            jdbcOdbcBoundParam.type = (short)201;
            jdbcOdbcBoundParam.setStreamType(1);
        }
        jdbcOdbcBoundParam.setInputStream(inputStream);
        jdbcOdbcBoundParam.setInputStreamLen(n2);
        jdbcOdbcBoundParam.setBoundValue(inputStream);
        try {
            this.ODBCOBJ.jdbcBindInParameterAtexec(this.getHSTMT(), n, n3, n4, jdbcOdbcBoundParam.dataBuf, jdbcOdbcBoundParam.indBuf, jdbcOdbcBoundParam.releasePointers);
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    protected int getObjectType(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            return 1;
        }
        if (object instanceof byte[]) {
            return -2;
        }
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof Boolean) {
            return -7;
        }
        if (object instanceof Float) {
            return 6;
        }
        if (object instanceof Double) {
            return 8;
        }
        if (object instanceof Date) {
            return 91;
        }
        if (object instanceof Time) {
            return 92;
        }
        if (object instanceof Timestamp) {
            return 93;
        }
        if (object instanceof Short) {
            return 5;
        }
        if (object instanceof Long) {
            return -5;
        }
        if (object instanceof BigDecimal) {
            return 3;
        }
        return 1111;
    }

    protected void checkType(int n) throws SQLException {
        switch (n) {
            case -16: 
            case -15: 
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -5: 
            case -4: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                break;
            }
            case -6: 
            case -3: 
            case 2: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                this.JDBCError("JERR_DRIVER_NOT_SUPPORT_SQL_TYPE", "" + n);
            }
            default: {
                this.JDBCError("JERR_INV_JDBC_DATA_TYPE", "" + n);
            }
        }
    }

    public void setDefault(int n, int n2) throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.setDefault (" + n + ", " + n2 + ")");
        }
        if (n <= 0 || n > this.nParam) {
            this.JDBCError("JERR_INV_PARAM_NUM", " 1 ~ " + this.nParam);
        }
        if (!this.executingBatch && this.curBatch != null) {
            this.curBatch[n - 1] = new Param(11, new Object[]{new Integer(n2)});
            return;
        }
        JdbcOdbcBoundParam jdbcOdbcBoundParam = this.boundParam[n - 1];
        jdbcOdbcBoundParam.setInputParameter(true);
        if (jdbcOdbcBoundParam.type != 99 || jdbcOdbcBoundParam.dataBuf == null) {
            this.freeGlobalVar(jdbcOdbcBoundParam);
            jdbcOdbcBoundParam.dataBuf = jdbcOdbcBoundParam.allocDataBuf(4);
            jdbcOdbcBoundParam.type = (short)99;
        }
        try {
            this.ODBCOBJ.jdbcBindInParameterDefault(this.getHSTMT(), n, n2, jdbcOdbcBoundParam.dataBuf, jdbcOdbcBoundParam.indBuf, jdbcOdbcBoundParam.releasePointers);
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
    }

    private int getSQLType(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 12: {
                n2 = 12;
                break;
            }
            case -1: {
                n2 = -1;
                break;
            }
            case -2: {
                n2 = -2;
                break;
            }
            case -3: {
                n2 = -3;
                break;
            }
            case -4: {
                n2 = -4;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case -7: 
            case 5: {
                n2 = 5;
                break;
            }
            case 6: {
                n2 = 6;
                break;
            }
            case 7: {
                n2 = 7;
                break;
            }
            case 8: {
                n2 = 8;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case -5: {
                n2 = -5;
                break;
            }
            case 91: {
                n2 = 91;
                break;
            }
            case 92: {
                n2 = 92;
                break;
            }
            case 93: {
                n2 = 93;
            }
        }
        return n2;
    }

    public JdbcOdbcParameterMetaData getParameterMetaData() throws SQLException {
        if (this.needTrace) {
            this.trace("PreparedStatement.getParameterMetaData");
        }
        this.checkClosed(this.isClosed());
        if (this.hasParam) {
            return new JdbcOdbcParameterMetaData(this.ODBCOBJ, this, this.nParam);
        }
        return null;
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "PreparedStatement.setURL(int parameterIndex, java.net.URL x)", null);
    }

    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        try {
            this.setAsciiStream(n, inputStream, inputStream.available());
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.setAsciiStream(n, inputStream, l < Integer.MAX_VALUE ? (int)l : Integer.MAX_VALUE);
    }

    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        try {
            this.setBinaryStream(n, inputStream, inputStream.available());
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.setBinaryStream(n, inputStream, l < Integer.MAX_VALUE ? (int)l : Integer.MAX_VALUE);
    }

    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.setBinaryStream(n, inputStream);
    }

    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.setBinaryStream(n, inputStream, l);
    }

    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.setCharacterStream(n, reader, Integer.MAX_VALUE);
    }

    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, l < Integer.MAX_VALUE ? (int)l : Integer.MAX_VALUE);
    }

    public void setClob(int n, Reader reader) throws SQLException {
        this.setCharacterStream(n, reader);
    }

    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, l);
    }

    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.setCharacterStream(n, reader);
    }

    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, l);
    }

    class Param {
        int type;
        Object[] values;

        Param(int n, Object[] objectArray) {
            this.type = n;
            this.values = objectArray;
        }
    }
}

