/*
 * Decompiled with CFR 0.152.
 */
package dbmaster.xml.symtb;

import dbmaster.xml.DisplaySetting;
import dbmaster.xml.symtb.SymbolicObject;
import dbmaster.xml.xttnode.QueryNode;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.ResultSet;
import java.sql.SQLException;

public class QueryVariable
implements SymbolicObject {
    private String column = null;
    private int position = 0;
    QueryNode qnode = null;
    private int type = 0;
    private boolean isNull = false;
    private String stringData = null;
    private InputStream inputStreamData = null;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public QueryVariable(QueryNode queryNode, String string, int n, int n2) {
        this.qnode = queryNode;
        this.column = string;
        this.type = n;
        this.position = n2;
    }

    public String getColumnName() {
        return this.column;
    }

    public SymbolicObject.SymbolicObjectType getType() {
        return SymbolicObject.SymbolicObjectType.QUERY_VARIABLE;
    }

    public int write(OutputStreamWriter outputStreamWriter, DisplaySetting displaySetting) throws Exception {
        int n = 0;
        DisplaySetting displaySetting2 = displaySetting != null ? displaySetting : this.qnode.getDisplaySetting();
        OutputStreamWriter outputStreamWriter2 = this.qnode.getXttEnv().getErrorOutputStreamWriter();
        if (!QueryVariable.isLob(this.type)) {
            if (this.isNull) {
                if (displaySetting2.null_handling == DisplaySetting.NullHandlingOption.NULL_STRING) {
                    outputStreamWriter.write("NULL");
                }
                n = 0;
                return 0;
            }
            if (displaySetting2.display_mode == DisplaySetting.DisplayModeOption.REGULAR) {
                QueryVariable.writeXMLPCDATA(outputStreamWriter, this.stringData.toCharArray(), this.stringData.length());
            } else {
                outputStreamWriter.write(this.stringData);
            }
        } else {
            if (this.isNull || this.inputStreamData == null || this.inputStreamData.available() == 0) {
                if (displaySetting2.null_handling == DisplaySetting.NullHandlingOption.NULL_STRING) {
                    outputStreamWriter.write("NULL");
                }
                n = 0;
                return 0;
            }
            if (displaySetting2.lo_mode == DisplaySetting.LoModeOption.CREATE_EXTERNAL) {
                String[] stringArray = new String[1];
                n = this.qnode.getXttEnv().getNextFileName(stringArray, this.type == 2004 || this.type == -4);
                if (n != 0) {
                    return n;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[0]);
                byte[] byArray = new byte[1024];
                int n2 = 0;
                while ((n2 = this.inputStreamData.read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                }
                ((OutputStream)fileOutputStream).close();
                outputStreamWriter.write(this.qnode.getXttEnv().getRelativePath(stringArray[0]));
            } else if (this.type == 2005 || this.type == -1) {
                InputStreamReader inputStreamReader = new InputStreamReader(this.inputStreamData);
                char[] cArray = new char[1024];
                int n3 = 0;
                while ((n3 = inputStreamReader.read(cArray)) > 0) {
                    if (displaySetting2.display_mode == DisplaySetting.DisplayModeOption.REGULAR) {
                        QueryVariable.writeXMLPCDATA(outputStreamWriter, cArray, n3);
                        continue;
                    }
                    outputStreamWriter.write(cArray, 0, n3);
                }
                inputStreamReader.close();
            } else {
                byte[] byArray = new byte[1024];
                int n4 = 0;
                while ((n4 = this.inputStreamData.read(byArray)) > 0) {
                    this.writeHex(outputStreamWriter, byArray, n4);
                }
            }
        }
        return n;
    }

    public int write(StringBuffer stringBuffer) throws Exception {
        int n = 0;
        OutputStreamWriter outputStreamWriter = this.qnode.getXttEnv().getErrorOutputStreamWriter();
        if (!QueryVariable.isLob(this.type)) {
            if (this.isNull) {
                n = 0;
                return 0;
            }
            stringBuffer.append(this.stringData);
        } else {
            if (this.isNull || this.inputStreamData == null || this.inputStreamData.available() == 0) {
                n = 0;
                return 0;
            }
            n = 8;
        }
        return n;
    }

    public static boolean isLob(int n) {
        return n == -1 || n == -4 || n == 2005 || n == 2004;
    }

    private static void writeXMLPCDATA(OutputStreamWriter outputStreamWriter, char[] cArray, int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            if (cArray[n3] != '<' && cArray[n3] != '>' && cArray[n3] != '&' && cArray[n3] != '\'' && cArray[n3] != '\"') continue;
            if (n2 < n3) {
                outputStreamWriter.write(cArray, n2, n3 - n2);
            }
            switch (cArray[n3]) {
                case '<': {
                    outputStreamWriter.write("&lt;");
                    break;
                }
                case '>': {
                    outputStreamWriter.write("&gt;");
                    break;
                }
                case '&': {
                    outputStreamWriter.write("&amp;");
                    break;
                }
                case '\'': {
                    outputStreamWriter.write("&apos;");
                    break;
                }
                case '\"': {
                    outputStreamWriter.write("&quot;");
                }
            }
            n2 = n3 + 1;
        }
        if (n2 < n3) {
            outputStreamWriter.write(cArray, n2, n3 - n2);
        }
    }

    private void writeHex(OutputStreamWriter outputStreamWriter, byte[] byArray, int n) throws IOException {
        char[] cArray = new char[2 * n];
        int n2 = 0;
        byte by = 0;
        for (int i = 0; i < n; ++i) {
            by = byArray[i];
            cArray[n2++] = HEX[by >> 4 & 0xF];
            cArray[n2++] = HEX[by & 0xF];
        }
        outputStreamWriter.write(cArray);
    }

    public void releaseSqlData() throws IOException {
        if (this.inputStreamData != null) {
            this.inputStreamData.close();
            this.inputStreamData = null;
        }
    }

    public void retrieveSqlData() throws SQLException {
        ResultSet resultSet = this.qnode.getResultSet();
        if (resultSet == null) {
            return;
        }
        if (!QueryVariable.isLob(this.type)) {
            this.stringData = resultSet.getString(this.position);
        } else {
            this.inputStreamData = resultSet.getBinaryStream(this.position);
        }
        this.isNull = resultSet.wasNull();
    }

    public boolean isNull() {
        return this.isNull;
    }
}

