/*
 * Decompiled with CFR 0.152.
 */
package dbmaker.xml.symtb;

import dbmaker.xml.XttEnv;
import dbmaker.xml.XttMessageUtil;
import dbmaker.xml.symtb.SymbolicObject;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class SymbolicTable {
    private XttEnv env = null;
    private Hashtable ht = new Hashtable();

    public SymbolicTable(XttEnv xttEnv) {
        this.env = xttEnv;
    }

    private void insert(Object object, Object object2) {
        Object v = this.ht.get(object);
        if (v == null) {
            this.ht.put(object, object2);
        } else if (v instanceof ArrayList) {
            ((ArrayList)v).add(object2);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(v);
            arrayList.add(object2);
            this.ht.put(object, arrayList);
        }
    }

    public SymbolicObject search(String string) {
        Object v = this.ht.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)v;
            Entry entry = (Entry)arrayList.get(arrayList.size() - 1);
            return entry.obj;
        }
        if (v instanceof Entry) {
            return ((Entry)v).obj;
        }
        return null;
    }

    public int insert(String string, SymbolicObject.SymbolicObjectType symbolicObjectType, int n, SymbolicObject symbolicObject) throws IOException {
        int n2 = 0;
        OutputStreamWriter outputStreamWriter = this.env.getErrorOutputStreamWriter();
        if (string == null || string.length() == 0) {
            outputStreamWriter.write(XttMessageUtil.formatMessage("SYMTB_INVALID_KEY"));
            n2 = 5;
            return 5;
        }
        Entry entry = new Entry(string, symbolicObjectType, n, symbolicObject);
        this.insert(string, entry);
        return n2;
    }

    private void remove(String string, int n) {
        Entry entry = null;
        Object v = this.ht.get(string);
        if (v instanceof Entry) {
            if (((Entry)v).scope == n) {
                this.ht.remove(string);
            }
        } else if (v instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)v;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                entry = (Entry)iterator.next();
                if (entry.scope != n) continue;
                arrayList.remove(entry);
            }
            if (arrayList.size() == 1) {
                this.ht.put(string, arrayList.get(0));
            }
        }
    }

    public void remove(int n) {
        Enumeration enumeration = this.ht.keys();
        while (enumeration.hasMoreElements()) {
            this.remove((String)enumeration.nextElement(), n);
        }
    }

    class Entry {
        String name = null;
        SymbolicObject.SymbolicObjectType type;
        int scope;
        SymbolicObject obj = null;

        Entry(String string, SymbolicObject.SymbolicObjectType symbolicObjectType, int n, SymbolicObject symbolicObject) {
            this.name = string;
            this.type = symbolicObjectType;
            this.scope = n;
            this.obj = symbolicObject;
        }
    }
}

