/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;
import net.sourceforge.mlf.metouia.MetouiaGradients;
import net.sourceforge.mlf.metouia.MetouiaLookAndFeel;
import net.sourceforge.mlf.metouia.MetouiaScrollButton;
import net.sourceforge.mlf.metouia.borders.MetouiaBorderUtilities;
import net.sourceforge.mlf.metouia.borders.MetouiaDots;

public class MetouiaScrollBarUI
extends MetalScrollBarUI {
    private static Color highlightColor;
    private static Color darkShadowColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    protected MetouiaDots dots;
    private boolean freeStanding = false;

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.dots = new MetouiaDots(5, 5);
    }

    public static ComponentUI createUI(JComponent c) {
        return new MetouiaScrollBarUI();
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new MetouiaScrollButton(orientation, this.scrollBarWidth - 0, this.freeStanding);
        return this.decreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new MetouiaScrollButton(orientation, this.scrollBarWidth, this.freeStanding);
        return this.increaseButton;
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        Rectangle rectShadow;
        Rectangle rectReflection;
        boolean leftToRight = c.getComponentOrientation().isLeftToRight();
        g.translate(thumbBounds.x, thumbBounds.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.freeStanding) {
                if (!leftToRight) {
                    ++thumbBounds.width;
                    g.translate(-1, 0);
                } else {
                    thumbBounds.width += 2;
                }
            }
            g.setColor(thumbShadow);
            g.drawRect(0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            this.dots.setDotsArea(thumbBounds.width - 6, thumbBounds.height - 7);
            this.dots.paintIcon(c, g, 4, 4);
            if (!this.freeStanding) {
                if (!leftToRight) {
                    --thumbBounds.width;
                    g.translate(1, 0);
                } else {
                    thumbBounds.width -= 2;
                }
            }
        } else {
            if (!this.freeStanding) {
                thumbBounds.height += 2;
            }
            g.setColor(thumbHighlightColor);
            g.setColor(thumbShadow);
            g.drawRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            this.dots.setDotsArea(thumbBounds.width - 7, thumbBounds.height - 6);
            this.dots.paintIcon(c, g, 4, 5);
            if (!this.freeStanding) {
                thumbBounds.height -= 2;
            }
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
        Color colorReflection = MetouiaLookAndFeel.getGradientReflection();
        Color colorReflectionFaded = MetouiaLookAndFeel.getGradientTranslucentReflection();
        Color colorShadow = MetouiaLookAndFeel.getGradientShadow();
        Color colorShadowFaded = MetouiaLookAndFeel.getGradientTranslucentShadow();
        if (this.scrollbar.getOrientation() == 1) {
            rectReflection = new Rectangle(thumbBounds.x + 1, thumbBounds.y + 1, thumbBounds.width / 2, thumbBounds.height - 2);
            rectShadow = new Rectangle(thumbBounds.x + thumbBounds.width / 2, thumbBounds.y + 1, thumbBounds.width / 2 + 1, thumbBounds.height - 2);
        } else {
            rectReflection = new Rectangle(thumbBounds.x + 1, thumbBounds.y + 1, thumbBounds.width - 2, thumbBounds.height / 2);
            rectShadow = new Rectangle(thumbBounds.x + 1, thumbBounds.y + thumbBounds.height / 2, thumbBounds.width - 2, thumbBounds.height / 2 + 1);
        }
        boolean isVertical = this.scrollbar.getOrientation() == 0;
        MetouiaGradients.drawGradient(g, colorReflection, colorReflectionFaded, rectReflection, isVertical, true);
        MetouiaGradients.drawGradient(g, colorShadowFaded, colorShadow, rectShadow, isVertical, false);
    }

    @Override
    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        darkShadowColor = UIManager.getColor("ScrollBar.darkShadow");
        thumbShadow = MetouiaLookAndFeel.getControlDarkShadow();
        thumbHighlightColor = MetouiaLookAndFeel.getMenuBackground();
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.translate(trackBounds.x, trackBounds.y);
        boolean leftToRight = c.getComponentOrientation().isLeftToRight();
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.freeStanding) {
                if (!leftToRight) {
                    ++trackBounds.width;
                    g.translate(-1, 0);
                } else {
                    trackBounds.width += 2;
                }
            }
            if (c.isEnabled()) {
                g.setColor(darkShadowColor);
                g.drawLine(0, 0, 0, trackBounds.height - 1);
                g.drawLine(trackBounds.width - 2, 0, trackBounds.width - 2, trackBounds.height - 1);
                g.drawLine(1, trackBounds.height - 1, trackBounds.width - 1, trackBounds.height - 1);
                g.drawLine(1, 0, trackBounds.width - 1, 0);
                g.setColor(highlightColor);
                g.drawLine(trackBounds.width - 1, 0, trackBounds.width - 1, trackBounds.height - 1);
            } else {
                MetouiaBorderUtilities.drawDisabledBorder(g, 0, 0, trackBounds.width, trackBounds.height);
            }
            if (!this.freeStanding) {
                if (!leftToRight) {
                    --trackBounds.width;
                    g.translate(1, 0);
                } else {
                    trackBounds.width -= 2;
                }
            }
        } else {
            if (!this.freeStanding) {
                trackBounds.height += 2;
            }
            if (c.isEnabled()) {
                g.setColor(darkShadowColor);
                g.drawLine(0, 0, trackBounds.width - 1, 0);
                g.drawLine(0, 1, 0, trackBounds.height - 1);
                g.drawLine(0, trackBounds.height - 2, trackBounds.width - 1, trackBounds.height - 2);
                g.drawLine(trackBounds.width - 1, 1, trackBounds.width - 1, trackBounds.height - 1);
            } else {
                MetouiaBorderUtilities.drawDisabledBorder(g, 0, 0, trackBounds.width, trackBounds.height);
            }
            if (!this.freeStanding) {
                trackBounds.height -= 2;
            }
        }
        g.translate(-trackBounds.x, -trackBounds.y);
    }
}

