/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sourceforge.mlf.metouia.MetouiaGradients;
import net.sourceforge.mlf.metouia.borders.MetouiaDots;

public class MetouiaInternalFrameTitlePane
extends MetalInternalFrameTitlePane
implements LayoutManager {
    protected int frameTitleHeight;
    private int buttonsWidth;
    protected MetouiaDots dots = new MetouiaDots(0, 0);
    protected MetouiaDots paletteDots;

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.frameTitleHeight = UIManager.getInt("InternalFrame.frameTitleHeight");
    }

    public MetouiaInternalFrameTitlePane(JInternalFrame frame) {
        super(frame);
    }

    @Override
    public void paintComponent(Graphics g) {
        int bumpXOffset;
        int bumpLength;
        if (this.isPalette) {
            this.paintPalette(g);
            return;
        }
        boolean leftToRight = this.frame.getComponentOrientation().isLeftToRight();
        boolean isSelected = this.frame.isSelected();
        int width = this.getWidth();
        int height = this.getHeight();
        ColorUIResource background = MetalLookAndFeel.getWindowTitleInactiveBackground();
        ColorUIResource foreground = MetalLookAndFeel.getWindowTitleInactiveForeground();
        ColorUIResource darkShadow = MetalLookAndFeel.getControlDarkShadow();
        g.setColor(background);
        g.fillRect(0, 0, width, height);
        g.setColor(darkShadow);
        g.drawLine(0, height - 2, width, height - 2);
        g.setColor(Color.white);
        g.drawLine(0, height - 1, width, height - 1);
        int titleLength = 0;
        int xOffset = leftToRight ? 2 : width - 2;
        String frameTitle = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            if (!leftToRight) {
                xOffset -= icon.getIconWidth();
            }
            int iconY = height / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, g, xOffset, iconY);
            xOffset += leftToRight ? icon.getIconWidth() + 2 : -2;
        }
        if (frameTitle != null) {
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            titleLength = fm.stringWidth(frameTitle);
            g.setColor(foreground);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            if (!leftToRight) {
                xOffset -= titleLength;
            }
            g.drawString(frameTitle, xOffset, yOffset);
            xOffset += leftToRight ? titleLength + 2 : -2;
        }
        if (leftToRight) {
            bumpLength = width - this.buttonsWidth - xOffset - 2;
            bumpXOffset = xOffset;
        } else {
            bumpLength = xOffset - this.buttonsWidth - 2;
            bumpXOffset = this.buttonsWidth + 2;
        }
        int bumpYOffset = 6;
        int bumpHeight = this.getHeight() - 2 * bumpYOffset + 1;
        this.dots.setDotsArea(bumpLength, bumpHeight);
        if (isSelected) {
            this.dots.paintIcon(this, g, bumpXOffset, bumpYOffset);
        }
        MetouiaGradients.drawHorizontalHighlight(g, this);
        MetouiaGradients.drawShadow(g, new Rectangle(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2 - 1), true, false);
    }

    @Override
    protected LayoutManager createLayout() {
        return this;
    }

    @Override
    protected void createButtons() {
        this.iconButton = new JButton();
        this.iconButton.addActionListener(this.iconifyAction);
        this.iconButton.setRolloverEnabled(true);
        this.iconButton.setContentAreaFilled(false);
        this.maxButton = new JButton();
        this.maxButton.addActionListener(this.maximizeAction);
        this.maxButton.setRolloverEnabled(true);
        this.maxButton.setContentAreaFilled(false);
        this.closeButton = new JButton();
        this.closeButton.addActionListener(this.closeAction);
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.setContentAreaFilled(false);
        this.setButtonIcons();
        this.iconButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.iconifyButtonAccessibleName"));
        this.maxButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.maximizeButtonAccessibleName"));
        this.closeButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.closeButtonAccessibleName"));
    }

    @Override
    public void paintPalette(Graphics g) {
        boolean leftToRight = this.frame.getComponentOrientation().isLeftToRight();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.paletteDots == null) {
            this.paletteDots = new MetouiaDots(0, 0);
        }
        ColorUIResource background = MetalLookAndFeel.getPrimaryControlShadow();
        ColorUIResource darkShadow = MetalLookAndFeel.getPrimaryControlDarkShadow();
        background = MetalLookAndFeel.getWindowTitleInactiveBackground();
        darkShadow = MetalLookAndFeel.getControlDarkShadow();
        g.setColor(background);
        g.fillRect(0, 0, width, height);
        g.setColor(darkShadow);
        g.drawLine(0, height - 1, width, height - 1);
        int xOffset = leftToRight ? 2 : this.buttonsWidth + 2;
        int bumpLength = width - this.buttonsWidth - 1;
        int bumpHeight = this.getHeight() - 2;
        this.paletteDots.setDotsArea(bumpLength, bumpHeight);
        this.paletteDots.paintIcon(this, g, xOffset, 2);
        MetouiaGradients.drawHorizontalHighlight(g, this);
        MetouiaGradients.drawHorizontalShadow(g, this);
    }

    @Override
    public void addLayoutComponent(String name, Component c) {
    }

    @Override
    public void removeLayoutComponent(Component c) {
    }

    @Override
    public Dimension preferredLayoutSize(Container c) {
        return this.getPreferredSize(c);
    }

    public Dimension getPreferredSize(Container c) {
        return new Dimension(c.getSize().width, this.isPalette ? this.paletteTitleHeight : this.frameTitleHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(70, 20);
    }

    @Override
    public Dimension minimumLayoutSize(Container c) {
        return this.preferredLayoutSize(c);
    }

    @Override
    public void layoutContainer(Container c) {
        int spacing;
        boolean leftToRight = this.frame.getComponentOrientation().isLeftToRight();
        int w = this.getWidth();
        int x = leftToRight ? w : 0;
        int y = 2;
        int buttonHeight = this.closeButton.getIcon().getIconHeight();
        int buttonWidth = this.closeButton.getIcon().getIconWidth();
        if (this.frame.isClosable()) {
            if (this.isPalette) {
                spacing = 0;
                this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y - 1, buttonWidth, this.getHeight() - 2);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            } else {
                spacing = 0;
                this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
        }
        if (this.frame.isMaximizable() && !this.isPalette) {
            spacing = this.frame.isClosable() ? 0 : 2;
            this.maxButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
            if (!leftToRight) {
                x += buttonWidth;
            }
        }
        if (this.frame.isIconifiable() && !this.isPalette) {
            spacing = this.frame.isMaximizable() ? 0 : (this.frame.isClosable() ? 0 : 2);
            this.iconButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
            if (!leftToRight) {
                x += buttonWidth;
            }
        }
        this.buttonsWidth = leftToRight ? w - x : x;
    }
}

