/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import net.sourceforge.mlf.metouia.MetouiaLookAndFeel;
import net.sourceforge.mlf.metouia.util.FastGradientPaintContext;

public class MetouiaGradients
implements Paint {
    private static final Color reflection = MetouiaLookAndFeel.getGradientReflection();
    private static final Color reflectionFaded = MetouiaLookAndFeel.getGradientTranslucentReflection();
    private static final Color shadow = MetouiaLookAndFeel.getGradientShadow();
    private static final Color shadowFaded = MetouiaLookAndFeel.getGradientTranslucentShadow();
    private int startColor;
    private int endColor;
    private boolean isVertical;
    private boolean isAscending;

    public MetouiaGradients(Color start, Color end, boolean isVertical, boolean isAscending) {
        this.startColor = start.getRGB();
        this.endColor = end.getRGB();
        this.isVertical = isVertical;
        this.isAscending = isAscending;
    }

    @Override
    public synchronized PaintContext createContext(ColorModel cm, Rectangle r, Rectangle2D r2d, AffineTransform xform, RenderingHints hints) {
        return new FastGradientPaintContext(cm, r, this.startColor, this.endColor, this.isVertical, this.isAscending);
    }

    @Override
    public int getTransparency() {
        return ((this.startColor & this.endColor) >> 24 & 0xFF) == 255 ? 1 : 3;
    }

    public static final void drawGradient(Graphics g, Color start, Color end, Rectangle rectangle, boolean isVertical, boolean isAscending) {
        Graphics2D g2D = (Graphics2D)g;
        MetouiaGradients gradient = new MetouiaGradients(start, end, isVertical, isAscending);
        g2D.setPaint(gradient);
        g2D.fill(rectangle);
    }

    public static final void drawHighlight(Graphics graphics, Rectangle rectangle, boolean isVertical, boolean isAscending) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(new MetouiaGradients(reflection, reflectionFaded, isVertical, isAscending));
        graphics2D.fill(rectangle);
    }

    public static final void drawShadow(Graphics graphics, Rectangle rectangle, boolean isVertical, boolean isAscending) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(new MetouiaGradients(shadowFaded, shadow, isVertical, isAscending));
        graphics2D.fill(rectangle);
    }

    public static final void drawHorizontalHighlight(Graphics g, Component c) {
        MetouiaGradients.drawHighlight(g, new Rectangle(0, 0, c.getWidth(), c.getHeight() / 2), true, true);
    }

    public static final void drawHorizontalShadow(Graphics g, Component c) {
        MetouiaGradients.drawShadow(g, new Rectangle(0, c.getHeight() / 2, c.getWidth(), c.getHeight() / 2), true, false);
    }

    public static final void drawVerticalHighlight(Graphics g, Component c) {
        MetouiaGradients.drawHighlight(g, new Rectangle(0, 0, c.getWidth() / 2, c.getHeight()), false, true);
    }

    public static final void drawVerticalShadow(Graphics g, Component c) {
        MetouiaGradients.drawShadow(g, new Rectangle(c.getWidth() / 2, 0, c.getWidth() / 2, c.getHeight()), false, false);
    }
}

