/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.undo;

import com.syscom.ut.locale.LocaleManager;
import com.syscom.xml.xtm.treetable.XtmTreeTable;
import java.util.ResourceBundle;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class AddNodeEdit
extends AbstractUndoableEdit {
    static ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.undo.resource.Res", LocaleManager.getLocale());
    private XtmTreeTable treeTable = null;
    private DefaultMutableTreeNode parent = null;
    private DefaultMutableTreeNode child = null;
    private int pos = 0;
    private boolean changeFocus = false;

    public AddNodeEdit(XtmTreeTable treeTable, DefaultMutableTreeNode parent, DefaultMutableTreeNode child, int pos, boolean changeFocus) {
        this.treeTable = treeTable;
        this.parent = parent;
        this.child = child;
        this.pos = pos;
        this.changeFocus = changeFocus;
    }

    @Override
    public void undo() throws CannotUndoException {
        this.treeTable.removeNodeFromParent(this.child, false);
        if (this.changeFocus) {
            this.treeTable.setSelectionNode(this.parent);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        this.treeTable.insertNodeInto(this.child, this.parent, this.pos, this.changeFocus);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return res.getString("Add");
    }
}

