/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.gui;

import com.borland.jbcl.layout.VerticalFlowLayout;
import com.syscom.ut.GuiUt;
import com.syscom.ut.comp.DbaButton;
import com.syscom.ut.comp.LocaleComboBox;
import com.syscom.ut.comp.ReflectionAction;
import com.syscom.ut.locale.LocaleChangeEvent;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.ut.resource.DBAImageResource;
import com.syscom.xml.xtm.Preferences;
import com.syscom.xml.xtm.gui.XTMFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PreferencesDlg
extends JDialog {
    private ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.gui.resource.Res", LocaleManager.getLocale());
    private JPanel panel1 = new JPanel(new BorderLayout());
    private DbaButton okButton = new DbaButton(this.res.getString("Ok"), 'O', new ReflectionAction(this, "okButton_actionPerformed"));
    private DbaButton cancelButton = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancelButton_actionPerformed"));
    private DbaButton helpButton = new DbaButton(this.res.getString("Help"), 'H');
    private LocaleComboBox languageComboBox = new LocaleComboBox();
    private JRadioButton[] connSecRadioButtons = new JRadioButton[]{new JRadioButton(this.res.getString("Print_xtm_connect")), new JRadioButton(this.res.getString("Print_xtm_connect1")), new JRadioButton(this.res.getString("Do_not_print_xtm_connect"))};

    public static PreferencesDlg createPreferencesDlg() {
        PreferencesDlg dlg = null;
        dlg = GuiUt.isWindows() ? new PreferencesDlg() : new PreferencesDlg((Frame)XTMFrame.frame, true);
        return dlg;
    }

    private PreferencesDlg(Frame frame, boolean modal) {
        super(frame, "", modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private PreferencesDlg() {
        super(XTMFrame.frame);
        this.setModal(true);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.okButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/ok.gif"));
        this.cancelButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/cancel.gif"));
        this.helpButton.setIcon(DBAImageResource.getResource(this.getClass(), "/images/ut/help.gif"));
        this.setResizable(false);
        this.setTitle(this.res.getString("Preferences"));
        XTMFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "preferencesdlg");
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
        JPanel panel3 = new JPanel(new GridLayout(1, 2));
        panel3.add(new JLabel(this.res.getString("Language_choice_")));
        panel3.add(this.languageComboBox);
        panel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel panel5 = new JPanel((LayoutManager)new VerticalFlowLayout());
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < this.connSecRadioButtons.length; ++i) {
            bg.add(this.connSecRadioButtons[i]);
            panel5.add(this.connSecRadioButtons[i]);
        }
        panel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.res.getString("Connect_section")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        Preferences pref = XTMFrame.frame.getPreferences();
        this.connSecRadioButtons[pref.getPrintConnectSection()].setSelected(true);
        JPanel panel4 = new JPanel(new FlowLayout(1));
        panel4.add(this.okButton);
        panel4.add(this.cancelButton);
        panel4.add(this.helpButton);
        panel2.add(panel3);
        panel2.add(panel5);
        this.panel1.add((Component)panel2, "Center");
        this.panel1.add((Component)panel4, "South");
        this.getContentPane().add(this.panel1);
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    public void okButton_actionPerformed(ActionEvent e) {
        short index;
        for (index = 0; index < this.connSecRadioButtons.length && !this.connSecRadioButtons[index].isSelected(); index = (short)((short)(index + 1))) {
        }
        short selection = this.languageComboBox.getSelectedLanguageChoice();
        if (selection != LocaleManager.getLanguageChoice()) {
            LocaleManager.getLocaleManager().localeChanged(new LocaleChangeEvent(this, LocaleManager.getLocale(selection)));
        }
        Preferences pref = XTMFrame.frame.getPreferences();
        pref.setPrintConnectSection(index);
        Preferences.setLanguageChoice((short)selection);
        this.setVisible(false);
    }
}

