/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import org.apache.xalan.xsltc.NodeIterator;
import org.apache.xalan.xsltc.dom.KeyIndex;
import org.apache.xalan.xsltc.dom.NodeIteratorBase;

public final class DupFilterIterator
extends NodeIteratorBase {
    private static final int INIT_DATA_SIZE = 16;
    private final NodeIterator _source;
    private int[] _data = null;
    private int _last = 0;
    private int _current = 0;

    public DupFilterIterator(NodeIterator source) {
        this._source = source;
        if (source instanceof KeyIndex) {
            this.setStartNode(1);
        }
    }

    public int next() {
        return this._current < this._last ? this._data[this._current++] : 0;
    }

    public NodeIterator setStartNode(int node) {
        if (this._source instanceof KeyIndex && this._data != null) {
            return this;
        }
        if (this._data == null || node != this._startNode) {
            this._startNode = node;
            this._last = 0;
            this._source.setStartNode(node);
            this._data = new int[16];
            while ((node = this._source.next()) != 0) {
                if (this._last == this._data.length) {
                    int[] newArray = new int[this._data.length * 2];
                    System.arraycopy(this._data, 0, newArray, 0, this._last);
                    this._data = newArray;
                }
                int i = 0;
                while (i < this._last) {
                    if (this._data[i] == node) break;
                    if (this._data[i] > node) {
                        int j;
                        ++this._last;
                        while (j > i) {
                            this._data[j] = this._data[j - 1];
                            --j;
                        }
                        this._data[i] = node;
                        break;
                    }
                    ++i;
                }
                if (i != this._last) continue;
                this._data[this._last++] = node;
            }
        }
        this._current = 0;
        return this;
    }

    public int getPosition() {
        return this._current;
    }

    public int getLast() {
        return this._last;
    }

    public void setMark() {
        this._source.setMark();
        this._markedNode = this._current;
    }

    public void gotoMark() {
        this._source.gotoMark();
        this._current = this._markedNode;
    }

    public NodeIterator reset() {
        this._current = 0;
        return this;
    }
}

