/*
 * Decompiled with CFR 0.152.
 */
package com.sun.medialib.mlib;

import com.sun.medialib.mlib.mediaLibImage;
import com.sun.medialib.mlib.mediaLibImageColormap;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

public class mediaLibImageCanvas
extends Canvas {
    mediaLibImage myImg;
    mediaLibImageColormap myColormap;
    int myWidth;
    int myHeight;
    Object myData;

    public mediaLibImageCanvas(mediaLibImage mediaLibImage2) {
        this.myImg = mediaLibImage2;
        this.myWidth = mediaLibImage2.getWidth();
        this.myHeight = mediaLibImage2.getHeight();
        this.myData = mediaLibImage2.getData();
        this.setSize(this.myWidth, this.myHeight);
    }

    public mediaLibImageCanvas(mediaLibImage mediaLibImage2, mediaLibImageColormap mediaLibImageColormap2) {
        this.myImg = mediaLibImage2;
        this.myColormap = mediaLibImageColormap2;
        this.myWidth = mediaLibImage2.getWidth();
        this.myHeight = mediaLibImage2.getHeight();
        this.myData = mediaLibImage2.getData();
        this.setSize(this.myWidth, this.myHeight);
    }

    public void updateImage(mediaLibImage mediaLibImage2) {
        this.setImage(mediaLibImage2);
    }

    public void updateColormap(mediaLibImageColormap mediaLibImageColormap2) {
        this.myColormap = mediaLibImageColormap2;
        this.repaint();
    }

    public void setImage(mediaLibImage mediaLibImage2) {
        this.myImg = mediaLibImage2;
        this.myWidth = mediaLibImage2.getWidth();
        this.myHeight = mediaLibImage2.getHeight();
        this.myData = mediaLibImage2.getData();
        this.setSize(this.myWidth, this.myHeight);
        this.repaint();
    }

    public void setColormap(mediaLibImageColormap mediaLibImageColormap2) {
        this.myColormap = mediaLibImageColormap2;
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Image image = null;
        int n = this.myImg.getFormat();
        int n2 = this.myImg.getChannels();
        int n3 = this.myImg.getType();
        if (n3 == 1) {
            if (n2 == 1) {
                if (n == 2) {
                    DirectColorModel directColorModel = new DirectColorModel(8, 255, 255, 255);
                    int n4 = this.myImg.getOffset();
                    int n5 = this.myImg.getStride();
                    image = this.createImage(new MemoryImageSource(this.myWidth, this.myHeight, (ColorModel)directColorModel, (byte[])this.myData, n4, n5));
                } else {
                    IndexColorModel indexColorModel = new IndexColorModel(32, this.myColormap.getLength(), this.myColormap.getByteRedMap(), this.myColormap.getByteGreenMap(), this.myColormap.getByteBlueMap());
                    int n6 = this.myImg.getOffset();
                    int n7 = this.myImg.getStride();
                    image = this.createImage(new MemoryImageSource(this.myWidth, this.myHeight, (ColorModel)indexColorModel, (byte[])this.myData, n6, n7));
                }
            } else if (n2 == 3) {
                int[] nArray = new int[this.myWidth * this.myHeight];
                if (n == 3) {
                    this.rgbImage2PackedARGB(this.myImg, nArray);
                } else if (n == 4) {
                    this.bgrImage2PackedARGB(this.myImg, nArray);
                }
                image = this.createImage(new MemoryImageSource(this.myWidth, this.myHeight, nArray, 0, this.myWidth));
            } else {
                int[] nArray = new int[this.myWidth * this.myHeight];
                if (n == 5) {
                    this.argbImage2PackedARGB(this.myImg, nArray);
                } else if (n == 6) {
                    this.abgrImage2PackedARGB(this.myImg, nArray);
                }
                image = this.createImage(new MemoryImageSource(this.myWidth, this.myHeight, nArray, 0, this.myWidth));
            }
        } else if (n3 == 3 && n2 == 1) {
            if (n == 7) {
                image = this.createImage(new MemoryImageSource(this.myWidth, this.myHeight, (int[])this.myData, 0, this.myWidth));
            } else if (n == 8) {
                int[] nArray = new int[this.myWidth * this.myHeight];
                this.packedabgrImage2PackedARGB(this.myImg, nArray);
                image = this.createImage(new MemoryImageSource(this.myWidth, this.myHeight, nArray, 0, this.myWidth));
            }
        }
        graphics.drawImage(image, 0, 0, this);
        System.gc();
    }

    public Dimension setMinimumSize() {
        return new Dimension(this.myWidth, this.myHeight);
    }

    public Dimension setPreferredSize() {
        return new Dimension(this.myWidth, this.myHeight);
    }

    private void rgbImage2PackedARGB(mediaLibImage mediaLibImage2, int[] nArray) {
        byte[] byArray = mediaLibImage2.getByteData();
        int n = mediaLibImage2.getWidth();
        int n2 = mediaLibImage2.getHeight();
        int n3 = mediaLibImage2.getStride();
        int n4 = mediaLibImage2.getOffset();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = n4 + n6 * n3;
            int n8 = 0;
            while (n8 < n) {
                int n9 = byArray[n7] & 0xFF;
                int n10 = byArray[n7 + 1] & 0xFF;
                int n11 = byArray[n7 + 2] & 0xFF;
                int n12 = -16777216;
                n12 |= n9 << 16;
                n12 |= n10 << 8;
                nArray[n5++] = n12 |= n11;
                ++n8;
                n7 += 3;
            }
            ++n6;
        }
    }

    private void bgrImage2PackedARGB(mediaLibImage mediaLibImage2, int[] nArray) {
        byte[] byArray = mediaLibImage2.getByteData();
        int n = mediaLibImage2.getWidth();
        int n2 = mediaLibImage2.getHeight();
        int n3 = mediaLibImage2.getStride();
        int n4 = mediaLibImage2.getOffset();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = n4 + n6 * n3;
            int n8 = 0;
            while (n8 < n) {
                int n9 = byArray[n7] & 0xFF;
                int n10 = byArray[n7 + 1] & 0xFF;
                int n11 = byArray[n7 + 2] & 0xFF;
                int n12 = -16777216;
                n12 |= n11 << 16;
                n12 |= n10 << 8;
                nArray[n5++] = n12 |= n9;
                ++n8;
                n7 += 3;
            }
            ++n6;
        }
    }

    private void argbImage2PackedARGB(mediaLibImage mediaLibImage2, int[] nArray) {
        byte[] byArray = mediaLibImage2.getByteData();
        int n = mediaLibImage2.getWidth();
        int n2 = mediaLibImage2.getHeight();
        int n3 = mediaLibImage2.getStride();
        int n4 = mediaLibImage2.getOffset();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = n4 + n6 * n3;
            int n8 = 0;
            while (n8 < n) {
                int n9 = byArray[n7] & 0xFF;
                int n10 = byArray[n7 + 1] & 0xFF;
                int n11 = byArray[n7 + 2] & 0xFF;
                int n12 = byArray[n7 + 3] & 0xFF;
                int n13 = n9 << 24;
                n13 |= n10 << 16;
                n13 |= n11 << 8;
                nArray[n5++] = n13 |= n12;
                ++n8;
                n7 += 4;
            }
            ++n6;
        }
    }

    private void abgrImage2PackedARGB(mediaLibImage mediaLibImage2, int[] nArray) {
        byte[] byArray = mediaLibImage2.getByteData();
        int n = mediaLibImage2.getWidth();
        int n2 = mediaLibImage2.getHeight();
        int n3 = mediaLibImage2.getStride();
        int n4 = mediaLibImage2.getOffset();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = n4 + n6 * n3;
            int n8 = 0;
            while (n8 < n) {
                int n9 = byArray[n7] & 0xFF;
                int n10 = byArray[n7 + 1] & 0xFF;
                int n11 = byArray[n7 + 2] & 0xFF;
                int n12 = byArray[n7 + 3] & 0xFF;
                int n13 = n9 << 24;
                n13 |= n12 << 16;
                n13 |= n11 << 8;
                nArray[n5++] = n13 |= n10;
                ++n8;
                n7 += 4;
            }
            ++n6;
        }
    }

    private void packedabgrImage2PackedARGB(mediaLibImage mediaLibImage2, int[] nArray) {
        Object object = mediaLibImage2.getData();
        byte[] byArray = (byte[])object;
        int n = mediaLibImage2.getWidth();
        int n2 = mediaLibImage2.getHeight();
        int n3 = mediaLibImage2.getStride();
        int n4 = mediaLibImage2.getOffset();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = n4 + n6 * n3;
            int n8 = 0;
            while (n8 < n) {
                int n9 = byArray[n7] & 0xFF;
                int n10 = byArray[n7 + 1] & 0xFF;
                int n11 = byArray[n7 + 2] & 0xFF;
                int n12 = byArray[n7 + 3] & 0xFF;
                int n13 = n9 << 24;
                n13 |= n12 << 16;
                n13 |= n11 << 8;
                nArray[n5++] = n13 |= n10;
                ++n8;
                n7 += 4;
            }
            ++n6;
        }
    }
}

