/*
 * Decompiled with CFR 0.152.
 */
package queryAnalyzer;

import dbaut.GuiUt;
import dbaut.WebBrowser;
import dbaut.comp.DbaFileChooser;
import dbaut.comp.DbaMenu;
import dbaut.comp.DbaMenuItem;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleChangeListener;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import preferences.PreferencesDlg;
import queryAnalyzer.LoginDlg;
import queryAnalyzer.QueryFrame;
import queryAnalyzer.RunBatchDlg;
import queryAnalyzer.SaveCommandDlg;

public class QueryMenuBar
extends JMenuBar
implements LocaleChangeListener {
    private DBAResourceBundle res = new DBAResourceBundle("resource.jsqltool", LocaleManager.getLocale());
    public DbaMenu loginMenu = new DbaMenu(this.res.getString("Login"), 'L');
    public DbaMenuItem connectItem = new DbaMenuItem(this.res.getString("Connect_Database"), 'C', new ReflectionAction(this, "connecItem_actionPerformed"));
    public DbaMenuItem disconnectItem = new DbaMenuItem(this.res.getString("Disconnect_Database"), 'D', new ReflectionAction(this, "disconnectItem_actionPerformed"));
    public DbaMenu fileMenu = new DbaMenu(this.res.getString("File"), 'F');
    public DbaMenuItem exitItem = new DbaMenuItem(this.res.getString("Exit"), 'E', new ReflectionAction(this, "exitItem_actionPerformed"));
    public DbaMenuItem saveItem = new DbaMenuItem(this.res.getString("Save_Command"), 'S', new ReflectionAction(this, "saveCommand_actionPerformed"));
    public DbaMenuItem loadItem = new DbaMenuItem(this.res.getString("Load_Command"), 'M', new ReflectionAction(this, "loadCommand_actionPerformed"));
    public DbaMenu runMenu = new DbaMenu(this.res.getString("Run"), 'R');
    public DbaMenuItem executeItem = new DbaMenuItem(this.res.getString("Execute_Command"), 'X', new ReflectionAction(this, "executeItem_actionPerformed"));
    public DbaMenuItem executeBatchItem = new DbaMenuItem(this.res.getString("Execute_Batch"), 'B', new ReflectionAction(this, "executeBatchItem_actionPerformed"));
    public DbaMenu optionMenu = new DbaMenu(this.res.getString("Option"), 'O');
    public DbaMenuItem preferItem = new DbaMenuItem(this.res.getString("Preferences"), 'P', new ReflectionAction(this, "preferItem_actionPerformed"));
    public DbaMenu helpMenu = new DbaMenu(this.res.getString("Help"), 'H');
    public DbaMenuItem helpMenuItem = new DbaMenuItem(this.res.getString("Help"), 'L', KeyStroke.getKeyStroke(KeyEvent.getKeyText(112)));
    public DbaMenuItem websiteMenuItem = new DbaMenuItem(this.res.getString("Website"), 'W', new ReflectionAction(this, "websiteMenuItem_actionPerformed"));
    public DbaMenuItem aboutMenuItem = new DbaMenuItem(this.res.getString("About"), 'A', new ReflectionAction(this, "aboutMenuItem_actionPerformed"));
    private ActionListener cshListener_menuitem = null;
    private ActionListener cshListener_popup_menuitem = null;

    public QueryMenuBar() {
        this.loginMenu.add(this.connectItem);
        this.loginMenu.add(this.disconnectItem);
        this.loginMenu.addSeparator();
        this.loginMenu.add(this.exitItem);
        this.fileMenu.add(this.saveItem);
        this.fileMenu.add(this.loadItem);
        this.runMenu.add(this.executeItem);
        this.runMenu.add(this.executeBatchItem);
        this.optionMenu.add(this.preferItem);
        this.optionMenu.setEnabled(true);
        this.helpMenu.add(this.helpMenuItem);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.websiteMenuItem);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.aboutMenuItem);
        this.add(this.loginMenu);
        this.add(this.fileMenu);
        this.add(this.runMenu);
        this.add(this.optionMenu);
        this.add(this.helpMenu);
    }

    public void connecItem_actionPerformed(ActionEvent e) {
        QueryFrame.frame.setRowField("", 0, 0, -1);
        LoginDlg dlg = new LoginDlg(QueryFrame.frame, true);
        dlg.pack();
        dlg.setResizable(false);
        dlg.validate();
        GuiUt.setCenterLocation(QueryFrame.frame, dlg);
        dlg.show();
    }

    public void disconnectItem_actionPerformed(ActionEvent e) {
        QueryFrame.frame.clearResultPane();
        if (QueryFrame.frame.conn != null) {
            QueryFrame.frame.conn.disconnect();
            QueryFrame.frame.conn = null;
        }
        QueryFrame.frame.isConnect = false;
        this.disconnectItem.setEnabled(false);
        this.executeItem.setEnabled(false);
        this.saveItem.setEnabled(false);
        this.loadItem.setEnabled(false);
        this.executeBatchItem.setEnabled(false);
        QueryFrame.frame.queryToolbar.runCommandButton.setEnabled(false);
        QueryFrame.frame.queryToolbar.loadCommandButton.setEnabled(false);
        QueryFrame.frame.queryToolbar.saveCommandButton.setEnabled(false);
        QueryFrame.frame.queryToolbar.clearCommandButton.setEnabled(false);
        QueryFrame.frame.sqlTextArea.setEnabled(false);
        QueryFrame.frame.clearButtonStatus(false);
        QueryFrame.frame.clearQueryPane();
        QueryFrame.frame.clearNonQueryPane();
        QueryFrame.frame.killHistory();
        QueryFrame.frame.setMessageField(QueryFrame.res.getString("No_database_connected"));
        QueryFrame.frame.setDBField("");
        QueryFrame.frame.setRowField("", 0, 0, -1);
        QueryFrame.frame.setQueryTimeField(-1L);
        QueryFrame.frame.setTitle("JSQL");
        boolean[] enable = new boolean[]{false, false, false, false, false};
        QueryFrame.frame.setToolbarStatus(enable);
    }

    public void exitItem_actionPerformed(ActionEvent e) {
        QueryFrame.frame.exitApplication();
    }

    public void executeItem_actionPerformed(ActionEvent e) {
        QueryFrame.frame.ExecuteCommand();
    }

    public void executeBatchItem_actionPerformed(ActionEvent e) {
        RunBatchDlg encDlg = new RunBatchDlg((Frame)QueryFrame.frame, true);
        GuiUt.setCenterLocation(QueryFrame.frame, encDlg);
        encDlg.show();
    }

    public void saveCommand_actionPerformed(ActionEvent e) {
        new SaveCommandDlg((Frame)QueryFrame.frame, true);
    }

    public void loadCommand_actionPerformed(ActionEvent e) {
        block11: {
            DbaFileChooser outputFile = null;
            outputFile = QueryFrame.frame.px.getBlobFilePath() != null ? new DbaFileChooser(QueryFrame.frame.px.getBlobFilePath()) : new DbaFileChooser(QueryFrame.frame.px.getSelectedDirectory());
            int loadResponse = outputFile.showOpenDialog(QueryFrame.frame);
            if (loadResponse == 0) {
                File file = outputFile.getSelectedFile();
                String enc = null;
                InputStreamReader reader = null;
                try {
                    QueryFrame.frame.setMessageField(this.res.getString("Load_Command"));
                    file.toURL();
                    if (file.exists()) {
                        FileInputStream stream = new FileInputStream(file);
                        int size = stream.available();
                        byte[] b = new byte[2];
                        stream.read(b, 0, 2);
                        Byte b1 = new Byte(b[0]);
                        Byte b2 = new Byte(b[1]);
                        stream = new FileInputStream(file);
                        if (b1.intValue() == -2 && b2.intValue() == -1) {
                            enc = "UnicodeBig";
                            size = (size - 2) / 2;
                            reader = new InputStreamReader((InputStream)stream, enc);
                        } else if (b1.intValue() == -1 && b2.intValue() == -2) {
                            enc = "UnicodeLittle";
                            size = (size - 2) / 2;
                            reader = new InputStreamReader((InputStream)stream, enc);
                        } else {
                            reader = new InputStreamReader(stream);
                        }
                        char[] CC = new char[size];
                        int breakpoint = 0;
                        reader.read(CC);
                        reader.close();
                        for (int n = size; n > 0; --n) {
                            if (CC[n - 1] == '\u0000') continue;
                            breakpoint = n;
                            break;
                        }
                        QueryFrame.frame.sqlTextArea.setText(new String(CC, 0, breakpoint));
                        GuiUt.showInformationDlg(QueryFrame.frame, this.res.getString("Load_file_successful"));
                        if (size > 0) {
                            QueryFrame.frame.clearButtonStatus(true);
                        } else {
                            QueryFrame.frame.clearButtonStatus(false);
                        }
                        break block11;
                    }
                    String s1 = this.res.getString("file_does_not_exist");
                    String s2 = GuiUt.mapStringForProperty(s1, file.toString());
                    GuiUt.showWarningDlg(QueryFrame.frame, this.res.getString("Warning"), s2);
                    return;
                }
                catch (Exception ee) {
                    QueryFrame.frame.setMessageField(this.res.getString("Load_Failed"));
                    GuiUt.showWarningDlg(QueryFrame.frame, this.res.getString("Warning"), ee.getMessage());
                    return;
                }
            }
        }
    }

    public void preferItem_actionPerformed(ActionEvent e) {
        PreferencesDlg preferDlg = new PreferencesDlg(QueryFrame.frame, this.res.getString("Setup_preferences"), true);
        preferDlg.setLocation(350, 250);
        preferDlg.show();
    }

    public void websiteMenuItem_actionPerformed(ActionEvent e) {
        if (LocaleManager.getLanguageChoice() == 1) {
            WebBrowser.displayURL(QueryFrame.frame, "http://www.dbmaker.com.tw");
        } else if (LocaleManager.getLanguageChoice() == 0 || LocaleManager.getLanguageChoice() == 3) {
            WebBrowser.displayURL(QueryFrame.frame, "http://www.dbmaker.com");
        } else {
            WebBrowser.displayURL(QueryFrame.frame, "http://www.dbmaker.co.jp");
        }
    }

    public void aboutMenuItem_actionPerformed(ActionEvent e) {
        try {
            JDialog dlg = (JDialog)GuiUt.getNewInstance("dbaut.AboutBox", new Class[]{Class.forName("java.awt.Frame"), Class.forName("java.lang.Integer")}, new Object[]{QueryFrame.frame, new Integer(0)});
            if (dlg == null) {
                return;
            }
            GuiUt.setCenterLocation(QueryFrame.frame, dlg);
            dlg.show();
            dlg = null;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            System.out.println(cnfe.getMessage());
        }
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        DBAResourceBundle res = QueryFrame.res;
        this.loginMenu.setText(res.getString("Login"));
        this.connectItem.setText(res.getString("Connect_Database"));
        this.disconnectItem.setText(res.getString("Disconnect_Database"));
        this.fileMenu.setText(res.getString("File"));
        this.exitItem.setText(res.getString("Exit"));
        this.saveItem.setText(res.getString("Save_Command"));
        this.loadItem.setText(res.getString("Load_Command"));
        this.runMenu.setText(res.getString("Run"));
        this.executeItem.setText(res.getString("Execute_Command"));
        this.executeBatchItem.setText(res.getString("Execute_Batch"));
        this.optionMenu.setText(res.getString("Option"));
        this.preferItem.setText(res.getString("Preferences"));
        this.helpMenu.setText(res.getString("Help"));
        this.helpMenuItem.setText(res.getString("Help"));
        this.websiteMenuItem.setText(res.getString("Website"));
        this.aboutMenuItem.setText(res.getString("About"));
    }

    public void setHelpButton(boolean first) {
        if (QueryFrame.frame.mainHB != null) {
            this.helpMenuItem.setEnabled(true);
            if (first) {
                this.cshListener_popup_menuitem = this.cshListener_menuitem = new CSH.DisplayHelpFromSource((HelpBroker)QueryFrame.frame.mainHB);
                this.helpMenuItem.addActionListener(this.cshListener_menuitem);
            } else {
                this.helpMenuItem.removeActionListener(this.cshListener_menuitem);
                this.cshListener_menuitem = new CSH.DisplayHelpFromSource((HelpBroker)QueryFrame.frame.mainHB);
                this.cshListener_popup_menuitem = new CSH.DisplayHelpFromSource((HelpBroker)QueryFrame.frame.mainHB);
                this.helpMenuItem.addActionListener(this.cshListener_menuitem);
            }
        } else {
            this.helpMenuItem.setEnabled(false);
        }
    }
}

