/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtt.tree;

import com.syscom.misc.XMLImageResource;
import com.syscom.xml.schema.node.Column;
import com.syscom.xml.schema.node.Database;
import com.syscom.xml.schema.node.Table;
import com.syscom.xml.schema.node.View;
import com.syscom.xml.xtt.tree.CheckNode;
import com.syscom.xml.xttinterface.TreeNodeInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.TreeCellRenderer;

public class CheckRenderer
extends JPanel
implements TreeCellRenderer {
    protected JCheckBox check;
    protected TreeLabel label;
    private String tableAttributeImage = "/xmlimages/attribute16.gif";
    private String tableElementImage = "/xmlimages/element16.gif";
    private String columnElementImage = "/xmlimages/element16.gif";
    private String columnAttributeImage = "/xmlimages/attribute16.gif";
    private String databaseImage = "/xmlimages/schema/database.gif";
    private String cancelImage = "/xmlimages/remove16.gif";
    private String hiddenImage = "/xmlimages/hidden16.gif";
    private ImageIcon icon = null;

    public CheckRenderer() {
        this.setLayout(null);
        this.label = new TreeLabel();
        this.add(this.label);
        this.label.setForeground(UIManager.getColor("Tree.textForeground"));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
        this.setEnabled(tree.isEnabled());
        this.label.setFont(tree.getFont());
        this.label.setText(stringValue);
        this.label.setSelected(isSelected);
        this.label.setFocus(hasFocus);
        CheckNode node = (CheckNode)value;
        TreeNodeInterface object = (TreeNodeInterface)node.getUserObject();
        boolean isFreeze = object.isFreeze();
        if (object instanceof Database) {
            this.label.setIcon(XMLImageResource.getResource(this.getClass(), this.databaseImage));
        } else if (object instanceof Table || object instanceof View) {
            if (node.itemPosition == 0) {
                this.label.setIcon(XMLImageResource.getResource(this.getClass(), this.tableElementImage));
            } else if (node.itemPosition == 1) {
                this.label.setIcon(XMLImageResource.getResource(this.getClass(), this.tableAttributeImage));
            } else if (node.itemPosition == 2) {
                this.label.setIcon(XMLImageResource.getResource(this.getClass(), this.cancelImage));
            } else {
                this.label.setIcon(XMLImageResource.getResource(this.getClass(), this.hiddenImage));
            }
        } else if (object instanceof Column) {
            if (node.itemPosition == 0) {
                this.label.setIcon(XMLImageResource.getResource(this.getClass(), this.columnElementImage));
            } else if (node.itemPosition == 1) {
                this.label.setIcon(XMLImageResource.getResource(this.getClass(), this.columnAttributeImage));
            } else if (node.itemPosition == 2) {
                this.label.setIcon(XMLImageResource.getResource(this.getClass(), this.cancelImage));
            } else {
                this.label.setIcon(XMLImageResource.getResource(this.getClass(), this.hiddenImage));
            }
        }
        this.label.revalidate();
        this.label.repaint();
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d_label = this.label.getPreferredSize();
        return new Dimension(d_label.width, d_label.height);
    }

    @Override
    public void doLayout() {
        Dimension d_label = this.label.getPreferredSize();
        this.label.setLocation(d_label.width, d_label.height);
        this.label.setBounds(0, 0, d_label.width, d_label.height);
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public class TreeLabel
    extends JLabel {
        boolean isSelected;
        boolean hasFocus;

        @Override
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        @Override
        public void paint(Graphics g) {
            String str = this.getText();
            if (str != null && 0 < str.length()) {
                if (this.isSelected) {
                    g.setColor(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    g.setColor(UIManager.getColor("Tree.textBackground"));
                }
                Dimension d = this.getPreferredSize();
                int imageOffset = 0;
                Icon currentI = this.getIcon();
                if (currentI != null) {
                    imageOffset = currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                }
                g.fillRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
                if (this.hasFocus) {
                    g.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                    g.drawRect(imageOffset, 0, d.width - 1 - imageOffset, d.height - 1);
                }
            }
            super.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension retDimension = super.getPreferredSize();
            if (retDimension != null) {
                retDimension = new Dimension(retDimension.width + 3, retDimension.height);
            }
            return retDimension;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public void setFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }
    }
}

