/*
 * Decompiled with CFR 0.152.
 */
package dbmaster.sql;

import dbmaster.sql.JdbcOdbc;
import dbmaster.sql.JdbcOdbcConnection;
import dbmaster.sql.JdbcOdbcConnection2;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class JdbcOdbcPooledConnection
extends JdbcOdbc
implements PooledConnection {
    protected JdbcOdbcConnection physicalConn;
    protected JdbcOdbcConnection logicalConn;
    protected boolean isClose;
    protected Hashtable EventListenerS = null;
    protected int CONN_CLOSE = 1;
    protected int CONN_ERROR = 2;

    public JdbcOdbcPooledConnection(JdbcOdbcConnection jdbcOdbcConnection) throws SQLException {
        if (this.needTrace) {
            this.trace("new a PooledConnection object");
        }
        this.physicalConn = jdbcOdbcConnection;
        this.isClose = false;
        this.EventListenerS = new Hashtable(12);
    }

    protected void finalize() {
        this.trace("PooledConnection.finalize()");
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Connection getConnection() throws SQLException {
        this.trace("JdbcOdbcPooledConnection.getConnection()");
        this.checkClosed(this.isClose);
        this.logicalConn = new JdbcOdbcConnection2(this, this.physicalConn);
        return this.logicalConn;
    }

    public void close() throws SQLException {
        this.trace("JdbcOdbcPooledConnection.close()");
        this.checkClosed(this.isClose);
        this.physicalConn.close();
        SQLException sQLException = new SQLException("physical connection had been closed");
        this.callListener(this.CONN_ERROR, sQLException);
    }

    public void logicalClose() throws SQLException {
        this.trace("JdbcOdbcPooledConnection.logicalClose()");
        this.checkClosed(this.isClose);
        this.callListener(this.CONN_CLOSE, null);
    }

    public void callListener(int n, SQLException sQLException) {
        Enumeration enumeration = this.EventListenerS.keys();
        ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            ConnectionEventListener connectionEventListener2 = (ConnectionEventListener)this.EventListenerS.get(connectionEventListener);
            if (n == this.CONN_CLOSE) {
                connectionEventListener2.connectionClosed(connectionEvent);
                continue;
            }
            connectionEventListener2.connectionErrorOccurred(connectionEvent);
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.trace("JdbcOdbcPooledConnection.addConnectionEventListener(ConnectionEventListener listener)");
        this.EventListenerS.put(connectionEventListener, connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.trace("JdbcOdbcPooledConnection.removeConnectionEventListener(ConnectionEventListener listener)");
        this.EventListenerS.remove(connectionEventListener);
    }

    protected ResourceBundle getResourceBundle() {
        return this.physicalConn.getResourceBundle();
    }
}

