/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.ut.preference;

import com.syscom.ut.JdmConfig;
import com.syscom.ut.locale.LocaleManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.xalan.xsltc.runtime.DefaultSAXOutputHandler;
import org.apache.xml.utils.TreeWalker;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import startup.ToolInfo;

public class CorePreferences {
    public final int LANGUAGE_CHOICE = 0;
    public final int LOGIN_DB_NAME = 1;
    public final int LOGIN_ID_NAME = 2;
    private static CorePreferences self = null;
    private static short language_choice = LocaleManager.getDefaultSystemLanguage();
    private static String login_db_name = "";
    private static String login_id_name = "";
    public static final String CONFIGNAME = ToolInfo.getToolConfigName();

    public CorePreferences() {
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init() throws Exception {
        String string = CorePreferences.getWinInstallPath();
        this.init(string + CONFIGNAME);
    }

    private void init(String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new File(string));
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        String string2 = null;
        Node node = XPathAPI.selectSingleNode((Node)document, (String)"/syscom");
        if (node != null && node.getNodeType() == 1) {
            Element element = (Element)node;
            string2 = element.getAttribute("login_db_name");
            if (string2 != null && string2.length() > 0) {
                login_db_name = string2;
            }
            if ((string2 = element.getAttribute("login_id")) != null && string2.length() > 0) {
                login_id_name = string2;
            }
            if ((string2 = element.getAttribute("language_choice")) != null && string2.length() > 0) {
                language_choice = Short.parseShort(string2);
                if (language_choice < 0) {
                    language_choice = 0;
                }
            }
        }
    }

    public void resetDOM(Document document) throws Exception {
        String string = null;
        Node node = XPathAPI.selectSingleNode((Node)document, (String)"/syscom");
        if (node != null && node.getNodeType() == 1) {
            string = ((Element)node).getAttribute("language_choice");
            if (string != null && string.length() > 0) {
                language_choice = Short.parseShort(string);
            }
            if ((string = ((Element)node).getAttribute("login_db_name")) != null && string.length() > 0) {
                login_db_name = string;
            }
            if ((string = ((Element)node).getAttribute("login_id_name")) != null && string.length() > 0) {
                login_id_name = string;
            }
        }
        LocaleManager.getLocaleManager().resetLocale(language_choice);
    }

    public void setDOM(Document document, int n, String string) throws Exception {
        Element element = null;
        NodeList nodeList = document.getElementsByTagName("syscom");
        if (nodeList.getLength() > 0) {
            element = (Element)nodeList.item(0);
        } else {
            this.resetDOM(document);
        }
        Element element2 = document.getDocumentElement();
        if (element2 == null) {
            element = document.createElement("syscom");
            document.appendChild(element);
        } else if (!element2.getNodeName().equals("syscom")) {
            element = document.createElement("syscom");
            document.replaceChild(element, element2);
        } else {
            element = element2;
        }
        switch (n) {
            case 0: {
                if (string == null || string.length() <= 0) break;
                element.setAttribute("language_choice", string);
                language_choice = Short.parseShort(string);
                break;
            }
            case 1: {
                if (string == null || string.length() <= 0) break;
                element.setAttribute("login_db_name", string);
                login_db_name = string;
                break;
            }
            case 2: {
                if (string == null || string.length() <= 0) break;
                element.setAttribute("login_id_name", string);
                login_id_name = string;
            }
        }
    }

    public void setDOM(Document document) throws Exception {
        Element element = null;
        NodeList nodeList = document.getElementsByTagName("syscom");
        if (nodeList.getLength() > 0) {
            element = (Element)nodeList.item(0);
        } else {
            this.resetDOM(document);
        }
        Element element2 = document.getDocumentElement();
        if (element2 == null) {
            element = document.createElement("syscom");
            document.appendChild(element);
        } else if (!element2.getNodeName().equals("syscom")) {
            element = document.createElement("syscom");
            document.replaceChild(element, element2);
        } else {
            element = element2;
        }
        element.setAttribute("language_choice", Short.toString(language_choice));
        if (login_db_name != null && login_db_name.length() > 0) {
            element.setAttribute("login_db_name", login_db_name);
        }
        if (login_id_name != null && login_id_name.length() > 0) {
            element.setAttribute("login_id_name", login_id_name);
        }
    }

    public static short getLanguageChoice() {
        return language_choice;
    }

    public static void setLanguageChoice(short s) {
        language_choice = s;
    }

    public static String getLoginDbName() {
        return login_db_name;
    }

    public static void setLoginDbName(String string) {
        login_db_name = string;
    }

    public static String getLoginIdName() {
        return login_id_name;
    }

    public static void setLoginIdName(String string) {
        login_id_name = string;
    }

    public static String getConfigName() {
        String string = CorePreferences.getWinInstallPath();
        return string + CONFIGNAME;
    }

    public static String getWinInstallPath() {
        String string = System.getProperty("file.separator");
        JdmConfig jdmConfig = new JdmConfig();
        String string2 = jdmConfig.filePath("dmconfig.ini");
        int n = string2.lastIndexOf(string);
        if (n > 0) {
            return string2.substring(0, n + 1);
        }
        return "";
    }

    public static void initCorePreferences() {
        if (self == null) {
            self = new CorePreferences();
        }
    }

    public static CorePreferences getCorePreferences() {
        if (self == null) {
            self = new CorePreferences();
        }
        return self;
    }

    public void updateAttributes(Document document, String string, int n, boolean bl) {
        Element element = null;
        if (bl) {
            NodeList nodeList = document.getElementsByTagName("syscom");
            if (nodeList.getLength() > 0) {
                element = (Element)nodeList.item(0);
            }
            switch (n) {
                case 0: {
                    if (string == null || string.length() <= 0) break;
                    element.setAttribute("language_choice", string);
                    language_choice = Short.parseShort(string);
                    break;
                }
                case 1: {
                    if (string == null || string.length() <= 0) break;
                    element.setAttribute("login_db_name", string);
                    login_db_name = string;
                    break;
                }
                case 2: {
                    if (string == null || string.length() <= 0) break;
                    element.setAttribute("login_id_name", string);
                    login_id_name = string;
                }
            }
        } else {
            element = document.createElement("syscom");
            switch (n) {
                case 0: {
                    element.setAttribute("language_choice", Short.toString(language_choice));
                    break;
                }
                case 1: {
                    if (login_db_name == null || login_db_name.length() <= 0) break;
                    element.setAttribute("login_db_name", login_db_name);
                    break;
                }
                case 2: {
                    if (login_id_name == null || login_id_name.length() <= 0) break;
                    element.setAttribute("login_id_name", login_id_name);
                }
            }
        }
    }

    private void save(String string) throws Exception {
        Object object;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = null;
        Element element = null;
        File file = new File(string);
        if (file.exists()) {
            document = documentBuilder.parse(file);
            object = document.getElementsByTagName("syscom");
            if (object.getLength() > 0) {
                element = (Element)object.item(0);
            }
        } else {
            document = documentBuilder.newDocument();
            element = document.createElement("syscom");
            document.appendChild(element);
        }
        element.setAttribute("language_choice", Short.toString(language_choice));
        if (login_db_name != null && login_db_name.length() > 0) {
            element.setAttribute("login_db_name", login_db_name);
        }
        if (login_id_name != null && login_id_name.length() > 0) {
            element.setAttribute("login_id_name", login_id_name);
        }
        object = new FileOutputStream(file);
        DefaultSAXOutputHandler defaultSAXOutputHandler = new DefaultSAXOutputHandler((OutputStream)object, "UTF-8");
        TreeWalker treeWalker = new TreeWalker((ContentHandler)defaultSAXOutputHandler);
        treeWalker.traverse((Node)document);
        ((FileOutputStream)object).close();
    }

    public void save() throws Exception {
        String string = CorePreferences.getWinInstallPath();
        this.save(string + CONFIGNAME);
    }
}

