/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixSelectionEvent;
import com.borland.jbcl.model.MatrixSelectionListener;
import com.borland.jbcl.model.WritableMatrixSelection;
import java.io.Serializable;
import java.util.EventListener;

public class ColumnMatrixSelection
implements WritableMatrixSelection,
Serializable {
    private int cellColumn = -1;
    private int rows;
    private transient EventMulticaster selectionListeners = new EventMulticaster();
    private boolean events = true;

    public ColumnMatrixSelection() {
    }

    public ColumnMatrixSelection(int maxRows) {
        this.rows = maxRows;
    }

    public ColumnMatrixSelection(int maxRows, int column) {
        this.rows = maxRows;
        this.cellColumn = column;
    }

    public int getMaxRows() {
        return this.rows;
    }

    public void setMaxRows(int maxRows) {
        this.rows = maxRows;
        this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
    }

    public boolean contains(MatrixLocation location) {
        return this.cellColumn != -1 ? location.column == this.cellColumn : false;
    }

    public boolean contains(int row, int column) {
        return this.cellColumn != -1 ? column == this.cellColumn : false;
    }

    public int getCount() {
        return this.cellColumn != -1 ? this.rows : 0;
    }

    public MatrixLocation[] getAll() {
        MatrixLocation[] contents = new MatrixLocation[this.cellColumn != -1 ? this.rows : 0];
        if (this.cellColumn != -1) {
            for (int i2 = 0; i2 < this.rows; ++i2) {
                contents[i2] = new MatrixLocation(i2, this.cellColumn);
            }
        }
        return contents;
    }

    public void addSelectionListener(MatrixSelectionListener listener) {
        this.selectionListeners.add((EventListener)listener);
    }

    public void removeSelectionListener(MatrixSelectionListener listener) {
        this.selectionListeners.remove((EventListener)listener);
    }

    public void set(MatrixLocation[] locations) {
        this.add(locations);
    }

    public void add(MatrixLocation location) {
        if (location.column != this.cellColumn) {
            this.cellColumn = location.column;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(int row, int column) {
        if (column != this.cellColumn) {
            this.cellColumn = column;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation[] locations) {
        if (locations.length > 0 && locations[0].column != this.cellColumn) {
            this.cellColumn = locations[0].column;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(MatrixLocation begin, MatrixLocation end) {
        if (end.column != this.cellColumn) {
            this.cellColumn = end.column;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(int beginRow, int beginColumn, int endRow, int endColumn) {
        if (this.cellColumn != endColumn) {
            this.cellColumn = endColumn;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation location) {
        if (this.cellColumn != -1 && location.column == this.cellColumn) {
            this.cellColumn = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(int row, int column) {
        if (this.cellColumn != -1 && column == this.cellColumn) {
            this.cellColumn = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation[] locations) {
        if (this.cellColumn != -1) {
            for (int i2 = 0; i2 < locations.length; ++i2) {
                if (locations[i2].column != this.cellColumn) continue;
                this.cellColumn = -1;
                this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
                return;
            }
        }
    }

    public void removeRange(MatrixLocation begin, MatrixLocation end) {
        this.removeRange(begin.row, begin.column, end.row, end.column);
    }

    public void removeRange(int beginRow, int beginColumn, int endRow, int endColumn) {
        if (this.cellColumn != -1 && this.cellColumn >= beginColumn && this.cellColumn <= endColumn) {
            this.cellColumn = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeAll() {
        if (this.cellColumn != -1) {
            this.cellColumn = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12289));
        }
    }

    public void enableSelectionEvents(boolean enable) {
        this.events = enable;
        if (this.events) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    protected void processSelectionEvent(MatrixSelectionEvent e2) {
        if (this.events && this.selectionListeners.hasListeners()) {
            this.selectionListeners.dispatch((DispatchableEvent)e2);
        }
    }
}

