/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.trax;

import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.TemplatesHandler;
import org.apache.xalan.xsltc.compiler.CompilerException;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.SourceLoader;
import org.apache.xalan.xsltc.compiler.Stylesheet;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.XSLTC;
import org.apache.xalan.xsltc.trax.TemplatesImpl;
import org.apache.xalan.xsltc.trax.TransformerFactoryImpl;
import org.apache.xalan.xsltc.trax.Util;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;

public class TemplatesHandlerImpl
extends Parser
implements TemplatesHandler,
SourceLoader {
    private String _systemId;
    private int _indentNumber;
    private URIResolver _uriResolver = null;
    private TransformerFactoryImpl _tfactory = null;

    protected TemplatesHandlerImpl(int indentNumber, TransformerFactoryImpl tfactory) {
        super(null);
        this._indentNumber = indentNumber;
        this._tfactory = tfactory;
    }

    public void init() {
        XSLTC xsltc = new XSLTC();
        super.setXSLTC(xsltc);
        xsltc.init();
        super.init();
        xsltc.setParser(this);
        xsltc.setOutputType(2);
    }

    public String getSystemId() {
        return this._systemId;
    }

    public void setSystemId(String id) {
        this._systemId = id;
    }

    public void setURIResolver(URIResolver resolver) {
        this._uriResolver = resolver;
    }

    public Templates getTemplates() {
        try {
            byte[][] bytecodes;
            XSLTC xsltc = this.getXSLTC();
            if (this._uriResolver != null) {
                xsltc.setSourceLoader(this);
            }
            String transletName = TransformerFactoryImpl._defaultTransletName;
            if (this._systemId != null) {
                transletName = Util.baseName(this._systemId);
            }
            xsltc.setClassName(transletName);
            transletName = xsltc.getClassName();
            Stylesheet stylesheet = null;
            SyntaxTreeNode root = this.getDocumentRoot();
            if (!this.errorsFound() && root != null) {
                stylesheet = this.makeStylesheet(root);
                stylesheet.setSystemId(this._systemId);
                stylesheet.setParentStylesheet(null);
                this.setCurrentStylesheet(stylesheet);
                xsltc.setStylesheet(stylesheet);
                this.createAST(stylesheet);
            }
            if (!this.errorsFound() && stylesheet != null) {
                stylesheet.setMultiDocument(xsltc.isMultiDocument());
                stylesheet.translate();
            }
            if (!this.errorsFound() && (bytecodes = xsltc.getBytecodes()) != null) {
                TemplatesImpl templates = new TemplatesImpl(xsltc.getBytecodes(), transletName, this.getOutputProperties(), this._indentNumber, this._tfactory);
                if (this._uriResolver != null) {
                    templates.setURIResolver(this._uriResolver);
                }
                return templates;
            }
        }
        catch (CompilerException compilerException) {
            // empty catch block
        }
        return null;
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.setSystemId(locator.getSystemId());
    }

    public InputSource loadSource(String href, String context, XSLTC xsltc) {
        try {
            Source source = this._uriResolver.resolve(href, context);
            if (source != null) {
                return Util.getInputSource(xsltc, source);
            }
        }
        catch (TransformerException e) {
            // empty catch block
        }
        return null;
    }
}

